# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SchemaArgs', 'Schema']

@pulumi.input_type
class SchemaArgs:
    def __init__(__self__, *,
                 catalog_name: pulumi.Input[builtins.str],
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 enable_predictive_optimization: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Schema resource.
        :param pulumi.Input[builtins.str] catalog_name: Name of parent catalog. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[builtins.str] enable_predictive_optimization: Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        :param pulumi.Input[builtins.bool] force_destroy: Delete schema regardless of its contents.
        :param pulumi.Input[builtins.str] name: Name of Schema relative to parent catalog. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] owner: Username/groupname/sp application_id of the schema owner.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] properties: Extensible Schema properties.
        :param pulumi.Input[builtins.str] storage_root: Managed location of the schema. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the catalog root location. Change forces creation of a new resource.
        """
        pulumi.set(__self__, "catalog_name", catalog_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enable_predictive_optimization is not None:
            pulumi.set(__self__, "enable_predictive_optimization", enable_predictive_optimization)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if storage_root is not None:
            pulumi.set(__self__, "storage_root", storage_root)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of parent catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-supplied free-form text.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="enablePredictiveOptimization")
    def enable_predictive_optimization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        """
        return pulumi.get(self, "enable_predictive_optimization")

    @enable_predictive_optimization.setter
    def enable_predictive_optimization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable_predictive_optimization", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Delete schema regardless of its contents.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of Schema relative to parent catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username/groupname/sp application_id of the schema owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Extensible Schema properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Managed location of the schema. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the catalog root location. Change forces creation of a new resource.
        """
        return pulumi.get(self, "storage_root")

    @storage_root.setter
    def storage_root(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_root", value)


@pulumi.input_type
class _SchemaState:
    def __init__(__self__, *,
                 catalog_name: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 enable_predictive_optimization: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 schema_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Schema resources.
        :param pulumi.Input[builtins.str] catalog_name: Name of parent catalog. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[builtins.str] enable_predictive_optimization: Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        :param pulumi.Input[builtins.bool] force_destroy: Delete schema regardless of its contents.
        :param pulumi.Input[builtins.str] name: Name of Schema relative to parent catalog. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] owner: Username/groupname/sp application_id of the schema owner.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] properties: Extensible Schema properties.
        :param pulumi.Input[builtins.str] schema_id: The unique identifier of the schema.
        :param pulumi.Input[builtins.str] storage_root: Managed location of the schema. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the catalog root location. Change forces creation of a new resource.
        """
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enable_predictive_optimization is not None:
            pulumi.set(__self__, "enable_predictive_optimization", enable_predictive_optimization)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if storage_root is not None:
            pulumi.set(__self__, "storage_root", storage_root)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of parent catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-supplied free-form text.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="enablePredictiveOptimization")
    def enable_predictive_optimization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        """
        return pulumi.get(self, "enable_predictive_optimization")

    @enable_predictive_optimization.setter
    def enable_predictive_optimization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable_predictive_optimization", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Delete schema regardless of its contents.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of Schema relative to parent catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username/groupname/sp application_id of the schema owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Extensible Schema properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the schema.
        """
        return pulumi.get(self, "schema_id")

    @schema_id.setter
    def schema_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema_id", value)

    @property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Managed location of the schema. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the catalog root location. Change forces creation of a new resource.
        """
        return pulumi.get(self, "storage_root")

    @storage_root.setter
    def storage_root(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_root", value)


@pulumi.type_token("databricks:index/schema:Schema")
class Schema(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_name: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 enable_predictive_optimization: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Within a metastore, Unity Catalog provides a 3-level namespace for organizing data: Catalogs, Databases (also called Schemas), and Tables / Views.

        > This resource can only be used with a workspace-level provider!

        A `Schema` is contained within Catalog and can contain tables & views.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        things = databricks.Schema("things",
            catalog_name=sandbox.id,
            name="things",
            comment="this database is managed by terraform",
            properties={
                "kind": "various",
            })
        ```

        ## Related Resources

        The following resources are used in the same context:

        * get_tables data to list tables within Unity Catalog.
        * get_schemas data to list schemas within Unity Catalog.
        * get_catalogs data to list catalogs within Unity Catalog.

        ## Import

        This resource can be imported by its full name:

        hcl

        import {

          to = databricks_schema.this

          id = "<catalog_name>.<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/schema:Schema this "<catalog_name>.<name>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] catalog_name: Name of parent catalog. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[builtins.str] enable_predictive_optimization: Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        :param pulumi.Input[builtins.bool] force_destroy: Delete schema regardless of its contents.
        :param pulumi.Input[builtins.str] name: Name of Schema relative to parent catalog. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] owner: Username/groupname/sp application_id of the schema owner.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] properties: Extensible Schema properties.
        :param pulumi.Input[builtins.str] storage_root: Managed location of the schema. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the catalog root location. Change forces creation of a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchemaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Within a metastore, Unity Catalog provides a 3-level namespace for organizing data: Catalogs, Databases (also called Schemas), and Tables / Views.

        > This resource can only be used with a workspace-level provider!

        A `Schema` is contained within Catalog and can contain tables & views.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        things = databricks.Schema("things",
            catalog_name=sandbox.id,
            name="things",
            comment="this database is managed by terraform",
            properties={
                "kind": "various",
            })
        ```

        ## Related Resources

        The following resources are used in the same context:

        * get_tables data to list tables within Unity Catalog.
        * get_schemas data to list schemas within Unity Catalog.
        * get_catalogs data to list catalogs within Unity Catalog.

        ## Import

        This resource can be imported by its full name:

        hcl

        import {

          to = databricks_schema.this

          id = "<catalog_name>.<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/schema:Schema this "<catalog_name>.<name>"
        ```

        :param str resource_name: The name of the resource.
        :param SchemaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchemaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_name: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 enable_predictive_optimization: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchemaArgs.__new__(SchemaArgs)

            if catalog_name is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_name'")
            __props__.__dict__["catalog_name"] = catalog_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["enable_predictive_optimization"] = enable_predictive_optimization
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["metastore_id"] = metastore_id
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["properties"] = properties
            __props__.__dict__["storage_root"] = storage_root
            __props__.__dict__["schema_id"] = None
        super(Schema, __self__).__init__(
            'databricks:index/schema:Schema',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_name: Optional[pulumi.Input[builtins.str]] = None,
            comment: Optional[pulumi.Input[builtins.str]] = None,
            enable_predictive_optimization: Optional[pulumi.Input[builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            metastore_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            schema_id: Optional[pulumi.Input[builtins.str]] = None,
            storage_root: Optional[pulumi.Input[builtins.str]] = None) -> 'Schema':
        """
        Get an existing Schema resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] catalog_name: Name of parent catalog. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[builtins.str] enable_predictive_optimization: Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        :param pulumi.Input[builtins.bool] force_destroy: Delete schema regardless of its contents.
        :param pulumi.Input[builtins.str] name: Name of Schema relative to parent catalog. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] owner: Username/groupname/sp application_id of the schema owner.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] properties: Extensible Schema properties.
        :param pulumi.Input[builtins.str] schema_id: The unique identifier of the schema.
        :param pulumi.Input[builtins.str] storage_root: Managed location of the schema. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the catalog root location. Change forces creation of a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SchemaState.__new__(_SchemaState)

        __props__.__dict__["catalog_name"] = catalog_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["enable_predictive_optimization"] = enable_predictive_optimization
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["properties"] = properties
        __props__.__dict__["schema_id"] = schema_id
        __props__.__dict__["storage_root"] = storage_root
        return Schema(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of parent catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-supplied free-form text.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="enablePredictiveOptimization")
    def enable_predictive_optimization(self) -> pulumi.Output[builtins.str]:
        """
        Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        """
        return pulumi.get(self, "enable_predictive_optimization")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Delete schema regardless of its contents.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of Schema relative to parent catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[builtins.str]:
        """
        Username/groupname/sp application_id of the schema owner.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Extensible Schema properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the schema.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Managed location of the schema. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the catalog root location. Change forces creation of a new resource.
        """
        return pulumi.get(self, "storage_root")

