# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ShareArgs', 'Share']

@pulumi.input_type
class ShareArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 objects: Optional[pulumi.Input[Sequence[pulumi.Input['ShareObjectArgs']]]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Share resource.
        :param pulumi.Input[builtins.int] created_at: Time when the share was created.
        :param pulumi.Input[builtins.str] created_by: The principal that created the share.
        :param pulumi.Input[builtins.str] name: Name of share. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] owner: User name/group name/sp application_id of the share owner.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if objects is not None:
            pulumi.set(__self__, "objects", objects)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)
        if storage_root is not None:
            pulumi.set(__self__, "storage_root", storage_root)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time when the share was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The principal that created the share.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of share. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ShareObjectArgs']]]]:
        return pulumi.get(self, "objects")

    @objects.setter
    def objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ShareObjectArgs']]]]):
        pulumi.set(self, "objects", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User name/group name/sp application_id of the share owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_location", value)

    @property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "storage_root")

    @storage_root.setter
    def storage_root(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_root", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_by", value)


@pulumi.input_type
class _ShareState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 objects: Optional[pulumi.Input[Sequence[pulumi.Input['ShareObjectArgs']]]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Share resources.
        :param pulumi.Input[builtins.int] created_at: Time when the share was created.
        :param pulumi.Input[builtins.str] created_by: The principal that created the share.
        :param pulumi.Input[builtins.str] name: Name of share. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] owner: User name/group name/sp application_id of the share owner.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if objects is not None:
            pulumi.set(__self__, "objects", objects)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)
        if storage_root is not None:
            pulumi.set(__self__, "storage_root", storage_root)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time when the share was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The principal that created the share.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of share. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ShareObjectArgs']]]]:
        return pulumi.get(self, "objects")

    @objects.setter
    def objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ShareObjectArgs']]]]):
        pulumi.set(self, "objects", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User name/group name/sp application_id of the share owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_location", value)

    @property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "storage_root")

    @storage_root.setter
    def storage_root(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_root", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_by", value)


@pulumi.type_token("databricks:index/share:Share")
class Share(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShareObjectArgs', 'ShareObjectArgsDict']]]]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        In Delta Sharing, a share is a read-only collection of tables and table partitions that a provider wants to share with one or more recipients. If your recipient uses a Unity Catalog-enabled Databricks workspace, you can also include notebook files, views (including dynamic views that restrict access at the row and column level), Unity Catalog volumes, and Unity Catalog models in a share.

        > This resource can only be used with a workspace-level provider!

        In a Unity Catalog-enabled Databricks workspace, a share is a securable object registered in Unity Catalog. A `Share` is contained within a databricks_metastore. If you remove a share from your Unity Catalog metastore, all recipients of that share lose the ability to access it.

        ## Example Usage

        > In Pulumi configuration, it is recommended to define objects in alphabetical order of their `name` arguments, so that you get consistent and readable diff. Whenever objects are added or removed, or `name` is renamed, you'll observe a change in the majority of tasks. It's related to the fact that the current version of the provider treats `object` blocks as an ordered list. Alternatively, `object` block could have been an unordered set, though end-users would see the entire block replaced upon a change in single property of the task.

        Creating a Delta Sharing share and add some existing tables to it

        ```python
        import pulumi
        import pulumi_databricks as databricks

        things = databricks.get_tables(catalog_name="sandbox",
            schema_name="things")
        some = databricks.Share("some",
            objects=[{"key": k, "value": v} for k, v in things.ids].apply(lambda entries: [{
                "name": entry["value"],
                "dataObjectType": "TABLE",
            } for entry in entries]),
            name="my_share")
        ```

        Creating a Delta Sharing share and add a schema to it(including all current and future tables).

        ```python
        import pulumi
        import pulumi_databricks as databricks

        schema_share = databricks.Share("schema_share",
            name="schema_share",
            objects=[{
                "name": "catalog_name.schema_name",
                "data_object_type": "SCHEMA",
                "history_data_sharing_status": "ENABLED",
            }])
        ```

        Creating a Delta Sharing share and share a table with partitions spec and history

        ```python
        import pulumi
        import pulumi_databricks as databricks

        some = databricks.Share("some",
            name="my_share",
            objects=[{
                "name": "my_catalog.my_schema.my_table",
                "data_object_type": "TABLE",
                "history_data_sharing_status": "ENABLED",
                "partitions": [
                    {
                        "values": [
                            {
                                "name": "year",
                                "op": "EQUAL",
                                "value": "2009",
                            },
                            {
                                "name": "month",
                                "op": "EQUAL",
                                "value": "12",
                            },
                        ],
                    },
                    {
                        "values": [{
                            "name": "year",
                            "op": "EQUAL",
                            "value": "2010",
                        }],
                    },
                ],
            }])
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * Recipient to create Delta Sharing recipients.
        * Grants to manage Delta Sharing permissions.
        * get_shares to read existing Delta Sharing shares.

        ## Import

        The share resource can be imported using the name of the share.

        hcl

        import {

          to = databricks_share.this

          id = "<share_name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/share:Share this <share_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] created_at: Time when the share was created.
        :param pulumi.Input[builtins.str] created_by: The principal that created the share.
        :param pulumi.Input[builtins.str] name: Name of share. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] owner: User name/group name/sp application_id of the share owner.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ShareArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        In Delta Sharing, a share is a read-only collection of tables and table partitions that a provider wants to share with one or more recipients. If your recipient uses a Unity Catalog-enabled Databricks workspace, you can also include notebook files, views (including dynamic views that restrict access at the row and column level), Unity Catalog volumes, and Unity Catalog models in a share.

        > This resource can only be used with a workspace-level provider!

        In a Unity Catalog-enabled Databricks workspace, a share is a securable object registered in Unity Catalog. A `Share` is contained within a databricks_metastore. If you remove a share from your Unity Catalog metastore, all recipients of that share lose the ability to access it.

        ## Example Usage

        > In Pulumi configuration, it is recommended to define objects in alphabetical order of their `name` arguments, so that you get consistent and readable diff. Whenever objects are added or removed, or `name` is renamed, you'll observe a change in the majority of tasks. It's related to the fact that the current version of the provider treats `object` blocks as an ordered list. Alternatively, `object` block could have been an unordered set, though end-users would see the entire block replaced upon a change in single property of the task.

        Creating a Delta Sharing share and add some existing tables to it

        ```python
        import pulumi
        import pulumi_databricks as databricks

        things = databricks.get_tables(catalog_name="sandbox",
            schema_name="things")
        some = databricks.Share("some",
            objects=[{"key": k, "value": v} for k, v in things.ids].apply(lambda entries: [{
                "name": entry["value"],
                "dataObjectType": "TABLE",
            } for entry in entries]),
            name="my_share")
        ```

        Creating a Delta Sharing share and add a schema to it(including all current and future tables).

        ```python
        import pulumi
        import pulumi_databricks as databricks

        schema_share = databricks.Share("schema_share",
            name="schema_share",
            objects=[{
                "name": "catalog_name.schema_name",
                "data_object_type": "SCHEMA",
                "history_data_sharing_status": "ENABLED",
            }])
        ```

        Creating a Delta Sharing share and share a table with partitions spec and history

        ```python
        import pulumi
        import pulumi_databricks as databricks

        some = databricks.Share("some",
            name="my_share",
            objects=[{
                "name": "my_catalog.my_schema.my_table",
                "data_object_type": "TABLE",
                "history_data_sharing_status": "ENABLED",
                "partitions": [
                    {
                        "values": [
                            {
                                "name": "year",
                                "op": "EQUAL",
                                "value": "2009",
                            },
                            {
                                "name": "month",
                                "op": "EQUAL",
                                "value": "12",
                            },
                        ],
                    },
                    {
                        "values": [{
                            "name": "year",
                            "op": "EQUAL",
                            "value": "2010",
                        }],
                    },
                ],
            }])
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * Recipient to create Delta Sharing recipients.
        * Grants to manage Delta Sharing permissions.
        * get_shares to read existing Delta Sharing shares.

        ## Import

        The share resource can be imported using the name of the share.

        hcl

        import {

          to = databricks_share.this

          id = "<share_name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/share:Share this <share_name>
        ```

        :param str resource_name: The name of the resource.
        :param ShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShareObjectArgs', 'ShareObjectArgsDict']]]]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ShareArgs.__new__(ShareArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["name"] = name
            __props__.__dict__["objects"] = objects
            __props__.__dict__["owner"] = owner
            __props__.__dict__["storage_location"] = storage_location
            __props__.__dict__["storage_root"] = storage_root
            __props__.__dict__["updated_at"] = updated_at
            __props__.__dict__["updated_by"] = updated_by
        super(Share, __self__).__init__(
            'databricks:index/share:Share',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.int]] = None,
            created_by: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShareObjectArgs', 'ShareObjectArgsDict']]]]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            storage_location: Optional[pulumi.Input[builtins.str]] = None,
            storage_root: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.int]] = None,
            updated_by: Optional[pulumi.Input[builtins.str]] = None) -> 'Share':
        """
        Get an existing Share resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] created_at: Time when the share was created.
        :param pulumi.Input[builtins.str] created_by: The principal that created the share.
        :param pulumi.Input[builtins.str] name: Name of share. Change forces creation of a new resource.
        :param pulumi.Input[builtins.str] owner: User name/group name/sp application_id of the share owner.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ShareState.__new__(_ShareState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["name"] = name
        __props__.__dict__["objects"] = objects
        __props__.__dict__["owner"] = owner
        __props__.__dict__["storage_location"] = storage_location
        __props__.__dict__["storage_root"] = storage_root
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        return Share(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.int]:
        """
        Time when the share was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.str]:
        """
        The principal that created the share.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of share. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def objects(self) -> pulumi.Output[Optional[Sequence['outputs.ShareObject']]]:
        return pulumi.get(self, "objects")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User name/group name/sp application_id of the share owner.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "storage_location")

    @property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "storage_root")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_by")

