# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlEndpointArgs', 'SqlEndpoint']

@pulumi.input_type
class SqlEndpointArgs:
    def __init__(__self__, *,
                 cluster_size: pulumi.Input[builtins.str],
                 auto_stop_mins: Optional[pulumi.Input[builtins.int]] = None,
                 channel: Optional[pulumi.Input['SqlEndpointChannelArgs']] = None,
                 data_source_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_photon: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_serverless_compute: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
                 max_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
                 min_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spot_instance_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input['SqlEndpointTagsArgs']] = None,
                 warehouse_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SqlEndpoint resource.
        :param pulumi.Input[builtins.str] cluster_size: The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        :param pulumi.Input[builtins.int] auto_stop_mins: Time in minutes until an idle SQL warehouse terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        :param pulumi.Input['SqlEndpointChannelArgs'] channel: block, consisting of following fields:
        :param pulumi.Input[builtins.str] data_source_id: ID of the data source for this endpoint. This is used to bind an Databricks SQL query to an endpoint.
        :param pulumi.Input[builtins.bool] enable_photon: Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        :param pulumi.Input[builtins.bool] enable_serverless_compute: Whether this SQL warehouse is a serverless endpoint. See below for details about the default values. To avoid ambiguity, especially for organizations with many workspaces, Databricks recommends that you always set this field explicitly.
               
               * **For AWS**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between September 1, 2022 and April 30, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. If your account needs updated [terms of use](https://docs.databricks.com/sql/admin/serverless.html#accept-terms), workspace admins are prompted in the Databricks SQL UI. A workspace must meet the [requirements](https://docs.databricks.com/sql/admin/serverless.html#requirements) and might require an update to its instance profile role to [add a trust relationship](https://docs.databricks.com/sql/admin/serverless.html#aws-instance-profile-setup).
               
               * **For Azure**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between November 1, 2022 and May 19, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. A workspace must meet the [requirements](https://learn.microsoft.com/azure/databricks/sql/admin/serverless) and might require an update to its [Azure storage firewall](https://learn.microsoft.com/azure/databricks/sql/admin/serverless-firewall).
        :param pulumi.Input[builtins.int] max_num_clusters: Maximum number of clusters available when a SQL warehouse is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        :param pulumi.Input[builtins.int] min_num_clusters: Minimum number of clusters available when a SQL warehouse is running. The default is `1`.
        :param pulumi.Input[builtins.str] name: Name of the SQL warehouse. Must be unique.
        :param pulumi.Input[builtins.str] spot_instance_policy: The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        :param pulumi.Input['SqlEndpointTagsArgs'] tags: Databricks tags all endpoint resources with these tags.
        :param pulumi.Input[builtins.str] warehouse_type: SQL warehouse type. See for [AWS](https://docs.databricks.com/sql/admin/sql-endpoints.html#switch-the-sql-warehouse-type-pro-classic-or-serverless) or [Azure](https://learn.microsoft.com/en-us/azure/databricks/sql/admin/create-sql-warehouse#--upgrade-a-pro-or-classic-sql-warehouse-to-a-serverless-sql-warehouse). Set to `PRO` or `CLASSIC`. If the field `enable_serverless_compute` has the value `true` either explicitly or through the default logic (see that field above for details), the default is `PRO`, which is required for serverless SQL warehouses. Otherwise, the default is `CLASSIC`.
        """
        pulumi.set(__self__, "cluster_size", cluster_size)
        if auto_stop_mins is not None:
            pulumi.set(__self__, "auto_stop_mins", auto_stop_mins)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if enable_photon is not None:
            pulumi.set(__self__, "enable_photon", enable_photon)
        if enable_serverless_compute is not None:
            pulumi.set(__self__, "enable_serverless_compute", enable_serverless_compute)
        if instance_profile_arn is not None:
            pulumi.set(__self__, "instance_profile_arn", instance_profile_arn)
        if max_num_clusters is not None:
            pulumi.set(__self__, "max_num_clusters", max_num_clusters)
        if min_num_clusters is not None:
            pulumi.set(__self__, "min_num_clusters", min_num_clusters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spot_instance_policy is not None:
            pulumi.set(__self__, "spot_instance_policy", spot_instance_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if warehouse_type is not None:
            pulumi.set(__self__, "warehouse_type", warehouse_type)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Input[builtins.str]:
        """
        The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="autoStopMins")
    def auto_stop_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time in minutes until an idle SQL warehouse terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        """
        return pulumi.get(self, "auto_stop_mins")

    @auto_stop_mins.setter
    def auto_stop_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "auto_stop_mins", value)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input['SqlEndpointChannelArgs']]:
        """
        block, consisting of following fields:
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input['SqlEndpointChannelArgs']]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the data source for this endpoint. This is used to bind an Databricks SQL query to an endpoint.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @property
    @pulumi.getter(name="enablePhoton")
    def enable_photon(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        """
        return pulumi.get(self, "enable_photon")

    @enable_photon.setter
    def enable_photon(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_photon", value)

    @property
    @pulumi.getter(name="enableServerlessCompute")
    def enable_serverless_compute(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this SQL warehouse is a serverless endpoint. See below for details about the default values. To avoid ambiguity, especially for organizations with many workspaces, Databricks recommends that you always set this field explicitly.

        * **For AWS**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between September 1, 2022 and April 30, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. If your account needs updated [terms of use](https://docs.databricks.com/sql/admin/serverless.html#accept-terms), workspace admins are prompted in the Databricks SQL UI. A workspace must meet the [requirements](https://docs.databricks.com/sql/admin/serverless.html#requirements) and might require an update to its instance profile role to [add a trust relationship](https://docs.databricks.com/sql/admin/serverless.html#aws-instance-profile-setup).

        * **For Azure**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between November 1, 2022 and May 19, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. A workspace must meet the [requirements](https://learn.microsoft.com/azure/databricks/sql/admin/serverless) and might require an update to its [Azure storage firewall](https://learn.microsoft.com/azure/databricks/sql/admin/serverless-firewall).
        """
        return pulumi.get(self, "enable_serverless_compute")

    @enable_serverless_compute.setter
    def enable_serverless_compute(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_serverless_compute", value)

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "instance_profile_arn")

    @instance_profile_arn.setter
    def instance_profile_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_profile_arn", value)

    @property
    @pulumi.getter(name="maxNumClusters")
    def max_num_clusters(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of clusters available when a SQL warehouse is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        """
        return pulumi.get(self, "max_num_clusters")

    @max_num_clusters.setter
    def max_num_clusters(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_num_clusters", value)

    @property
    @pulumi.getter(name="minNumClusters")
    def min_num_clusters(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum number of clusters available when a SQL warehouse is running. The default is `1`.
        """
        return pulumi.get(self, "min_num_clusters")

    @min_num_clusters.setter
    def min_num_clusters(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_num_clusters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SQL warehouse. Must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="spotInstancePolicy")
    def spot_instance_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        """
        return pulumi.get(self, "spot_instance_policy")

    @spot_instance_policy.setter
    def spot_instance_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_instance_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['SqlEndpointTagsArgs']]:
        """
        Databricks tags all endpoint resources with these tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['SqlEndpointTagsArgs']]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="warehouseType")
    def warehouse_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SQL warehouse type. See for [AWS](https://docs.databricks.com/sql/admin/sql-endpoints.html#switch-the-sql-warehouse-type-pro-classic-or-serverless) or [Azure](https://learn.microsoft.com/en-us/azure/databricks/sql/admin/create-sql-warehouse#--upgrade-a-pro-or-classic-sql-warehouse-to-a-serverless-sql-warehouse). Set to `PRO` or `CLASSIC`. If the field `enable_serverless_compute` has the value `true` either explicitly or through the default logic (see that field above for details), the default is `PRO`, which is required for serverless SQL warehouses. Otherwise, the default is `CLASSIC`.
        """
        return pulumi.get(self, "warehouse_type")

    @warehouse_type.setter
    def warehouse_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "warehouse_type", value)


@pulumi.input_type
class _SqlEndpointState:
    def __init__(__self__, *,
                 auto_stop_mins: Optional[pulumi.Input[builtins.int]] = None,
                 channel: Optional[pulumi.Input['SqlEndpointChannelArgs']] = None,
                 cluster_size: Optional[pulumi.Input[builtins.str]] = None,
                 creator_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_photon: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_serverless_compute: Optional[pulumi.Input[builtins.bool]] = None,
                 healths: Optional[pulumi.Input[Sequence[pulumi.Input['SqlEndpointHealthArgs']]]] = None,
                 instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
                 jdbc_url: Optional[pulumi.Input[builtins.str]] = None,
                 max_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
                 min_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_active_sessions: Optional[pulumi.Input[builtins.int]] = None,
                 num_clusters: Optional[pulumi.Input[builtins.int]] = None,
                 odbc_params: Optional[pulumi.Input['SqlEndpointOdbcParamsArgs']] = None,
                 spot_instance_policy: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input['SqlEndpointTagsArgs']] = None,
                 warehouse_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlEndpoint resources.
        :param pulumi.Input[builtins.int] auto_stop_mins: Time in minutes until an idle SQL warehouse terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        :param pulumi.Input['SqlEndpointChannelArgs'] channel: block, consisting of following fields:
        :param pulumi.Input[builtins.str] cluster_size: The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        :param pulumi.Input[builtins.str] creator_name: The username of the user who created the endpoint.
        :param pulumi.Input[builtins.str] data_source_id: ID of the data source for this endpoint. This is used to bind an Databricks SQL query to an endpoint.
        :param pulumi.Input[builtins.bool] enable_photon: Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        :param pulumi.Input[builtins.bool] enable_serverless_compute: Whether this SQL warehouse is a serverless endpoint. See below for details about the default values. To avoid ambiguity, especially for organizations with many workspaces, Databricks recommends that you always set this field explicitly.
               
               * **For AWS**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between September 1, 2022 and April 30, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. If your account needs updated [terms of use](https://docs.databricks.com/sql/admin/serverless.html#accept-terms), workspace admins are prompted in the Databricks SQL UI. A workspace must meet the [requirements](https://docs.databricks.com/sql/admin/serverless.html#requirements) and might require an update to its instance profile role to [add a trust relationship](https://docs.databricks.com/sql/admin/serverless.html#aws-instance-profile-setup).
               
               * **For Azure**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between November 1, 2022 and May 19, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. A workspace must meet the [requirements](https://learn.microsoft.com/azure/databricks/sql/admin/serverless) and might require an update to its [Azure storage firewall](https://learn.microsoft.com/azure/databricks/sql/admin/serverless-firewall).
        :param pulumi.Input[Sequence[pulumi.Input['SqlEndpointHealthArgs']]] healths: Health status of the endpoint.
        :param pulumi.Input[builtins.str] jdbc_url: JDBC connection string.
        :param pulumi.Input[builtins.int] max_num_clusters: Maximum number of clusters available when a SQL warehouse is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        :param pulumi.Input[builtins.int] min_num_clusters: Minimum number of clusters available when a SQL warehouse is running. The default is `1`.
        :param pulumi.Input[builtins.str] name: Name of the SQL warehouse. Must be unique.
        :param pulumi.Input[builtins.int] num_active_sessions: The current number of clusters used by the endpoint.
        :param pulumi.Input[builtins.int] num_clusters: The current number of clusters used by the endpoint.
        :param pulumi.Input['SqlEndpointOdbcParamsArgs'] odbc_params: ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        :param pulumi.Input[builtins.str] spot_instance_policy: The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        :param pulumi.Input[builtins.str] state: The current state of the endpoint.
        :param pulumi.Input['SqlEndpointTagsArgs'] tags: Databricks tags all endpoint resources with these tags.
        :param pulumi.Input[builtins.str] warehouse_type: SQL warehouse type. See for [AWS](https://docs.databricks.com/sql/admin/sql-endpoints.html#switch-the-sql-warehouse-type-pro-classic-or-serverless) or [Azure](https://learn.microsoft.com/en-us/azure/databricks/sql/admin/create-sql-warehouse#--upgrade-a-pro-or-classic-sql-warehouse-to-a-serverless-sql-warehouse). Set to `PRO` or `CLASSIC`. If the field `enable_serverless_compute` has the value `true` either explicitly or through the default logic (see that field above for details), the default is `PRO`, which is required for serverless SQL warehouses. Otherwise, the default is `CLASSIC`.
        """
        if auto_stop_mins is not None:
            pulumi.set(__self__, "auto_stop_mins", auto_stop_mins)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if creator_name is not None:
            pulumi.set(__self__, "creator_name", creator_name)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if enable_photon is not None:
            pulumi.set(__self__, "enable_photon", enable_photon)
        if enable_serverless_compute is not None:
            pulumi.set(__self__, "enable_serverless_compute", enable_serverless_compute)
        if healths is not None:
            pulumi.set(__self__, "healths", healths)
        if instance_profile_arn is not None:
            pulumi.set(__self__, "instance_profile_arn", instance_profile_arn)
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)
        if max_num_clusters is not None:
            pulumi.set(__self__, "max_num_clusters", max_num_clusters)
        if min_num_clusters is not None:
            pulumi.set(__self__, "min_num_clusters", min_num_clusters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_active_sessions is not None:
            pulumi.set(__self__, "num_active_sessions", num_active_sessions)
        if num_clusters is not None:
            pulumi.set(__self__, "num_clusters", num_clusters)
        if odbc_params is not None:
            pulumi.set(__self__, "odbc_params", odbc_params)
        if spot_instance_policy is not None:
            pulumi.set(__self__, "spot_instance_policy", spot_instance_policy)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if warehouse_type is not None:
            pulumi.set(__self__, "warehouse_type", warehouse_type)

    @property
    @pulumi.getter(name="autoStopMins")
    def auto_stop_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time in minutes until an idle SQL warehouse terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        """
        return pulumi.get(self, "auto_stop_mins")

    @auto_stop_mins.setter
    def auto_stop_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "auto_stop_mins", value)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input['SqlEndpointChannelArgs']]:
        """
        block, consisting of following fields:
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input['SqlEndpointChannelArgs']]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="creatorName")
    def creator_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username of the user who created the endpoint.
        """
        return pulumi.get(self, "creator_name")

    @creator_name.setter
    def creator_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creator_name", value)

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the data source for this endpoint. This is used to bind an Databricks SQL query to an endpoint.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @property
    @pulumi.getter(name="enablePhoton")
    def enable_photon(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        """
        return pulumi.get(self, "enable_photon")

    @enable_photon.setter
    def enable_photon(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_photon", value)

    @property
    @pulumi.getter(name="enableServerlessCompute")
    def enable_serverless_compute(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this SQL warehouse is a serverless endpoint. See below for details about the default values. To avoid ambiguity, especially for organizations with many workspaces, Databricks recommends that you always set this field explicitly.

        * **For AWS**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between September 1, 2022 and April 30, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. If your account needs updated [terms of use](https://docs.databricks.com/sql/admin/serverless.html#accept-terms), workspace admins are prompted in the Databricks SQL UI. A workspace must meet the [requirements](https://docs.databricks.com/sql/admin/serverless.html#requirements) and might require an update to its instance profile role to [add a trust relationship](https://docs.databricks.com/sql/admin/serverless.html#aws-instance-profile-setup).

        * **For Azure**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between November 1, 2022 and May 19, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. A workspace must meet the [requirements](https://learn.microsoft.com/azure/databricks/sql/admin/serverless) and might require an update to its [Azure storage firewall](https://learn.microsoft.com/azure/databricks/sql/admin/serverless-firewall).
        """
        return pulumi.get(self, "enable_serverless_compute")

    @enable_serverless_compute.setter
    def enable_serverless_compute(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_serverless_compute", value)

    @property
    @pulumi.getter
    def healths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlEndpointHealthArgs']]]]:
        """
        Health status of the endpoint.
        """
        return pulumi.get(self, "healths")

    @healths.setter
    def healths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlEndpointHealthArgs']]]]):
        pulumi.set(self, "healths", value)

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "instance_profile_arn")

    @instance_profile_arn.setter
    def instance_profile_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_profile_arn", value)

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JDBC connection string.
        """
        return pulumi.get(self, "jdbc_url")

    @jdbc_url.setter
    def jdbc_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "jdbc_url", value)

    @property
    @pulumi.getter(name="maxNumClusters")
    def max_num_clusters(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of clusters available when a SQL warehouse is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        """
        return pulumi.get(self, "max_num_clusters")

    @max_num_clusters.setter
    def max_num_clusters(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_num_clusters", value)

    @property
    @pulumi.getter(name="minNumClusters")
    def min_num_clusters(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum number of clusters available when a SQL warehouse is running. The default is `1`.
        """
        return pulumi.get(self, "min_num_clusters")

    @min_num_clusters.setter
    def min_num_clusters(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_num_clusters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SQL warehouse. Must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numActiveSessions")
    def num_active_sessions(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The current number of clusters used by the endpoint.
        """
        return pulumi.get(self, "num_active_sessions")

    @num_active_sessions.setter
    def num_active_sessions(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_active_sessions", value)

    @property
    @pulumi.getter(name="numClusters")
    def num_clusters(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The current number of clusters used by the endpoint.
        """
        return pulumi.get(self, "num_clusters")

    @num_clusters.setter
    def num_clusters(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_clusters", value)

    @property
    @pulumi.getter(name="odbcParams")
    def odbc_params(self) -> Optional[pulumi.Input['SqlEndpointOdbcParamsArgs']]:
        """
        ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        """
        return pulumi.get(self, "odbc_params")

    @odbc_params.setter
    def odbc_params(self, value: Optional[pulumi.Input['SqlEndpointOdbcParamsArgs']]):
        pulumi.set(self, "odbc_params", value)

    @property
    @pulumi.getter(name="spotInstancePolicy")
    def spot_instance_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        """
        return pulumi.get(self, "spot_instance_policy")

    @spot_instance_policy.setter
    def spot_instance_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_instance_policy", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['SqlEndpointTagsArgs']]:
        """
        Databricks tags all endpoint resources with these tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['SqlEndpointTagsArgs']]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="warehouseType")
    def warehouse_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SQL warehouse type. See for [AWS](https://docs.databricks.com/sql/admin/sql-endpoints.html#switch-the-sql-warehouse-type-pro-classic-or-serverless) or [Azure](https://learn.microsoft.com/en-us/azure/databricks/sql/admin/create-sql-warehouse#--upgrade-a-pro-or-classic-sql-warehouse-to-a-serverless-sql-warehouse). Set to `PRO` or `CLASSIC`. If the field `enable_serverless_compute` has the value `true` either explicitly or through the default logic (see that field above for details), the default is `PRO`, which is required for serverless SQL warehouses. Otherwise, the default is `CLASSIC`.
        """
        return pulumi.get(self, "warehouse_type")

    @warehouse_type.setter
    def warehouse_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "warehouse_type", value)


@pulumi.type_token("databricks:index/sqlEndpoint:SqlEndpoint")
class SqlEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_stop_mins: Optional[pulumi.Input[builtins.int]] = None,
                 channel: Optional[pulumi.Input[Union['SqlEndpointChannelArgs', 'SqlEndpointChannelArgsDict']]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_photon: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_serverless_compute: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
                 max_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
                 min_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spot_instance_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Union['SqlEndpointTagsArgs', 'SqlEndpointTagsArgsDict']]] = None,
                 warehouse_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource is used to manage [Databricks SQL warehouses](https://docs.databricks.com/sql/admin/sql-endpoints.html). To create [SQL warehouses](https://docs.databricks.com/sql/get-started/concepts.html) you must have `databricks_sql_access` on your Group or databricks_user.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        this = databricks.SqlEndpoint("this",
            name=f"Endpoint of {me.alphanumeric}",
            cluster_size="Small",
            max_num_clusters=1,
            tags={
                "custom_tags": [{
                    "key": "City",
                    "value": "Amsterdam",
                }],
            })
        ```

        ## Access control

        * Permissions can control which groups or individual users can *Can Use* or *Can Manage* SQL warehouses.
        * `databricks_sql_access` on Group or databricks_user.

        ## Related resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.
        * SqlDashboard to manage Databricks SQL [Dashboards](https://docs.databricks.com/sql/user/dashboards/index.html).
        * SqlGlobalConfig to configure the security policy, databricks_instance_profile, and [data access properties](https://docs.databricks.com/sql/admin/data-access-configuration.html) for all SqlEndpoint of workspace.
        * SqlPermissions to manage data object access control lists in Databricks workspaces for things like tables, views, databases, and [more](https://docs.databricks.com/security/access-control/table-acls/object-privileges.html).

        ## Import

        You can import a `databricks_sql_endpoint` resource with ID like the following:

        hcl

        import {

          to = databricks_sql_endpoint.this

          id = "<endpoint-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/sqlEndpoint:SqlEndpoint this <endpoint-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] auto_stop_mins: Time in minutes until an idle SQL warehouse terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        :param pulumi.Input[Union['SqlEndpointChannelArgs', 'SqlEndpointChannelArgsDict']] channel: block, consisting of following fields:
        :param pulumi.Input[builtins.str] cluster_size: The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        :param pulumi.Input[builtins.str] data_source_id: ID of the data source for this endpoint. This is used to bind an Databricks SQL query to an endpoint.
        :param pulumi.Input[builtins.bool] enable_photon: Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        :param pulumi.Input[builtins.bool] enable_serverless_compute: Whether this SQL warehouse is a serverless endpoint. See below for details about the default values. To avoid ambiguity, especially for organizations with many workspaces, Databricks recommends that you always set this field explicitly.
               
               * **For AWS**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between September 1, 2022 and April 30, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. If your account needs updated [terms of use](https://docs.databricks.com/sql/admin/serverless.html#accept-terms), workspace admins are prompted in the Databricks SQL UI. A workspace must meet the [requirements](https://docs.databricks.com/sql/admin/serverless.html#requirements) and might require an update to its instance profile role to [add a trust relationship](https://docs.databricks.com/sql/admin/serverless.html#aws-instance-profile-setup).
               
               * **For Azure**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between November 1, 2022 and May 19, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. A workspace must meet the [requirements](https://learn.microsoft.com/azure/databricks/sql/admin/serverless) and might require an update to its [Azure storage firewall](https://learn.microsoft.com/azure/databricks/sql/admin/serverless-firewall).
        :param pulumi.Input[builtins.int] max_num_clusters: Maximum number of clusters available when a SQL warehouse is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        :param pulumi.Input[builtins.int] min_num_clusters: Minimum number of clusters available when a SQL warehouse is running. The default is `1`.
        :param pulumi.Input[builtins.str] name: Name of the SQL warehouse. Must be unique.
        :param pulumi.Input[builtins.str] spot_instance_policy: The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        :param pulumi.Input[Union['SqlEndpointTagsArgs', 'SqlEndpointTagsArgsDict']] tags: Databricks tags all endpoint resources with these tags.
        :param pulumi.Input[builtins.str] warehouse_type: SQL warehouse type. See for [AWS](https://docs.databricks.com/sql/admin/sql-endpoints.html#switch-the-sql-warehouse-type-pro-classic-or-serverless) or [Azure](https://learn.microsoft.com/en-us/azure/databricks/sql/admin/create-sql-warehouse#--upgrade-a-pro-or-classic-sql-warehouse-to-a-serverless-sql-warehouse). Set to `PRO` or `CLASSIC`. If the field `enable_serverless_compute` has the value `true` either explicitly or through the default logic (see that field above for details), the default is `PRO`, which is required for serverless SQL warehouses. Otherwise, the default is `CLASSIC`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is used to manage [Databricks SQL warehouses](https://docs.databricks.com/sql/admin/sql-endpoints.html). To create [SQL warehouses](https://docs.databricks.com/sql/get-started/concepts.html) you must have `databricks_sql_access` on your Group or databricks_user.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.get_current_user()
        this = databricks.SqlEndpoint("this",
            name=f"Endpoint of {me.alphanumeric}",
            cluster_size="Small",
            max_num_clusters=1,
            tags={
                "custom_tags": [{
                    "key": "City",
                    "value": "Amsterdam",
                }],
            })
        ```

        ## Access control

        * Permissions can control which groups or individual users can *Can Use* or *Can Manage* SQL warehouses.
        * `databricks_sql_access` on Group or databricks_user.

        ## Related resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.
        * SqlDashboard to manage Databricks SQL [Dashboards](https://docs.databricks.com/sql/user/dashboards/index.html).
        * SqlGlobalConfig to configure the security policy, databricks_instance_profile, and [data access properties](https://docs.databricks.com/sql/admin/data-access-configuration.html) for all SqlEndpoint of workspace.
        * SqlPermissions to manage data object access control lists in Databricks workspaces for things like tables, views, databases, and [more](https://docs.databricks.com/security/access-control/table-acls/object-privileges.html).

        ## Import

        You can import a `databricks_sql_endpoint` resource with ID like the following:

        hcl

        import {

          to = databricks_sql_endpoint.this

          id = "<endpoint-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/sqlEndpoint:SqlEndpoint this <endpoint-id>
        ```

        :param str resource_name: The name of the resource.
        :param SqlEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_stop_mins: Optional[pulumi.Input[builtins.int]] = None,
                 channel: Optional[pulumi.Input[Union['SqlEndpointChannelArgs', 'SqlEndpointChannelArgsDict']]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_photon: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_serverless_compute: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
                 max_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
                 min_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spot_instance_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Union['SqlEndpointTagsArgs', 'SqlEndpointTagsArgsDict']]] = None,
                 warehouse_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlEndpointArgs.__new__(SqlEndpointArgs)

            __props__.__dict__["auto_stop_mins"] = auto_stop_mins
            __props__.__dict__["channel"] = channel
            if cluster_size is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_size'")
            __props__.__dict__["cluster_size"] = cluster_size
            __props__.__dict__["data_source_id"] = data_source_id
            __props__.__dict__["enable_photon"] = enable_photon
            __props__.__dict__["enable_serverless_compute"] = enable_serverless_compute
            __props__.__dict__["instance_profile_arn"] = instance_profile_arn
            __props__.__dict__["max_num_clusters"] = max_num_clusters
            __props__.__dict__["min_num_clusters"] = min_num_clusters
            __props__.__dict__["name"] = name
            __props__.__dict__["spot_instance_policy"] = spot_instance_policy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["warehouse_type"] = warehouse_type
            __props__.__dict__["creator_name"] = None
            __props__.__dict__["healths"] = None
            __props__.__dict__["jdbc_url"] = None
            __props__.__dict__["num_active_sessions"] = None
            __props__.__dict__["num_clusters"] = None
            __props__.__dict__["odbc_params"] = None
            __props__.__dict__["state"] = None
        super(SqlEndpoint, __self__).__init__(
            'databricks:index/sqlEndpoint:SqlEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_stop_mins: Optional[pulumi.Input[builtins.int]] = None,
            channel: Optional[pulumi.Input[Union['SqlEndpointChannelArgs', 'SqlEndpointChannelArgsDict']]] = None,
            cluster_size: Optional[pulumi.Input[builtins.str]] = None,
            creator_name: Optional[pulumi.Input[builtins.str]] = None,
            data_source_id: Optional[pulumi.Input[builtins.str]] = None,
            enable_photon: Optional[pulumi.Input[builtins.bool]] = None,
            enable_serverless_compute: Optional[pulumi.Input[builtins.bool]] = None,
            healths: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlEndpointHealthArgs', 'SqlEndpointHealthArgsDict']]]]] = None,
            instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
            jdbc_url: Optional[pulumi.Input[builtins.str]] = None,
            max_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
            min_num_clusters: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            num_active_sessions: Optional[pulumi.Input[builtins.int]] = None,
            num_clusters: Optional[pulumi.Input[builtins.int]] = None,
            odbc_params: Optional[pulumi.Input[Union['SqlEndpointOdbcParamsArgs', 'SqlEndpointOdbcParamsArgsDict']]] = None,
            spot_instance_policy: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Union['SqlEndpointTagsArgs', 'SqlEndpointTagsArgsDict']]] = None,
            warehouse_type: Optional[pulumi.Input[builtins.str]] = None) -> 'SqlEndpoint':
        """
        Get an existing SqlEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] auto_stop_mins: Time in minutes until an idle SQL warehouse terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        :param pulumi.Input[Union['SqlEndpointChannelArgs', 'SqlEndpointChannelArgsDict']] channel: block, consisting of following fields:
        :param pulumi.Input[builtins.str] cluster_size: The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        :param pulumi.Input[builtins.str] creator_name: The username of the user who created the endpoint.
        :param pulumi.Input[builtins.str] data_source_id: ID of the data source for this endpoint. This is used to bind an Databricks SQL query to an endpoint.
        :param pulumi.Input[builtins.bool] enable_photon: Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        :param pulumi.Input[builtins.bool] enable_serverless_compute: Whether this SQL warehouse is a serverless endpoint. See below for details about the default values. To avoid ambiguity, especially for organizations with many workspaces, Databricks recommends that you always set this field explicitly.
               
               * **For AWS**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between September 1, 2022 and April 30, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. If your account needs updated [terms of use](https://docs.databricks.com/sql/admin/serverless.html#accept-terms), workspace admins are prompted in the Databricks SQL UI. A workspace must meet the [requirements](https://docs.databricks.com/sql/admin/serverless.html#requirements) and might require an update to its instance profile role to [add a trust relationship](https://docs.databricks.com/sql/admin/serverless.html#aws-instance-profile-setup).
               
               * **For Azure**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between November 1, 2022 and May 19, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. A workspace must meet the [requirements](https://learn.microsoft.com/azure/databricks/sql/admin/serverless) and might require an update to its [Azure storage firewall](https://learn.microsoft.com/azure/databricks/sql/admin/serverless-firewall).
        :param pulumi.Input[Sequence[pulumi.Input[Union['SqlEndpointHealthArgs', 'SqlEndpointHealthArgsDict']]]] healths: Health status of the endpoint.
        :param pulumi.Input[builtins.str] jdbc_url: JDBC connection string.
        :param pulumi.Input[builtins.int] max_num_clusters: Maximum number of clusters available when a SQL warehouse is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        :param pulumi.Input[builtins.int] min_num_clusters: Minimum number of clusters available when a SQL warehouse is running. The default is `1`.
        :param pulumi.Input[builtins.str] name: Name of the SQL warehouse. Must be unique.
        :param pulumi.Input[builtins.int] num_active_sessions: The current number of clusters used by the endpoint.
        :param pulumi.Input[builtins.int] num_clusters: The current number of clusters used by the endpoint.
        :param pulumi.Input[Union['SqlEndpointOdbcParamsArgs', 'SqlEndpointOdbcParamsArgsDict']] odbc_params: ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        :param pulumi.Input[builtins.str] spot_instance_policy: The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        :param pulumi.Input[builtins.str] state: The current state of the endpoint.
        :param pulumi.Input[Union['SqlEndpointTagsArgs', 'SqlEndpointTagsArgsDict']] tags: Databricks tags all endpoint resources with these tags.
        :param pulumi.Input[builtins.str] warehouse_type: SQL warehouse type. See for [AWS](https://docs.databricks.com/sql/admin/sql-endpoints.html#switch-the-sql-warehouse-type-pro-classic-or-serverless) or [Azure](https://learn.microsoft.com/en-us/azure/databricks/sql/admin/create-sql-warehouse#--upgrade-a-pro-or-classic-sql-warehouse-to-a-serverless-sql-warehouse). Set to `PRO` or `CLASSIC`. If the field `enable_serverless_compute` has the value `true` either explicitly or through the default logic (see that field above for details), the default is `PRO`, which is required for serverless SQL warehouses. Otherwise, the default is `CLASSIC`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlEndpointState.__new__(_SqlEndpointState)

        __props__.__dict__["auto_stop_mins"] = auto_stop_mins
        __props__.__dict__["channel"] = channel
        __props__.__dict__["cluster_size"] = cluster_size
        __props__.__dict__["creator_name"] = creator_name
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["enable_photon"] = enable_photon
        __props__.__dict__["enable_serverless_compute"] = enable_serverless_compute
        __props__.__dict__["healths"] = healths
        __props__.__dict__["instance_profile_arn"] = instance_profile_arn
        __props__.__dict__["jdbc_url"] = jdbc_url
        __props__.__dict__["max_num_clusters"] = max_num_clusters
        __props__.__dict__["min_num_clusters"] = min_num_clusters
        __props__.__dict__["name"] = name
        __props__.__dict__["num_active_sessions"] = num_active_sessions
        __props__.__dict__["num_clusters"] = num_clusters
        __props__.__dict__["odbc_params"] = odbc_params
        __props__.__dict__["spot_instance_policy"] = spot_instance_policy
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["warehouse_type"] = warehouse_type
        return SqlEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoStopMins")
    def auto_stop_mins(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Time in minutes until an idle SQL warehouse terminates all clusters and stops. This field is optional. The default is 120, set to 0 to disable the auto stop.
        """
        return pulumi.get(self, "auto_stop_mins")

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Output[Optional['outputs.SqlEndpointChannel']]:
        """
        block, consisting of following fields:
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Output[builtins.str]:
        """
        The size of the clusters allocated to the endpoint: "2X-Small", "X-Small", "Small", "Medium", "Large", "X-Large", "2X-Large", "3X-Large", "4X-Large".
        """
        return pulumi.get(self, "cluster_size")

    @property
    @pulumi.getter(name="creatorName")
    def creator_name(self) -> pulumi.Output[builtins.str]:
        """
        The username of the user who created the endpoint.
        """
        return pulumi.get(self, "creator_name")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the data source for this endpoint. This is used to bind an Databricks SQL query to an endpoint.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter(name="enablePhoton")
    def enable_photon(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable [Photon](https://databricks.com/product/delta-engine). This field is optional and is enabled by default.
        """
        return pulumi.get(self, "enable_photon")

    @property
    @pulumi.getter(name="enableServerlessCompute")
    def enable_serverless_compute(self) -> pulumi.Output[builtins.bool]:
        """
        Whether this SQL warehouse is a serverless endpoint. See below for details about the default values. To avoid ambiguity, especially for organizations with many workspaces, Databricks recommends that you always set this field explicitly.

        * **For AWS**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between September 1, 2022 and April 30, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. If your account needs updated [terms of use](https://docs.databricks.com/sql/admin/serverless.html#accept-terms), workspace admins are prompted in the Databricks SQL UI. A workspace must meet the [requirements](https://docs.databricks.com/sql/admin/serverless.html#requirements) and might require an update to its instance profile role to [add a trust relationship](https://docs.databricks.com/sql/admin/serverless.html#aws-instance-profile-setup).

        * **For Azure**, If omitted, the default is `false` for most workspaces. However, if this workspace used the SQL Warehouses API to create a warehouse between November 1, 2022 and May 19, 2023, the default remains the previous behavior which is default to `true` if the workspace is enabled for serverless and fits the requirements for serverless SQL warehouses. A workspace must meet the [requirements](https://learn.microsoft.com/azure/databricks/sql/admin/serverless) and might require an update to its [Azure storage firewall](https://learn.microsoft.com/azure/databricks/sql/admin/serverless-firewall).
        """
        return pulumi.get(self, "enable_serverless_compute")

    @property
    @pulumi.getter
    def healths(self) -> pulumi.Output[Sequence['outputs.SqlEndpointHealth']]:
        """
        Health status of the endpoint.
        """
        return pulumi.get(self, "healths")

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "instance_profile_arn")

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> pulumi.Output[builtins.str]:
        """
        JDBC connection string.
        """
        return pulumi.get(self, "jdbc_url")

    @property
    @pulumi.getter(name="maxNumClusters")
    def max_num_clusters(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Maximum number of clusters available when a SQL warehouse is running. This field is required. If multi-cluster load balancing is not enabled, this is default to `1`.
        """
        return pulumi.get(self, "max_num_clusters")

    @property
    @pulumi.getter(name="minNumClusters")
    def min_num_clusters(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Minimum number of clusters available when a SQL warehouse is running. The default is `1`.
        """
        return pulumi.get(self, "min_num_clusters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the SQL warehouse. Must be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numActiveSessions")
    def num_active_sessions(self) -> pulumi.Output[builtins.int]:
        """
        The current number of clusters used by the endpoint.
        """
        return pulumi.get(self, "num_active_sessions")

    @property
    @pulumi.getter(name="numClusters")
    def num_clusters(self) -> pulumi.Output[builtins.int]:
        """
        The current number of clusters used by the endpoint.
        """
        return pulumi.get(self, "num_clusters")

    @property
    @pulumi.getter(name="odbcParams")
    def odbc_params(self) -> pulumi.Output['outputs.SqlEndpointOdbcParams']:
        """
        ODBC connection params: `odbc_params.hostname`, `odbc_params.path`, `odbc_params.protocol`, and `odbc_params.port`.
        """
        return pulumi.get(self, "odbc_params")

    @property
    @pulumi.getter(name="spotInstancePolicy")
    def spot_instance_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The spot policy to use for allocating instances to clusters: `COST_OPTIMIZED` or `RELIABILITY_OPTIMIZED`. This field is optional. Default is `COST_OPTIMIZED`.
        """
        return pulumi.get(self, "spot_instance_policy")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional['outputs.SqlEndpointTags']]:
        """
        Databricks tags all endpoint resources with these tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="warehouseType")
    def warehouse_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        SQL warehouse type. See for [AWS](https://docs.databricks.com/sql/admin/sql-endpoints.html#switch-the-sql-warehouse-type-pro-classic-or-serverless) or [Azure](https://learn.microsoft.com/en-us/azure/databricks/sql/admin/create-sql-warehouse#--upgrade-a-pro-or-classic-sql-warehouse-to-a-serverless-sql-warehouse). Set to `PRO` or `CLASSIC`. If the field `enable_serverless_compute` has the value `true` either explicitly or through the default logic (see that field above for details), the default is `PRO`, which is required for serverless SQL warehouses. Otherwise, the default is `CLASSIC`.
        """
        return pulumi.get(self, "warehouse_type")

