# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 user_name: pulumi.Input[builtins.str],
                 acl_principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_cluster_create: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_instance_pool_create: Optional[pulumi.Input[builtins.bool]] = None,
                 databricks_sql_access: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_as_user_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_home_dir: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_repos: Optional[pulumi.Input[builtins.bool]] = None,
                 home: Optional[pulumi.Input[builtins.str]] = None,
                 repos: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_access: Optional[pulumi.Input[builtins.bool]] = None,
                 workspace_consume: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] user_name: This is the username of the given user and will be their form of access and identity.  Provided username will be converted to lower case if it contains upper case characters.
        :param pulumi.Input[builtins.str] acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `users/mr.foo@example.com`.
        :param pulumi.Input[builtins.bool] active: Either user is active or not. True by default, but can be set to false in case of user deactivation with preserving user assets.
        :param pulumi.Input[builtins.bool] allow_cluster_create: Allow the user to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within boundaries of that specific policy.
        :param pulumi.Input[builtins.bool] allow_instance_pool_create: Allow the user to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        :param pulumi.Input[builtins.bool] databricks_sql_access: This is a field to allow the user to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature in User Interface and through databricks_sql_endpoint.
        :param pulumi.Input[builtins.bool] disable_as_user_deletion: Deactivate the user when deleting the resource, rather than deleting the user entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        :param pulumi.Input[builtins.str] display_name: This is an alias for the username that can be the full name of the user.
        :param pulumi.Input[builtins.str] external_id: ID of the user in an external identity provider.
        :param pulumi.Input[builtins.bool] force: Ignore `cannot create user: User with username X already exists` errors and implicitly import the specific user into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        :param pulumi.Input[builtins.bool] force_delete_home_dir: This flag determines whether the user's home directory is deleted when the user is deleted. It will have not impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[builtins.bool] force_delete_repos: This flag determines whether the user's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[builtins.str] home: Home folder of the user, e.g. `/Users/mr.foo@example.com`.
        :param pulumi.Input[builtins.str] repos: Personal Repos location of the user, e.g. `/Repos/mr.foo@example.com`.
        :param pulumi.Input[builtins.bool] workspace_access: This is a field to allow the user to have access to a Databricks Workspace.
        :param pulumi.Input[builtins.bool] workspace_consume: This is a field to allow the user to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        pulumi.set(__self__, "user_name", user_name)
        if acl_principal_id is not None:
            pulumi.set(__self__, "acl_principal_id", acl_principal_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if allow_cluster_create is not None:
            pulumi.set(__self__, "allow_cluster_create", allow_cluster_create)
        if allow_instance_pool_create is not None:
            pulumi.set(__self__, "allow_instance_pool_create", allow_instance_pool_create)
        if databricks_sql_access is not None:
            pulumi.set(__self__, "databricks_sql_access", databricks_sql_access)
        if disable_as_user_deletion is not None:
            pulumi.set(__self__, "disable_as_user_deletion", disable_as_user_deletion)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if force_delete_home_dir is not None:
            pulumi.set(__self__, "force_delete_home_dir", force_delete_home_dir)
        if force_delete_repos is not None:
            pulumi.set(__self__, "force_delete_repos", force_delete_repos)
        if home is not None:
            pulumi.set(__self__, "home", home)
        if repos is not None:
            pulumi.set(__self__, "repos", repos)
        if workspace_access is not None:
            pulumi.set(__self__, "workspace_access", workspace_access)
        if workspace_consume is not None:
            pulumi.set(__self__, "workspace_consume", workspace_consume)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[builtins.str]:
        """
        This is the username of the given user and will be their form of access and identity.  Provided username will be converted to lower case if it contains upper case characters.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="aclPrincipalId")
    def acl_principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        identifier for use in databricks_access_control_rule_set, e.g. `users/mr.foo@example.com`.
        """
        return pulumi.get(self, "acl_principal_id")

    @acl_principal_id.setter
    def acl_principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_principal_id", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Either user is active or not. True by default, but can be set to false in case of user deactivation with preserving user assets.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="allowClusterCreate")
    def allow_cluster_create(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow the user to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within boundaries of that specific policy.
        """
        return pulumi.get(self, "allow_cluster_create")

    @allow_cluster_create.setter
    def allow_cluster_create(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_cluster_create", value)

    @property
    @pulumi.getter(name="allowInstancePoolCreate")
    def allow_instance_pool_create(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow the user to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        """
        return pulumi.get(self, "allow_instance_pool_create")

    @allow_instance_pool_create.setter
    def allow_instance_pool_create(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_instance_pool_create", value)

    @property
    @pulumi.getter(name="databricksSqlAccess")
    def databricks_sql_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is a field to allow the user to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature in User Interface and through databricks_sql_endpoint.
        """
        return pulumi.get(self, "databricks_sql_access")

    @databricks_sql_access.setter
    def databricks_sql_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "databricks_sql_access", value)

    @property
    @pulumi.getter(name="disableAsUserDeletion")
    def disable_as_user_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Deactivate the user when deleting the resource, rather than deleting the user entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        """
        return pulumi.get(self, "disable_as_user_deletion")

    @disable_as_user_deletion.setter
    def disable_as_user_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_as_user_deletion", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is an alias for the username that can be the full name of the user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the user in an external identity provider.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Ignore `cannot create user: User with username X already exists` errors and implicitly import the specific user into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="forceDeleteHomeDir")
    def force_delete_home_dir(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This flag determines whether the user's home directory is deleted when the user is deleted. It will have not impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_home_dir")

    @force_delete_home_dir.setter
    def force_delete_home_dir(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete_home_dir", value)

    @property
    @pulumi.getter(name="forceDeleteRepos")
    def force_delete_repos(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This flag determines whether the user's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_repos")

    @force_delete_repos.setter
    def force_delete_repos(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete_repos", value)

    @property
    @pulumi.getter
    def home(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Home folder of the user, e.g. `/Users/mr.foo@example.com`.
        """
        return pulumi.get(self, "home")

    @home.setter
    def home(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "home", value)

    @property
    @pulumi.getter
    def repos(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Personal Repos location of the user, e.g. `/Repos/mr.foo@example.com`.
        """
        return pulumi.get(self, "repos")

    @repos.setter
    def repos(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repos", value)

    @property
    @pulumi.getter(name="workspaceAccess")
    def workspace_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is a field to allow the user to have access to a Databricks Workspace.
        """
        return pulumi.get(self, "workspace_access")

    @workspace_access.setter
    def workspace_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "workspace_access", value)

    @property
    @pulumi.getter(name="workspaceConsume")
    def workspace_consume(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is a field to allow the user to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        return pulumi.get(self, "workspace_consume")

    @workspace_consume.setter
    def workspace_consume(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "workspace_consume", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 acl_principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_cluster_create: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_instance_pool_create: Optional[pulumi.Input[builtins.bool]] = None,
                 databricks_sql_access: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_as_user_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_home_dir: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_repos: Optional[pulumi.Input[builtins.bool]] = None,
                 home: Optional[pulumi.Input[builtins.str]] = None,
                 repos: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_access: Optional[pulumi.Input[builtins.bool]] = None,
                 workspace_consume: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.str] acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `users/mr.foo@example.com`.
        :param pulumi.Input[builtins.bool] active: Either user is active or not. True by default, but can be set to false in case of user deactivation with preserving user assets.
        :param pulumi.Input[builtins.bool] allow_cluster_create: Allow the user to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within boundaries of that specific policy.
        :param pulumi.Input[builtins.bool] allow_instance_pool_create: Allow the user to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        :param pulumi.Input[builtins.bool] databricks_sql_access: This is a field to allow the user to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature in User Interface and through databricks_sql_endpoint.
        :param pulumi.Input[builtins.bool] disable_as_user_deletion: Deactivate the user when deleting the resource, rather than deleting the user entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        :param pulumi.Input[builtins.str] display_name: This is an alias for the username that can be the full name of the user.
        :param pulumi.Input[builtins.str] external_id: ID of the user in an external identity provider.
        :param pulumi.Input[builtins.bool] force: Ignore `cannot create user: User with username X already exists` errors and implicitly import the specific user into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        :param pulumi.Input[builtins.bool] force_delete_home_dir: This flag determines whether the user's home directory is deleted when the user is deleted. It will have not impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[builtins.bool] force_delete_repos: This flag determines whether the user's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[builtins.str] home: Home folder of the user, e.g. `/Users/mr.foo@example.com`.
        :param pulumi.Input[builtins.str] repos: Personal Repos location of the user, e.g. `/Repos/mr.foo@example.com`.
        :param pulumi.Input[builtins.str] user_name: This is the username of the given user and will be their form of access and identity.  Provided username will be converted to lower case if it contains upper case characters.
        :param pulumi.Input[builtins.bool] workspace_access: This is a field to allow the user to have access to a Databricks Workspace.
        :param pulumi.Input[builtins.bool] workspace_consume: This is a field to allow the user to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        if acl_principal_id is not None:
            pulumi.set(__self__, "acl_principal_id", acl_principal_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if allow_cluster_create is not None:
            pulumi.set(__self__, "allow_cluster_create", allow_cluster_create)
        if allow_instance_pool_create is not None:
            pulumi.set(__self__, "allow_instance_pool_create", allow_instance_pool_create)
        if databricks_sql_access is not None:
            pulumi.set(__self__, "databricks_sql_access", databricks_sql_access)
        if disable_as_user_deletion is not None:
            pulumi.set(__self__, "disable_as_user_deletion", disable_as_user_deletion)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if force_delete_home_dir is not None:
            pulumi.set(__self__, "force_delete_home_dir", force_delete_home_dir)
        if force_delete_repos is not None:
            pulumi.set(__self__, "force_delete_repos", force_delete_repos)
        if home is not None:
            pulumi.set(__self__, "home", home)
        if repos is not None:
            pulumi.set(__self__, "repos", repos)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if workspace_access is not None:
            pulumi.set(__self__, "workspace_access", workspace_access)
        if workspace_consume is not None:
            pulumi.set(__self__, "workspace_consume", workspace_consume)

    @property
    @pulumi.getter(name="aclPrincipalId")
    def acl_principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        identifier for use in databricks_access_control_rule_set, e.g. `users/mr.foo@example.com`.
        """
        return pulumi.get(self, "acl_principal_id")

    @acl_principal_id.setter
    def acl_principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_principal_id", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Either user is active or not. True by default, but can be set to false in case of user deactivation with preserving user assets.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="allowClusterCreate")
    def allow_cluster_create(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow the user to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within boundaries of that specific policy.
        """
        return pulumi.get(self, "allow_cluster_create")

    @allow_cluster_create.setter
    def allow_cluster_create(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_cluster_create", value)

    @property
    @pulumi.getter(name="allowInstancePoolCreate")
    def allow_instance_pool_create(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow the user to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        """
        return pulumi.get(self, "allow_instance_pool_create")

    @allow_instance_pool_create.setter
    def allow_instance_pool_create(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_instance_pool_create", value)

    @property
    @pulumi.getter(name="databricksSqlAccess")
    def databricks_sql_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is a field to allow the user to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature in User Interface and through databricks_sql_endpoint.
        """
        return pulumi.get(self, "databricks_sql_access")

    @databricks_sql_access.setter
    def databricks_sql_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "databricks_sql_access", value)

    @property
    @pulumi.getter(name="disableAsUserDeletion")
    def disable_as_user_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Deactivate the user when deleting the resource, rather than deleting the user entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        """
        return pulumi.get(self, "disable_as_user_deletion")

    @disable_as_user_deletion.setter
    def disable_as_user_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_as_user_deletion", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is an alias for the username that can be the full name of the user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the user in an external identity provider.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Ignore `cannot create user: User with username X already exists` errors and implicitly import the specific user into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="forceDeleteHomeDir")
    def force_delete_home_dir(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This flag determines whether the user's home directory is deleted when the user is deleted. It will have not impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_home_dir")

    @force_delete_home_dir.setter
    def force_delete_home_dir(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete_home_dir", value)

    @property
    @pulumi.getter(name="forceDeleteRepos")
    def force_delete_repos(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This flag determines whether the user's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_repos")

    @force_delete_repos.setter
    def force_delete_repos(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete_repos", value)

    @property
    @pulumi.getter
    def home(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Home folder of the user, e.g. `/Users/mr.foo@example.com`.
        """
        return pulumi.get(self, "home")

    @home.setter
    def home(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "home", value)

    @property
    @pulumi.getter
    def repos(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Personal Repos location of the user, e.g. `/Repos/mr.foo@example.com`.
        """
        return pulumi.get(self, "repos")

    @repos.setter
    def repos(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repos", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is the username of the given user and will be their form of access and identity.  Provided username will be converted to lower case if it contains upper case characters.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="workspaceAccess")
    def workspace_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is a field to allow the user to have access to a Databricks Workspace.
        """
        return pulumi.get(self, "workspace_access")

    @workspace_access.setter
    def workspace_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "workspace_access", value)

    @property
    @pulumi.getter(name="workspaceConsume")
    def workspace_consume(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This is a field to allow the user to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        return pulumi.get(self, "workspace_consume")

    @workspace_consume.setter
    def workspace_consume(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "workspace_consume", value)


@pulumi.type_token("databricks:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_cluster_create: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_instance_pool_create: Optional[pulumi.Input[builtins.bool]] = None,
                 databricks_sql_access: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_as_user_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_home_dir: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_repos: Optional[pulumi.Input[builtins.bool]] = None,
                 home: Optional[pulumi.Input[builtins.str]] = None,
                 repos: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_access: Optional[pulumi.Input[builtins.bool]] = None,
                 workspace_consume: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource allows you to manage [users in Databricks Workspace](https://docs.databricks.com/administration-guide/users-groups/users.html), [Databricks Account Console](https://accounts.cloud.databricks.com/) or [Azure Databricks Account Console](https://accounts.azuredatabricks.net). You can also associate Databricks users to databricks_group. Upon user creation the user will receive a welcome email. You can also get information about caller identity using get_current_user data source.

        > This resource can be used with an account or workspace-level provider.

        > To assign account level users to workspace use databricks_mws_permission_assignment.

        > Entitlements, like, `allow_cluster_create`, `allow_instance_pool_create`, `databricks_sql_access`, `workspace_access`, `workspace_consume` applicable only for workspace-level users.  Use Entitlements resource to assign entitlements inside a workspace to account-level users.

        To create users in the Databricks account, the provider must be configured with `host = "https://accounts.cloud.databricks.com"` on AWS deployments or `host = "https://accounts.azuredatabricks.net"` and authenticate using AAD tokens on Azure deployments.

        The default behavior when deleting a `User` resource depends on whether the provider is configured at the workspace-level or account-level. When the provider is configured at the workspace-level, the user will be deleted from the workspace. When the provider is configured at the account-level, the user will be deactivated but not deleted. When the provider is configured at the account level, to delete the user from the account when the resource is deleted, set `disable_as_user_deletion = false`. Conversely, when the provider is configured at the account-level, to deactivate the user when the resource is deleted, set `disable_as_user_deletion = true`.

        ## Example Usage

        Creating regular user:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.User("me", user_name="me@example.com")
        ```

        Creating user with administrative permissions - referencing special `admins` Group in GroupMember resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        admins = databricks.get_group(display_name="admins")
        me = databricks.User("me", user_name="me@example.com")
        i_am_admin = databricks.GroupMember("i-am-admin",
            group_id=admins.id,
            member_id=me.id)
        ```

        Creating user with cluster create permissions:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.User("me",
            user_name="me@example.com",
            display_name="Example user",
            allow_cluster_create=True)
        ```

        Creating user in AWS Databricks account:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        account_user = databricks.User("account_user",
            user_name="me@example.com",
            display_name="Example user")
        ```

        Creating user in Azure Databricks account:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        account_user = databricks.User("account_user",
            user_name="me@example.com",
            display_name="Example user")
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * Group to manage [groups in Databricks Workspace](https://docs.databricks.com/administration-guide/users-groups/groups.html) or [Account Console](https://accounts.cloud.databricks.com/) (for AWS deployments).
        * Group data to retrieve information about Group members, entitlements and instance profiles.
        * GroupInstanceProfile to attach InstanceProfile (AWS) to databricks_group.
        * GroupMember to attach users and groups as group members.
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.
        * User data to retrieve information about databricks_user.

        ## Import

        The resource scim user can be imported using its SCIM id:

        hcl

        import {

          to = databricks_user.this

          id = "<user-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/user:User this "<user-id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `users/mr.foo@example.com`.
        :param pulumi.Input[builtins.bool] active: Either user is active or not. True by default, but can be set to false in case of user deactivation with preserving user assets.
        :param pulumi.Input[builtins.bool] allow_cluster_create: Allow the user to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within boundaries of that specific policy.
        :param pulumi.Input[builtins.bool] allow_instance_pool_create: Allow the user to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        :param pulumi.Input[builtins.bool] databricks_sql_access: This is a field to allow the user to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature in User Interface and through databricks_sql_endpoint.
        :param pulumi.Input[builtins.bool] disable_as_user_deletion: Deactivate the user when deleting the resource, rather than deleting the user entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        :param pulumi.Input[builtins.str] display_name: This is an alias for the username that can be the full name of the user.
        :param pulumi.Input[builtins.str] external_id: ID of the user in an external identity provider.
        :param pulumi.Input[builtins.bool] force: Ignore `cannot create user: User with username X already exists` errors and implicitly import the specific user into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        :param pulumi.Input[builtins.bool] force_delete_home_dir: This flag determines whether the user's home directory is deleted when the user is deleted. It will have not impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[builtins.bool] force_delete_repos: This flag determines whether the user's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[builtins.str] home: Home folder of the user, e.g. `/Users/mr.foo@example.com`.
        :param pulumi.Input[builtins.str] repos: Personal Repos location of the user, e.g. `/Repos/mr.foo@example.com`.
        :param pulumi.Input[builtins.str] user_name: This is the username of the given user and will be their form of access and identity.  Provided username will be converted to lower case if it contains upper case characters.
        :param pulumi.Input[builtins.bool] workspace_access: This is a field to allow the user to have access to a Databricks Workspace.
        :param pulumi.Input[builtins.bool] workspace_consume: This is a field to allow the user to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [users in Databricks Workspace](https://docs.databricks.com/administration-guide/users-groups/users.html), [Databricks Account Console](https://accounts.cloud.databricks.com/) or [Azure Databricks Account Console](https://accounts.azuredatabricks.net). You can also associate Databricks users to databricks_group. Upon user creation the user will receive a welcome email. You can also get information about caller identity using get_current_user data source.

        > This resource can be used with an account or workspace-level provider.

        > To assign account level users to workspace use databricks_mws_permission_assignment.

        > Entitlements, like, `allow_cluster_create`, `allow_instance_pool_create`, `databricks_sql_access`, `workspace_access`, `workspace_consume` applicable only for workspace-level users.  Use Entitlements resource to assign entitlements inside a workspace to account-level users.

        To create users in the Databricks account, the provider must be configured with `host = "https://accounts.cloud.databricks.com"` on AWS deployments or `host = "https://accounts.azuredatabricks.net"` and authenticate using AAD tokens on Azure deployments.

        The default behavior when deleting a `User` resource depends on whether the provider is configured at the workspace-level or account-level. When the provider is configured at the workspace-level, the user will be deleted from the workspace. When the provider is configured at the account-level, the user will be deactivated but not deleted. When the provider is configured at the account level, to delete the user from the account when the resource is deleted, set `disable_as_user_deletion = false`. Conversely, when the provider is configured at the account-level, to deactivate the user when the resource is deleted, set `disable_as_user_deletion = true`.

        ## Example Usage

        Creating regular user:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.User("me", user_name="me@example.com")
        ```

        Creating user with administrative permissions - referencing special `admins` Group in GroupMember resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        admins = databricks.get_group(display_name="admins")
        me = databricks.User("me", user_name="me@example.com")
        i_am_admin = databricks.GroupMember("i-am-admin",
            group_id=admins.id,
            member_id=me.id)
        ```

        Creating user with cluster create permissions:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        me = databricks.User("me",
            user_name="me@example.com",
            display_name="Example user",
            allow_cluster_create=True)
        ```

        Creating user in AWS Databricks account:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        account_user = databricks.User("account_user",
            user_name="me@example.com",
            display_name="Example user")
        ```

        Creating user in Azure Databricks account:

        ```python
        import pulumi
        import pulumi_databricks as databricks

        account_user = databricks.User("account_user",
            user_name="me@example.com",
            display_name="Example user")
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * Group to manage [groups in Databricks Workspace](https://docs.databricks.com/administration-guide/users-groups/groups.html) or [Account Console](https://accounts.cloud.databricks.com/) (for AWS deployments).
        * Group data to retrieve information about Group members, entitlements and instance profiles.
        * GroupInstanceProfile to attach InstanceProfile (AWS) to databricks_group.
        * GroupMember to attach users and groups as group members.
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.
        * User data to retrieve information about databricks_user.

        ## Import

        The resource scim user can be imported using its SCIM id:

        hcl

        import {

          to = databricks_user.this

          id = "<user-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/user:User this "<user-id>"
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_cluster_create: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_instance_pool_create: Optional[pulumi.Input[builtins.bool]] = None,
                 databricks_sql_access: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_as_user_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_home_dir: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_repos: Optional[pulumi.Input[builtins.bool]] = None,
                 home: Optional[pulumi.Input[builtins.str]] = None,
                 repos: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_access: Optional[pulumi.Input[builtins.bool]] = None,
                 workspace_consume: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["acl_principal_id"] = acl_principal_id
            __props__.__dict__["active"] = active
            __props__.__dict__["allow_cluster_create"] = allow_cluster_create
            __props__.__dict__["allow_instance_pool_create"] = allow_instance_pool_create
            __props__.__dict__["databricks_sql_access"] = databricks_sql_access
            __props__.__dict__["disable_as_user_deletion"] = disable_as_user_deletion
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["force"] = force
            __props__.__dict__["force_delete_home_dir"] = force_delete_home_dir
            __props__.__dict__["force_delete_repos"] = force_delete_repos
            __props__.__dict__["home"] = home
            __props__.__dict__["repos"] = repos
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["workspace_access"] = workspace_access
            __props__.__dict__["workspace_consume"] = workspace_consume
        super(User, __self__).__init__(
            'databricks:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_principal_id: Optional[pulumi.Input[builtins.str]] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            allow_cluster_create: Optional[pulumi.Input[builtins.bool]] = None,
            allow_instance_pool_create: Optional[pulumi.Input[builtins.bool]] = None,
            databricks_sql_access: Optional[pulumi.Input[builtins.bool]] = None,
            disable_as_user_deletion: Optional[pulumi.Input[builtins.bool]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            external_id: Optional[pulumi.Input[builtins.str]] = None,
            force: Optional[pulumi.Input[builtins.bool]] = None,
            force_delete_home_dir: Optional[pulumi.Input[builtins.bool]] = None,
            force_delete_repos: Optional[pulumi.Input[builtins.bool]] = None,
            home: Optional[pulumi.Input[builtins.str]] = None,
            repos: Optional[pulumi.Input[builtins.str]] = None,
            user_name: Optional[pulumi.Input[builtins.str]] = None,
            workspace_access: Optional[pulumi.Input[builtins.bool]] = None,
            workspace_consume: Optional[pulumi.Input[builtins.bool]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] acl_principal_id: identifier for use in databricks_access_control_rule_set, e.g. `users/mr.foo@example.com`.
        :param pulumi.Input[builtins.bool] active: Either user is active or not. True by default, but can be set to false in case of user deactivation with preserving user assets.
        :param pulumi.Input[builtins.bool] allow_cluster_create: Allow the user to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within boundaries of that specific policy.
        :param pulumi.Input[builtins.bool] allow_instance_pool_create: Allow the user to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        :param pulumi.Input[builtins.bool] databricks_sql_access: This is a field to allow the user to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature in User Interface and through databricks_sql_endpoint.
        :param pulumi.Input[builtins.bool] disable_as_user_deletion: Deactivate the user when deleting the resource, rather than deleting the user entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        :param pulumi.Input[builtins.str] display_name: This is an alias for the username that can be the full name of the user.
        :param pulumi.Input[builtins.str] external_id: ID of the user in an external identity provider.
        :param pulumi.Input[builtins.bool] force: Ignore `cannot create user: User with username X already exists` errors and implicitly import the specific user into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        :param pulumi.Input[builtins.bool] force_delete_home_dir: This flag determines whether the user's home directory is deleted when the user is deleted. It will have not impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[builtins.bool] force_delete_repos: This flag determines whether the user's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        :param pulumi.Input[builtins.str] home: Home folder of the user, e.g. `/Users/mr.foo@example.com`.
        :param pulumi.Input[builtins.str] repos: Personal Repos location of the user, e.g. `/Repos/mr.foo@example.com`.
        :param pulumi.Input[builtins.str] user_name: This is the username of the given user and will be their form of access and identity.  Provided username will be converted to lower case if it contains upper case characters.
        :param pulumi.Input[builtins.bool] workspace_access: This is a field to allow the user to have access to a Databricks Workspace.
        :param pulumi.Input[builtins.bool] workspace_consume: This is a field to allow the user to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["acl_principal_id"] = acl_principal_id
        __props__.__dict__["active"] = active
        __props__.__dict__["allow_cluster_create"] = allow_cluster_create
        __props__.__dict__["allow_instance_pool_create"] = allow_instance_pool_create
        __props__.__dict__["databricks_sql_access"] = databricks_sql_access
        __props__.__dict__["disable_as_user_deletion"] = disable_as_user_deletion
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["force"] = force
        __props__.__dict__["force_delete_home_dir"] = force_delete_home_dir
        __props__.__dict__["force_delete_repos"] = force_delete_repos
        __props__.__dict__["home"] = home
        __props__.__dict__["repos"] = repos
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["workspace_access"] = workspace_access
        __props__.__dict__["workspace_consume"] = workspace_consume
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclPrincipalId")
    def acl_principal_id(self) -> pulumi.Output[builtins.str]:
        """
        identifier for use in databricks_access_control_rule_set, e.g. `users/mr.foo@example.com`.
        """
        return pulumi.get(self, "acl_principal_id")

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Either user is active or not. True by default, but can be set to false in case of user deactivation with preserving user assets.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="allowClusterCreate")
    def allow_cluster_create(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Allow the user to have cluster create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and `cluster_id` argument. Everyone without `allow_cluster_create` argument set, but with permission to use Cluster Policy would be able to create clusters, but within boundaries of that specific policy.
        """
        return pulumi.get(self, "allow_cluster_create")

    @property
    @pulumi.getter(name="allowInstancePoolCreate")
    def allow_instance_pool_create(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Allow the user to have instance pool create privileges. Defaults to false. More fine grained permissions could be assigned with Permissions and instance_pool_id argument.
        """
        return pulumi.get(self, "allow_instance_pool_create")

    @property
    @pulumi.getter(name="databricksSqlAccess")
    def databricks_sql_access(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This is a field to allow the user to have access to [Databricks SQL](https://databricks.com/product/databricks-sql) feature in User Interface and through databricks_sql_endpoint.
        """
        return pulumi.get(self, "databricks_sql_access")

    @property
    @pulumi.getter(name="disableAsUserDeletion")
    def disable_as_user_deletion(self) -> pulumi.Output[builtins.bool]:
        """
        Deactivate the user when deleting the resource, rather than deleting the user entirely. Defaults to `true` when the provider is configured at the account-level and `false` when configured at the workspace-level. This flag is exclusive to force_delete_repos and force_delete_home_dir flags.
        """
        return pulumi.get(self, "disable_as_user_deletion")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        This is an alias for the username that can be the full name of the user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID of the user in an external identity provider.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Ignore `cannot create user: User with username X already exists` errors and implicitly import the specific user into Pulumi state, enforcing entitlements defined in the instance of resource. _This functionality is experimental_ and is designed to simplify corner cases, like Azure Active Directory synchronisation.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter(name="forceDeleteHomeDir")
    def force_delete_home_dir(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This flag determines whether the user's home directory is deleted when the user is deleted. It will have not impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_home_dir")

    @property
    @pulumi.getter(name="forceDeleteRepos")
    def force_delete_repos(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This flag determines whether the user's repo directory is deleted when the user is deleted. It will have no impact when in the accounts SCIM API. False by default.
        """
        return pulumi.get(self, "force_delete_repos")

    @property
    @pulumi.getter
    def home(self) -> pulumi.Output[builtins.str]:
        """
        Home folder of the user, e.g. `/Users/mr.foo@example.com`.
        """
        return pulumi.get(self, "home")

    @property
    @pulumi.getter
    def repos(self) -> pulumi.Output[builtins.str]:
        """
        Personal Repos location of the user, e.g. `/Repos/mr.foo@example.com`.
        """
        return pulumi.get(self, "repos")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[builtins.str]:
        """
        This is the username of the given user and will be their form of access and identity.  Provided username will be converted to lower case if it contains upper case characters.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="workspaceAccess")
    def workspace_access(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This is a field to allow the user to have access to a Databricks Workspace.
        """
        return pulumi.get(self, "workspace_access")

    @property
    @pulumi.getter(name="workspaceConsume")
    def workspace_consume(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This is a field to allow the user to have access to a Databricks Workspace as consumer, with limited access to workspace UI.  Couldn't be used with `workspace_access` or `databricks_sql_access`.
        """
        return pulumi.get(self, "workspace_consume")

