# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WorkspaceConfArgs', 'WorkspaceConf']

@pulumi.input_type
class WorkspaceConfArgs:
    def __init__(__self__, *,
                 custom_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a WorkspaceConf resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_config: Key-value map of strings that represent workspace configuration. Upon resource deletion, properties that start with `enable` or `enforce` will be reset to `false` value, regardless of initial default one.
        """
        if custom_config is not None:
            pulumi.set(__self__, "custom_config", custom_config)

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of strings that represent workspace configuration. Upon resource deletion, properties that start with `enable` or `enforce` will be reset to `false` value, regardless of initial default one.
        """
        return pulumi.get(self, "custom_config")

    @custom_config.setter
    def custom_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_config", value)


@pulumi.input_type
class _WorkspaceConfState:
    def __init__(__self__, *,
                 custom_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering WorkspaceConf resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_config: Key-value map of strings that represent workspace configuration. Upon resource deletion, properties that start with `enable` or `enforce` will be reset to `false` value, regardless of initial default one.
        """
        if custom_config is not None:
            pulumi.set(__self__, "custom_config", custom_config)

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of strings that represent workspace configuration. Upon resource deletion, properties that start with `enable` or `enforce` will be reset to `false` value, regardless of initial default one.
        """
        return pulumi.get(self, "custom_config")

    @custom_config.setter
    def custom_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_config", value)


@pulumi.type_token("databricks:index/workspaceConf:WorkspaceConf")
class WorkspaceConf(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages workspace configuration for expert usage. Currently, more than one instance of resource can exist in Pulumi state, though there's no deterministic behavior, when they manage the same property. We strongly recommend to use a single `WorkspaceConf` per workspace.

        > This resource can only be used with a workspace-level provider!

        > This resource has an evolving API, which may change in future versions of the provider.

        > Deleting `WorkspaceConf` resources may fail depending on the configuration properties set, including but not limited to `enableIpAccessLists`, `enableGp3`, and `maxTokenLifetimeDays`. The provider will print a warning if this occurs. You can verify the workspace configuration by reviewing [the workspace settings in the UI](https://docs.databricks.com/en/admin/workspace-settings/index.html).

        ## Example Usage

        Allows specification of custom configuration properties for expert usage:

        - `enableIpAccessLists` - enables the use of IpAccessList resources
        - `maxTokenLifetimeDays` - (string) Maximum token lifetime of new tokens in days, as an integer. This value can range from 1 day to 730 days (2 years). If not specified, the maximum lifetime of new tokens is 730 days. **WARNING:** This limit only applies to new tokens, so there may be tokens with lifetimes longer than this value, including unlimited lifetime. Such tokens may have been created before the current maximum token lifetime was set.
        - `enableTokensConfig` - (boolean) Enable or disable personal access tokens for this workspace.
        - `enableDeprecatedClusterNamedInitScripts` - (boolean) Enable or disable [legacy cluster-named init scripts](https://docs.databricks.com/clusters/init-scripts.html#disable-legacy-cluster-named-init-scripts-for-a-workspace) for this workspace.
        - `enableDeprecatedGlobalInitScripts` - (boolean) Enable or disable [legacy global init scripts](https://docs.databricks.com/clusters/init-scripts.html#migrate-legacy-scripts) for this workspace.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.WorkspaceConf("this", custom_config={
            "enableIpAccessLists": "true",
        })
        ```

        ## Import

        !> Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_config: Key-value map of strings that represent workspace configuration. Upon resource deletion, properties that start with `enable` or `enforce` will be reset to `false` value, regardless of initial default one.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[WorkspaceConfArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages workspace configuration for expert usage. Currently, more than one instance of resource can exist in Pulumi state, though there's no deterministic behavior, when they manage the same property. We strongly recommend to use a single `WorkspaceConf` per workspace.

        > This resource can only be used with a workspace-level provider!

        > This resource has an evolving API, which may change in future versions of the provider.

        > Deleting `WorkspaceConf` resources may fail depending on the configuration properties set, including but not limited to `enableIpAccessLists`, `enableGp3`, and `maxTokenLifetimeDays`. The provider will print a warning if this occurs. You can verify the workspace configuration by reviewing [the workspace settings in the UI](https://docs.databricks.com/en/admin/workspace-settings/index.html).

        ## Example Usage

        Allows specification of custom configuration properties for expert usage:

        - `enableIpAccessLists` - enables the use of IpAccessList resources
        - `maxTokenLifetimeDays` - (string) Maximum token lifetime of new tokens in days, as an integer. This value can range from 1 day to 730 days (2 years). If not specified, the maximum lifetime of new tokens is 730 days. **WARNING:** This limit only applies to new tokens, so there may be tokens with lifetimes longer than this value, including unlimited lifetime. Such tokens may have been created before the current maximum token lifetime was set.
        - `enableTokensConfig` - (boolean) Enable or disable personal access tokens for this workspace.
        - `enableDeprecatedClusterNamedInitScripts` - (boolean) Enable or disable [legacy cluster-named init scripts](https://docs.databricks.com/clusters/init-scripts.html#disable-legacy-cluster-named-init-scripts-for-a-workspace) for this workspace.
        - `enableDeprecatedGlobalInitScripts` - (boolean) Enable or disable [legacy global init scripts](https://docs.databricks.com/clusters/init-scripts.html#migrate-legacy-scripts) for this workspace.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.WorkspaceConf("this", custom_config={
            "enableIpAccessLists": "true",
        })
        ```

        ## Import

        !> Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param WorkspaceConfArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceConfArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceConfArgs.__new__(WorkspaceConfArgs)

            __props__.__dict__["custom_config"] = custom_config
        super(WorkspaceConf, __self__).__init__(
            'databricks:index/workspaceConf:WorkspaceConf',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'WorkspaceConf':
        """
        Get an existing WorkspaceConf resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_config: Key-value map of strings that represent workspace configuration. Upon resource deletion, properties that start with `enable` or `enforce` will be reset to `false` value, regardless of initial default one.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceConfState.__new__(_WorkspaceConfState)

        __props__.__dict__["custom_config"] = custom_config
        return WorkspaceConf(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of strings that represent workspace configuration. Upon resource deletion, properties that start with `enable` or `enforce` will be reset to `false` value, regardless of initial default one.
        """
        return pulumi.get(self, "custom_config")

