# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WorkspaceNetworkOptionArgs', 'WorkspaceNetworkOption']

@pulumi.input_type
class WorkspaceNetworkOptionArgs:
    def __init__(__self__, *,
                 network_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceNetworkOption resource.
        :param pulumi.Input[builtins.str] network_policy_id: The network policy ID to apply to the workspace. This controls the network access rules
               for all serverless compute resources in the workspace. Each workspace can only be
               linked to one policy at a time. If no policy is explicitly assigned,
               the workspace will use 'default-policy'
        :param pulumi.Input[builtins.str] workspace_id: The workspace ID
        """
        if network_policy_id is not None:
            pulumi.set(__self__, "network_policy_id", network_policy_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="networkPolicyId")
    def network_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network policy ID to apply to the workspace. This controls the network access rules
        for all serverless compute resources in the workspace. Each workspace can only be
        linked to one policy at a time. If no policy is explicitly assigned,
        the workspace will use 'default-policy'
        """
        return pulumi.get(self, "network_policy_id")

    @network_policy_id.setter
    def network_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_policy_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The workspace ID
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _WorkspaceNetworkOptionState:
    def __init__(__self__, *,
                 network_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceNetworkOption resources.
        :param pulumi.Input[builtins.str] network_policy_id: The network policy ID to apply to the workspace. This controls the network access rules
               for all serverless compute resources in the workspace. Each workspace can only be
               linked to one policy at a time. If no policy is explicitly assigned,
               the workspace will use 'default-policy'
        :param pulumi.Input[builtins.str] workspace_id: The workspace ID
        """
        if network_policy_id is not None:
            pulumi.set(__self__, "network_policy_id", network_policy_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="networkPolicyId")
    def network_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network policy ID to apply to the workspace. This controls the network access rules
        for all serverless compute resources in the workspace. Each workspace can only be
        linked to one policy at a time. If no policy is explicitly assigned,
        the workspace will use 'default-policy'
        """
        return pulumi.get(self, "network_policy_id")

    @network_policy_id.setter
    def network_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_policy_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The workspace ID
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/workspaceNetworkOption:WorkspaceNetworkOption")
class WorkspaceNetworkOption(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = workspace_id

          to = databricks_workspace_network_option.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/workspaceNetworkOption:WorkspaceNetworkOption databricks_workspace_network_option workspace_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_policy_id: The network policy ID to apply to the workspace. This controls the network access rules
               for all serverless compute resources in the workspace. Each workspace can only be
               linked to one policy at a time. If no policy is explicitly assigned,
               the workspace will use 'default-policy'
        :param pulumi.Input[builtins.str] workspace_id: The workspace ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[WorkspaceNetworkOptionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = workspace_id

          to = databricks_workspace_network_option.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/workspaceNetworkOption:WorkspaceNetworkOption databricks_workspace_network_option workspace_id
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceNetworkOptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceNetworkOptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceNetworkOptionArgs.__new__(WorkspaceNetworkOptionArgs)

            __props__.__dict__["network_policy_id"] = network_policy_id
            __props__.__dict__["workspace_id"] = workspace_id
        super(WorkspaceNetworkOption, __self__).__init__(
            'databricks:index/workspaceNetworkOption:WorkspaceNetworkOption',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkspaceNetworkOption':
        """
        Get an existing WorkspaceNetworkOption resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_policy_id: The network policy ID to apply to the workspace. This controls the network access rules
               for all serverless compute resources in the workspace. Each workspace can only be
               linked to one policy at a time. If no policy is explicitly assigned,
               the workspace will use 'default-policy'
        :param pulumi.Input[builtins.str] workspace_id: The workspace ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceNetworkOptionState.__new__(_WorkspaceNetworkOptionState)

        __props__.__dict__["network_policy_id"] = network_policy_id
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceNetworkOption(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="networkPolicyId")
    def network_policy_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The network policy ID to apply to the workspace. This controls the network access rules
        for all serverless compute resources in the workspace. Each workspace can only be
        linked to one policy at a time. If no policy is explicitly assigned,
        the workspace will use 'default-policy'
        """
        return pulumi.get(self, "network_policy_id")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The workspace ID
        """
        return pulumi.get(self, "workspace_id")

