import uuid


# 使用 echarts 的基本图表
def chart_html(option):
    uid = uuid.uuid4().hex
    s = ['<!DOCTYPE html>',
         '<html lang="zh-CN" style="height: 100%;">',
         '<head>',
         '    <meta charset="utf-8">',
         '</head>',
         '<body style="height: calc(100% - 40px);margin: 0;">',
         '<div id="container-uid-" style="height: 100%;margin: 20px;"></div>',
         '<script type="text/javascript" src="https://fastly.jsdelivr.net/npm/echarts/dist/echarts.min.js"></script>',
         '<script type="text/javascript">',
         '    var option-uid- = -option-;',
         '    var myChart-uid- = echarts.init(document.getElementById("container-uid-"), null, {',
         '        renderer: "canvas",',
         '        useDirtyRect: false,',
         '    });',
         '    myChart-uid-.setOption(option-uid-);',
         '    window.addEventListener("resize", myChart-uid-.resize);',
         '</script>',
         '</body>',
         '</html>',
         '']
    return list(map(lambda x: x.replace('-option-', '\n    '.join(option)).replace('-uid-', uid), s))


# 使用 table 的基本图表
def table_list_html(table_list, header_obj, title):
    uid = uuid.uuid4().hex
    s = ['<!DOCTYPE html>',
         '<html lang="zh-CN" style="height: 100%;">',
         '<head>',
         '    <meta charset="UTF-8">',
         '    <link rel="stylesheet" href="https://unpkg.com/element-ui/lib/theme-chalk/index.css">',
         '</head>',
         '<body style="height: calc(100% - 40px);margin: 0;">',
         '<div id="app-uid-" style="height: 100%;margin: 20px;">',
         '    <el-row style="padding: 10px;">',
         '        <el-col :span="12" style="text-align: right;">',
         '            <span style="font-size: 1.5em;font-weight: bold;">-title-</span>',
         '        </el-col>',
         '        <el-col :span="12" style="text-align: right;">',
         '            <el-button type="primary" size="small" @click="export_csv()">导出 CSV</el-button>',
         '        </el-col>',
         '    </el-row>',
         '    <el-table',
         '            :data="tableData-uid-"',
         '            border',
         '            stripe',
         '            max-height="850"',
         '            style="width: 100%">',
         '        <el-table-column label="序号" type="index" fixed width="50"></el-table-column>',
         '        <el-table-column v-for="(value, key, index) of header-uid-" :key="index"',
         '                         :fixed="index===0" sortable :prop="key" :label="value">',
         '        </el-table-column>',
         '    </el-table>',
         '</div>',
         '</body>',
         '<script src="https://unpkg.com/vue@2/dist/vue.js"></script>',
         '<script src="https://unpkg.com/element-ui/lib/index.js"></script>',
         '<script>',
         '    new Vue({',
         '        el: "#app-uid-",',
         '        data: function () {',
         '            return {',
         '                header-uid-: {',
         '                    -header_obj-',
         '                },',
         '                tableData-uid-: [',
         '                    -table_list-',
         '                ]',
         '            }',
         '        },',
         '		  methods: {',
         '            export_csv() {',
         '                let list = []',
         '                let date = new Date();',
         '                let name = "" + date.getFullYear() + (date.getMonth() + 1) + date.getDate() + "_" + date.getHours() + date.getMinutes() + date.getSeconds()',
         '                let first = []',
         '                for (let k of Object.keys(this.header-uid-)) {',
         '                    first.push(this.header-uid-[k])',
         '                }',
         '                list.push(first)',
         '                this.tableData-uid-.map(t => {',
         '                    let line = []',
         '                    for (let k of Object.keys(this.header-uid-)) {',
         '                        line.push(t[k])',
         '                    }',
         '                    list.push(line)',
         '                })',
         '                const newList = list.map(res => res.join(","))',
         '                const data = newList.join(",\\n")',
         '                var uri = "data:text/csv;charset=utf-8,\\ufeff" + encodeURIComponent(data);',
         '                var downloadLink = document.createElement("a");',
         '                downloadLink.href = uri;',
         '                downloadLink.download = (name + ".csv") || "temp.csv";',
         '                document.body.appendChild(downloadLink);',
         '                downloadLink.click();',
         '                document.body.removeChild(downloadLink);',
         '            }',
         '        }',
         '    })',
         '</script>',
         '</html>']
    return list(map(lambda x: x.replace('-header_obj-', ',\n                    '.join(header_obj))
                    .replace('-title-', title)
                    .replace('-table_list-', ',\n                    '.join(table_list))
                    .replace('-uid-', uid), s))


# 使用 text 的基本图表
def text_list_html(text_list, title):
    uid = uuid.uuid4().hex
    s = ['<!DOCTYPE html>',
         '<html lang="zh-CN" style="height: 100%;">',
         '<head>',
         '    <meta charset="UTF-8">',
         '    <link rel="stylesheet" href="https://unpkg.com/element-ui/lib/theme-chalk/index.css">',
         '</head>',
         '<body style="height: calc(100% - 40px);margin: 0;">',
         '<div id="app-uid-" style="height: 100%;margin: 20px;">',
         '    <el-row style="padding: 10px;">',
         '        <el-descriptions :title="title" :column="1" direction="vertical">',
         '            <el-descriptions-item v-for="(obj, index) of text_list" :key="index" :label="obj[\'name\']">',
         '                {{obj[\'text\']}}',
         '            </el-descriptions-item>',
         '        </el-descriptions>',
         '    </el-row>',
         '</div>',
         '</body>',
         '<script src="https://unpkg.com/vue@2/dist/vue.js"></script>',
         '<script src="https://unpkg.com/element-ui/lib/index.js"></script>',
         '<script>',
         '    new Vue({',
         '        el: "#app-uid-",',
         '        data: function () {',
         '            return {',
         '                title: "-title-",',
         '                text_list: [',
         '                    -text_list-',
         '                ]',
         '            }',
         '        }',
         '    })',
         '</script>',
         '</html>'
         ]
    r_list = []
    if isinstance(text_list, dict):
        r_list.append(str(text_list))
    else:
        for o in text_list:
            r_list.append(str(o))
    return list(map(lambda x: x.replace('-text_list-', ',\n                    '.join(r_list))
                    .replace('-title-', str(title))
                    .replace('-uid-', uid), s))


# 折线图的 html 模板代码
def line_stack_html():
    option = ['{',
              '    title: {',
              '        text: "-chart_name-",',
              '    },',
              '    tooltip: {',
              '        trigger: "axis",',
              '    },',
              '    dataZoom: [',
              '        {',
              '            show: true,',
              '            realtime: true,',
              '        },',
              '        {',
              '            type: "inside",',
              '            realtime: true,',
              '        },',
              '    ],',
              '    grid: {',
              '        left: "30px",',
              '        right: "30px",',
              '        bottom: "50px",',
              '        containLabel: true,',
              '    },',
              '    toolbox: {',
              '        feature: {',
              '            saveAsImage: {',
              '                pixelRatio: 5',
              '            },',
              '        },',
              '    },',
              '    yAxis: {',
              '        type: "value",',
              '    },',
              '    xAxis: {',
              '        type: "category",',
              '        boundaryGap: false,',
              '        data: -x_list-,',
              '    },',
              '    legend: {',
              '        -legend-,',
              '    },',
              '    series: -series-,',
              '}']
    return chart_html(option)


# 折线图的 html 模板代码
def line_area_html():
    option = ['{',
              '  tooltip: {',
              '    trigger: "axis",',
              '  },',
              '  title: {',
              '    text: "-chart_name-"',
              '  },',
              '  toolbox: {',
              '    feature: {',
              '       saveAsImage: {',
              '           pixelRatio: 5',
              '       },',
              '    }',
              '  },',
              '    grid: {',
              '        left: "30px",',
              '        right: "30px",',
              '        bottom: "50px",',
              '        containLabel: true,',
              '    },',
              '  xAxis: {',
              '    type: "category",',
              '    boundaryGap: false,',
              '    data: -x_list-',
              '  },',
              '  yAxis: {',
              '    type: "value",',
              '  },',
              '    dataZoom: [',
              '        {',
              '            show: true,',
              '            realtime: true,',
              '        },',
              '        {',
              '            type: "inside",',
              '            realtime: true,',
              '        },',
              '    ],',
              '  series: [',
              '    {',
              '      type: "line",',
              '      symbol: "none",',
              '      smooth: -smooth-,',
              '      sampling: "lttb",',
              '      itemStyle: {',
              '        color: "rgb(255, 70, 131)"',
              '      },',
              '      areaStyle: {',
              '        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [',
              '          {',
              '            offset: 0,',
              '            color: "rgb(255, 158, 68)"',
              '          },',
              '          {',
              '            offset: 1,',
              '            color: "rgb(255, 70, 131)"',
              '          }',
              '        ])',
              '      },',
              '      data: -y_list-',
              '    }',
              '  ]',
              '}']
    return chart_html(option)


# 饼图的 html 模板代码
def pie_html():
    option = ['{',
              '  title: {',
              '    text: "-chart_name-",',
              '    left: 10',
              '  },',
              '  tooltip: {',
              '    trigger: "item"',
              '  },',
              '    toolbox: {',
              '        feature: {',
              '            saveAsImage: {',
              '                pixelRatio: 5',
              '            },',
              '        },',
              '    },',
              '  legend: {',
              '    top: "5%",',
              '    left: "center"',
              '  },',
              '  series: [',
              '    {',
              '      name: "-chart_name-",',
              '      type: "pie",',
              '      radius: ["30%", "70%"],',
              '      itemStyle: {',
              '        borderRadius: 10,',
              '        borderColor: "#fff",',
              '        borderWidth: 1',
              '      },',
              '      emphasis: {',
              '        label: {',
              '          show: true,',
              '          fontSize: 30,',
              '          fontWeight: "bold"',
              '        }',
              '      },',
              '      labelLine: {',
              '        show: true',
              '      },',
              '      data: -x_list-',
              '    }',
              '  ]',
              '}']
    return chart_html(option)


# 柱状的 html 模板代码
def bar_html():
    option = ['{',
              '  title: {',
              '    text: "-chart_name-",',
              '    left: 10',
              '  },',
              '  toolbox: {',
              '    feature: {',
              '      dataZoom: {',
              '        yAxisIndex: false',
              '      },',
              '      saveAsImage: {',
              '            saveAsImage: {',
              '                pixelRatio: 5',
              '            },',
              '      }',
              '    }',
              '  },',
              '  tooltip: {',
              '    trigger: "axis",',
              '    axisPointer: {',
              '      type: "shadow"',
              '    }',
              '  },',
              '    grid: {',
              '        left: "30px",',
              '        right: "30px",',
              '        bottom: "50px",',
              '        containLabel: true,',
              '    },',
              '  dataZoom: [',
              '    {',
              '      type: "inside"',
              '    },',
              '    {',
              '      type: "slider"',
              '    }',
              '  ],',
              '  xAxis: {',
              '    data: -x_list-,',
              '    silent: false,',
              '    splitLine: {',
              '      show: false',
              '    },',
              '    splitArea: {',
              '      show: false',
              '    }',
              '  },',
              '  yAxis: {',
              '    splitArea: {',
              '      show: false',
              '    }',
              '  },',
              '  series: [',
              '    {',
              '      type: "bar",',
              '      data: -y_list-,',
              '      large: true',
              '    }',
              '  ]',
              '}']
    return chart_html(option)
