# coding: utf-8

# flake8: noqa

"""
    Corbado Backend API

     # Introduction This documentation gives an overview of all Corbado Backend API calls to implement passwordless authentication with Passkeys.  The Corbado Backend API is organized around REST principles. It uses resource-oriented URLs with verbs (HTTP methods) and HTTP status codes. Requests need to be valid JSON payloads. We always return JSON.  The Corbado Backend API specification is written in **OpenAPI Version 3.0.3**. You can download it via the download button at the top and use it to generate clients in languages we do not provide officially for example.  # Authentication To authenticate your API requests HTTP Basic Auth is used.  You need to set the projectID as username and the API secret as password. The authorization header looks as follows:  `Basic <<projectID>:<API secret>>`  The **authorization header** needs to be **Base64 encoded** to be working. If the authorization header is missing or incorrect, the API will respond with status code 401.  # Error types As mentioned above we make use of HTTP status codes. **4xx** errors indicate so called client errors, meaning the error occurred on client side and you need to fix it. **5xx** errors indicate server errors, which means the error occurred on server side and outside your control.  Besides HTTP status codes Corbado uses what we call error types which gives more details in error cases and help you to debug your request.  ## internal_error The error type **internal_error** is used when some internal error occurred at Corbado. You can retry your request but usually there is nothing you can do about it. All internal errors get logged and will triggert an alert to our operations team which takes care of the situation as soon as possible.  ## not_found The error type **not_found** is used when you try to get a resource which cannot be found. Most common case is that you provided a wrong ID.  ## method_not_allowed The error type **method_not_allowed** is used when you use a HTTP method (GET for example) on a resource/endpoint which it not supports.   ## validation_error The error type **validation_error** is used when there is validation error on the data you provided in the request payload or path. There will be detailed information in the JSON response about the validation error like what exactly went wrong on what field.   ## project_id_mismatch The error type **project_id_mismatch** is used when there is a project ID you provided mismatch.  ## login_error The error type **login_error** is used when the authentication failed. Most common case is that you provided a wrong pair of project ID and API secret. As mentioned above with use HTTP Basic Auth for authentication.  ## invalid_json The error type **invalid_json** is used when you send invalid JSON as request body. There will be detailed information in the JSON response about what went wrong.  ## rate_limited The error type **rate_limited** is used when ran into rate limiting of the Corbado Backend API. Right now you can do a maximum of **2000 requests** within **10 seconds** from a **single IP**. Throttle your requests and try again. If you think you need more contact support@corbado.com.  ## invalid_origin The error type **invalid_origin** is used when the API has been called from a origin which is not authorized (CORS). Add the origin to your project at https://app.corbado.com/app/settings/credentials/authorized-origins.  ## already_exists The error type **already_exists** is used when you try create a resource which already exists. Most common case is that there is some unique constraint on one of the fields.  # Security and privacy Corbado services are designed, developed, monitored, and updated with security at our core to protect you and your customers’ data and privacy.  ## Security  ### Infrastructure security Corbado leverages highly available and secure cloud infrastructure to ensure that our services are always available and securely delivered. Corbado's services are operated in uvensys GmbH's data centers in Germany and comply with ISO standard 27001. All data centers have redundant power and internet connections to avoid failure. The main location of the servers used is in Linden and offers 24/7 support. We do not use any AWS, GCP or Azure services.  Each server is monitored 24/7 and in the event of problems, automated information is sent via SMS and e-mail. The monitoring is done by the external service provider Serverguard24 GmbH.   All Corbado hardware and networking is routinely updated and audited to ensure systems are secure and that least privileged access is followed. Additionally we implement robust logging and audit protocols that allow us high visibility into system use.  ### Responsible disclosure program Here at Corbado, we take the security of our user’s data and of our services seriously. As such, we encourage responsible security research on Corbado services and products. If you believe you’ve discovered a potential vulnerability, please let us know by emailing us at [security@corbado.com](mailto:security@corbado.com). We will acknowledge your email within 2 business days. As public disclosures of a security vulnerability could put the entire Corbado community at risk, we ask that you keep such potential vulnerabilities confidential until we are able to address them. We aim to resolve critical issues within 30 days of disclosure. Please make a good faith effort to avoid violating privacy, destroying data, or interrupting or degrading the Corbado service. Please only interact with accounts you own or for which you have explicit permission from the account holder. While researching, please refrain from:  - Distributed Denial of Service (DDoS) - Spamming - Social engineering or phishing of Corbado employees or contractors - Any attacks against Corbado's physical property or data centers  Thank you for helping to keep Corbado and our users safe!  ### Rate limiting At Corbado, we apply rate limit policies on our APIs in order to protect your application and user management infrastructure, so your users will have a frictionless non-interrupted experience.  Corbado responds with HTTP status code 429 (too many requests) when the rate limits exceed. Your code logic should be able to handle such cases by checking the status code on the response and recovering from such cases. If a retry is needed, it is best to allow for a back-off to avoid going into an infinite retry loop.  The current rate limit for all our API endpoints is **max. 100 requests per 10 seconds**.  ## Privacy Corbado is committed to protecting the personal data of our customers and their customers. Corbado has in place appropriate data security measures that meet industry standards. We regularly review and make enhancements to our processes, products, documentation, and contracts to help support ours and our customers’ compliance for the processing of personal data.  We try to minimize the usage and processing of personally identifiable information. Therefore, all our services are constructed to avoid unnecessary data consumption.  To make our services work, we only require the following data: - any kind of identifier (e.g. UUID, phone number, email address) - IP address (only temporarily for rate limiting aspects) - User agent (for device management) 

    The version of the OpenAPI document: 1.0.0
    Contact: support@corbado.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.0.0"

# import apis into sdk package
from corbado_python_sdk.generated.api.api_secrets_api import APISecretsApi
from corbado_python_sdk.generated.api.analyzer_api import AnalyzerApi
from corbado_python_sdk.generated.api.android_app_config_api import AndroidAppConfigApi
from corbado_python_sdk.generated.api.association_tokens_api import AssociationTokensApi
from corbado_python_sdk.generated.api.auth_methods_api import AuthMethodsApi
from corbado_python_sdk.generated.api.auth_tokens_api import AuthTokensApi
from corbado_python_sdk.generated.api.email_otp_api import EmailOTPApi
from corbado_python_sdk.generated.api.email_magic_links_api import EmailMagicLinksApi
from corbado_python_sdk.generated.api.email_templates_api import EmailTemplatesApi
from corbado_python_sdk.generated.api.examples_api import ExamplesApi
from corbado_python_sdk.generated.api.long_sessions_api import LongSessionsApi
from corbado_python_sdk.generated.api.passkeys_biometrics_api import PasskeysBiometricsApi
from corbado_python_sdk.generated.api.project_config_api import ProjectConfigApi
from corbado_python_sdk.generated.api.request_logs_api import RequestLogsApi
from corbado_python_sdk.generated.api.smsotp_api import SMSOTPApi
from corbado_python_sdk.generated.api.sms_templates_api import SMSTemplatesApi
from corbado_python_sdk.generated.api.session_config_api import SessionConfigApi
from corbado_python_sdk.generated.api.user_api import UserApi
from corbado_python_sdk.generated.api.validation_api import ValidationApi
from corbado_python_sdk.generated.api.webhook_logs_api import WebhookLogsApi
from corbado_python_sdk.generated.api.ios_app_config_api import IOSAppConfigApi

# import ApiClient
from corbado_python_sdk.generated.api_response import ApiResponse
from corbado_python_sdk.generated.api_client import ApiClient
from corbado_python_sdk.generated.configuration import Configuration
from corbado_python_sdk.generated.exceptions import OpenApiException
from corbado_python_sdk.generated.exceptions import ApiTypeError
from corbado_python_sdk.generated.exceptions import ApiValueError
from corbado_python_sdk.generated.exceptions import ApiKeyError
from corbado_python_sdk.generated.exceptions import ApiAttributeError
from corbado_python_sdk.generated.exceptions import ApiException

# import models into sdk package
from corbado_python_sdk.generated.models.android_app_config_delete_req import AndroidAppConfigDeleteReq
from corbado_python_sdk.generated.models.android_app_config_item import AndroidAppConfigItem
from corbado_python_sdk.generated.models.android_app_config_list_rsp import AndroidAppConfigListRsp
from corbado_python_sdk.generated.models.android_app_config_save_req import AndroidAppConfigSaveReq
from corbado_python_sdk.generated.models.android_app_config_save_rsp import AndroidAppConfigSaveRsp
from corbado_python_sdk.generated.models.android_app_config_update_req import AndroidAppConfigUpdateReq
from corbado_python_sdk.generated.models.android_app_config_update_rsp import AndroidAppConfigUpdateRsp
from corbado_python_sdk.generated.models.app_type import AppType
from corbado_python_sdk.generated.models.association_token_create_req import AssociationTokenCreateReq
from corbado_python_sdk.generated.models.association_token_create_rsp import AssociationTokenCreateRsp
from corbado_python_sdk.generated.models.association_token_create_rsp_all_of_data import AssociationTokenCreateRspAllOfData
from corbado_python_sdk.generated.models.auth_method import AuthMethod
from corbado_python_sdk.generated.models.auth_methods_list_req import AuthMethodsListReq
from corbado_python_sdk.generated.models.auth_methods_list_rsp import AuthMethodsListRsp
from corbado_python_sdk.generated.models.auth_methods_list_rsp_all_of_data import AuthMethodsListRspAllOfData
from corbado_python_sdk.generated.models.auth_token_validate_req import AuthTokenValidateReq
from corbado_python_sdk.generated.models.auth_token_validate_rsp import AuthTokenValidateRsp
from corbado_python_sdk.generated.models.client_info import ClientInfo
from corbado_python_sdk.generated.models.custom_login_identifier import CustomLoginIdentifier
from corbado_python_sdk.generated.models.email import Email
from corbado_python_sdk.generated.models.email_code import EmailCode
from corbado_python_sdk.generated.models.email_code_get_rsp import EmailCodeGetRsp
from corbado_python_sdk.generated.models.email_code_get_rsp_all_of_data import EmailCodeGetRspAllOfData
from corbado_python_sdk.generated.models.email_code_send_req import EmailCodeSendReq
from corbado_python_sdk.generated.models.email_code_send_rsp import EmailCodeSendRsp
from corbado_python_sdk.generated.models.email_code_send_rsp_all_of_data import EmailCodeSendRspAllOfData
from corbado_python_sdk.generated.models.email_code_validate_req import EmailCodeValidateReq
from corbado_python_sdk.generated.models.email_code_validate_rsp import EmailCodeValidateRsp
from corbado_python_sdk.generated.models.email_link import EmailLink
from corbado_python_sdk.generated.models.email_link_get_rsp import EmailLinkGetRsp
from corbado_python_sdk.generated.models.email_link_get_rsp_all_of_data import EmailLinkGetRspAllOfData
from corbado_python_sdk.generated.models.email_link_send_req import EmailLinkSendReq
from corbado_python_sdk.generated.models.email_link_send_rsp import EmailLinkSendRsp
from corbado_python_sdk.generated.models.email_link_send_rsp_all_of_data import EmailLinkSendRspAllOfData
from corbado_python_sdk.generated.models.email_link_validate_rsp import EmailLinkValidateRsp
from corbado_python_sdk.generated.models.email_links_delete_req import EmailLinksDeleteReq
from corbado_python_sdk.generated.models.email_links_validate_req import EmailLinksValidateReq
from corbado_python_sdk.generated.models.email_template_create_req import EmailTemplateCreateReq
from corbado_python_sdk.generated.models.email_template_create_rsp import EmailTemplateCreateRsp
from corbado_python_sdk.generated.models.email_template_create_rsp_all_of_data import EmailTemplateCreateRspAllOfData
from corbado_python_sdk.generated.models.email_template_delete_req import EmailTemplateDeleteReq
from corbado_python_sdk.generated.models.email_validation_result import EmailValidationResult
from corbado_python_sdk.generated.models.empty_req import EmptyReq
from corbado_python_sdk.generated.models.error_rsp import ErrorRsp
from corbado_python_sdk.generated.models.error_rsp_all_of_error import ErrorRspAllOfError
from corbado_python_sdk.generated.models.error_rsp_all_of_error_validation import ErrorRspAllOfErrorValidation
from corbado_python_sdk.generated.models.example_get_rsp import ExampleGetRsp
from corbado_python_sdk.generated.models.full_user import FullUser
from corbado_python_sdk.generated.models.generic_rsp import GenericRsp
from corbado_python_sdk.generated.models.ios_app_config_delete_req import IOSAppConfigDeleteReq
from corbado_python_sdk.generated.models.ios_app_config_item import IOSAppConfigItem
from corbado_python_sdk.generated.models.ios_app_config_list_rsp import IOSAppConfigListRsp
from corbado_python_sdk.generated.models.ios_app_config_save_req import IOSAppConfigSaveReq
from corbado_python_sdk.generated.models.ios_app_config_save_rsp import IOSAppConfigSaveRsp
from corbado_python_sdk.generated.models.ios_app_config_update_req import IOSAppConfigUpdateReq
from corbado_python_sdk.generated.models.ios_app_config_update_rsp import IOSAppConfigUpdateRsp
from corbado_python_sdk.generated.models.login_identifier_type import LoginIdentifierType
from corbado_python_sdk.generated.models.long_session import LongSession
from corbado_python_sdk.generated.models.long_session_get_rsp import LongSessionGetRsp
from corbado_python_sdk.generated.models.long_session_get_rsp_all_of_data import LongSessionGetRspAllOfData
from corbado_python_sdk.generated.models.long_session_list_rsp import LongSessionListRsp
from corbado_python_sdk.generated.models.long_session_list_rsp_all_of_data import LongSessionListRspAllOfData
from corbado_python_sdk.generated.models.long_session_revoke_req import LongSessionRevokeReq
from corbado_python_sdk.generated.models.paging import Paging
from corbado_python_sdk.generated.models.phone_number import PhoneNumber
from corbado_python_sdk.generated.models.phone_number_validation_result import PhoneNumberValidationResult
from corbado_python_sdk.generated.models.project_config import ProjectConfig
from corbado_python_sdk.generated.models.project_config_get_rsp import ProjectConfigGetRsp
from corbado_python_sdk.generated.models.project_config_save_req import ProjectConfigSaveReq
from corbado_python_sdk.generated.models.project_config_webhook_test_req import ProjectConfigWebhookTestReq
from corbado_python_sdk.generated.models.project_config_webhook_test_rsp import ProjectConfigWebhookTestRsp
from corbado_python_sdk.generated.models.project_config_webhook_test_rsp_all_of_data import ProjectConfigWebhookTestRspAllOfData
from corbado_python_sdk.generated.models.project_secret_create_req import ProjectSecretCreateReq
from corbado_python_sdk.generated.models.project_secret_create_rsp import ProjectSecretCreateRsp
from corbado_python_sdk.generated.models.project_secret_delete_req import ProjectSecretDeleteReq
from corbado_python_sdk.generated.models.project_secret_item import ProjectSecretItem
from corbado_python_sdk.generated.models.project_secret_list_rsp import ProjectSecretListRsp
from corbado_python_sdk.generated.models.request_data import RequestData
from corbado_python_sdk.generated.models.request_log import RequestLog
from corbado_python_sdk.generated.models.request_log_get_rsp import RequestLogGetRsp
from corbado_python_sdk.generated.models.request_logs_list_rsp import RequestLogsListRsp
from corbado_python_sdk.generated.models.request_logs_list_rsp_all_of_data import RequestLogsListRspAllOfData
from corbado_python_sdk.generated.models.session_config import SessionConfig
from corbado_python_sdk.generated.models.session_config_get_rsp import SessionConfigGetRsp
from corbado_python_sdk.generated.models.session_config_update_req import SessionConfigUpdateReq
from corbado_python_sdk.generated.models.session_token_create_req import SessionTokenCreateReq
from corbado_python_sdk.generated.models.session_token_create_rsp import SessionTokenCreateRsp
from corbado_python_sdk.generated.models.session_token_create_rsp_all_of_data import SessionTokenCreateRspAllOfData
from corbado_python_sdk.generated.models.session_token_verify_req import SessionTokenVerifyReq
from corbado_python_sdk.generated.models.session_token_verify_rsp import SessionTokenVerifyRsp
from corbado_python_sdk.generated.models.session_token_verify_rsp_all_of_data import SessionTokenVerifyRspAllOfData
from corbado_python_sdk.generated.models.sms_code_send_req import SmsCodeSendReq
from corbado_python_sdk.generated.models.sms_code_send_rsp import SmsCodeSendRsp
from corbado_python_sdk.generated.models.sms_code_send_rsp_all_of_data import SmsCodeSendRspAllOfData
from corbado_python_sdk.generated.models.sms_code_validate_req import SmsCodeValidateReq
from corbado_python_sdk.generated.models.sms_code_validate_rsp import SmsCodeValidateRsp
from corbado_python_sdk.generated.models.sms_template_create_req import SmsTemplateCreateReq
from corbado_python_sdk.generated.models.sms_template_create_rsp import SmsTemplateCreateRsp
from corbado_python_sdk.generated.models.sms_template_create_rsp_all_of_data import SmsTemplateCreateRspAllOfData
from corbado_python_sdk.generated.models.sms_template_delete_req import SmsTemplateDeleteReq
from corbado_python_sdk.generated.models.status import Status
from corbado_python_sdk.generated.models.tracking_backup_state import TrackingBackupState
from corbado_python_sdk.generated.models.tracking_backup_state_get_rsp import TrackingBackupStateGetRsp
from corbado_python_sdk.generated.models.tracking_browser_detailed_stats import TrackingBrowserDetailedStats
from corbado_python_sdk.generated.models.tracking_browser_detailed_stats_list_rsp import TrackingBrowserDetailedStatsListRsp
from corbado_python_sdk.generated.models.tracking_browser_detailed_stats_list_rsp_all_of_data import TrackingBrowserDetailedStatsListRspAllOfData
from corbado_python_sdk.generated.models.tracking_browser_stats import TrackingBrowserStats
from corbado_python_sdk.generated.models.tracking_browser_stats_list_rsp import TrackingBrowserStatsListRsp
from corbado_python_sdk.generated.models.tracking_browser_stats_list_rsp_all_of_data import TrackingBrowserStatsListRspAllOfData
from corbado_python_sdk.generated.models.tracking_detailed_stats import TrackingDetailedStats
from corbado_python_sdk.generated.models.tracking_detailed_stats_list_rsp import TrackingDetailedStatsListRsp
from corbado_python_sdk.generated.models.tracking_detailed_stats_list_rsp_all_of_data import TrackingDetailedStatsListRspAllOfData
from corbado_python_sdk.generated.models.tracking_enums import TrackingEnums
from corbado_python_sdk.generated.models.tracking_enums_get_rsp import TrackingEnumsGetRsp
from corbado_python_sdk.generated.models.tracking_os_detailed_stats import TrackingOSDetailedStats
from corbado_python_sdk.generated.models.tracking_os_detailed_stats_list_rsp import TrackingOSDetailedStatsListRsp
from corbado_python_sdk.generated.models.tracking_os_detailed_stats_list_rsp_all_of_data import TrackingOSDetailedStatsListRspAllOfData
from corbado_python_sdk.generated.models.tracking_os_stats import TrackingOSStats
from corbado_python_sdk.generated.models.tracking_os_stats_list_rsp import TrackingOSStatsListRsp
from corbado_python_sdk.generated.models.tracking_os_stats_list_rsp_all_of_data import TrackingOSStatsListRspAllOfData
from corbado_python_sdk.generated.models.tracking_raw_list_row import TrackingRawListRow
from corbado_python_sdk.generated.models.tracking_raw_list_rsp import TrackingRawListRsp
from corbado_python_sdk.generated.models.tracking_stats import TrackingStats
from corbado_python_sdk.generated.models.tracking_stats_list_rsp import TrackingStatsListRsp
from corbado_python_sdk.generated.models.tracking_stats_list_rsp_all_of_data import TrackingStatsListRspAllOfData
from corbado_python_sdk.generated.models.user import User
from corbado_python_sdk.generated.models.user_auth_log import UserAuthLog
from corbado_python_sdk.generated.models.user_auth_log_list_rsp import UserAuthLogListRsp
from corbado_python_sdk.generated.models.user_auth_log_list_rsp_all_of_data import UserAuthLogListRspAllOfData
from corbado_python_sdk.generated.models.user_create_req import UserCreateReq
from corbado_python_sdk.generated.models.user_create_rsp import UserCreateRsp
from corbado_python_sdk.generated.models.user_create_rsp_all_of_data import UserCreateRspAllOfData
from corbado_python_sdk.generated.models.user_custom_login_identifier_create_req import UserCustomLoginIdentifierCreateReq
from corbado_python_sdk.generated.models.user_custom_login_identifier_create_rsp import UserCustomLoginIdentifierCreateRsp
from corbado_python_sdk.generated.models.user_custom_login_identifier_create_rsp_all_of_data import UserCustomLoginIdentifierCreateRspAllOfData
from corbado_python_sdk.generated.models.user_custom_login_identifier_delete_req import UserCustomLoginIdentifierDeleteReq
from corbado_python_sdk.generated.models.user_custom_login_identifier_get_rsp import UserCustomLoginIdentifierGetRsp
from corbado_python_sdk.generated.models.user_custom_login_identifier_get_rsp_all_of_data import UserCustomLoginIdentifierGetRspAllOfData
from corbado_python_sdk.generated.models.user_delete_req import UserDeleteReq
from corbado_python_sdk.generated.models.user_device import UserDevice
from corbado_python_sdk.generated.models.user_device_list_rsp import UserDeviceListRsp
from corbado_python_sdk.generated.models.user_email import UserEmail
from corbado_python_sdk.generated.models.user_email_create_req import UserEmailCreateReq
from corbado_python_sdk.generated.models.user_email_create_rsp import UserEmailCreateRsp
from corbado_python_sdk.generated.models.user_email_create_rsp_all_of_data import UserEmailCreateRspAllOfData
from corbado_python_sdk.generated.models.user_email_delete_req import UserEmailDeleteReq
from corbado_python_sdk.generated.models.user_email_get_rsp import UserEmailGetRsp
from corbado_python_sdk.generated.models.user_email_get_rsp_all_of_data import UserEmailGetRspAllOfData
from corbado_python_sdk.generated.models.user_exists_req import UserExistsReq
from corbado_python_sdk.generated.models.user_exists_rsp import UserExistsRsp
from corbado_python_sdk.generated.models.user_get_rsp import UserGetRsp
from corbado_python_sdk.generated.models.user_list_rsp import UserListRsp
from corbado_python_sdk.generated.models.user_list_rsp_all_of_data import UserListRspAllOfData
from corbado_python_sdk.generated.models.user_phone_number import UserPhoneNumber
from corbado_python_sdk.generated.models.user_phone_number_create_req import UserPhoneNumberCreateReq
from corbado_python_sdk.generated.models.user_phone_number_create_rsp import UserPhoneNumberCreateRsp
from corbado_python_sdk.generated.models.user_phone_number_create_rsp_all_of_data import UserPhoneNumberCreateRspAllOfData
from corbado_python_sdk.generated.models.user_phone_number_delete_req import UserPhoneNumberDeleteReq
from corbado_python_sdk.generated.models.user_phone_number_get_rsp import UserPhoneNumberGetRsp
from corbado_python_sdk.generated.models.user_phone_number_get_rsp_all_of_data import UserPhoneNumberGetRspAllOfData
from corbado_python_sdk.generated.models.user_stats import UserStats
from corbado_python_sdk.generated.models.user_stats_list_rsp import UserStatsListRsp
from corbado_python_sdk.generated.models.user_stats_list_rsp_all_of_data import UserStatsListRspAllOfData
from corbado_python_sdk.generated.models.user_update_req import UserUpdateReq
from corbado_python_sdk.generated.models.user_update_rsp import UserUpdateRsp
from corbado_python_sdk.generated.models.user_username import UserUsername
from corbado_python_sdk.generated.models.validate_email_req import ValidateEmailReq
from corbado_python_sdk.generated.models.validate_email_rsp import ValidateEmailRsp
from corbado_python_sdk.generated.models.validate_phone_number_req import ValidatePhoneNumberReq
from corbado_python_sdk.generated.models.validate_phone_number_rsp import ValidatePhoneNumberRsp
from corbado_python_sdk.generated.models.validation_email import ValidationEmail
from corbado_python_sdk.generated.models.validation_phone_number import ValidationPhoneNumber
from corbado_python_sdk.generated.models.web_authn_associate_start_req import WebAuthnAssociateStartReq
from corbado_python_sdk.generated.models.web_authn_associate_start_rsp import WebAuthnAssociateStartRsp
from corbado_python_sdk.generated.models.web_authn_authenticate_finish_rsp import WebAuthnAuthenticateFinishRsp
from corbado_python_sdk.generated.models.web_authn_authenticate_start_req import WebAuthnAuthenticateStartReq
from corbado_python_sdk.generated.models.web_authn_authenticate_start_rsp import WebAuthnAuthenticateStartRsp
from corbado_python_sdk.generated.models.web_authn_authenticate_success import WebAuthnAuthenticateSuccess
from corbado_python_sdk.generated.models.web_authn_authenticator_update_req import WebAuthnAuthenticatorUpdateReq
from corbado_python_sdk.generated.models.web_authn_credential_exists_req import WebAuthnCredentialExistsReq
from corbado_python_sdk.generated.models.web_authn_credential_exists_rsp import WebAuthnCredentialExistsRsp
from corbado_python_sdk.generated.models.web_authn_credential_item_rsp import WebAuthnCredentialItemRsp
from corbado_python_sdk.generated.models.web_authn_credential_list_rsp import WebAuthnCredentialListRsp
from corbado_python_sdk.generated.models.web_authn_credential_req import WebAuthnCredentialReq
from corbado_python_sdk.generated.models.web_authn_credential_rsp import WebAuthnCredentialRsp
from corbado_python_sdk.generated.models.web_authn_finish_req import WebAuthnFinishReq
from corbado_python_sdk.generated.models.web_authn_mediation_start_req import WebAuthnMediationStartReq
from corbado_python_sdk.generated.models.web_authn_mediation_start_rsp import WebAuthnMediationStartRsp
from corbado_python_sdk.generated.models.web_authn_register_finish_rsp import WebAuthnRegisterFinishRsp
from corbado_python_sdk.generated.models.web_authn_register_start_req import WebAuthnRegisterStartReq
from corbado_python_sdk.generated.models.web_authn_register_start_rsp import WebAuthnRegisterStartRsp
from corbado_python_sdk.generated.models.webauthn_setting_create import WebauthnSettingCreate
from corbado_python_sdk.generated.models.webauthn_setting_create_req import WebauthnSettingCreateReq
from corbado_python_sdk.generated.models.webauthn_setting_create_rsp import WebauthnSettingCreateRsp
from corbado_python_sdk.generated.models.webauthn_setting_delete_req import WebauthnSettingDeleteReq
from corbado_python_sdk.generated.models.webauthn_setting_get_rsp import WebauthnSettingGetRsp
from corbado_python_sdk.generated.models.webauthn_setting_item import WebauthnSettingItem
from corbado_python_sdk.generated.models.webauthn_setting_list_rsp import WebauthnSettingListRsp
from corbado_python_sdk.generated.models.webauthn_setting_update_req import WebauthnSettingUpdateReq
from corbado_python_sdk.generated.models.webauthn_setting_update_rsp import WebauthnSettingUpdateRsp
from corbado_python_sdk.generated.models.webhook_log import WebhookLog
from corbado_python_sdk.generated.models.webhook_logs_list_rsp import WebhookLogsListRsp
from corbado_python_sdk.generated.models.webhook_logs_list_rsp_all_of_data import WebhookLogsListRspAllOfData
