from data_aggregator_sdk.constants.enums import IntegrationV0MessageEvent, DeviceEventLevelEnum

EVENT_LEVEL_MAP: dict[IntegrationV0MessageEvent, DeviceEventLevelEnum] = {
    IntegrationV0MessageEvent.SYS_NO_DATA: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.BATTERY_IS_LOW: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.MAGNET_WAS_DETECTED: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.CASE_WAS_OPENED: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.TEMPERATURE_LIMIT: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.FLOW_REVERSE: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.FLOW_SPEED_OVER_LIMIT: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.CONTINUES_CONSUMPTION: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.NO_WATER: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.NO_RESOURCE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.BATTERY_WARNING: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.BATTERY_OR_TEMPERATURE_LIMITS: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.LOW_AMBIENT_TEMPERATURE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.RESET: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.RESET_POWER_ON: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.RESET_PIN: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.RESET_LOW_VOLTAGE: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.RESET_SOFTWARE: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.RESET_WATCHDOG: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.RESET_HARD_FAULT: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_SENSOR: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_SYSTEM: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_SENSOR_MEASUREMENT: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_SENSOR_TEMPERATURE: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_MEASUREMENT: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_LOW_VOLTAGE: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_INTERNAL_CLOCK: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_FLASH: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_EEPROM: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_RADIO: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_DISPLAY: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_PLC: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.ERROR_RESET: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.IMPACT_POWER_LOST: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.IMPACT_MAGNET: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.IMPACT_CLEAT_TAMPER: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.IMPACT_RADIO: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.OTHER: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.ERROR_METER_SYNC: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.NONE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.SUCCESSFUL_AUTO_DIAGNOSTIC: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.SETUP_UPDATE: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.SWITCH_WINTER_DAYLIGHT: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.SWITCH_SUMMER_DAYLIGHT: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.RECORD_DATETIME: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_OFFSET_DAILY_CLOCK: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.PERMISSION_SWITCH_DAYLIGHT_ON: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.PERMISSION_SWITCH_DAYLIGHT_OFF: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_DATE_TIME_SWITCH_DAYLIGHT: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.ERASE_EEPROM: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.NULLIFY_TARIFF_ACCUMULATION: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.NULLIFY_INTERVAL_ACCUMULATION: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.RESET_PASSWORD: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.RESET_POWER_LOST_TIME_COUNTER: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.RESET_MAGNET_IMPACT_TIME_COUNTER: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.RESET_POWER_INCREASE_TIME_COUNTER: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.RESET_POWER_DECREASE_TIME_COUNTER: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.RESET_MAINTS_FREQ_DIVERGENCE_TIME_COUNTER: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.RESET_POWER_OVER_LIMIT_TIME_COUNTER: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_CAPACITY_DATA_LCD: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.CHANGE_TARIFF_METHODS: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_TARIFF_PROGRAMS: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_ACTUAL_SEASON_SCHEDULES: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_CONSUMPTION_LIMIT: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_LOW_THRESHOLD_VOLTAGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_HIGH_THRESHOLD_VOLTAGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_MAINTS_FREQ_THRESHOLD: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_THRESHOLD_LOW_CONSUMPTION: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.RECHARGE_ENERGY_PAYMENT: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.UNSUCCESSFUL_AUTO_DIAGNOSTIC_INTERNAL_CLOCK: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.ABNORMAL_COUNTER_AUTOSTART: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.EXTERNAL_POWER_LOST: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.EXTERNAL_POWER_DETECTED: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.START_POWER_OVER_LIMIT: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.STOP_POWER_OVER_LIMIT: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.ENERGY_OVER_LIMIT_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.ENERGY_OVER_LIMIT_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.ENERGY_OVER_LIMIT_3: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.WRONG_PASSWORD_BLOCK: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.WRONG_PASSWORD_APPEAL: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.EXHAUST_DAILY_BATTERY_LIFE_LIMIT: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.START_MAGNET_IMPACT: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.STOP_MAGNET_IMPACT: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.VIOLATION_TERMINAL_BLOCK_SEAL: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.RECOVERY_TERMINAL_BLOCK_SEAL: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.VIOLATION_CASE_SEAL: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.RECOVERY_CASE_SEAL: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.TIME_OUT_SYNC_LIMIT: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.CRITICAL_DIVERGENCE_TIME: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.OVERHEAT_COUNTER_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERHEAT_COUNTER_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.UNSUCCESSFUL_AUTO_DIAGNOSTIC_MEMORY: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.LOW_BATTERY_CAPACITY: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.RECOVERY_BATTERY_WORKING_VOLTAGE: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.LOW_CONSUMPTION: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.RESET_FLAG_LOW_CONSUMPTION: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_VALIDATION_SETTINGS: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CHANGE_TARIFFICATION_PARAMETERS: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.UNSUCCESSFUL_AUTO_DIAGNOSTIC_MEASUREMENT_BLOCK: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.UNSUCCESSFUL_AUTO_DIAGNOSTIC_CALCULATION_BLOCK: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.UNSUCCESSFUL_AUTO_DIAGNOSTIC_POWER_BLOCK: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.UNSUCCESSFUL_AUTO_DIAGNOSTIC_SCREEN: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.UNSUCCESSFUL_AUTO_DIAGNOSTIC_RADIO: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.MAINS_VOLTAGE_LOST_PHASE_A_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.MAINS_VOLTAGE_LOST_PHASE_A_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.MAINS_VOLTAGE_LOST_PHASE_B_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.MAINS_VOLTAGE_LOST_PHASE_B_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.MAINS_VOLTAGE_LOST_PHASE_C_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.MAINS_VOLTAGE_LOST_PHASE_C_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.VOLTAGE_LAYDOWN_PHASE_A_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.VOLTAGE_LAYDOWN_PHASE_A_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.VOLTAGE_LAYDOWN_PHASE_B_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.VOLTAGE_LAYDOWN_PHASE_B_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.VOLTAGE_LAYDOWN_PHASE_C_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.VOLTAGE_LAYDOWN_PHASE_C_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERVOLTAGE_PHASE_A_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERVOLTAGE_PHASE_A_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERVOLTAGE_PHASE_B_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERVOLTAGE_PHASE_B_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERVOLTAGE_PHASE_C_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERVOLTAGE_PHASE_C_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERCURRENT_PHASE_A_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERCURRENT_PHASE_A_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERCURRENT_PHASE_B_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERCURRENT_PHASE_B_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERCURRENT_PHASE_C_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.OVERCURRENT_PHASE_C_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.CURRENT_SUM_THRESHOLD_LOW_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.CURRENT_SUM_THRESHOLD_LOW_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.FREQ_OUT_PHASE_A_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.FREQ_OUT_PHASE_A_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.FREQ_OUT_PHASE_B_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.FREQ_OUT_PHASE_B_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.FREQ_OUT_PHASE_C_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.FREQ_OUT_PHASE_C_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.PHASE_ORDER_DISTURBANCE_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.PHASE_ORDER_DISTURBANCE_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.RADIO_IMPACT_START: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.RADIO_IMPACT_STOP: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DAYLIGHT_TIME_SWITCH: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.DAYLIGHT_TIME_MODE_DATES_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.INTERNAL_CLOCK_SYNC: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.METROLOGY_CHANGE: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.PROFILE_CONF_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.TARIFFICATION_METHOD_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.PERMISSION_CHANGE_SETTINGS_POWER_CONTROL: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.CONTROL_LEVEL_MAINS_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.PERMISSION_CHANGE_SETTINGS_CONSUMPTION_CONTROL: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.LOAD_RELAY_CONDITION_SETTINGS_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.SIGNALIZATION_RELAY_CONDITION_SETTINGS_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.INTERFACE_SIGNALIZATION_CONDITION_SETTINGS_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.INDICATION_SETTINGS_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.SOUND_SIGNAL_CONDITION_SETTINGS_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.LOAD_RELAY_STATE_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.SIGNALIZATION_RELAY_STATE_CHANGE: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.START_ALTERNATING_MAGNET_IMPACT: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.STOP_ALTERNATING_MAGNET_IMPACT: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CIRCUIT_BREAK_T_SENSOR_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CIRCUIT_BREAK_T_SENSOR_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CIRCUIT_BREAK_T_SENSOR_3: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__ERROR_DELTA_T: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.SYSTEM__CONSUMPTION_LOWER_G_MIN_CHANNEL_RATE_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CONSUMPTION_LOWER_G_MIN_CHANNEL_RATE_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CONSUMPTION_LOWER_G_MIN_CHANNEL_RATE_3: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CONSUMPTION_LOWER_G_MAX_CHANNEL_RATE_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CONSUMPTION_LOWER_G_MAX_CHANNEL_RATE_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CONSUMPTION_LOWER_G_MAX_CHANNEL_RATE_3: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__NO_COOLANT_CHANNEL_RATE_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__NO_COOLANT_CHANNEL_RATE_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__NO_COOLANT_CHANNEL_RATE_3: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CIRCUIT_BREAK_STIMULATION_CHANNEL_RATE_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CIRCUIT_BREAK_STIMULATION_CHANNEL_RATE_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CIRCUIT_BREAK_PRESSURE_SENSOR_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CIRCUIT_BREAK_PRESSURE_SENSOR_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__CIRCUIT_BREAK_PRESSURE_SENSOR_3: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.SYSTEM__REVERSE: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.DEVICE__POWER_SUPPLY_LOST: DeviceEventLevelEnum.CRITICAL,
    IntegrationV0MessageEvent.DEVICE__POWER_SUPPLY_ENABLED: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.DEVICE__COMMON_SETTINGS_CHANGED: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.DEVICE__ALARM_DIGITAL_INPUT_1: DeviceEventLevelEnum.INFO,
    IntegrationV0MessageEvent.DEVICE__ALARM_OVERRATE_DIGITAL_INPUT_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_OVERRATE_DIGITAL_INPUT_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_UNDERRATE_DIGITAL_INPUT_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_UNDERRATE_DIGITAL_INPUT_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_T_HIGH_DIGITAL_INPUT_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_T_HIGH_DIGITAL_INPUT_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_T_LOW_DIGITAL_INPUT_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_T_LOW_DIGITAL_INPUT_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_DELTA_T_HIGH_DIGITAL_INPUT_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_DELTA_T_HIGH_DIGITAL_INPUT_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_DELTA_T_LOW_DIGITAL_INPUT_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_DELTA_T_LOW_DIGITAL_INPUT_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_POWER_HIGH_DIGITAL_INPUT_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_POWER_HIGH_DIGITAL_INPUT_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_POWER_LOW_DIGITAL_INPUT_1: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__ALARM_POWER_LOW_DIGITAL_INPUT_2: DeviceEventLevelEnum.WARNING,
    IntegrationV0MessageEvent.DEVICE__MEASURE_CHANNELS_SETTINGS_CHANGED: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.DEVICE__SYSTEM_SETTINGS_CHANGED_1: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.DEVICE__SYSTEM_SETTINGS_CHANGED_2: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.DEVICE__SYSTEM_SETTINGS_CHANGED_3: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.DEVICE__SYSTEM_SETTINGS_CHANGED_4: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.DEVICE__DIGITAL_I_O_SETTINGS_CHANGED: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.DEVICE__DATETIME_CHANGED: DeviceEventLevelEnum.SYSTEM,
    IntegrationV0MessageEvent.DEVICE__ETHERNET_SETTINGS_CHANGED: DeviceEventLevelEnum.SYSTEM,
 }
