# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

import ccxt.async_support
from ccxt.async_support.base.ws.cache import ArrayCache, ArrayCacheByTimestamp
from ccxt.base.types import Any, Int, Market, OrderBook, Strings, Ticker, Tickers, Trade
from ccxt.async_support.base.ws.client import Client
from typing import List
from ccxt.base.errors import ArgumentsRequired


class aster(ccxt.async_support.aster):

    def describe(self) -> Any:
        return self.deep_extend(super(aster, self).describe(), {
            'has': {
                'ws': True,
                'watchBalance': False,
                'watchBidsAsks': True,
                'watchTicker': True,
                'watchTickers': True,
                'watchMarkPrice': True,
                'watchMarkPrices': True,
                'watchTrades': True,
                'watchTradesForSymbols': True,
                'watchOrderBook': True,
                'watchOrderBookForSymbols': True,
                'watchOHLCV': True,
                'watchOHLCVForSymbols': True,
                'unWatchTicker': True,
                'unWatchTickers': True,
                'unWatchMarkPrice': True,
                'unWatchMarkPrices': True,
                'unWatchBidsAsks': True,
                'unWatchTrades': True,
                'unWatchTradesForSymbols': True,
                'unWatchOrderBook': True,
                'unWatchOrderBookForSymbols': True,
                'unWatchOHLCV': True,
                'unWatchOHLCVForSymbols': True,
            },
            'urls': {
                'api': {
                    'ws': {
                        'spot': 'wss://sstream.asterdex.com/stream',
                        'swap': 'wss://fstream.asterdex.com/stream',
                    },
                },
            },
            'options': {},
            'streaming': {},
            'exceptions': {},
        })

    def get_account_type_from_subscriptions(self, subscriptions: List[str]) -> str:
        accountType = ''
        for i in range(0, len(subscriptions)):
            subscription = subscriptions[i]
            if (subscription == 'spot') or (subscription == 'swap'):
                accountType = subscription
                break
        return accountType

    async def watch_ticker(self, symbol: str, params={}) -> Ticker:
        """
        watches a price ticker, a statistical calculation with the information calculated over the past 24 hours for a specific market

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#full-ticker-per-symbol
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#individual-symbol-ticker-streams

        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        params['callerMethodName'] = 'watchTicker'
        await self.load_markets()
        symbol = self.safe_symbol(symbol)
        tickers = await self.watch_tickers([symbol], params)
        return tickers[symbol]

    async def un_watch_ticker(self, symbol: str, params={}) -> Any:
        """
        unWatches a price ticker

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#full-ticker-per-symbol
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#individual-symbol-ticker-streams

        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        params['callerMethodName'] = 'unWatchTicker'
        return await self.un_watch_tickers([symbol], params)

    async def watch_tickers(self, symbols: Strings = None, params={}) -> Tickers:
        """
        watches a price ticker, a statistical calculation with the information calculated over the past 24 hours for all markets of a specific list

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#full-ticker-per-symbol
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#individual-symbol-ticker-streams

        :param str[] symbols: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'watchTickers')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'SUBSCRIBE',
            'params': subscriptionArgs,
        }
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@ticker')
            messageHashes.append('ticker:' + market['symbol'])
        newTicker = await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])
        if self.newUpdates:
            result: dict = {}
            result[newTicker['symbol']] = newTicker
            return result
        return self.filter_by_array(self.tickers, 'symbol', symbols)

    async def un_watch_tickers(self, symbols: Strings = None, params={}) -> Any:
        """
        unWatches a price ticker, a statistical calculation with the information calculated over the past 24 hours for all markets of a specific list

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#full-ticker-per-symbol
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#individual-symbol-ticker-streams

        :param str[] symbols: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'unWatchTickers')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'UNSUBSCRIBE',
            'params': subscriptionArgs,
        }
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@ticker')
            messageHashes.append('unsubscribe:ticker:' + market['symbol'])
        return await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])

    async def watch_mark_price(self, symbol: str, params={}) -> Ticker:
        """
        watches a mark price for a specific market

        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#mark-price-stream

        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :param boolean [params.use1sFreq]: *default is True* if set to True, the mark price will be updated every second, otherwise every 3 seconds
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        params['callerMethodName'] = 'watchMarkPrice'
        await self.load_markets()
        symbol = self.safe_symbol(symbol)
        tickers = await self.watch_mark_prices([symbol], params)
        return tickers[symbol]

    async def un_watch_mark_price(self, symbol: str, params={}) -> Any:
        """
        unWatches a mark price for a specific market

        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#mark-price-stream

        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :param boolean [params.use1sFreq]: *default is True* if set to True, the mark price will be updated every second, otherwise every 3 seconds
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        params['callerMethodName'] = 'unWatchMarkPrice'
        return await self.un_watch_mark_prices([symbol], params)

    async def watch_mark_prices(self, symbols: Strings = None, params={}) -> Tickers:
        """
        watches the mark price for all markets

        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#mark-price-stream

        :param str[] symbols: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :param boolean [params.use1sFreq]: *default is True* if set to True, the mark price will be updated every second, otherwise every 3 seconds
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'watchMarkPrices')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'SUBSCRIBE',
            'params': subscriptionArgs,
        }
        use1sFreq = self.safe_bool(params, 'use1sFreq', True)
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            suffix = '@1s' if (use1sFreq) else ''
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@markPrice' + suffix)
            messageHashes.append('ticker:' + market['symbol'])
        newTicker = await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])
        if self.newUpdates:
            result = {}
            result[newTicker['symbol']] = newTicker
            return result
        return self.filter_by_array(self.tickers, 'symbol', symbols)

    async def un_watch_mark_prices(self, symbols: Strings = None, params={}) -> Any:
        """
        watches the mark price for all markets

        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#mark-price-stream

        :param str[] symbols: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :param boolean [params.use1sFreq]: *default is True* if set to True, the mark price will be updated every second, otherwise every 3 seconds
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'unWatchMarkPrices')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'UNSUBSCRIBE',
            'params': subscriptionArgs,
        }
        use1sFreq = self.safe_bool(params, 'use1sFreq', True)
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            suffix = '@1s' if (use1sFreq) else ''
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@markPrice' + suffix)
            messageHashes.append('unsubscribe:ticker:' + market['symbol'])
        return await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])

    def handle_ticker(self, client: Client, message):
        #
        #     {
        #         "stream": "trumpusdt@ticker",
        #         "data": {
        #             "e": "24hrTicker",
        #             "E": 1754451187277,
        #             "s": "CAKEUSDT",
        #             "p": "-0.08800",
        #             "P": "-3.361",
        #             "w": "2.58095",
        #             "c": "2.53000",
        #             "Q": "5",
        #             "o": "2.61800",
        #             "h": "2.64700",
        #             "l": "2.52400",
        #             "v": "15775",
        #             "q": "40714.46000",
        #             "O": 1754364780000,
        #             "C": 1754451187274,
        #             "F": 6571389,
        #             "L": 6574507,
        #             "n": 3119
        #         }
        #     }
        #     {
        #         "stream": "btcusdt@markPrice",
        #         "data": {
        #             "e": "markPriceUpdate",
        #             "E": 1754660466000,
        #             "s": "BTCUSDT",
        #             "p": "116809.60000000",
        #             "P": "116595.54012838",
        #             "i": "116836.93534884",
        #             "r": "0.00010000",
        #             "T": 1754668800000
        #         }
        #     }
        #
        subscriptions = client.subscriptions
        subscriptionsKeys = list(subscriptions.keys())
        marketType = self.get_account_type_from_subscriptions(subscriptionsKeys)
        ticker = self.safe_dict(message, 'data')
        parsed = self.parse_ws_ticker(ticker, marketType)
        symbol = parsed['symbol']
        messageHash = 'ticker:' + symbol
        self.tickers[symbol] = parsed
        client.resolve(self.tickers[symbol], messageHash)

    def parse_ws_ticker(self, message, marketType):
        event = self.safe_string(message, 'e')
        part = event.split('@')
        channel = self.safe_string(part, 1)
        marketId = self.safe_string(message, 's')
        timestamp = self.safe_integer(message, 'E')
        market = self.safe_market(marketId, None, None, marketType)
        last = self.safe_string(message, 'c')
        if channel == 'markPriceUpdate':
            return self.safe_ticker({
                'symbol': market['symbol'],
                'timestamp': timestamp,
                'datetime': self.iso8601(timestamp),
                'info': message,
                'markPrice': self.safe_string(message, 'p'),
                'indexPrice': self.safe_string(message, 'i'),
            })
        return self.safe_ticker({
            'symbol': market['symbol'],
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'high': self.safe_string(message, 'h'),
            'low': self.safe_string(message, 'l'),
            'bid': None,
            'bidVolume': None,
            'ask': None,
            'askVolume': None,
            'vwap': self.safe_string(message, 'w'),
            'open': self.safe_string(message, 'o'),
            'close': last,
            'last': last,
            'previousClose': None,
            'change': self.safe_string(message, 'p'),
            'percentage': self.safe_string(message, 'P'),
            'average': None,
            'baseVolume': self.safe_string(message, 'v'),
            'quoteVolume': self.safe_string(message, 'q'),
            'info': message,
        }, market)

    async def watch_bids_asks(self, symbols: Strings = None, params={}) -> Tickers:
        """
        watches best bid & ask for symbols

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#best-order-book-information-by-symbol
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#individual-symbol-book-ticker-streams

        :param str[] symbols: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' watchBidsAsks() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'SUBSCRIBE',
            'params': subscriptionArgs,
        }
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@bookTicker')
            messageHashes.append('bidask:' + market['symbol'])
        newTicker = await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])
        if self.newUpdates:
            result = {}
            result[newTicker['symbol']] = newTicker
            return result
        return self.filter_by_array(self.bidsasks, 'symbol', symbols)

    async def un_watch_bids_asks(self, symbols: Strings = None, params={}) -> Any:
        """
        unWatches best bid & ask for symbols

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#best-order-book-information-by-symbol
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#individual-symbol-book-ticker-streams

        :param str[] symbols: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' unWatchBidsAsks() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'UNSUBSCRIBE',
            'params': subscriptionArgs,
        }
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@bookTicker')
            messageHashes.append('unsubscribe:bidask:' + market['symbol'])
        return await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])

    def handle_bid_ask(self, client: Client, message):
        #
        #     {
        #         "stream": "btcusdt@bookTicker",
        #         "data": {
        #             "e": "bookTicker",
        #             "u": 157240846459,
        #             "s": "BTCUSDT",
        #             "b": "122046.7",
        #             "B": "1.084",
        #             "a": "122046.8",
        #             "A": "0.001",
        #             "T": 1754896692922,
        #             "E": 1754896692926
        #         }
        #     }
        #
        subscriptions = client.subscriptions
        subscriptionsKeys = list(subscriptions.keys())
        marketType = self.get_account_type_from_subscriptions(subscriptionsKeys)
        data = self.safe_dict(message, 'data', {})
        marketId = self.safe_string(data, 's')
        market = self.safe_market(marketId, None, None, marketType)
        ticker = self.parse_ws_bid_ask(data, market)
        symbol = ticker['symbol']
        self.bidsasks[symbol] = ticker
        messageHash = 'bidask:' + symbol
        client.resolve(ticker, messageHash)

    def parse_ws_bid_ask(self, message, market=None):
        timestamp = self.safe_integer(message, 'T')
        return self.safe_ticker({
            'symbol': market['symbol'],
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'ask': self.safe_string(message, 'a'),
            'askVolume': self.safe_string(message, 'A'),
            'bid': self.safe_string(message, 'b'),
            'bidVolume': self.safe_string(message, 'B'),
            'info': message,
        }, market)

    async def watch_trades(self, symbol: str, since: Int = None, limit: Int = None, params={}) -> List[Trade]:
        """
        watches information on multiple trades made in a market

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#collection-transaction-flow
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#aggregate-trade-streams

        :param str symbol: unified market symbol of the market trades were made in
        :param int [since]: the earliest time in ms to fetch trades for
        :param int [limit]: the maximum number of trade structures to retrieve
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict[]: a list of `trade structures <https://docs.ccxt.com/#/?id=trade-structure>`
        """
        params['callerMethodName'] = 'watchTrades'
        return await self.watch_trades_for_symbols([symbol], since, limit, params)

    async def un_watch_trades(self, symbol: str, params={}) -> Any:
        """
        unsubscribe from the trades channel

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#collection-transaction-flow
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#aggregate-trade-streams

        :param str symbol: unified market symbol of the market trades were made in
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict[]: a list of `trade structures <https://docs.ccxt.com/#/?id=trade-structure>`
        """
        params['callerMethodName'] = 'unWatchTrades'
        return await self.un_watch_trades_for_symbols([symbol], params)

    async def watch_trades_for_symbols(self, symbols: List[str], since: Int = None, limit: Int = None, params={}) -> List[Trade]:
        """
        get the list of most recent trades for a list of symbols

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#collection-transaction-flow
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#aggregate-trade-streams

        :param str[] symbols: unified symbol of the market to fetch trades for
        :param int [since]: timestamp in ms of the earliest trade to fetch
        :param int [limit]: the maximum amount of trades to fetch
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict[]: a list of `trade structures <https://docs.ccxt.com/#/?id=public-trades>`
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'watchTradesForSymbols')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'SUBSCRIBE',
            'params': subscriptionArgs,
        }
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@aggTrade')
            messageHashes.append('trade:' + market['symbol'])
        trades = await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])
        if self.newUpdates:
            first = self.safe_value(trades, 0)
            tradeSymbol = self.safe_string(first, 'symbol')
            limit = trades.getLimit(tradeSymbol, limit)
        return self.filter_by_since_limit(trades, since, limit, 'timestamp', True)

    async def un_watch_trades_for_symbols(self, symbols: List[str], params={}) -> Any:
        """
        unsubscribe from the trades channel

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#collection-transaction-flow
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#aggregate-trade-streams

        :param str[] symbols: unified symbol of the market to fetch trades for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict[]: a list of `trade structures <https://docs.ccxt.com/#/?id=public-trades>`
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'unWatchTradesForSymbols')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'UNSUBSCRIBE',
            'params': subscriptionArgs,
        }
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@aggTrade')
            messageHashes.append('unsubscribe:trade:' + market['symbol'])
        return await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])

    def handle_trade(self, client: Client, message):
        #
        #     {
        #         "stream": "btcusdt@aggTrade",
        #         "data": {
        #             "e": "aggTrade",
        #             "E": 1754551358681,
        #             "a": 20505890,
        #             "s": "BTCUSDT",
        #             "p": "114783.7",
        #             "q": "0.020",
        #             "f": 26024678,
        #             "l": 26024682,
        #             "T": 1754551358528,
        #             "m": False
        #         }
        #     }
        #
        subscriptions = client.subscriptions
        subscriptionsKeys = list(subscriptions.keys())
        marketType = self.get_account_type_from_subscriptions(subscriptionsKeys)
        trade = self.safe_dict(message, 'data')
        marketId = self.safe_string(trade, 's')
        market = self.safe_market(marketId, None, None, marketType)
        parsed = self.parse_ws_trade(trade, market)
        symbol = parsed['symbol']
        stored = self.safe_value(self.trades, symbol)
        if stored is None:
            limit = self.safe_integer(self.options, 'tradesLimit', 1000)
            stored = ArrayCache(limit)
            self.trades[symbol] = stored
        stored.append(parsed)
        messageHash = 'trade' + ':' + symbol
        client.resolve(stored, messageHash)

    def parse_ws_trade(self, trade: dict, market: Market = None) -> Trade:
        timestamp = self.safe_integer(trade, 'T')
        symbol = market['symbol']
        amountString = self.safe_string(trade, 'q')
        priceString = self.safe_string(trade, 'p')
        isMaker = self.safe_bool(trade, 'm')
        takerOrMaker = None
        if isMaker is not None:
            takerOrMaker = 'maker' if isMaker else 'taker'
        return self.safe_trade({
            'id': self.safe_string(trade, 'a'),
            'info': trade,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'symbol': symbol,
            'order': None,
            'type': None,
            'side': None,
            'takerOrMaker': takerOrMaker,
            'price': priceString,
            'amount': amountString,
            'cost': None,
            'fee': None,
        }, market)

    async def watch_order_book(self, symbol: str, limit: Int = None, params={}) -> OrderBook:
        """
        watches information on open orders with bid(buy) and ask(sell) prices, volumes and other data

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#limited-depth-information
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#partial-book-depth-streams

        :param str symbol: unified symbol of the market to fetch the order book for
        :param int [limit]: the maximum amount of order book entries to return.
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: A dictionary of `order book structures <https://docs.ccxt.com/#/?id=order-book-structure>` indexed by market symbols
        """
        params['callerMethodName'] = 'watchOrderBook'
        return await self.watch_order_book_for_symbols([symbol], limit, params)

    async def un_watch_order_book(self, symbol: str, params={}) -> Any:
        """
        unsubscribe from the orderbook channel

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#limited-depth-information
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#partial-book-depth-streams

        :param str symbol: symbol of the market to unwatch the trades for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :param int [params.limit]: orderbook limit, default is None
        :returns dict: A dictionary of `order book structures <https://docs.ccxt.com/#/?id=order-book-structure>` indexed by market symbols
        """
        params['callerMethodName'] = 'unWatchOrderBook'
        return await self.un_watch_order_book_for_symbols([symbol], params)

    async def watch_order_book_for_symbols(self, symbols: List[str], limit: Int = None, params={}) -> OrderBook:
        """
        watches information on open orders with bid(buy) and ask(sell) prices, volumes and other data

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#limited-depth-information
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#partial-book-depth-streams

        :param str[] symbols: unified array of symbols
        :param int [limit]: the maximum amount of order book entries to return.
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: A dictionary of `order book structures <https://docs.ccxt.com/#/?id=order-book-structure>` indexed by market symbols
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'watchOrderBookForSymbols')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'SUBSCRIBE',
            'params': subscriptionArgs,
        }
        if limit is None or (limit != 5 and limit != 10 and limit != 20):
            limit = 20
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@depth' + limit)
            messageHashes.append('orderbook:' + market['symbol'])
        orderbook = await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])
        return orderbook.limit()

    async def un_watch_order_book_for_symbols(self, symbols: List[str], params={}) -> Any:
        """
        unsubscribe from the orderbook channel

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#limited-depth-information
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#partial-book-depth-streams

        :param str[] symbols: unified symbol of the market to unwatch the trades for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :param int [params.limit]: orderbook limit, default is None
        :returns dict: A dictionary of `order book structures <https://docs.ccxt.com/#/?id=order-book-structure>` indexed by market symbols
        """
        await self.load_markets()
        symbols = self.market_symbols(symbols, None, True, True, True)
        firstMarket = self.get_market_from_symbols(symbols)
        type = self.safe_string(firstMarket, 'type', 'swap')
        symbolsLength = len(symbols)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'unWatchOrderBookForSymbols')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'UNSUBSCRIBE',
            'params': subscriptionArgs,
        }
        limit = self.safe_number(params, 'limit')
        params = self.omit(params, 'limit')
        if limit is None or (limit != 5 and limit != 10 and limit != 20):
            limit = 20
        for i in range(0, len(symbols)):
            symbol = symbols[i]
            market = self.market(symbol)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@depth' + limit)
            messageHashes.append('unsubscribe:orderbook:' + market['symbol'])
        return await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])

    def handle_order_book(self, client: Client, message):
        #
        #     {
        #         "stream": "btcusdt@depth20",
        #         "data": {
        #             "e": "depthUpdate",
        #             "E": 1754556878284,
        #             "T": 1754556878031,
        #             "s": "BTCUSDT",
        #             "U": 156391349814,
        #             "u": 156391349814,
        #             "pu": 156391348236,
        #             "b": [
        #                 [
        #                     "114988.3",
        #                     "0.147"
        #                 ]
        #             ],
        #             "a": [
        #                 [
        #                     "114988.4",
        #                     "1.060"
        #                 ]
        #             ]
        #         }
        #     }
        #
        subscriptions = client.subscriptions
        subscriptionsKeys = list(subscriptions.keys())
        marketType = self.get_account_type_from_subscriptions(subscriptionsKeys)
        data = self.safe_dict(message, 'data')
        marketId = self.safe_string(data, 's')
        timestamp = self.safe_integer(data, 'T')
        market = self.safe_market(marketId, None, None, marketType)
        symbol = market['symbol']
        if not (symbol in self.orderbooks):
            self.orderbooks[symbol] = self.order_book()
        orderbook = self.orderbooks[symbol]
        snapshot = self.parse_order_book(data, symbol, timestamp, 'b', 'a')
        orderbook.reset(snapshot)
        messageHash = 'orderbook' + ':' + symbol
        self.orderbooks[symbol] = orderbook
        client.resolve(orderbook, messageHash)

    async def watch_ohlcv(self, symbol: str, timeframe='1m', since: Int = None, limit: Int = None, params={}) -> List[list]:
        """
        watches historical candlestick data containing the open, high, low, and close price, and the volume of a market

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#k-line-streams
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#klinecandlestick-streams

        :param str symbol: unified symbol of the market to fetch OHLCV data for
        :param str timeframe: the length of time each candle represents
        :param int [since]: timestamp in ms of the earliest candle to fetch
        :param int [limit]: the maximum amount of candles to fetch
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns int[][]: A list of candles ordered, open, high, low, close, volume
        """
        params['callerMethodName'] = 'watchOHLCV'
        await self.load_markets()
        symbol = self.safe_symbol(symbol)
        result = await self.watch_ohlcv_for_symbols([[symbol, timeframe]], since, limit, params)
        return result[symbol][timeframe]

    async def un_watch_ohlcv(self, symbol: str, timeframe='1m', params={}) -> Any:
        """
        unWatches historical candlestick data containing the open, high, low, and close price, and the volume of a market

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#k-line-streams
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#klinecandlestick-streams

        :param str symbol: unified symbol of the market to fetch OHLCV data for
        :param str timeframe: the length of time each candle represents
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns int[][]: A list of candles ordered, open, high, low, close, volume
        """
        params['callerMethodName'] = 'unWatchOHLCV'
        return await self.un_watch_ohlcv_for_symbols([[symbol, timeframe]], params)

    async def watch_ohlcv_for_symbols(self, symbolsAndTimeframes: List[List[str]], since: Int = None, limit: Int = None, params={}):
        """
        watches historical candlestick data containing the open, high, low, and close price, and the volume of a market

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#k-line-streams
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#klinecandlestick-streams

        :param str[][] symbolsAndTimeframes: array of arrays containing unified symbols and timeframes to fetch OHLCV data for, example [['BTC/USDT', '1m'], ['LTC/USDT', '5m']]
        :param int [since]: timestamp in ms of the earliest candle to fetch
        :param int [limit]: the maximum amount of candles to fetch
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: A list of candles ordered, open, high, low, close, volume
        """
        await self.load_markets()
        symbolsLength = len(symbolsAndTimeframes)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'watchOHLCVForSymbols')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        symbols = self.get_list_from_object_values(symbolsAndTimeframes, 0)
        marketSymbols = self.market_symbols(symbols, None, False, True, True)
        firstMarket = self.market(marketSymbols[0])
        type = self.safe_string(firstMarket, 'type', 'swap')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'SUBSCRIBE',
            'params': subscriptionArgs,
        }
        for i in range(0, len(symbolsAndTimeframes)):
            data = symbolsAndTimeframes[i]
            symbolString = self.safe_string(data, 0)
            market = self.market(symbolString)
            symbolString = market['symbol']
            unfiedTimeframe = self.safe_string(data, 1)
            timeframeId = self.safe_string(self.timeframes, unfiedTimeframe, unfiedTimeframe)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@kline_' + timeframeId)
            messageHashes.append('ohlcv:' + market['symbol'] + ':' + unfiedTimeframe)
        symbol, timeframe, stored = await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])
        if self.newUpdates:
            limit = stored.getLimit(symbol, limit)
        filtered = self.filter_by_since_limit(stored, since, limit, 0, True)
        return self.create_ohlcv_object(symbol, timeframe, filtered)

    async def un_watch_ohlcv_for_symbols(self, symbolsAndTimeframes: List[List[str]], params={}) -> Any:
        """
        unWatches historical candlestick data containing the open, high, low, and close price, and the volume of a market

        https://github.com/asterdex/api-docs/blob/master/aster-finance-spot-api.md#k-line-streams
        https://github.com/asterdex/api-docs/blob/master/aster-finance-futures-api.md#klinecandlestick-streams

        :param str[][] symbolsAndTimeframes: array of arrays containing unified symbols and timeframes to fetch OHLCV data for, example [['BTC/USDT', '1m'], ['LTC/USDT', '5m']]
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns int[][]: A list of candles ordered, open, high, low, close, volume
        """
        await self.load_markets()
        symbolsLength = len(symbolsAndTimeframes)
        methodName = None
        methodName, params = self.handle_param_string(params, 'callerMethodName', 'unWatchOHLCVForSymbols')
        params = self.omit(params, 'callerMethodName')
        if symbolsLength == 0:
            raise ArgumentsRequired(self.id + ' ' + methodName + '() requires a non-empty array of symbols')
        symbols = self.get_list_from_object_values(symbolsAndTimeframes, 0)
        marketSymbols = self.market_symbols(symbols, None, False, True, True)
        firstMarket = self.market(marketSymbols[0])
        type = self.safe_string(firstMarket, 'type', 'swap')
        url = self.urls['api']['ws'][type]
        subscriptionArgs = []
        messageHashes = []
        request: dict = {
            'method': 'UNSUBSCRIBE',
            'params': subscriptionArgs,
        }
        for i in range(0, len(symbolsAndTimeframes)):
            data = symbolsAndTimeframes[i]
            symbolString = self.safe_string(data, 0)
            market = self.market(symbolString)
            symbolString = market['symbol']
            unfiedTimeframe = self.safe_string(data, 1)
            timeframeId = self.safe_string(self.timeframes, unfiedTimeframe, unfiedTimeframe)
            subscriptionArgs.append(self.safe_string_lower(market, 'id') + '@kline_' + timeframeId)
            messageHashes.append('unsubscribe:ohlcv:' + market['symbol'] + ':' + unfiedTimeframe)
        return await self.watch_multiple(url, messageHashes, self.extend(request, params), [type])

    def handle_ohlcv(self, client: Client, message):
        #
        #     {
        #         "stream": "btcusdt@kline_1m",
        #         "data": {
        #             "e": "kline",
        #             "E": 1754655777119,
        #             "s": "BTCUSDT",
        #             "k": {
        #                 "t": 1754655720000,
        #                 "T": 1754655779999,
        #                 "s": "BTCUSDT",
        #                 "i": "1m",
        #                 "f": 26032629,
        #                 "L": 26032629,
        #                 "o": "116546.9",
        #                 "c": "116546.9",
        #                 "h": "116546.9",
        #                 "l": "116546.9",
        #                 "v": "0.011",
        #                 "n": 1,
        #                 "x": False,
        #                 "q": "1282.0159",
        #                 "V": "0.000",
        #                 "Q": "0.0000",
        #                 "B": "0"
        #             }
        #         }
        #     }
        #
        subscriptions = client.subscriptions
        subscriptionsKeys = list(subscriptions.keys())
        marketType = self.get_account_type_from_subscriptions(subscriptionsKeys)
        data = self.safe_dict(message, 'data')
        marketId = self.safe_string(data, 's')
        market = self.safe_market(marketId, None, None, marketType)
        symbol = market['symbol']
        kline = self.safe_dict(data, 'k')
        timeframeId = self.safe_string(kline, 'i')
        timeframe = self.find_timeframe(timeframeId)
        ohlcvsByTimeframe = self.safe_value(self.ohlcvs, symbol)
        if ohlcvsByTimeframe is None:
            self.ohlcvs[symbol] = {}
        if self.safe_value(ohlcvsByTimeframe, timeframe) is None:
            limit = self.safe_integer(self.options, 'OHLCVLimit', 1000)
            self.ohlcvs[symbol][timeframe] = ArrayCacheByTimestamp(limit)
        stored = self.ohlcvs[symbol][timeframe]
        parsed = self.parse_ws_ohlcv(kline)
        stored.append(parsed)
        messageHash = 'ohlcv:' + symbol + ':' + timeframe
        resolveData = [symbol, timeframe, stored]
        client.resolve(resolveData, messageHash)

    def parse_ws_ohlcv(self, ohlcv, market=None) -> list:
        return [
            self.safe_integer(ohlcv, 't'),
            self.safe_number(ohlcv, 'o'),
            self.safe_number(ohlcv, 'h'),
            self.safe_number(ohlcv, 'l'),
            self.safe_number(ohlcv, 'c'),
            self.safe_number(ohlcv, 'v'),
        ]

    def handle_message(self, client: Client, message):
        stream = self.safe_string(message, 'stream')
        if stream is not None:
            part = stream.split('@')
            topic = self.safe_string(part, 1, '')
            part2 = topic.split('_')
            topic = self.safe_string(part2, 0, '')
            methods: dict = {
                'ticker': self.handle_ticker,
                'aggTrade': self.handle_trade,
                'depth5': self.handle_order_book,
                'depth10': self.handle_order_book,
                'depth20': self.handle_order_book,
                'kline': self.handle_ohlcv,
                'markPrice': self.handle_ticker,
                'bookTicker': self.handle_bid_ask,
            }
            method = self.safe_value(methods, topic)
            if method is not None:
                method(client, message)
