"""

Revision ID: 08ac1116e055
Revises: 11d35a452b40
Create Date: 2025-06-27 21:22:44.798799

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision: str = "08ac1116e055"
down_revision: Union[str, None] = "11d35a452b40"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("cdlmorningstar", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("cdl3linestrike", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("cdl3whitesoldiers", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("cdlabandonedbaby", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("cdltasukigap", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("cdlpiercing", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("cdlengulfing", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("rate_of_change_1", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("rate_of_change_7_4", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("rate_of_change_7_12", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("rate_of_change_30", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("golden_cross", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("death_cross", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("mfi_oversold", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("mfi_overbought", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("stoch_oversold", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("stoch_overbought", sa.Date(), nullable=True))
        batch_op.add_column(
            sa.Column("rsi_bullish_crossover", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("rsi_bearish_crossover", sa.Date(), nullable=True)
        )
        batch_op.add_column(sa.Column("rsi_oversold", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("rsi_overbought", sa.Date(), nullable=True))
        batch_op.add_column(
            sa.Column("macd_12_26_9_bullish_crossover", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("macd_12_26_9_bearish_crossover", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("macd_12_26_9_zero_line_cross_up", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("macd_12_26_9_zero_line_cross_down", sa.Date(), nullable=True)
        )
        batch_op.add_column(sa.Column("adx_14_long", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("adx_14_short", sa.Date(), nullable=True))
        batch_op.create_index("ix_analysis_adx_14_long", ["adx_14_long"], unique=False)
        batch_op.create_index(
            "ix_analysis_adx_14_short", ["adx_14_short"], unique=False
        )
        batch_op.create_index("ix_analysis_base_symbol", ["base_symbol"], unique=False)
        batch_op.create_index("ix_analysis_book_value", ["book_value"], unique=False)
        batch_op.create_index(
            "ix_analysis_cdl3linestrike", ["cdl3linestrike"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_cdl3whitesoldiers", ["cdl3whitesoldiers"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_cdlabandonedbaby", ["cdlabandonedbaby"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_cdlengulfing", ["cdlengulfing"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_cdlmorningstar", ["cdlmorningstar"], unique=False
        )
        batch_op.create_index("ix_analysis_cdlpiercing", ["cdlpiercing"], unique=False)
        batch_op.create_index(
            "ix_analysis_cdltasukigap", ["cdltasukigap"], unique=False
        )
        batch_op.create_index("ix_analysis_country", ["country"], unique=False)
        batch_op.create_index("ix_analysis_created_at", ["created_at"], unique=False)
        batch_op.create_index("ix_analysis_currency", ["currency"], unique=False)
        batch_op.create_index("ix_analysis_date", ["date"], unique=False)
        batch_op.create_index("ix_analysis_death_cross", ["death_cross"], unique=False)
        batch_op.create_index(
            "ix_analysis_dividend_rate", ["dividend_rate"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_dividend_yield", ["dividend_yield"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_earning_per_share", ["earning_per_share"], unique=False
        )
        batch_op.create_index("ix_analysis_exchange", ["exchange"], unique=False)
        batch_op.create_index(
            "ix_analysis_forward_earnings_per_share",
            ["forward_earnings_per_share"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_golden_cross", ["golden_cross"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_gross_margins", ["gross_margins"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_growing_basic_eps", ["growing_basic_eps"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_growing_diluted_eps", ["growing_diluted_eps"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_growing_net_income", ["growing_net_income"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_growing_operating_cash_flow",
            ["growing_operating_cash_flow"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_growing_operating_income",
            ["growing_operating_income"],
            unique=False,
        )
        batch_op.create_index("ix_analysis_industry", ["industry"], unique=False)
        batch_op.create_index(
            "ix_analysis_industry_group", ["industry_group"], unique=False
        )
        batch_op.create_index("ix_analysis_isin", ["isin"], unique=False)
        batch_op.create_index("ix_analysis_last_price", ["last_price"], unique=False)
        batch_op.create_index(
            "ix_analysis_macd_12_26_9_bearish_crossover",
            ["macd_12_26_9_bearish_crossover"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_macd_12_26_9_bullish_crossover",
            ["macd_12_26_9_bullish_crossover"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_macd_12_26_9_zero_line_cross_down",
            ["macd_12_26_9_zero_line_cross_down"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_macd_12_26_9_zero_line_cross_up",
            ["macd_12_26_9_zero_line_cross_up"],
            unique=False,
        )
        batch_op.create_index("ix_analysis_market", ["market"], unique=False)
        batch_op.create_index(
            "ix_analysis_market_capitalization", ["market_capitalization"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_max_capex_ratio", ["max_capex_ratio"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_max_dividend_payout_ratio",
            ["max_dividend_payout_ratio"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_mean_capex_ratio", ["mean_capex_ratio"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_mean_dividend_payout_ratio",
            ["mean_dividend_payout_ratio"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_mfi_overbought", ["mfi_overbought"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_mfi_oversold", ["mfi_oversold"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_min_capex_ratio", ["min_capex_ratio"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_min_dividend_payout_ratio",
            ["min_dividend_payout_ratio"],
            unique=False,
        )
        batch_op.create_index("ix_analysis_modifier", ["modifier"], unique=False)
        batch_op.create_index("ix_analysis_name", ["name"], unique=False)
        batch_op.create_index(
            "ix_analysis_operating_cash_flow_is_higher_than_net_income",
            ["operating_cash_flow_is_higher_than_net_income"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_operating_margins", ["operating_margins"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_positive_basic_eps", ["positive_basic_eps"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_positive_debt_to_equity",
            ["positive_debt_to_equity"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_positive_diluted_eps", ["positive_diluted_eps"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_positive_free_cash_flow",
            ["positive_free_cash_flow"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_positive_net_income", ["positive_net_income"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_positive_operating_income",
            ["positive_operating_income"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_positive_return_on_assets",
            ["positive_return_on_assets"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_positive_return_on_equity",
            ["positive_return_on_equity"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_price_per_earning_ratio",
            ["price_per_earning_ratio"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_price_to_book", ["price_to_book"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_quarterly_earning_per_share",
            ["quarterly_earning_per_share"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_growing_basic_eps",
            ["quarterly_growing_basic_eps"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_growing_diluted_eps",
            ["quarterly_growing_diluted_eps"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_growing_net_income",
            ["quarterly_growing_net_income"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_growing_operating_cash_flow",
            ["quarterly_growing_operating_cash_flow"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_growing_operating_income",
            ["quarterly_growing_operating_income"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_max_capex_ratio",
            ["quarterly_max_capex_ratio"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_max_dividend_payout_ratio",
            ["quarterly_max_dividend_payout_ratio"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_mean_capex_ratio",
            ["quarterly_mean_capex_ratio"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_mean_dividend_payout_ratio",
            ["quarterly_mean_dividend_payout_ratio"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_min_capex_ratio",
            ["quarterly_min_capex_ratio"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_min_dividend_payout_ratio",
            ["quarterly_min_dividend_payout_ratio"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_operating_cash_flow_is_higher_than_net_income",
            ["quarterly_operating_cash_flow_is_higher_than_net_income"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_positive_basic_eps",
            ["quarterly_positive_basic_eps"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_positive_debt_to_equity",
            ["quarterly_positive_debt_to_equity"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_positive_diluted_eps",
            ["quarterly_positive_diluted_eps"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_positive_free_cash_flow",
            ["quarterly_positive_free_cash_flow"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_positive_net_income",
            ["quarterly_positive_net_income"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_positive_operating_income",
            ["quarterly_positive_operating_income"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_positive_return_on_assets",
            ["quarterly_positive_return_on_assets"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_quarterly_positive_return_on_equity",
            ["quarterly_positive_return_on_equity"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_rate_of_change_1", ["rate_of_change_1"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_rate_of_change_30", ["rate_of_change_30"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_rate_of_change_7_12", ["rate_of_change_7_12"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_rate_of_change_7_4", ["rate_of_change_7_4"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_return_on_equity", ["return_on_equity"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_revenue_growth", ["revenue_growth"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_rsi_bearish_crossover", ["rsi_bearish_crossover"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_rsi_bullish_crossover", ["rsi_bullish_crossover"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_rsi_overbought", ["rsi_overbought"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_rsi_oversold", ["rsi_oversold"], unique=False
        )
        batch_op.create_index("ix_analysis_sector", ["sector"], unique=False)
        batch_op.create_index(
            "ix_analysis_stoch_overbought", ["stoch_overbought"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_stoch_oversold", ["stoch_oversold"], unique=False
        )
        batch_op.create_index("ix_analysis_summary", ["summary"], unique=False)
        batch_op.create_index(
            "ix_analysis_trailing_earnings_per_share",
            ["trailing_earnings_per_share"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_trailing_price_to_earnings",
            ["trailing_price_to_earnings"],
            unique=False,
        )
        batch_op.create_index("ix_analysis_website", ["website"], unique=False)
        batch_op.drop_column("last_year_growth")
        batch_op.drop_column("year_to_date_max_growth")
        batch_op.drop_column("last_month_max_growth")
        batch_op.drop_column("last_week_max_growth")
        batch_op.drop_column("star_wow")
        batch_op.drop_column("last_dmp")
        batch_op.drop_column("year_to_date_growth")
        batch_op.drop_column("last_week_growth")
        batch_op.drop_column("rsi_last_value")
        batch_op.drop_column("ma_50_200_buy_date")
        batch_op.drop_column("slope_14")
        batch_op.drop_column("slope_7")
        batch_op.drop_column("last_52_weeks_growth")
        batch_op.drop_column("slope_60")
        batch_op.drop_column("last_dmn")
        batch_op.drop_column("last_price_date")
        batch_op.drop_column("slope_30")
        batch_op.drop_column("macd_12_26_9_buy")
        batch_op.drop_column("last_year_max_growth")
        batch_op.drop_column("macd_12_26_9_buy_date")
        batch_op.drop_column("last_adx")
        batch_op.drop_column("last_month_growth")
        batch_op.drop_column("star_mom")
        batch_op.drop_column("star_yoy")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("star_yoy", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("star_mom", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("last_month_growth", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("last_adx", sa.FLOAT(), nullable=True))
        batch_op.add_column(
            sa.Column("macd_12_26_9_buy_date", sa.DATE(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("last_year_max_growth", sa.FLOAT(), nullable=True)
        )
        batch_op.add_column(sa.Column("macd_12_26_9_buy", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("slope_30", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("last_price_date", sa.DATE(), nullable=True))
        batch_op.add_column(sa.Column("last_dmn", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("slope_60", sa.FLOAT(), nullable=True))
        batch_op.add_column(
            sa.Column("last_52_weeks_growth", sa.FLOAT(), nullable=True)
        )
        batch_op.add_column(sa.Column("slope_7", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("slope_14", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("ma_50_200_buy_date", sa.DATE(), nullable=True))
        batch_op.add_column(sa.Column("rsi_last_value", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("last_week_growth", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("year_to_date_growth", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("last_dmp", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("star_wow", sa.FLOAT(), nullable=True))
        batch_op.add_column(
            sa.Column("last_week_max_growth", sa.FLOAT(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("last_month_max_growth", sa.FLOAT(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("year_to_date_max_growth", sa.FLOAT(), nullable=True)
        )
        batch_op.add_column(sa.Column("last_year_growth", sa.FLOAT(), nullable=True))
        batch_op.drop_index("ix_analysis_website")
        batch_op.drop_index("ix_analysis_trailing_price_to_earnings")
        batch_op.drop_index("ix_analysis_trailing_earnings_per_share")
        batch_op.drop_index("ix_analysis_summary")
        batch_op.drop_index("ix_analysis_stoch_oversold")
        batch_op.drop_index("ix_analysis_stoch_overbought")
        batch_op.drop_index("ix_analysis_sector")
        batch_op.drop_index("ix_analysis_rsi_oversold")
        batch_op.drop_index("ix_analysis_rsi_overbought")
        batch_op.drop_index("ix_analysis_rsi_bullish_crossover")
        batch_op.drop_index("ix_analysis_rsi_bearish_crossover")
        batch_op.drop_index("ix_analysis_revenue_growth")
        batch_op.drop_index("ix_analysis_return_on_equity")
        batch_op.drop_index("ix_analysis_rate_of_change_7_4")
        batch_op.drop_index("ix_analysis_rate_of_change_7_12")
        batch_op.drop_index("ix_analysis_rate_of_change_30")
        batch_op.drop_index("ix_analysis_rate_of_change_1")
        batch_op.drop_index("ix_analysis_quarterly_positive_return_on_equity")
        batch_op.drop_index("ix_analysis_quarterly_positive_return_on_assets")
        batch_op.drop_index("ix_analysis_quarterly_positive_operating_income")
        batch_op.drop_index("ix_analysis_quarterly_positive_net_income")
        batch_op.drop_index("ix_analysis_quarterly_positive_free_cash_flow")
        batch_op.drop_index("ix_analysis_quarterly_positive_diluted_eps")
        batch_op.drop_index("ix_analysis_quarterly_positive_debt_to_equity")
        batch_op.drop_index("ix_analysis_quarterly_positive_basic_eps")
        batch_op.drop_index(
            "ix_analysis_quarterly_operating_cash_flow_is_higher_than_net_income"
        )
        batch_op.drop_index("ix_analysis_quarterly_min_dividend_payout_ratio")
        batch_op.drop_index("ix_analysis_quarterly_min_capex_ratio")
        batch_op.drop_index("ix_analysis_quarterly_mean_dividend_payout_ratio")
        batch_op.drop_index("ix_analysis_quarterly_mean_capex_ratio")
        batch_op.drop_index("ix_analysis_quarterly_max_dividend_payout_ratio")
        batch_op.drop_index("ix_analysis_quarterly_max_capex_ratio")
        batch_op.drop_index("ix_analysis_quarterly_growing_operating_income")
        batch_op.drop_index("ix_analysis_quarterly_growing_operating_cash_flow")
        batch_op.drop_index("ix_analysis_quarterly_growing_net_income")
        batch_op.drop_index("ix_analysis_quarterly_growing_diluted_eps")
        batch_op.drop_index("ix_analysis_quarterly_growing_basic_eps")
        batch_op.drop_index("ix_analysis_quarterly_earning_per_share")
        batch_op.drop_index("ix_analysis_price_to_book")
        batch_op.drop_index("ix_analysis_price_per_earning_ratio")
        batch_op.drop_index("ix_analysis_positive_return_on_equity")
        batch_op.drop_index("ix_analysis_positive_return_on_assets")
        batch_op.drop_index("ix_analysis_positive_operating_income")
        batch_op.drop_index("ix_analysis_positive_net_income")
        batch_op.drop_index("ix_analysis_positive_free_cash_flow")
        batch_op.drop_index("ix_analysis_positive_diluted_eps")
        batch_op.drop_index("ix_analysis_positive_debt_to_equity")
        batch_op.drop_index("ix_analysis_positive_basic_eps")
        batch_op.drop_index("ix_analysis_operating_margins")
        batch_op.drop_index("ix_analysis_operating_cash_flow_is_higher_than_net_income")
        batch_op.drop_index("ix_analysis_name")
        batch_op.drop_index("ix_analysis_modifier")
        batch_op.drop_index("ix_analysis_min_dividend_payout_ratio")
        batch_op.drop_index("ix_analysis_min_capex_ratio")
        batch_op.drop_index("ix_analysis_mfi_oversold")
        batch_op.drop_index("ix_analysis_mfi_overbought")
        batch_op.drop_index("ix_analysis_mean_dividend_payout_ratio")
        batch_op.drop_index("ix_analysis_mean_capex_ratio")
        batch_op.drop_index("ix_analysis_max_dividend_payout_ratio")
        batch_op.drop_index("ix_analysis_max_capex_ratio")
        batch_op.drop_index("ix_analysis_market_capitalization")
        batch_op.drop_index("ix_analysis_market")
        batch_op.drop_index("ix_analysis_macd_12_26_9_zero_line_cross_up")
        batch_op.drop_index("ix_analysis_macd_12_26_9_zero_line_cross_down")
        batch_op.drop_index("ix_analysis_macd_12_26_9_bullish_crossover")
        batch_op.drop_index("ix_analysis_macd_12_26_9_bearish_crossover")
        batch_op.drop_index("ix_analysis_last_price")
        batch_op.drop_index("ix_analysis_isin")
        batch_op.drop_index("ix_analysis_industry_group")
        batch_op.drop_index("ix_analysis_industry")
        batch_op.drop_index("ix_analysis_growing_operating_income")
        batch_op.drop_index("ix_analysis_growing_operating_cash_flow")
        batch_op.drop_index("ix_analysis_growing_net_income")
        batch_op.drop_index("ix_analysis_growing_diluted_eps")
        batch_op.drop_index("ix_analysis_growing_basic_eps")
        batch_op.drop_index("ix_analysis_gross_margins")
        batch_op.drop_index("ix_analysis_golden_cross")
        batch_op.drop_index("ix_analysis_forward_earnings_per_share")
        batch_op.drop_index("ix_analysis_exchange")
        batch_op.drop_index("ix_analysis_earning_per_share")
        batch_op.drop_index("ix_analysis_dividend_yield")
        batch_op.drop_index("ix_analysis_dividend_rate")
        batch_op.drop_index("ix_analysis_death_cross")
        batch_op.drop_index("ix_analysis_date")
        batch_op.drop_index("ix_analysis_currency")
        batch_op.drop_index("ix_analysis_created_at")
        batch_op.drop_index("ix_analysis_country")
        batch_op.drop_index("ix_analysis_cdltasukigap")
        batch_op.drop_index("ix_analysis_cdlpiercing")
        batch_op.drop_index("ix_analysis_cdlmorningstar")
        batch_op.drop_index("ix_analysis_cdlengulfing")
        batch_op.drop_index("ix_analysis_cdlabandonedbaby")
        batch_op.drop_index("ix_analysis_cdl3whitesoldiers")
        batch_op.drop_index("ix_analysis_cdl3linestrike")
        batch_op.drop_index("ix_analysis_book_value")
        batch_op.drop_index("ix_analysis_base_symbol")
        batch_op.drop_index("ix_analysis_adx_14_short")
        batch_op.drop_index("ix_analysis_adx_14_long")
        batch_op.drop_column("adx_14_short")
        batch_op.drop_column("adx_14_long")
        batch_op.drop_column("macd_12_26_9_zero_line_cross_down")
        batch_op.drop_column("macd_12_26_9_zero_line_cross_up")
        batch_op.drop_column("macd_12_26_9_bearish_crossover")
        batch_op.drop_column("macd_12_26_9_bullish_crossover")
        batch_op.drop_column("rsi_overbought")
        batch_op.drop_column("rsi_oversold")
        batch_op.drop_column("rsi_bearish_crossover")
        batch_op.drop_column("rsi_bullish_crossover")
        batch_op.drop_column("stoch_overbought")
        batch_op.drop_column("stoch_oversold")
        batch_op.drop_column("mfi_overbought")
        batch_op.drop_column("mfi_oversold")
        batch_op.drop_column("death_cross")
        batch_op.drop_column("golden_cross")
        batch_op.drop_column("rate_of_change_30")
        batch_op.drop_column("rate_of_change_7_12")
        batch_op.drop_column("rate_of_change_7_4")
        batch_op.drop_column("rate_of_change_1")
        batch_op.drop_column("cdlengulfing")
        batch_op.drop_column("cdlpiercing")
        batch_op.drop_column("cdltasukigap")
        batch_op.drop_column("cdlabandonedbaby")
        batch_op.drop_column("cdl3whitesoldiers")
        batch_op.drop_column("cdl3linestrike")
        batch_op.drop_column("cdlmorningstar")
