"""

Revision ID: 12889a2cbd7d
Revises: 040b15fba458
Create Date: 2025-07-17 17:50:35.004785

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "12889a2cbd7d"
down_revision: Union[str, None] = "040b15fba458"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "signalseries",
        sa.Column("date", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("value", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("date", "name", "symbol"),
    )

    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_analysis_momentum_time_span"))
        batch_op.drop_column("momentum_time_span")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("momentum_time_span", sa.DATE(), nullable=True))
        batch_op.create_index(
            batch_op.f("ix_analysis_momentum_time_span"),
            ["momentum_time_span"],
            unique=False,
        )

    op.drop_table("signalseries")
    # ### end Alembic commands ###
