"""

Revision ID: 6d252e23f543
Revises: 12889a2cbd7d
Create Date: 2025-07-27 16:46:41.885125

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "6d252e23f543"
down_revision: Union[str, None] = "12889a2cbd7d"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "backtestresult",
        sa.Column("end", sa.Date(), nullable=False),
        sa.Column("investment", sa.Float(), nullable=False),
        sa.Column("start", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("holding_period", sa.Integer(), nullable=False),
        sa.Column("extend_days", sa.Integer(), nullable=False),
        sa.Column("percentage", sa.Integer(), nullable=False),
        sa.Column("iterations", sa.Integer(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("data", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint(
            "start", "holding_period", "extend_days", "percentage", "iterations", "name"
        ),
    )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    op.drop_table("backtestresult")
    # ### end Alembic commands ###
