# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ImageRegistryCustomImage',
    'InfrastructureV2Env',
    'InfrastructureV2Identifier',
    'InfrastructureV2ImageRegistry',
    'InfrastructureV2ImageRegistryCustomImage',
    'InfrastructureV2ImageRegistryIdentifier',
    'InfrastructureV2Mtls',
    'InfrastructureV2Proxy',
    'InfrastructureV2Toleration',
    'InfrastructureV2Volume',
    'InfrastructureV2VolumeMount',
    'SecurityGovernanceConditionFaultSpec',
    'SecurityGovernanceConditionFaultSpecFault',
    'SecurityGovernanceConditionK8sSpec',
    'SecurityGovernanceConditionK8sSpecApplicationSpec',
    'SecurityGovernanceConditionK8sSpecApplicationSpecWorkload',
    'SecurityGovernanceConditionK8sSpecChaosServiceAccountSpec',
    'SecurityGovernanceConditionK8sSpecInfraSpec',
    'SecurityGovernanceConditionMachineSpec',
    'SecurityGovernanceConditionMachineSpecInfraSpec',
    'SecurityGovernanceRuleTimeWindow',
    'SecurityGovernanceRuleTimeWindowRecurrence',
    'GetImageRegistryCustomImageResult',
    'GetInfrastructureV2ImageRegistryResult',
    'GetInfrastructureV2ImageRegistryCustomImageResult',
    'GetInfrastructureV2ImageRegistryIdentifierResult',
    'GetInfrastructureV2MtlsResult',
    'GetInfrastructureV2ProxyResult',
    'GetInfrastructureV2TolerationResult',
    'GetInfrastructureV2VolumeResult',
    'GetInfrastructureV2VolumeMountResult',
    'GetSecurityGovernanceConditionFaultSpecResult',
    'GetSecurityGovernanceConditionFaultSpecFaultResult',
    'GetSecurityGovernanceConditionK8sSpecResult',
    'GetSecurityGovernanceConditionK8sSpecInfraSpecResult',
    'GetSecurityGovernanceConditionMachineSpecResult',
    'GetSecurityGovernanceConditionMachineSpecInfraSpecResult',
    'GetSecurityGovernanceRuleTimeWindowResult',
    'GetSecurityGovernanceRuleTimeWindowRecurrenceResult',
]

@pulumi.output_type
class ImageRegistryCustomImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ddcrFault":
            suggest = "ddcr_fault"
        elif key == "ddcrLib":
            suggest = "ddcr_lib"
        elif key == "logWatcher":
            suggest = "log_watcher"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRegistryCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRegistryCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRegistryCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ddcr: Optional[_builtins.str] = None,
                 ddcr_fault: Optional[_builtins.str] = None,
                 ddcr_lib: Optional[_builtins.str] = None,
                 log_watcher: Optional[_builtins.str] = None):
        if ddcr is not None:
            pulumi.set(__self__, "ddcr", ddcr)
        if ddcr_fault is not None:
            pulumi.set(__self__, "ddcr_fault", ddcr_fault)
        if ddcr_lib is not None:
            pulumi.set(__self__, "ddcr_lib", ddcr_lib)
        if log_watcher is not None:
            pulumi.set(__self__, "log_watcher", log_watcher)

    @_builtins.property
    @pulumi.getter
    def ddcr(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ddcr")

    @_builtins.property
    @pulumi.getter(name="ddcrFault")
    def ddcr_fault(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ddcr_fault")

    @_builtins.property
    @pulumi.getter(name="ddcrLib")
    def ddcr_lib(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ddcr_lib")

    @_builtins.property
    @pulumi.getter(name="logWatcher")
    def log_watcher(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "log_watcher")


@pulumi.output_type
class InfrastructureV2Env(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2Env. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2Env.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2Env.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None,
                 value_from: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param _builtins.str key: Variable name from a ConfigMap or Secret. Required when value_from is configMapKeyRef or secretKeyRef.
        :param _builtins.str value: Variable references $(VAR*NAME) are expanded using the container's environment. If the variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR*NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        :param _builtins.str value_from: Source for the environment variable's value. Cannot be used if value is not empty.
        """
        pulumi.set(__self__, "name", name)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from is not None:
            pulumi.set(__self__, "value_from", value_from)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Variable name from a ConfigMap or Secret. Required when value_from is configMapKeyRef or secretKeyRef.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Variable references $(VAR*NAME) are expanded using the container's environment. If the variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR*NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> Optional[_builtins.str]:
        """
        Source for the environment variable's value. Cannot be used if value is not empty.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class InfrastructureV2Identifier(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountIdentifier":
            suggest = "account_identifier"
        elif key == "orgIdentifier":
            suggest = "org_identifier"
        elif key == "projectIdentifier":
            suggest = "project_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2Identifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2Identifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2Identifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_identifier: Optional[_builtins.str] = None,
                 org_identifier: Optional[_builtins.str] = None,
                 project_identifier: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_identifier: Account identifier.
        :param _builtins.str org_identifier: Organization identifier.
        :param _builtins.str project_identifier: Project identifier.
        """
        if account_identifier is not None:
            pulumi.set(__self__, "account_identifier", account_identifier)
        if org_identifier is not None:
            pulumi.set(__self__, "org_identifier", org_identifier)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)

    @_builtins.property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> Optional[_builtins.str]:
        """
        Account identifier.
        """
        return pulumi.get(self, "account_identifier")

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> Optional[_builtins.str]:
        """
        Organization identifier.
        """
        return pulumi.get(self, "org_identifier")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[_builtins.str]:
        """
        Project identifier.
        """
        return pulumi.get(self, "project_identifier")


@pulumi.output_type
class InfrastructureV2ImageRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "customImages":
            suggest = "custom_images"
        elif key == "infraId":
            suggest = "infra_id"
        elif key == "isDefault":
            suggest = "is_default"
        elif key == "isOverrideAllowed":
            suggest = "is_override_allowed"
        elif key == "isPrivate":
            suggest = "is_private"
        elif key == "registryAccount":
            suggest = "registry_account"
        elif key == "registryServer":
            suggest = "registry_server"
        elif key == "secretName":
            suggest = "secret_name"
        elif key == "updatedAt":
            suggest = "updated_at"
        elif key == "useCustomImages":
            suggest = "use_custom_images"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2ImageRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2ImageRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2ImageRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[_builtins.str] = None,
                 custom_images: Optional[Sequence['outputs.InfrastructureV2ImageRegistryCustomImage']] = None,
                 identifiers: Optional[Sequence['outputs.InfrastructureV2ImageRegistryIdentifier']] = None,
                 infra_id: Optional[_builtins.str] = None,
                 is_default: Optional[_builtins.bool] = None,
                 is_override_allowed: Optional[_builtins.bool] = None,
                 is_private: Optional[_builtins.bool] = None,
                 registry_account: Optional[_builtins.str] = None,
                 registry_server: Optional[_builtins.str] = None,
                 secret_name: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None,
                 use_custom_images: Optional[_builtins.bool] = None):
        """
        :param _builtins.str created_at: Timestamp when the registry was created.
        :param Sequence['InfrastructureV2ImageRegistryCustomImageArgs'] custom_images: Custom image configurations. Required when use*custom*images is true.
        :param Sequence['InfrastructureV2ImageRegistryIdentifierArgs'] identifiers: Scoped identifiers for the registry.
        :param _builtins.str infra_id: ID of the infrastructure.
        :param _builtins.bool is_default: Whether this is the default registry.
        :param _builtins.bool is_override_allowed: Whether override is allowed for this registry.
        :param _builtins.bool is_private: Whether the registry is private.
        :param _builtins.str registry_account: The account name for the container registry.
        :param _builtins.str registry_server: The container image registry server URL (e.g., docker.io, gcr.io).
        :param _builtins.str secret_name: Name of the Kubernetes secret containing registry credentials.
        :param _builtins.str updated_at: Timestamp when the registry was last updated.
        :param _builtins.bool use_custom_images: Whether to use custom images instead of default ones.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if identifiers is not None:
            pulumi.set(__self__, "identifiers", identifiers)
        if infra_id is not None:
            pulumi.set(__self__, "infra_id", infra_id)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_override_allowed is not None:
            pulumi.set(__self__, "is_override_allowed", is_override_allowed)
        if is_private is not None:
            pulumi.set(__self__, "is_private", is_private)
        if registry_account is not None:
            pulumi.set(__self__, "registry_account", registry_account)
        if registry_server is not None:
            pulumi.set(__self__, "registry_server", registry_server)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if use_custom_images is not None:
            pulumi.set(__self__, "use_custom_images", use_custom_images)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        Timestamp when the registry was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.InfrastructureV2ImageRegistryCustomImage']]:
        """
        Custom image configurations. Required when use*custom*images is true.
        """
        return pulumi.get(self, "custom_images")

    @_builtins.property
    @pulumi.getter
    def identifiers(self) -> Optional[Sequence['outputs.InfrastructureV2ImageRegistryIdentifier']]:
        """
        Scoped identifiers for the registry.
        """
        return pulumi.get(self, "identifiers")

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> Optional[_builtins.str]:
        """
        ID of the infrastructure.
        """
        return pulumi.get(self, "infra_id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[_builtins.bool]:
        """
        Whether this is the default registry.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="isOverrideAllowed")
    def is_override_allowed(self) -> Optional[_builtins.bool]:
        """
        Whether override is allowed for this registry.
        """
        return pulumi.get(self, "is_override_allowed")

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> Optional[_builtins.bool]:
        """
        Whether the registry is private.
        """
        return pulumi.get(self, "is_private")

    @_builtins.property
    @pulumi.getter(name="registryAccount")
    def registry_account(self) -> Optional[_builtins.str]:
        """
        The account name for the container registry.
        """
        return pulumi.get(self, "registry_account")

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> Optional[_builtins.str]:
        """
        The container image registry server URL (e.g., docker.io, gcr.io).
        """
        return pulumi.get(self, "registry_server")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        Name of the Kubernetes secret containing registry credentials.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        Timestamp when the registry was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="useCustomImages")
    def use_custom_images(self) -> Optional[_builtins.bool]:
        """
        Whether to use custom images instead of default ones.
        """
        return pulumi.get(self, "use_custom_images")


@pulumi.output_type
class InfrastructureV2ImageRegistryCustomImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ddcrFault":
            suggest = "ddcr_fault"
        elif key == "ddcrLib":
            suggest = "ddcr_lib"
        elif key == "logWatcher":
            suggest = "log_watcher"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2ImageRegistryCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2ImageRegistryCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2ImageRegistryCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ddcr: Optional[_builtins.str] = None,
                 ddcr_fault: Optional[_builtins.str] = None,
                 ddcr_lib: Optional[_builtins.str] = None,
                 log_watcher: Optional[_builtins.str] = None):
        """
        :param _builtins.str ddcr: Custom image for ddcr.
        :param _builtins.str ddcr_fault: Custom image for ddcr-fault.
        :param _builtins.str ddcr_lib: Custom image for ddcr-lib.
        :param _builtins.str log_watcher: Custom image for log-watcher.
        """
        if ddcr is not None:
            pulumi.set(__self__, "ddcr", ddcr)
        if ddcr_fault is not None:
            pulumi.set(__self__, "ddcr_fault", ddcr_fault)
        if ddcr_lib is not None:
            pulumi.set(__self__, "ddcr_lib", ddcr_lib)
        if log_watcher is not None:
            pulumi.set(__self__, "log_watcher", log_watcher)

    @_builtins.property
    @pulumi.getter
    def ddcr(self) -> Optional[_builtins.str]:
        """
        Custom image for ddcr.
        """
        return pulumi.get(self, "ddcr")

    @_builtins.property
    @pulumi.getter(name="ddcrFault")
    def ddcr_fault(self) -> Optional[_builtins.str]:
        """
        Custom image for ddcr-fault.
        """
        return pulumi.get(self, "ddcr_fault")

    @_builtins.property
    @pulumi.getter(name="ddcrLib")
    def ddcr_lib(self) -> Optional[_builtins.str]:
        """
        Custom image for ddcr-lib.
        """
        return pulumi.get(self, "ddcr_lib")

    @_builtins.property
    @pulumi.getter(name="logWatcher")
    def log_watcher(self) -> Optional[_builtins.str]:
        """
        Custom image for log-watcher.
        """
        return pulumi.get(self, "log_watcher")


@pulumi.output_type
class InfrastructureV2ImageRegistryIdentifier(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountIdentifier":
            suggest = "account_identifier"
        elif key == "orgIdentifier":
            suggest = "org_identifier"
        elif key == "projectIdentifier":
            suggest = "project_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2ImageRegistryIdentifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2ImageRegistryIdentifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2ImageRegistryIdentifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_identifier: Optional[_builtins.str] = None,
                 org_identifier: Optional[_builtins.str] = None,
                 project_identifier: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_identifier: Harness account identifier.
        :param _builtins.str org_identifier: Harness organization identifier.
        :param _builtins.str project_identifier: Harness project identifier.
        """
        if account_identifier is not None:
            pulumi.set(__self__, "account_identifier", account_identifier)
        if org_identifier is not None:
            pulumi.set(__self__, "org_identifier", org_identifier)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)

    @_builtins.property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> Optional[_builtins.str]:
        """
        Harness account identifier.
        """
        return pulumi.get(self, "account_identifier")

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> Optional[_builtins.str]:
        """
        Harness organization identifier.
        """
        return pulumi.get(self, "org_identifier")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[_builtins.str]:
        """
        Harness project identifier.
        """
        return pulumi.get(self, "project_identifier")


@pulumi.output_type
class InfrastructureV2Mtls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certPath":
            suggest = "cert_path"
        elif key == "keyPath":
            suggest = "key_path"
        elif key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2Mtls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2Mtls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2Mtls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_path: Optional[_builtins.str] = None,
                 key_path: Optional[_builtins.str] = None,
                 secret_name: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str cert_path: Path to the certificate file for mTLS
        :param _builtins.str key_path: Path to the private key file for mTLS
        :param _builtins.str secret_name: Name of the Kubernetes secret containing mTLS certificates
        :param _builtins.str url: URL for the mTLS endpoint
        """
        if cert_path is not None:
            pulumi.set(__self__, "cert_path", cert_path)
        if key_path is not None:
            pulumi.set(__self__, "key_path", key_path)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="certPath")
    def cert_path(self) -> Optional[_builtins.str]:
        """
        Path to the certificate file for mTLS
        """
        return pulumi.get(self, "cert_path")

    @_builtins.property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> Optional[_builtins.str]:
        """
        Path to the private key file for mTLS
        """
        return pulumi.get(self, "key_path")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        Name of the Kubernetes secret containing mTLS certificates
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        URL for the mTLS endpoint
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class InfrastructureV2Proxy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpProxy":
            suggest = "http_proxy"
        elif key == "httpsProxy":
            suggest = "https_proxy"
        elif key == "noProxy":
            suggest = "no_proxy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2Proxy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2Proxy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2Proxy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: _builtins.str,
                 http_proxy: Optional[_builtins.str] = None,
                 https_proxy: Optional[_builtins.str] = None,
                 no_proxy: Optional[_builtins.str] = None):
        """
        :param _builtins.str url: Proxy URL.
        :param _builtins.str http_proxy: HTTP proxy URL.
        :param _builtins.str https_proxy: HTTPS proxy URL.
        :param _builtins.str no_proxy: List of hosts that should not use proxy.
        """
        pulumi.set(__self__, "url", url)
        if http_proxy is not None:
            pulumi.set(__self__, "http_proxy", http_proxy)
        if https_proxy is not None:
            pulumi.set(__self__, "https_proxy", https_proxy)
        if no_proxy is not None:
            pulumi.set(__self__, "no_proxy", no_proxy)

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Proxy URL.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> Optional[_builtins.str]:
        """
        HTTP proxy URL.
        """
        return pulumi.get(self, "http_proxy")

    @_builtins.property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> Optional[_builtins.str]:
        """
        HTTPS proxy URL.
        """
        return pulumi.get(self, "https_proxy")

    @_builtins.property
    @pulumi.getter(name="noProxy")
    def no_proxy(self) -> Optional[_builtins.str]:
        """
        List of hosts that should not use proxy.
        """
        return pulumi.get(self, "no_proxy")


@pulumi.output_type
class InfrastructureV2Toleration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tolerationSeconds":
            suggest = "toleration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2Toleration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2Toleration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2Toleration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 operator: _builtins.str,
                 toleration_seconds: Optional[_builtins.int] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str effect: Effect indicates the taint effect to match. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
        :param _builtins.str key: Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists.
        :param _builtins.str operator: Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal.
        :param _builtins.int toleration_seconds: TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
        :param _builtins.str value: Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        if toleration_seconds is not None:
            pulumi.set(__self__, "toleration_seconds", toleration_seconds)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        Effect indicates the taint effect to match. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter(name="tolerationSeconds")
    def toleration_seconds(self) -> Optional[_builtins.int]:
        """
        TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
        """
        return pulumi.get(self, "toleration_seconds")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InfrastructureV2Volume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2Volume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2Volume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2Volume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 size_limit: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the volume. Must be a DNS_LABEL and unique within the pod.
        :param _builtins.str size_limit: Size limit of the volume. Example: '10Gi', '100Mi'
        """
        pulumi.set(__self__, "name", name)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the volume. Must be a DNS_LABEL and unique within the pod.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[_builtins.str]:
        """
        Size limit of the volume. Example: '10Gi', '100Mi'
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class InfrastructureV2VolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "mountPropagation":
            suggest = "mount_propagation"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "subPath":
            suggest = "sub_path"
        elif key == "subPathExpr":
            suggest = "sub_path_expr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureV2VolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureV2VolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureV2VolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str,
                 mount_propagation: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 sub_path: Optional[_builtins.str] = None,
                 sub_path_expr: Optional[_builtins.str] = None):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param _builtins.str name: This must match the Name of a Volume.
        :param _builtins.str mount_propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used.
        :param _builtins.bool read_only: Mounted read-only if true, read-write otherwise.
        :param _builtins.str sub_path: Path within the volume from which the container's volume should be mounted. Mutually exclusive with sub*path*expr.
        :param _builtins.str sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to sub*path but environment variable references $(VAR*NAME) are expanded using the container's environment. Mutually exclusive with sub_path.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        if mount_propagation is not None:
            pulumi.set(__self__, "mount_propagation", mount_propagation)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)
        if sub_path_expr is not None:
            pulumi.set(__self__, "sub_path_expr", sub_path_expr)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="mountPropagation")
    def mount_propagation(self) -> Optional[_builtins.str]:
        """
        Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used.
        """
        return pulumi.get(self, "mount_propagation")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        Mounted read-only if true, read-write otherwise.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[_builtins.str]:
        """
        Path within the volume from which the container's volume should be mounted. Mutually exclusive with sub*path*expr.
        """
        return pulumi.get(self, "sub_path")

    @_builtins.property
    @pulumi.getter(name="subPathExpr")
    def sub_path_expr(self) -> Optional[_builtins.str]:
        """
        Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to sub*path but environment variable references $(VAR*NAME) are expanded using the container's environment. Mutually exclusive with sub_path.
        """
        return pulumi.get(self, "sub_path_expr")


@pulumi.output_type
class SecurityGovernanceConditionFaultSpec(dict):
    def __init__(__self__, *,
                 faults: Sequence['outputs.SecurityGovernanceConditionFaultSpecFault'],
                 operator: _builtins.str):
        """
        :param Sequence['SecurityGovernanceConditionFaultSpecFaultArgs'] faults: List of fault specifications
        :param _builtins.str operator: Operator for comparing faults (EQUAL*TO or NOT*EQUAL_TO)
        """
        pulumi.set(__self__, "faults", faults)
        pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter
    def faults(self) -> Sequence['outputs.SecurityGovernanceConditionFaultSpecFault']:
        """
        List of fault specifications
        """
        return pulumi.get(self, "faults")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator for comparing faults (EQUAL*TO or NOT*EQUAL_TO)
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class SecurityGovernanceConditionFaultSpecFault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "faultType":
            suggest = "fault_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGovernanceConditionFaultSpecFault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGovernanceConditionFaultSpecFault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGovernanceConditionFaultSpecFault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fault_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str fault_type: Type of the fault (FAULT or FAULT_GROUP)
        :param _builtins.str name: Name of the fault
        """
        pulumi.set(__self__, "fault_type", fault_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="faultType")
    def fault_type(self) -> _builtins.str:
        """
        Type of the fault (FAULT or FAULT_GROUP)
        """
        return pulumi.get(self, "fault_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the fault
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SecurityGovernanceConditionK8sSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationSpec":
            suggest = "application_spec"
        elif key == "chaosServiceAccountSpec":
            suggest = "chaos_service_account_spec"
        elif key == "infraSpec":
            suggest = "infra_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGovernanceConditionK8sSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGovernanceConditionK8sSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGovernanceConditionK8sSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_spec: Optional['outputs.SecurityGovernanceConditionK8sSpecApplicationSpec'] = None,
                 chaos_service_account_spec: Optional['outputs.SecurityGovernanceConditionK8sSpecChaosServiceAccountSpec'] = None,
                 infra_spec: Optional['outputs.SecurityGovernanceConditionK8sSpecInfraSpec'] = None):
        """
        :param 'SecurityGovernanceConditionK8sSpecApplicationSpecArgs' application_spec: Application specification
        :param 'SecurityGovernanceConditionK8sSpecChaosServiceAccountSpecArgs' chaos_service_account_spec: Chaos service account specification
        :param 'SecurityGovernanceConditionK8sSpecInfraSpecArgs' infra_spec: Infrastructure specification
        """
        if application_spec is not None:
            pulumi.set(__self__, "application_spec", application_spec)
        if chaos_service_account_spec is not None:
            pulumi.set(__self__, "chaos_service_account_spec", chaos_service_account_spec)
        if infra_spec is not None:
            pulumi.set(__self__, "infra_spec", infra_spec)

    @_builtins.property
    @pulumi.getter(name="applicationSpec")
    def application_spec(self) -> Optional['outputs.SecurityGovernanceConditionK8sSpecApplicationSpec']:
        """
        Application specification
        """
        return pulumi.get(self, "application_spec")

    @_builtins.property
    @pulumi.getter(name="chaosServiceAccountSpec")
    def chaos_service_account_spec(self) -> Optional['outputs.SecurityGovernanceConditionK8sSpecChaosServiceAccountSpec']:
        """
        Chaos service account specification
        """
        return pulumi.get(self, "chaos_service_account_spec")

    @_builtins.property
    @pulumi.getter(name="infraSpec")
    def infra_spec(self) -> Optional['outputs.SecurityGovernanceConditionK8sSpecInfraSpec']:
        """
        Infrastructure specification
        """
        return pulumi.get(self, "infra_spec")


@pulumi.output_type
class SecurityGovernanceConditionK8sSpecApplicationSpec(dict):
    def __init__(__self__, *,
                 operator: _builtins.str,
                 workloads: Optional[Sequence['outputs.SecurityGovernanceConditionK8sSpecApplicationSpecWorkload']] = None):
        """
        :param _builtins.str operator: Operator for application matching (EQUAL*TO or NOT*EQUAL_TO)
        :param Sequence['SecurityGovernanceConditionK8sSpecApplicationSpecWorkloadArgs'] workloads: List of workloads to include/exclude
        """
        pulumi.set(__self__, "operator", operator)
        if workloads is not None:
            pulumi.set(__self__, "workloads", workloads)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator for application matching (EQUAL*TO or NOT*EQUAL_TO)
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def workloads(self) -> Optional[Sequence['outputs.SecurityGovernanceConditionK8sSpecApplicationSpecWorkload']]:
        """
        List of workloads to include/exclude
        """
        return pulumi.get(self, "workloads")


@pulumi.output_type
class SecurityGovernanceConditionK8sSpecApplicationSpecWorkload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationMapId":
            suggest = "application_map_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGovernanceConditionK8sSpecApplicationSpecWorkload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGovernanceConditionK8sSpecApplicationSpecWorkload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGovernanceConditionK8sSpecApplicationSpecWorkload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: _builtins.str,
                 application_map_id: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 label: Optional[_builtins.str] = None,
                 services: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str namespace: Namespace of the workload
        :param _builtins.str application_map_id: ID for the application map
        :param _builtins.str kind: Kind of the workload (e.g., deployment, statefulset)
        :param _builtins.str label: Label selector for the workload
        :param Sequence[_builtins.str] services: List of services associated with the workload
        """
        pulumi.set(__self__, "namespace", namespace)
        if application_map_id is not None:
            pulumi.set(__self__, "application_map_id", application_map_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Namespace of the workload
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="applicationMapId")
    def application_map_id(self) -> Optional[_builtins.str]:
        """
        ID for the application map
        """
        return pulumi.get(self, "application_map_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind of the workload (e.g., deployment, statefulset)
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Label selector for the workload
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of services associated with the workload
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class SecurityGovernanceConditionK8sSpecChaosServiceAccountSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccounts":
            suggest = "service_accounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGovernanceConditionK8sSpecChaosServiceAccountSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGovernanceConditionK8sSpecChaosServiceAccountSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGovernanceConditionK8sSpecChaosServiceAccountSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: _builtins.str,
                 service_accounts: Sequence[_builtins.str]):
        """
        :param _builtins.str operator: Operator for service account matching (EQUAL*TO or NOT*EQUAL_TO)
        :param Sequence[_builtins.str] service_accounts: List of service accounts to include/exclude
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "service_accounts", service_accounts)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator for service account matching (EQUAL*TO or NOT*EQUAL_TO)
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Sequence[_builtins.str]:
        """
        List of service accounts to include/exclude
        """
        return pulumi.get(self, "service_accounts")


@pulumi.output_type
class SecurityGovernanceConditionK8sSpecInfraSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infraIds":
            suggest = "infra_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGovernanceConditionK8sSpecInfraSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGovernanceConditionK8sSpecInfraSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGovernanceConditionK8sSpecInfraSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 infra_ids: Sequence[_builtins.str],
                 operator: _builtins.str):
        """
        :param Sequence[_builtins.str] infra_ids: List of infrastructure IDs to apply the condition to
        :param _builtins.str operator: Operator for comparing infrastructure IDs (EQUAL*TO or NOT*EQUAL_TO)
        """
        pulumi.set(__self__, "infra_ids", infra_ids)
        pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter(name="infraIds")
    def infra_ids(self) -> Sequence[_builtins.str]:
        """
        List of infrastructure IDs to apply the condition to
        """
        return pulumi.get(self, "infra_ids")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator for comparing infrastructure IDs (EQUAL*TO or NOT*EQUAL_TO)
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class SecurityGovernanceConditionMachineSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infraSpec":
            suggest = "infra_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGovernanceConditionMachineSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGovernanceConditionMachineSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGovernanceConditionMachineSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 infra_spec: Optional['outputs.SecurityGovernanceConditionMachineSpecInfraSpec'] = None):
        """
        :param 'SecurityGovernanceConditionMachineSpecInfraSpecArgs' infra_spec: Infrastructure specification
        """
        if infra_spec is not None:
            pulumi.set(__self__, "infra_spec", infra_spec)

    @_builtins.property
    @pulumi.getter(name="infraSpec")
    def infra_spec(self) -> Optional['outputs.SecurityGovernanceConditionMachineSpecInfraSpec']:
        """
        Infrastructure specification
        """
        return pulumi.get(self, "infra_spec")


@pulumi.output_type
class SecurityGovernanceConditionMachineSpecInfraSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infraIds":
            suggest = "infra_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGovernanceConditionMachineSpecInfraSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGovernanceConditionMachineSpecInfraSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGovernanceConditionMachineSpecInfraSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 infra_ids: Sequence[_builtins.str],
                 operator: _builtins.str):
        """
        :param Sequence[_builtins.str] infra_ids: List of infrastructure IDs to apply the condition to
        :param _builtins.str operator: Operator for comparing infrastructure IDs (EQUAL*TO or NOT*EQUAL_TO)
        """
        pulumi.set(__self__, "infra_ids", infra_ids)
        pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter(name="infraIds")
    def infra_ids(self) -> Sequence[_builtins.str]:
        """
        List of infrastructure IDs to apply the condition to
        """
        return pulumi.get(self, "infra_ids")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator for comparing infrastructure IDs (EQUAL*TO or NOT*EQUAL_TO)
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class SecurityGovernanceRuleTimeWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "endTime":
            suggest = "end_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGovernanceRuleTimeWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGovernanceRuleTimeWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGovernanceRuleTimeWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: _builtins.int,
                 time_zone: _builtins.str,
                 duration: Optional[_builtins.str] = None,
                 end_time: Optional[_builtins.int] = None,
                 recurrence: Optional['outputs.SecurityGovernanceRuleTimeWindowRecurrence'] = None):
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "time_zone", time_zone)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.int:
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> Optional['outputs.SecurityGovernanceRuleTimeWindowRecurrence']:
        return pulumi.get(self, "recurrence")


@pulumi.output_type
class SecurityGovernanceRuleTimeWindowRecurrence(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 until: _builtins.int,
                 value: Optional[_builtins.int] = None):
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "until", until)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def until(self) -> _builtins.int:
        return pulumi.get(self, "until")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetImageRegistryCustomImageResult(dict):
    def __init__(__self__, *,
                 ddcr: _builtins.str,
                 ddcr_fault: _builtins.str,
                 ddcr_lib: _builtins.str,
                 log_watcher: _builtins.str):
        pulumi.set(__self__, "ddcr", ddcr)
        pulumi.set(__self__, "ddcr_fault", ddcr_fault)
        pulumi.set(__self__, "ddcr_lib", ddcr_lib)
        pulumi.set(__self__, "log_watcher", log_watcher)

    @_builtins.property
    @pulumi.getter
    def ddcr(self) -> _builtins.str:
        return pulumi.get(self, "ddcr")

    @_builtins.property
    @pulumi.getter(name="ddcrFault")
    def ddcr_fault(self) -> _builtins.str:
        return pulumi.get(self, "ddcr_fault")

    @_builtins.property
    @pulumi.getter(name="ddcrLib")
    def ddcr_lib(self) -> _builtins.str:
        return pulumi.get(self, "ddcr_lib")

    @_builtins.property
    @pulumi.getter(name="logWatcher")
    def log_watcher(self) -> _builtins.str:
        return pulumi.get(self, "log_watcher")


@pulumi.output_type
class GetInfrastructureV2ImageRegistryResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 custom_images: Sequence['outputs.GetInfrastructureV2ImageRegistryCustomImageResult'],
                 identifiers: Sequence['outputs.GetInfrastructureV2ImageRegistryIdentifierResult'],
                 infra_id: _builtins.str,
                 is_default: _builtins.bool,
                 is_override_allowed: _builtins.bool,
                 is_private: _builtins.bool,
                 registry_account: _builtins.str,
                 registry_server: _builtins.str,
                 updated_at: _builtins.str,
                 use_custom_images: _builtins.bool,
                 secret_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str created_at: Timestamp when the registry was created.
        :param Sequence['GetInfrastructureV2ImageRegistryCustomImageArgs'] custom_images: Custom image configurations. Required when use*custom*images is true.
        :param Sequence['GetInfrastructureV2ImageRegistryIdentifierArgs'] identifiers: Scoped identifiers for the registry.
        :param _builtins.str infra_id: ID of the infrastructure.
        :param _builtins.bool is_default: Whether this is the default registry.
        :param _builtins.bool is_override_allowed: Whether override is allowed for this registry.
        :param _builtins.bool is_private: Whether the registry is private.
        :param _builtins.str registry_account: The account name for the container registry.
        :param _builtins.str registry_server: The container image registry server URL (e.g., docker.io, gcr.io).
        :param _builtins.str updated_at: Timestamp when the registry was last updated.
        :param _builtins.bool use_custom_images: Whether to use custom images instead of default ones.
        :param _builtins.str secret_name: Name of the Kubernetes secret containing registry credentials.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "custom_images", custom_images)
        pulumi.set(__self__, "identifiers", identifiers)
        pulumi.set(__self__, "infra_id", infra_id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "is_override_allowed", is_override_allowed)
        pulumi.set(__self__, "is_private", is_private)
        pulumi.set(__self__, "registry_account", registry_account)
        pulumi.set(__self__, "registry_server", registry_server)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "use_custom_images", use_custom_images)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Timestamp when the registry was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Sequence['outputs.GetInfrastructureV2ImageRegistryCustomImageResult']:
        """
        Custom image configurations. Required when use*custom*images is true.
        """
        return pulumi.get(self, "custom_images")

    @_builtins.property
    @pulumi.getter
    def identifiers(self) -> Sequence['outputs.GetInfrastructureV2ImageRegistryIdentifierResult']:
        """
        Scoped identifiers for the registry.
        """
        return pulumi.get(self, "identifiers")

    @_builtins.property
    @pulumi.getter(name="infraId")
    def infra_id(self) -> _builtins.str:
        """
        ID of the infrastructure.
        """
        return pulumi.get(self, "infra_id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether this is the default registry.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="isOverrideAllowed")
    def is_override_allowed(self) -> _builtins.bool:
        """
        Whether override is allowed for this registry.
        """
        return pulumi.get(self, "is_override_allowed")

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> _builtins.bool:
        """
        Whether the registry is private.
        """
        return pulumi.get(self, "is_private")

    @_builtins.property
    @pulumi.getter(name="registryAccount")
    def registry_account(self) -> _builtins.str:
        """
        The account name for the container registry.
        """
        return pulumi.get(self, "registry_account")

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> _builtins.str:
        """
        The container image registry server URL (e.g., docker.io, gcr.io).
        """
        return pulumi.get(self, "registry_server")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Timestamp when the registry was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="useCustomImages")
    def use_custom_images(self) -> _builtins.bool:
        """
        Whether to use custom images instead of default ones.
        """
        return pulumi.get(self, "use_custom_images")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        Name of the Kubernetes secret containing registry credentials.
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class GetInfrastructureV2ImageRegistryCustomImageResult(dict):
    def __init__(__self__, *,
                 ddcr: _builtins.str,
                 ddcr_fault: _builtins.str,
                 ddcr_lib: _builtins.str,
                 log_watcher: _builtins.str):
        """
        :param _builtins.str ddcr: Custom image for ddcr.
        :param _builtins.str ddcr_fault: Custom image for ddcr-fault.
        :param _builtins.str ddcr_lib: Custom image for ddcr-lib.
        :param _builtins.str log_watcher: Custom image for log-watcher.
        """
        pulumi.set(__self__, "ddcr", ddcr)
        pulumi.set(__self__, "ddcr_fault", ddcr_fault)
        pulumi.set(__self__, "ddcr_lib", ddcr_lib)
        pulumi.set(__self__, "log_watcher", log_watcher)

    @_builtins.property
    @pulumi.getter
    def ddcr(self) -> _builtins.str:
        """
        Custom image for ddcr.
        """
        return pulumi.get(self, "ddcr")

    @_builtins.property
    @pulumi.getter(name="ddcrFault")
    def ddcr_fault(self) -> _builtins.str:
        """
        Custom image for ddcr-fault.
        """
        return pulumi.get(self, "ddcr_fault")

    @_builtins.property
    @pulumi.getter(name="ddcrLib")
    def ddcr_lib(self) -> _builtins.str:
        """
        Custom image for ddcr-lib.
        """
        return pulumi.get(self, "ddcr_lib")

    @_builtins.property
    @pulumi.getter(name="logWatcher")
    def log_watcher(self) -> _builtins.str:
        """
        Custom image for log-watcher.
        """
        return pulumi.get(self, "log_watcher")


@pulumi.output_type
class GetInfrastructureV2ImageRegistryIdentifierResult(dict):
    def __init__(__self__, *,
                 account_identifier: _builtins.str,
                 org_identifier: _builtins.str,
                 project_identifier: _builtins.str):
        """
        :param _builtins.str account_identifier: Harness account identifier.
        :param _builtins.str org_identifier: Harness organization identifier.
        :param _builtins.str project_identifier: Harness project identifier.
        """
        pulumi.set(__self__, "account_identifier", account_identifier)
        pulumi.set(__self__, "org_identifier", org_identifier)
        pulumi.set(__self__, "project_identifier", project_identifier)

    @_builtins.property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> _builtins.str:
        """
        Harness account identifier.
        """
        return pulumi.get(self, "account_identifier")

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> _builtins.str:
        """
        Harness organization identifier.
        """
        return pulumi.get(self, "org_identifier")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> _builtins.str:
        """
        Harness project identifier.
        """
        return pulumi.get(self, "project_identifier")


@pulumi.output_type
class GetInfrastructureV2MtlsResult(dict):
    def __init__(__self__, *,
                 cert_path: Optional[_builtins.str] = None,
                 key_path: Optional[_builtins.str] = None,
                 secret_name: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str cert_path: Path to the certificate file for mTLS
        :param _builtins.str key_path: Path to the private key file for mTLS
        :param _builtins.str secret_name: Name of the Kubernetes secret containing mTLS certificates
        :param _builtins.str url: URL for the mTLS endpoint
        """
        if cert_path is not None:
            pulumi.set(__self__, "cert_path", cert_path)
        if key_path is not None:
            pulumi.set(__self__, "key_path", key_path)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="certPath")
    def cert_path(self) -> Optional[_builtins.str]:
        """
        Path to the certificate file for mTLS
        """
        return pulumi.get(self, "cert_path")

    @_builtins.property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> Optional[_builtins.str]:
        """
        Path to the private key file for mTLS
        """
        return pulumi.get(self, "key_path")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        Name of the Kubernetes secret containing mTLS certificates
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        URL for the mTLS endpoint
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetInfrastructureV2ProxyResult(dict):
    def __init__(__self__, *,
                 url: _builtins.str,
                 http_proxy: Optional[_builtins.str] = None,
                 https_proxy: Optional[_builtins.str] = None,
                 no_proxy: Optional[_builtins.str] = None):
        """
        :param _builtins.str url: Proxy URL.
        :param _builtins.str http_proxy: HTTP proxy URL.
        :param _builtins.str https_proxy: HTTPS proxy URL.
        :param _builtins.str no_proxy: List of hosts that should not use proxy.
        """
        pulumi.set(__self__, "url", url)
        if http_proxy is not None:
            pulumi.set(__self__, "http_proxy", http_proxy)
        if https_proxy is not None:
            pulumi.set(__self__, "https_proxy", https_proxy)
        if no_proxy is not None:
            pulumi.set(__self__, "no_proxy", no_proxy)

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Proxy URL.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> Optional[_builtins.str]:
        """
        HTTP proxy URL.
        """
        return pulumi.get(self, "http_proxy")

    @_builtins.property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> Optional[_builtins.str]:
        """
        HTTPS proxy URL.
        """
        return pulumi.get(self, "https_proxy")

    @_builtins.property
    @pulumi.getter(name="noProxy")
    def no_proxy(self) -> Optional[_builtins.str]:
        """
        List of hosts that should not use proxy.
        """
        return pulumi.get(self, "no_proxy")


@pulumi.output_type
class GetInfrastructureV2TolerationResult(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 operator: _builtins.str,
                 toleration_seconds: Optional[_builtins.int] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str effect: Effect indicates the taint effect to match. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
        :param _builtins.str key: Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists.
        :param _builtins.str operator: Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal.
        :param _builtins.int toleration_seconds: TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
        :param _builtins.str value: Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        if toleration_seconds is not None:
            pulumi.set(__self__, "toleration_seconds", toleration_seconds)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        Effect indicates the taint effect to match. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter(name="tolerationSeconds")
    def toleration_seconds(self) -> Optional[_builtins.int]:
        """
        TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
        """
        return pulumi.get(self, "toleration_seconds")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInfrastructureV2VolumeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 size_limit: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the volume. Must be a DNS_LABEL and unique within the pod.
        :param _builtins.str size_limit: Size limit of the volume. Example: '10Gi', '100Mi'
        """
        pulumi.set(__self__, "name", name)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the volume. Must be a DNS_LABEL and unique within the pod.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[_builtins.str]:
        """
        Size limit of the volume. Example: '10Gi', '100Mi'
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class GetInfrastructureV2VolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str,
                 mount_propagation: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 sub_path: Optional[_builtins.str] = None,
                 sub_path_expr: Optional[_builtins.str] = None):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param _builtins.str name: This must match the Name of a Volume.
        :param _builtins.str mount_propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used.
        :param _builtins.bool read_only: Mounted read-only if true, read-write otherwise.
        :param _builtins.str sub_path: Path within the volume from which the container's volume should be mounted. Mutually exclusive with sub*path*expr.
        :param _builtins.str sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to sub*path but environment variable references $(VAR*NAME) are expanded using the container's environment. Mutually exclusive with sub_path.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        if mount_propagation is not None:
            pulumi.set(__self__, "mount_propagation", mount_propagation)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)
        if sub_path_expr is not None:
            pulumi.set(__self__, "sub_path_expr", sub_path_expr)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="mountPropagation")
    def mount_propagation(self) -> Optional[_builtins.str]:
        """
        Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used.
        """
        return pulumi.get(self, "mount_propagation")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        Mounted read-only if true, read-write otherwise.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[_builtins.str]:
        """
        Path within the volume from which the container's volume should be mounted. Mutually exclusive with sub*path*expr.
        """
        return pulumi.get(self, "sub_path")

    @_builtins.property
    @pulumi.getter(name="subPathExpr")
    def sub_path_expr(self) -> Optional[_builtins.str]:
        """
        Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to sub*path but environment variable references $(VAR*NAME) are expanded using the container's environment. Mutually exclusive with sub_path.
        """
        return pulumi.get(self, "sub_path_expr")


@pulumi.output_type
class GetSecurityGovernanceConditionFaultSpecResult(dict):
    def __init__(__self__, *,
                 faults: Sequence['outputs.GetSecurityGovernanceConditionFaultSpecFaultResult'],
                 operator: _builtins.str):
        """
        :param Sequence['GetSecurityGovernanceConditionFaultSpecFaultArgs'] faults: List of fault specifications
        :param _builtins.str operator: Operator for the fault specification
        """
        pulumi.set(__self__, "faults", faults)
        pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter
    def faults(self) -> Sequence['outputs.GetSecurityGovernanceConditionFaultSpecFaultResult']:
        """
        List of fault specifications
        """
        return pulumi.get(self, "faults")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator for the fault specification
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class GetSecurityGovernanceConditionFaultSpecFaultResult(dict):
    def __init__(__self__, *,
                 fault_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str fault_type: Type of the fault
        :param _builtins.str name: Name of the fault
        """
        pulumi.set(__self__, "fault_type", fault_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="faultType")
    def fault_type(self) -> _builtins.str:
        """
        Type of the fault
        """
        return pulumi.get(self, "fault_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the fault
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSecurityGovernanceConditionK8sSpecResult(dict):
    def __init__(__self__, *,
                 infra_specs: Sequence['outputs.GetSecurityGovernanceConditionK8sSpecInfraSpecResult']):
        """
        :param Sequence['GetSecurityGovernanceConditionK8sSpecInfraSpecArgs'] infra_specs: Infrastructure specification
        """
        pulumi.set(__self__, "infra_specs", infra_specs)

    @_builtins.property
    @pulumi.getter(name="infraSpecs")
    def infra_specs(self) -> Sequence['outputs.GetSecurityGovernanceConditionK8sSpecInfraSpecResult']:
        """
        Infrastructure specification
        """
        return pulumi.get(self, "infra_specs")


@pulumi.output_type
class GetSecurityGovernanceConditionK8sSpecInfraSpecResult(dict):
    def __init__(__self__, *,
                 infra_ids: Sequence[_builtins.str],
                 operator: _builtins.str):
        """
        :param Sequence[_builtins.str] infra_ids: List of infrastructure IDs
        :param _builtins.str operator: Operator for comparing infrastructure IDs
        """
        pulumi.set(__self__, "infra_ids", infra_ids)
        pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter(name="infraIds")
    def infra_ids(self) -> Sequence[_builtins.str]:
        """
        List of infrastructure IDs
        """
        return pulumi.get(self, "infra_ids")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator for comparing infrastructure IDs
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class GetSecurityGovernanceConditionMachineSpecResult(dict):
    def __init__(__self__, *,
                 infra_specs: Sequence['outputs.GetSecurityGovernanceConditionMachineSpecInfraSpecResult']):
        """
        :param Sequence['GetSecurityGovernanceConditionMachineSpecInfraSpecArgs'] infra_specs: Infrastructure specification
        """
        pulumi.set(__self__, "infra_specs", infra_specs)

    @_builtins.property
    @pulumi.getter(name="infraSpecs")
    def infra_specs(self) -> Sequence['outputs.GetSecurityGovernanceConditionMachineSpecInfraSpecResult']:
        """
        Infrastructure specification
        """
        return pulumi.get(self, "infra_specs")


@pulumi.output_type
class GetSecurityGovernanceConditionMachineSpecInfraSpecResult(dict):
    def __init__(__self__, *,
                 infra_ids: Sequence[_builtins.str],
                 operator: _builtins.str):
        """
        :param Sequence[_builtins.str] infra_ids: List of infrastructure IDs
        :param _builtins.str operator: Operator for comparing infrastructure IDs
        """
        pulumi.set(__self__, "infra_ids", infra_ids)
        pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter(name="infraIds")
    def infra_ids(self) -> Sequence[_builtins.str]:
        """
        List of infrastructure IDs
        """
        return pulumi.get(self, "infra_ids")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator for comparing infrastructure IDs
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class GetSecurityGovernanceRuleTimeWindowResult(dict):
    def __init__(__self__, *,
                 duration: _builtins.str,
                 end_time: _builtins.int,
                 recurrences: Sequence['outputs.GetSecurityGovernanceRuleTimeWindowRecurrenceResult'],
                 start_time: _builtins.int,
                 time_zone: _builtins.str):
        """
        :param _builtins.str duration: Duration of the time window (e.g., '30m', '2h').
        :param _builtins.int end_time: End time of the time window in milliseconds since epoch.
        :param Sequence['GetSecurityGovernanceRuleTimeWindowRecurrenceArgs'] recurrences: Recurrence configuration for the time window.
        :param _builtins.int start_time: Start time of the time window in milliseconds since epoch.
        :param _builtins.str time_zone: Time zone for the time window.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "recurrences", recurrences)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Duration of the time window (e.g., '30m', '2h').
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.int:
        """
        End time of the time window in milliseconds since epoch.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def recurrences(self) -> Sequence['outputs.GetSecurityGovernanceRuleTimeWindowRecurrenceResult']:
        """
        Recurrence configuration for the time window.
        """
        return pulumi.get(self, "recurrences")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.int:
        """
        Start time of the time window in milliseconds since epoch.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        Time zone for the time window.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetSecurityGovernanceRuleTimeWindowRecurrenceResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 until: _builtins.int,
                 value: _builtins.int):
        """
        :param _builtins.str type: Type of recurrence (e.g., 'Daily', 'Weekly', 'Monthly').
        :param _builtins.int until: Unix timestamp in milliseconds until when the recurrence should continue.
        :param _builtins.int value: Recurrence value (e.g., interval for daily recurrence).
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "until", until)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of recurrence (e.g., 'Daily', 'Weekly', 'Monthly').
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def until(self) -> _builtins.int:
        """
        Unix timestamp in milliseconds until when the recurrence should continue.
        """
        return pulumi.get(self, "until")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        Recurrence value (e.g., interval for daily recurrence).
        """
        return pulumi.get(self, "value")


