# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RuleEnforcementArgs', 'RuleEnforcement']

@pulumi.input_type
class RuleEnforcementArgs:
    def __init__(__self__, *,
                 cloud_provider: pulumi.Input[_builtins.str],
                 execution_schedule: pulumi.Input[_builtins.str],
                 execution_timezone: pulumi.Input[_builtins.str],
                 target_accounts: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RuleEnforcement resource.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider for the rule enforcement. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[_builtins.str] execution_schedule: Execution schedule in cron format.
        :param pulumi.Input[_builtins.str] execution_timezone: Timezone for the execution schedule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_accounts: List of target account which can be either AWS Account Ids or Azure Subscription Ids or Gcp Project Ids.
        :param pulumi.Input[_builtins.str] description: Description for rule enforcement.
        :param pulumi.Input[_builtins.bool] is_dry_run: Indicates if the rule enforcement is a dry run. This by default is set to false.
        :param pulumi.Input[_builtins.bool] is_enabled: Indicates if the rule enforcement is enabled. This by default is set to true.
        :param pulumi.Input[_builtins.str] name: Name of the rule enforcement.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_ids: List of rule IDs. Either rule*ids or rule*set_ids should be provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_set_ids: List of rule set IDs. Either rule*ids or rule*set_ids should be provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_regions: List of target regions. For GCP it should be left empty but is required in case of AWS or Azure.
        """
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        pulumi.set(__self__, "execution_schedule", execution_schedule)
        pulumi.set(__self__, "execution_timezone", execution_timezone)
        pulumi.set(__self__, "target_accounts", target_accounts)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_dry_run is not None:
            pulumi.set(__self__, "is_dry_run", is_dry_run)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_ids is not None:
            pulumi.set(__self__, "rule_ids", rule_ids)
        if rule_set_ids is not None:
            pulumi.set(__self__, "rule_set_ids", rule_set_ids)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud provider for the rule enforcement. It should be either AWS, AZURE or GCP.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_provider", value)

    @_builtins.property
    @pulumi.getter(name="executionSchedule")
    def execution_schedule(self) -> pulumi.Input[_builtins.str]:
        """
        Execution schedule in cron format.
        """
        return pulumi.get(self, "execution_schedule")

    @execution_schedule.setter
    def execution_schedule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "execution_schedule", value)

    @_builtins.property
    @pulumi.getter(name="executionTimezone")
    def execution_timezone(self) -> pulumi.Input[_builtins.str]:
        """
        Timezone for the execution schedule.
        """
        return pulumi.get(self, "execution_timezone")

    @execution_timezone.setter
    def execution_timezone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "execution_timezone", value)

    @_builtins.property
    @pulumi.getter(name="targetAccounts")
    def target_accounts(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of target account which can be either AWS Account Ids or Azure Subscription Ids or Gcp Project Ids.
        """
        return pulumi.get(self, "target_accounts")

    @target_accounts.setter
    def target_accounts(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "target_accounts", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for rule enforcement.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the rule enforcement is a dry run. This by default is set to false.
        """
        return pulumi.get(self, "is_dry_run")

    @is_dry_run.setter
    def is_dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_dry_run", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the rule enforcement is enabled. This by default is set to true.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rule enforcement.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of rule IDs. Either rule*ids or rule*set_ids should be provided.
        """
        return pulumi.get(self, "rule_ids")

    @rule_ids.setter
    def rule_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rule_ids", value)

    @_builtins.property
    @pulumi.getter(name="ruleSetIds")
    def rule_set_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of rule set IDs. Either rule*ids or rule*set_ids should be provided.
        """
        return pulumi.get(self, "rule_set_ids")

    @rule_set_ids.setter
    def rule_set_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rule_set_ids", value)

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of target regions. For GCP it should be left empty but is required in case of AWS or Azure.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_regions", value)


@pulumi.input_type
class _RuleEnforcementState:
    def __init__(__self__, *,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_id: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RuleEnforcement resources.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider for the rule enforcement. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[_builtins.str] description: Description for rule enforcement.
        :param pulumi.Input[_builtins.str] enforcement_id: Id of the rule enforcement.
        :param pulumi.Input[_builtins.str] execution_schedule: Execution schedule in cron format.
        :param pulumi.Input[_builtins.str] execution_timezone: Timezone for the execution schedule.
        :param pulumi.Input[_builtins.bool] is_dry_run: Indicates if the rule enforcement is a dry run. This by default is set to false.
        :param pulumi.Input[_builtins.bool] is_enabled: Indicates if the rule enforcement is enabled. This by default is set to true.
        :param pulumi.Input[_builtins.str] name: Name of the rule enforcement.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_ids: List of rule IDs. Either rule*ids or rule*set_ids should be provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_set_ids: List of rule set IDs. Either rule*ids or rule*set_ids should be provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_accounts: List of target account which can be either AWS Account Ids or Azure Subscription Ids or Gcp Project Ids.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_regions: List of target regions. For GCP it should be left empty but is required in case of AWS or Azure.
        """
        if cloud_provider is not None:
            pulumi.set(__self__, "cloud_provider", cloud_provider)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforcement_id is not None:
            pulumi.set(__self__, "enforcement_id", enforcement_id)
        if execution_schedule is not None:
            pulumi.set(__self__, "execution_schedule", execution_schedule)
        if execution_timezone is not None:
            pulumi.set(__self__, "execution_timezone", execution_timezone)
        if is_dry_run is not None:
            pulumi.set(__self__, "is_dry_run", is_dry_run)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_ids is not None:
            pulumi.set(__self__, "rule_ids", rule_ids)
        if rule_set_ids is not None:
            pulumi.set(__self__, "rule_set_ids", rule_set_ids)
        if target_accounts is not None:
            pulumi.set(__self__, "target_accounts", target_accounts)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud provider for the rule enforcement. It should be either AWS, AZURE or GCP.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_provider", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for rule enforcement.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enforcementId")
    def enforcement_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the rule enforcement.
        """
        return pulumi.get(self, "enforcement_id")

    @enforcement_id.setter
    def enforcement_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforcement_id", value)

    @_builtins.property
    @pulumi.getter(name="executionSchedule")
    def execution_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execution schedule in cron format.
        """
        return pulumi.get(self, "execution_schedule")

    @execution_schedule.setter
    def execution_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_schedule", value)

    @_builtins.property
    @pulumi.getter(name="executionTimezone")
    def execution_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timezone for the execution schedule.
        """
        return pulumi.get(self, "execution_timezone")

    @execution_timezone.setter
    def execution_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_timezone", value)

    @_builtins.property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the rule enforcement is a dry run. This by default is set to false.
        """
        return pulumi.get(self, "is_dry_run")

    @is_dry_run.setter
    def is_dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_dry_run", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the rule enforcement is enabled. This by default is set to true.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rule enforcement.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of rule IDs. Either rule*ids or rule*set_ids should be provided.
        """
        return pulumi.get(self, "rule_ids")

    @rule_ids.setter
    def rule_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rule_ids", value)

    @_builtins.property
    @pulumi.getter(name="ruleSetIds")
    def rule_set_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of rule set IDs. Either rule*ids or rule*set_ids should be provided.
        """
        return pulumi.get(self, "rule_set_ids")

    @rule_set_ids.setter
    def rule_set_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rule_set_ids", value)

    @_builtins.property
    @pulumi.getter(name="targetAccounts")
    def target_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of target account which can be either AWS Account Ids or Azure Subscription Ids or Gcp Project Ids.
        """
        return pulumi.get(self, "target_accounts")

    @target_accounts.setter
    def target_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_accounts", value)

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of target regions. For GCP it should be left empty but is required in case of AWS or Azure.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_regions", value)


@pulumi.type_token("harness:governance/ruleEnforcement:RuleEnforcement")
class RuleEnforcement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for creating, updating, and managing rule enforcement.

        ## Import

        The `pulumi import` command can be used, for example:

        Import governance enforcement

        ```sh
        $ pulumi import harness:governance/ruleEnforcement:RuleEnforcement example <enforcement_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider for the rule enforcement. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[_builtins.str] description: Description for rule enforcement.
        :param pulumi.Input[_builtins.str] execution_schedule: Execution schedule in cron format.
        :param pulumi.Input[_builtins.str] execution_timezone: Timezone for the execution schedule.
        :param pulumi.Input[_builtins.bool] is_dry_run: Indicates if the rule enforcement is a dry run. This by default is set to false.
        :param pulumi.Input[_builtins.bool] is_enabled: Indicates if the rule enforcement is enabled. This by default is set to true.
        :param pulumi.Input[_builtins.str] name: Name of the rule enforcement.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_ids: List of rule IDs. Either rule*ids or rule*set_ids should be provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_set_ids: List of rule set IDs. Either rule*ids or rule*set_ids should be provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_accounts: List of target account which can be either AWS Account Ids or Azure Subscription Ids or Gcp Project Ids.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_regions: List of target regions. For GCP it should be left empty but is required in case of AWS or Azure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleEnforcementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating, updating, and managing rule enforcement.

        ## Import

        The `pulumi import` command can be used, for example:

        Import governance enforcement

        ```sh
        $ pulumi import harness:governance/ruleEnforcement:RuleEnforcement example <enforcement_id>
        ```

        :param str resource_name: The name of the resource.
        :param RuleEnforcementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleEnforcementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleEnforcementArgs.__new__(RuleEnforcementArgs)

            if cloud_provider is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_provider'")
            __props__.__dict__["cloud_provider"] = cloud_provider
            __props__.__dict__["description"] = description
            if execution_schedule is None and not opts.urn:
                raise TypeError("Missing required property 'execution_schedule'")
            __props__.__dict__["execution_schedule"] = execution_schedule
            if execution_timezone is None and not opts.urn:
                raise TypeError("Missing required property 'execution_timezone'")
            __props__.__dict__["execution_timezone"] = execution_timezone
            __props__.__dict__["is_dry_run"] = is_dry_run
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["rule_ids"] = rule_ids
            __props__.__dict__["rule_set_ids"] = rule_set_ids
            if target_accounts is None and not opts.urn:
                raise TypeError("Missing required property 'target_accounts'")
            __props__.__dict__["target_accounts"] = target_accounts
            __props__.__dict__["target_regions"] = target_regions
            __props__.__dict__["enforcement_id"] = None
        super(RuleEnforcement, __self__).__init__(
            'harness:governance/ruleEnforcement:RuleEnforcement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enforcement_id: Optional[pulumi.Input[_builtins.str]] = None,
            execution_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            execution_timezone: Optional[pulumi.Input[_builtins.str]] = None,
            is_dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rule_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'RuleEnforcement':
        """
        Get an existing RuleEnforcement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider for the rule enforcement. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[_builtins.str] description: Description for rule enforcement.
        :param pulumi.Input[_builtins.str] enforcement_id: Id of the rule enforcement.
        :param pulumi.Input[_builtins.str] execution_schedule: Execution schedule in cron format.
        :param pulumi.Input[_builtins.str] execution_timezone: Timezone for the execution schedule.
        :param pulumi.Input[_builtins.bool] is_dry_run: Indicates if the rule enforcement is a dry run. This by default is set to false.
        :param pulumi.Input[_builtins.bool] is_enabled: Indicates if the rule enforcement is enabled. This by default is set to true.
        :param pulumi.Input[_builtins.str] name: Name of the rule enforcement.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_ids: List of rule IDs. Either rule*ids or rule*set_ids should be provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rule_set_ids: List of rule set IDs. Either rule*ids or rule*set_ids should be provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_accounts: List of target account which can be either AWS Account Ids or Azure Subscription Ids or Gcp Project Ids.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_regions: List of target regions. For GCP it should be left empty but is required in case of AWS or Azure.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleEnforcementState.__new__(_RuleEnforcementState)

        __props__.__dict__["cloud_provider"] = cloud_provider
        __props__.__dict__["description"] = description
        __props__.__dict__["enforcement_id"] = enforcement_id
        __props__.__dict__["execution_schedule"] = execution_schedule
        __props__.__dict__["execution_timezone"] = execution_timezone
        __props__.__dict__["is_dry_run"] = is_dry_run
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["rule_ids"] = rule_ids
        __props__.__dict__["rule_set_ids"] = rule_set_ids
        __props__.__dict__["target_accounts"] = target_accounts
        __props__.__dict__["target_regions"] = target_regions
        return RuleEnforcement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud provider for the rule enforcement. It should be either AWS, AZURE or GCP.
        """
        return pulumi.get(self, "cloud_provider")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for rule enforcement.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enforcementId")
    def enforcement_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the rule enforcement.
        """
        return pulumi.get(self, "enforcement_id")

    @_builtins.property
    @pulumi.getter(name="executionSchedule")
    def execution_schedule(self) -> pulumi.Output[_builtins.str]:
        """
        Execution schedule in cron format.
        """
        return pulumi.get(self, "execution_schedule")

    @_builtins.property
    @pulumi.getter(name="executionTimezone")
    def execution_timezone(self) -> pulumi.Output[_builtins.str]:
        """
        Timezone for the execution schedule.
        """
        return pulumi.get(self, "execution_timezone")

    @_builtins.property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the rule enforcement is a dry run. This by default is set to false.
        """
        return pulumi.get(self, "is_dry_run")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the rule enforcement is enabled. This by default is set to true.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the rule enforcement.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of rule IDs. Either rule*ids or rule*set_ids should be provided.
        """
        return pulumi.get(self, "rule_ids")

    @_builtins.property
    @pulumi.getter(name="ruleSetIds")
    def rule_set_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of rule set IDs. Either rule*ids or rule*set_ids should be provided.
        """
        return pulumi.get(self, "rule_set_ids")

    @_builtins.property
    @pulumi.getter(name="targetAccounts")
    def target_accounts(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of target account which can be either AWS Account Ids or Azure Subscription Ids or Gcp Project Ids.
        """
        return pulumi.get(self, "target_accounts")

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of target regions. For GCP it should be left empty but is required in case of AWS or Azure.
        """
        return pulumi.get(self, "target_regions")

