# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorCustomSecretManagerArgs', 'ConnectorCustomSecretManager']

@pulumi.input_type
class ConnectorCustomSecretManagerArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 template_ref: pulumi.Input[_builtins.str],
                 version_label: pulumi.Input[_builtins.str],
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_secret_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_host: Optional[pulumi.Input[_builtins.str]] = None,
                 template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ConnectorCustomSecretManager resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] ssh_secret_ref: SSH secret reference for the custom secrets manager, required if 'on_delegate' is false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] target_host: Host where the custom secrets manager is located, required if 'on_delegate' is false.
        :param pulumi.Input[_builtins.str] working_directory: The working directory for operations, required if 'on_delegate' is false.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "template_ref", template_ref)
        pulumi.set(__self__, "version_label", version_label)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_delegate is not None:
            pulumi.set(__self__, "on_delegate", on_delegate)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if ssh_secret_ref is not None:
            pulumi.set(__self__, "ssh_secret_ref", ssh_secret_ref)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_host is not None:
            pulumi.set(__self__, "target_host", target_host)
        if template_inputs is not None:
            pulumi.set(__self__, "template_inputs", template_inputs)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="templateRef")
    def template_ref(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "template_ref")

    @template_ref.setter
    def template_ref(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template_ref", value)

    @_builtins.property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "version_label")

    @version_label.setter
    def version_label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version_label", value)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onDelegate")
    def on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "on_delegate")

    @on_delegate.setter
    def on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_delegate", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="sshSecretRef")
    def ssh_secret_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SSH secret reference for the custom secrets manager, required if 'on_delegate' is false.
        """
        return pulumi.get(self, "ssh_secret_ref")

    @ssh_secret_ref.setter
    def ssh_secret_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_secret_ref", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetHost")
    def target_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host where the custom secrets manager is located, required if 'on_delegate' is false.
        """
        return pulumi.get(self, "target_host")

    @target_host.setter
    def target_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_host", value)

    @_builtins.property
    @pulumi.getter(name="templateInputs")
    def template_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]]:
        return pulumi.get(self, "template_inputs")

    @template_inputs.setter
    def template_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]]):
        pulumi.set(self, "template_inputs", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The working directory for operations, required if 'on_delegate' is false.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.input_type
class _ConnectorCustomSecretManagerState:
    def __init__(__self__, *,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_secret_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_host: Optional[pulumi.Input[_builtins.str]] = None,
                 template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]] = None,
                 template_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version_label: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConnectorCustomSecretManager resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] ssh_secret_ref: SSH secret reference for the custom secrets manager, required if 'on_delegate' is false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] target_host: Host where the custom secrets manager is located, required if 'on_delegate' is false.
        :param pulumi.Input[_builtins.str] working_directory: The working directory for operations, required if 'on_delegate' is false.
        """
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_delegate is not None:
            pulumi.set(__self__, "on_delegate", on_delegate)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if ssh_secret_ref is not None:
            pulumi.set(__self__, "ssh_secret_ref", ssh_secret_ref)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_host is not None:
            pulumi.set(__self__, "target_host", target_host)
        if template_inputs is not None:
            pulumi.set(__self__, "template_inputs", template_inputs)
        if template_ref is not None:
            pulumi.set(__self__, "template_ref", template_ref)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version_label is not None:
            pulumi.set(__self__, "version_label", version_label)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onDelegate")
    def on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "on_delegate")

    @on_delegate.setter
    def on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_delegate", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="sshSecretRef")
    def ssh_secret_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SSH secret reference for the custom secrets manager, required if 'on_delegate' is false.
        """
        return pulumi.get(self, "ssh_secret_ref")

    @ssh_secret_ref.setter
    def ssh_secret_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_secret_ref", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetHost")
    def target_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host where the custom secrets manager is located, required if 'on_delegate' is false.
        """
        return pulumi.get(self, "target_host")

    @target_host.setter
    def target_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_host", value)

    @_builtins.property
    @pulumi.getter(name="templateInputs")
    def template_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]]:
        return pulumi.get(self, "template_inputs")

    @template_inputs.setter
    def template_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]]):
        pulumi.set(self, "template_inputs", value)

    @_builtins.property
    @pulumi.getter(name="templateRef")
    def template_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "template_ref")

    @template_ref.setter
    def template_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_ref", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "version_label")

    @version_label.setter
    def version_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_label", value)

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The working directory for operations, required if 'on_delegate' is false.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.type_token("harness:platform/connectorCustomSecretManager:ConnectorCustomSecretManager")
class ConnectorCustomSecretManager(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_secret_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_host: Optional[pulumi.Input[_builtins.str]] = None,
                 template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomSecretManagerTemplateInputArgs', 'ConnectorCustomSecretManagerTemplateInputArgsDict']]]]] = None,
                 template_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version_label: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating a Custom Secrets Manager (CSM) connector.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] ssh_secret_ref: SSH secret reference for the custom secrets manager, required if 'on_delegate' is false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] target_host: Host where the custom secrets manager is located, required if 'on_delegate' is false.
        :param pulumi.Input[_builtins.str] working_directory: The working directory for operations, required if 'on_delegate' is false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorCustomSecretManagerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Custom Secrets Manager (CSM) connector.

        :param str resource_name: The name of the resource.
        :param ConnectorCustomSecretManagerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorCustomSecretManagerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_secret_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_host: Optional[pulumi.Input[_builtins.str]] = None,
                 template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomSecretManagerTemplateInputArgs', 'ConnectorCustomSecretManagerTemplateInputArgsDict']]]]] = None,
                 template_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version_label: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorCustomSecretManagerArgs.__new__(ConnectorCustomSecretManagerArgs)

            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["description"] = description
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["on_delegate"] = on_delegate
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["ssh_secret_ref"] = ssh_secret_ref
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_host"] = target_host
            __props__.__dict__["template_inputs"] = template_inputs
            if template_ref is None and not opts.urn:
                raise TypeError("Missing required property 'template_ref'")
            __props__.__dict__["template_ref"] = template_ref
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["type"] = type
            if version_label is None and not opts.urn:
                raise TypeError("Missing required property 'version_label'")
            __props__.__dict__["version_label"] = version_label
            __props__.__dict__["working_directory"] = working_directory
        super(ConnectorCustomSecretManager, __self__).__init__(
            'harness:platform/connectorCustomSecretManager:ConnectorCustomSecretManager',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_secret_ref: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target_host: Optional[pulumi.Input[_builtins.str]] = None,
            template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomSecretManagerTemplateInputArgs', 'ConnectorCustomSecretManagerTemplateInputArgsDict']]]]] = None,
            template_ref: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            version_label: Optional[pulumi.Input[_builtins.str]] = None,
            working_directory: Optional[pulumi.Input[_builtins.str]] = None) -> 'ConnectorCustomSecretManager':
        """
        Get an existing ConnectorCustomSecretManager resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] ssh_secret_ref: SSH secret reference for the custom secrets manager, required if 'on_delegate' is false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] target_host: Host where the custom secrets manager is located, required if 'on_delegate' is false.
        :param pulumi.Input[_builtins.str] working_directory: The working directory for operations, required if 'on_delegate' is false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorCustomSecretManagerState.__new__(_ConnectorCustomSecretManagerState)

        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["description"] = description
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["on_delegate"] = on_delegate
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["ssh_secret_ref"] = ssh_secret_ref
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_host"] = target_host
        __props__.__dict__["template_inputs"] = template_inputs
        __props__.__dict__["template_ref"] = template_ref
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["type"] = type
        __props__.__dict__["version_label"] = version_label
        __props__.__dict__["working_directory"] = working_directory
        return ConnectorCustomSecretManager(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onDelegate")
    def on_delegate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "on_delegate")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="sshSecretRef")
    def ssh_secret_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SSH secret reference for the custom secrets manager, required if 'on_delegate' is false.
        """
        return pulumi.get(self, "ssh_secret_ref")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetHost")
    def target_host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Host where the custom secrets manager is located, required if 'on_delegate' is false.
        """
        return pulumi.get(self, "target_host")

    @_builtins.property
    @pulumi.getter(name="templateInputs")
    def template_inputs(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectorCustomSecretManagerTemplateInput']]]:
        return pulumi.get(self, "template_inputs")

    @_builtins.property
    @pulumi.getter(name="templateRef")
    def template_ref(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "template_ref")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "version_label")

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The working directory for operations, required if 'on_delegate' is false.
        """
        return pulumi.get(self, "working_directory")

