# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPipelineResult',
    'AwaitableGetPipelineResult',
    'get_pipeline',
    'get_pipeline_output',
]

@pulumi.output_type
class GetPipelineResult:
    """
    A collection of values returned by getPipeline.
    """
    def __init__(__self__, description=None, git_details=None, id=None, identifier=None, name=None, org_id=None, project_id=None, tags=None, template_applied=None, template_applied_pipeline_yaml=None, yaml=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if git_details and not isinstance(git_details, dict):
            raise TypeError("Expected argument 'git_details' to be a dict")
        pulumi.set(__self__, "git_details", git_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if template_applied and not isinstance(template_applied, bool):
            raise TypeError("Expected argument 'template_applied' to be a bool")
        pulumi.set(__self__, "template_applied", template_applied)
        if template_applied_pipeline_yaml and not isinstance(template_applied_pipeline_yaml, str):
            raise TypeError("Expected argument 'template_applied_pipeline_yaml' to be a str")
        pulumi.set(__self__, "template_applied_pipeline_yaml", template_applied_pipeline_yaml)
        if yaml and not isinstance(yaml, str):
            raise TypeError("Expected argument 'yaml' to be a str")
        pulumi.set(__self__, "yaml", yaml)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional['outputs.GetPipelineGitDetailsResult']:
        """
        Contains parameters related to creating an Entity for Git Experience.
        """
        return pulumi.get(self, "git_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> _builtins.str:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateApplied")
    def template_applied(self) -> _builtins.bool:
        """
        If true, returns Pipeline YAML with Templates applied on it.
        """
        return pulumi.get(self, "template_applied")

    @_builtins.property
    @pulumi.getter(name="templateAppliedPipelineYaml")
    def template_applied_pipeline_yaml(self) -> _builtins.str:
        """
        Pipeline YAML after resolving Templates (returned as a String).
        """
        return pulumi.get(self, "template_applied_pipeline_yaml")

    @_builtins.property
    @pulumi.getter
    def yaml(self) -> _builtins.str:
        """
        YAML of the pipeline.
        """
        return pulumi.get(self, "yaml")


class AwaitableGetPipelineResult(GetPipelineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineResult(
            description=self.description,
            git_details=self.git_details,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            tags=self.tags,
            template_applied=self.template_applied,
            template_applied_pipeline_yaml=self.template_applied_pipeline_yaml,
            yaml=self.yaml)


def get_pipeline(git_details: Optional[Union['GetPipelineGitDetailsArgs', 'GetPipelineGitDetailsArgsDict']] = None,
                 identifier: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 org_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineResult:
    """
    Data source for retrieving a Harness pipeline.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_pipeline(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param Union['GetPipelineGitDetailsArgs', 'GetPipelineGitDetailsArgsDict'] git_details: Contains parameters related to creating an Entity for Git Experience.
    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['gitDetails'] = git_details
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getPipeline:getPipeline', __args__, opts=opts, typ=GetPipelineResult).value

    return AwaitableGetPipelineResult(
        description=pulumi.get(__ret__, 'description'),
        git_details=pulumi.get(__ret__, 'git_details'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        template_applied=pulumi.get(__ret__, 'template_applied'),
        template_applied_pipeline_yaml=pulumi.get(__ret__, 'template_applied_pipeline_yaml'),
        yaml=pulumi.get(__ret__, 'yaml'))
def get_pipeline_output(git_details: Optional[pulumi.Input[Optional[Union['GetPipelineGitDetailsArgs', 'GetPipelineGitDetailsArgsDict']]]] = None,
                        identifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        org_id: Optional[pulumi.Input[_builtins.str]] = None,
                        project_id: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipelineResult]:
    """
    Data source for retrieving a Harness pipeline.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_pipeline(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param Union['GetPipelineGitDetailsArgs', 'GetPipelineGitDetailsArgsDict'] git_details: Contains parameters related to creating an Entity for Git Experience.
    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['gitDetails'] = git_details
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getPipeline:getPipeline', __args__, opts=opts, typ=GetPipelineResult)
    return __ret__.apply(lambda __response__: GetPipelineResult(
        description=pulumi.get(__response__, 'description'),
        git_details=pulumi.get(__response__, 'git_details'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags'),
        template_applied=pulumi.get(__response__, 'template_applied'),
        template_applied_pipeline_yaml=pulumi.get(__response__, 'template_applied_pipeline_yaml'),
        yaml=pulumi.get(__response__, 'yaml')))
