# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRepoRuleBranchResult',
    'AwaitableGetRepoRuleBranchResult',
    'get_repo_rule_branch',
    'get_repo_rule_branch_output',
]

@pulumi.output_type
class GetRepoRuleBranchResult:
    """
    A collection of values returned by getRepoRuleBranch.
    """
    def __init__(__self__, bypasses=None, created=None, created_by=None, description=None, id=None, identifier=None, org_id=None, patterns=None, policies=None, project_id=None, repo_identifier=None, state=None, updated=None, updated_by=None):
        if bypasses and not isinstance(bypasses, list):
            raise TypeError("Expected argument 'bypasses' to be a list")
        pulumi.set(__self__, "bypasses", bypasses)
        if created and not isinstance(created, int):
            raise TypeError("Expected argument 'created' to be a int")
        pulumi.set(__self__, "created", created)
        if created_by and not isinstance(created_by, int):
            raise TypeError("Expected argument 'created_by' to be a int")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if patterns and not isinstance(patterns, list):
            raise TypeError("Expected argument 'patterns' to be a list")
        pulumi.set(__self__, "patterns", patterns)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if repo_identifier and not isinstance(repo_identifier, str):
            raise TypeError("Expected argument 'repo_identifier' to be a str")
        pulumi.set(__self__, "repo_identifier", repo_identifier)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if updated and not isinstance(updated, int):
            raise TypeError("Expected argument 'updated' to be a int")
        pulumi.set(__self__, "updated", updated)
        if updated_by and not isinstance(updated_by, int):
            raise TypeError("Expected argument 'updated_by' to be a int")
        pulumi.set(__self__, "updated_by", updated_by)

    @_builtins.property
    @pulumi.getter
    def bypasses(self) -> Sequence['outputs.GetRepoRuleBranchBypassResult']:
        """
        List of users who can bypass this rule.
        """
        return pulumi.get(self, "bypasses")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.int:
        """
        Timestamp when the rule was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.int:
        """
        ID of the user who created the rule.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Identifier of the rule.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def patterns(self) -> Optional[Sequence['outputs.GetRepoRuleBranchPatternResult']]:
        """
        Pattern of branch to which rule will apply.
        """
        return pulumi.get(self, "patterns")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetRepoRuleBranchPolicyResult']:
        """
        Policies to be applied for this rule.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoIdentifier")
    def repo_identifier(self) -> _builtins.str:
        """
        Repo identifier of the repository.
        """
        return pulumi.get(self, "repo_identifier")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the rule (active, disable, monitor).
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> _builtins.int:
        """
        Timestamp when the rule was updated.
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.int:
        """
        ID of the user who updated the rule.
        """
        return pulumi.get(self, "updated_by")


class AwaitableGetRepoRuleBranchResult(GetRepoRuleBranchResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepoRuleBranchResult(
            bypasses=self.bypasses,
            created=self.created,
            created_by=self.created_by,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            org_id=self.org_id,
            patterns=self.patterns,
            policies=self.policies,
            project_id=self.project_id,
            repo_identifier=self.repo_identifier,
            state=self.state,
            updated=self.updated,
            updated_by=self.updated_by)


def get_repo_rule_branch(bypasses: Optional[Sequence[Union['GetRepoRuleBranchBypassArgs', 'GetRepoRuleBranchBypassArgsDict']]] = None,
                         description: Optional[_builtins.str] = None,
                         identifier: Optional[_builtins.str] = None,
                         org_id: Optional[_builtins.str] = None,
                         patterns: Optional[Sequence[Union['GetRepoRuleBranchPatternArgs', 'GetRepoRuleBranchPatternArgsDict']]] = None,
                         policies: Optional[Sequence[Union['GetRepoRuleBranchPolicyArgs', 'GetRepoRuleBranchPolicyArgsDict']]] = None,
                         project_id: Optional[_builtins.str] = None,
                         repo_identifier: Optional[_builtins.str] = None,
                         state: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepoRuleBranchResult:
    """
    Data source for retrieving a Harness repo branch rule.


    :param Sequence[Union['GetRepoRuleBranchBypassArgs', 'GetRepoRuleBranchBypassArgsDict']] bypasses: List of users who can bypass this rule.
    :param _builtins.str description: Description of the rule.
    :param _builtins.str identifier: Identifier of the rule.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param Sequence[Union['GetRepoRuleBranchPatternArgs', 'GetRepoRuleBranchPatternArgsDict']] patterns: Pattern of branch to which rule will apply.
    :param Sequence[Union['GetRepoRuleBranchPolicyArgs', 'GetRepoRuleBranchPolicyArgsDict']] policies: Policies to be applied for this rule.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str repo_identifier: Repo identifier of the repository.
    :param _builtins.str state: State of the rule (active, disable, monitor).
    """
    __args__ = dict()
    __args__['bypasses'] = bypasses
    __args__['description'] = description
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['patterns'] = patterns
    __args__['policies'] = policies
    __args__['projectId'] = project_id
    __args__['repoIdentifier'] = repo_identifier
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getRepoRuleBranch:getRepoRuleBranch', __args__, opts=opts, typ=GetRepoRuleBranchResult).value

    return AwaitableGetRepoRuleBranchResult(
        bypasses=pulumi.get(__ret__, 'bypasses'),
        created=pulumi.get(__ret__, 'created'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        org_id=pulumi.get(__ret__, 'org_id'),
        patterns=pulumi.get(__ret__, 'patterns'),
        policies=pulumi.get(__ret__, 'policies'),
        project_id=pulumi.get(__ret__, 'project_id'),
        repo_identifier=pulumi.get(__ret__, 'repo_identifier'),
        state=pulumi.get(__ret__, 'state'),
        updated=pulumi.get(__ret__, 'updated'),
        updated_by=pulumi.get(__ret__, 'updated_by'))
def get_repo_rule_branch_output(bypasses: Optional[pulumi.Input[Sequence[Union['GetRepoRuleBranchBypassArgs', 'GetRepoRuleBranchBypassArgsDict']]]] = None,
                                description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                identifier: Optional[pulumi.Input[_builtins.str]] = None,
                                org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                patterns: Optional[pulumi.Input[Optional[Sequence[Union['GetRepoRuleBranchPatternArgs', 'GetRepoRuleBranchPatternArgsDict']]]]] = None,
                                policies: Optional[pulumi.Input[Sequence[Union['GetRepoRuleBranchPolicyArgs', 'GetRepoRuleBranchPolicyArgsDict']]]] = None,
                                project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                repo_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                                state: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepoRuleBranchResult]:
    """
    Data source for retrieving a Harness repo branch rule.


    :param Sequence[Union['GetRepoRuleBranchBypassArgs', 'GetRepoRuleBranchBypassArgsDict']] bypasses: List of users who can bypass this rule.
    :param _builtins.str description: Description of the rule.
    :param _builtins.str identifier: Identifier of the rule.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param Sequence[Union['GetRepoRuleBranchPatternArgs', 'GetRepoRuleBranchPatternArgsDict']] patterns: Pattern of branch to which rule will apply.
    :param Sequence[Union['GetRepoRuleBranchPolicyArgs', 'GetRepoRuleBranchPolicyArgsDict']] policies: Policies to be applied for this rule.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str repo_identifier: Repo identifier of the repository.
    :param _builtins.str state: State of the rule (active, disable, monitor).
    """
    __args__ = dict()
    __args__['bypasses'] = bypasses
    __args__['description'] = description
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['patterns'] = patterns
    __args__['policies'] = policies
    __args__['projectId'] = project_id
    __args__['repoIdentifier'] = repo_identifier
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getRepoRuleBranch:getRepoRuleBranch', __args__, opts=opts, typ=GetRepoRuleBranchResult)
    return __ret__.apply(lambda __response__: GetRepoRuleBranchResult(
        bypasses=pulumi.get(__response__, 'bypasses'),
        created=pulumi.get(__response__, 'created'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        org_id=pulumi.get(__response__, 'org_id'),
        patterns=pulumi.get(__response__, 'patterns'),
        policies=pulumi.get(__response__, 'policies'),
        project_id=pulumi.get(__response__, 'project_id'),
        repo_identifier=pulumi.get(__response__, 'repo_identifier'),
        state=pulumi.get(__response__, 'state'),
        updated=pulumi.get(__response__, 'updated'),
        updated_by=pulumi.get(__response__, 'updated_by')))
