# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VaultConnectorArgs', 'VaultConnector']

@pulumi.input_type
class VaultConnectorArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 renewal_interval_minutes: pulumi.Input[_builtins.int],
                 vault_url: pulumi.Input[_builtins.str],
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 app_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 k8s_auth_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 renew_app_role_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 secret_engine_manually_configured: Optional[pulumi.Input[_builtins.bool]] = None,
                 secret_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_engine_version: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_token_path: Optional[pulumi.Input[_builtins.str]] = None,
                 sink_path: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_aws_iam: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_jwt_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_k8s_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_vault_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 vault_aws_iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_jwt_auth_path: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_jwt_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_k8s_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
                 xvault_aws_iam_server_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VaultConnector resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.int] renewal_interval_minutes: The time interval for the token renewal.
        :param pulumi.Input[_builtins.str] vault_url: URL of the HashiCorp Vault.
        :param pulumi.Input[_builtins.str] access_type: Access type.
        :param pulumi.Input[_builtins.str] app_role_id: ID of App Role.
        :param pulumi.Input[_builtins.str] auth_token: Authentication token for Vault.
        :param pulumi.Input[_builtins.str] aws_region: AWS region where the AWS IAM authentication will happen.
        :param pulumi.Input[_builtins.str] base_path: Location of the Vault directory where the secret will be stored.
        :param pulumi.Input[_builtins.bool] default: Is default or not.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: List of Delegate Selectors that belong to the same Delegate and are used to connect to the Secret Manager.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[_builtins.bool] is_default: Is default or not.
        :param pulumi.Input[_builtins.bool] is_read_only: Read only or not.
        :param pulumi.Input[_builtins.str] k8s_auth_endpoint: The path where Kubernetes Auth is enabled in Vault.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] namespace: Vault namespace where the Secret will be created.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.bool] read_only: Read only.
        :param pulumi.Input[_builtins.bool] renew_app_role_token: Boolean value to indicate if AppRole token renewal is enabled or not.
        :param pulumi.Input[_builtins.bool] secret_engine_manually_configured: Manually entered Secret Engine.
        :param pulumi.Input[_builtins.str] secret_engine_name: Name of the Secret Engine.
        :param pulumi.Input[_builtins.int] secret_engine_version: Version of Secret Engine.
        :param pulumi.Input[_builtins.str] secret_id: ID of the Secret.
        :param pulumi.Input[_builtins.str] service_account_token_path: The Service Account token path in the K8s pod where the token is mounted.
        :param pulumi.Input[_builtins.str] sink_path: The location from which the authentication token should be read.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.bool] use_aws_iam: Boolean value to indicate if AWS IAM is used for authentication.
        :param pulumi.Input[_builtins.bool] use_jwt_auth: Boolean value to indicate if JWT is used for authentication.
        :param pulumi.Input[_builtins.bool] use_k8s_auth: Boolean value to indicate if K8s Auth is used for authentication.
        :param pulumi.Input[_builtins.bool] use_vault_agent: Boolean value to indicate if Vault Agent is used for authentication.
        :param pulumi.Input[_builtins.str] vault_aws_iam_role: The Vault role defined to bind to aws iam account/role being accessed.
        :param pulumi.Input[_builtins.str] vault_jwt_auth_path: Custom path at with JWT auth in enabled for Vault
        :param pulumi.Input[_builtins.str] vault_jwt_auth_role: The Vault role defined with JWT auth type for accessing Vault as per policies binded.
        :param pulumi.Input[_builtins.str] vault_k8s_auth_role: The role where K8s Auth will happen.
        :param pulumi.Input[_builtins.str] xvault_aws_iam_server_id: The AWS IAM Header Server ID that has been configured for this AWS IAM instance.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "renewal_interval_minutes", renewal_interval_minutes)
        pulumi.set(__self__, "vault_url", vault_url)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if app_role_id is not None:
            pulumi.set(__self__, "app_role_id", app_role_id)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if k8s_auth_endpoint is not None:
            pulumi.set(__self__, "k8s_auth_endpoint", k8s_auth_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if renew_app_role_token is not None:
            pulumi.set(__self__, "renew_app_role_token", renew_app_role_token)
        if secret_engine_manually_configured is not None:
            pulumi.set(__self__, "secret_engine_manually_configured", secret_engine_manually_configured)
        if secret_engine_name is not None:
            pulumi.set(__self__, "secret_engine_name", secret_engine_name)
        if secret_engine_version is not None:
            pulumi.set(__self__, "secret_engine_version", secret_engine_version)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if service_account_token_path is not None:
            pulumi.set(__self__, "service_account_token_path", service_account_token_path)
        if sink_path is not None:
            pulumi.set(__self__, "sink_path", sink_path)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_aws_iam is not None:
            pulumi.set(__self__, "use_aws_iam", use_aws_iam)
        if use_jwt_auth is not None:
            pulumi.set(__self__, "use_jwt_auth", use_jwt_auth)
        if use_k8s_auth is not None:
            pulumi.set(__self__, "use_k8s_auth", use_k8s_auth)
        if use_vault_agent is not None:
            pulumi.set(__self__, "use_vault_agent", use_vault_agent)
        if vault_aws_iam_role is not None:
            pulumi.set(__self__, "vault_aws_iam_role", vault_aws_iam_role)
        if vault_jwt_auth_path is not None:
            pulumi.set(__self__, "vault_jwt_auth_path", vault_jwt_auth_path)
        if vault_jwt_auth_role is not None:
            pulumi.set(__self__, "vault_jwt_auth_role", vault_jwt_auth_role)
        if vault_k8s_auth_role is not None:
            pulumi.set(__self__, "vault_k8s_auth_role", vault_k8s_auth_role)
        if xvault_aws_iam_server_id is not None:
            pulumi.set(__self__, "xvault_aws_iam_server_id", xvault_aws_iam_server_id)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="renewalIntervalMinutes")
    def renewal_interval_minutes(self) -> pulumi.Input[_builtins.int]:
        """
        The time interval for the token renewal.
        """
        return pulumi.get(self, "renewal_interval_minutes")

    @renewal_interval_minutes.setter
    def renewal_interval_minutes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "renewal_interval_minutes", value)

    @_builtins.property
    @pulumi.getter(name="vaultUrl")
    def vault_url(self) -> pulumi.Input[_builtins.str]:
        """
        URL of the HashiCorp Vault.
        """
        return pulumi.get(self, "vault_url")

    @vault_url.setter
    def vault_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_url", value)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access type.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="appRoleId")
    def app_role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of App Role.
        """
        return pulumi.get(self, "app_role_id")

    @app_role_id.setter
    def app_role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_role_id", value)

    @_builtins.property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication token for Vault.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_token", value)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region where the AWS IAM authentication will happen.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @_builtins.property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location of the Vault directory where the secret will be stored.
        """
        return pulumi.get(self, "base_path")

    @base_path.setter
    def base_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_path", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is default or not.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Delegate Selectors that belong to the same Delegate and are used to connect to the Secret Manager.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is default or not.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Read only or not.
        """
        return pulumi.get(self, "is_read_only")

    @is_read_only.setter
    def is_read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_read_only", value)

    @_builtins.property
    @pulumi.getter(name="k8sAuthEndpoint")
    def k8s_auth_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where Kubernetes Auth is enabled in Vault.
        """
        return pulumi.get(self, "k8s_auth_endpoint")

    @k8s_auth_endpoint.setter
    def k8s_auth_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "k8s_auth_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vault namespace where the Secret will be created.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Read only.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @_builtins.property
    @pulumi.getter(name="renewAppRoleToken")
    def renew_app_role_token(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if AppRole token renewal is enabled or not.
        """
        return pulumi.get(self, "renew_app_role_token")

    @renew_app_role_token.setter
    def renew_app_role_token(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renew_app_role_token", value)

    @_builtins.property
    @pulumi.getter(name="secretEngineManuallyConfigured")
    def secret_engine_manually_configured(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Manually entered Secret Engine.
        """
        return pulumi.get(self, "secret_engine_manually_configured")

    @secret_engine_manually_configured.setter
    def secret_engine_manually_configured(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secret_engine_manually_configured", value)

    @_builtins.property
    @pulumi.getter(name="secretEngineName")
    def secret_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Secret Engine.
        """
        return pulumi.get(self, "secret_engine_name")

    @secret_engine_name.setter
    def secret_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="secretEngineVersion")
    def secret_engine_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version of Secret Engine.
        """
        return pulumi.get(self, "secret_engine_version")

    @secret_engine_version.setter
    def secret_engine_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secret_engine_version", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Secret.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountTokenPath")
    def service_account_token_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Service Account token path in the K8s pod where the token is mounted.
        """
        return pulumi.get(self, "service_account_token_path")

    @service_account_token_path.setter
    def service_account_token_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_token_path", value)

    @_builtins.property
    @pulumi.getter(name="sinkPath")
    def sink_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location from which the authentication token should be read.
        """
        return pulumi.get(self, "sink_path")

    @sink_path.setter
    def sink_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sink_path", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="useAwsIam")
    def use_aws_iam(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if AWS IAM is used for authentication.
        """
        return pulumi.get(self, "use_aws_iam")

    @use_aws_iam.setter
    def use_aws_iam(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_aws_iam", value)

    @_builtins.property
    @pulumi.getter(name="useJwtAuth")
    def use_jwt_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if JWT is used for authentication.
        """
        return pulumi.get(self, "use_jwt_auth")

    @use_jwt_auth.setter
    def use_jwt_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_jwt_auth", value)

    @_builtins.property
    @pulumi.getter(name="useK8sAuth")
    def use_k8s_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if K8s Auth is used for authentication.
        """
        return pulumi.get(self, "use_k8s_auth")

    @use_k8s_auth.setter
    def use_k8s_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_k8s_auth", value)

    @_builtins.property
    @pulumi.getter(name="useVaultAgent")
    def use_vault_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if Vault Agent is used for authentication.
        """
        return pulumi.get(self, "use_vault_agent")

    @use_vault_agent.setter
    def use_vault_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_vault_agent", value)

    @_builtins.property
    @pulumi.getter(name="vaultAwsIamRole")
    def vault_aws_iam_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Vault role defined to bind to aws iam account/role being accessed.
        """
        return pulumi.get(self, "vault_aws_iam_role")

    @vault_aws_iam_role.setter
    def vault_aws_iam_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_aws_iam_role", value)

    @_builtins.property
    @pulumi.getter(name="vaultJwtAuthPath")
    def vault_jwt_auth_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom path at with JWT auth in enabled for Vault
        """
        return pulumi.get(self, "vault_jwt_auth_path")

    @vault_jwt_auth_path.setter
    def vault_jwt_auth_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_jwt_auth_path", value)

    @_builtins.property
    @pulumi.getter(name="vaultJwtAuthRole")
    def vault_jwt_auth_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Vault role defined with JWT auth type for accessing Vault as per policies binded.
        """
        return pulumi.get(self, "vault_jwt_auth_role")

    @vault_jwt_auth_role.setter
    def vault_jwt_auth_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_jwt_auth_role", value)

    @_builtins.property
    @pulumi.getter(name="vaultK8sAuthRole")
    def vault_k8s_auth_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role where K8s Auth will happen.
        """
        return pulumi.get(self, "vault_k8s_auth_role")

    @vault_k8s_auth_role.setter
    def vault_k8s_auth_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_k8s_auth_role", value)

    @_builtins.property
    @pulumi.getter(name="xvaultAwsIamServerId")
    def xvault_aws_iam_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS IAM Header Server ID that has been configured for this AWS IAM instance.
        """
        return pulumi.get(self, "xvault_aws_iam_server_id")

    @xvault_aws_iam_server_id.setter
    def xvault_aws_iam_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xvault_aws_iam_server_id", value)


@pulumi.input_type
class _VaultConnectorState:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 app_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 k8s_auth_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 renew_app_role_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 renewal_interval_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_engine_manually_configured: Optional[pulumi.Input[_builtins.bool]] = None,
                 secret_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_engine_version: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_token_path: Optional[pulumi.Input[_builtins.str]] = None,
                 sink_path: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_aws_iam: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_jwt_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_k8s_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_vault_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 vault_aws_iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_jwt_auth_path: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_jwt_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_k8s_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_url: Optional[pulumi.Input[_builtins.str]] = None,
                 xvault_aws_iam_server_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VaultConnector resources.
        :param pulumi.Input[_builtins.str] access_type: Access type.
        :param pulumi.Input[_builtins.str] app_role_id: ID of App Role.
        :param pulumi.Input[_builtins.str] auth_token: Authentication token for Vault.
        :param pulumi.Input[_builtins.str] aws_region: AWS region where the AWS IAM authentication will happen.
        :param pulumi.Input[_builtins.str] base_path: Location of the Vault directory where the secret will be stored.
        :param pulumi.Input[_builtins.bool] default: Is default or not.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: List of Delegate Selectors that belong to the same Delegate and are used to connect to the Secret Manager.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.bool] is_default: Is default or not.
        :param pulumi.Input[_builtins.bool] is_read_only: Read only or not.
        :param pulumi.Input[_builtins.str] k8s_auth_endpoint: The path where Kubernetes Auth is enabled in Vault.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] namespace: Vault namespace where the Secret will be created.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.bool] read_only: Read only.
        :param pulumi.Input[_builtins.bool] renew_app_role_token: Boolean value to indicate if AppRole token renewal is enabled or not.
        :param pulumi.Input[_builtins.int] renewal_interval_minutes: The time interval for the token renewal.
        :param pulumi.Input[_builtins.bool] secret_engine_manually_configured: Manually entered Secret Engine.
        :param pulumi.Input[_builtins.str] secret_engine_name: Name of the Secret Engine.
        :param pulumi.Input[_builtins.int] secret_engine_version: Version of Secret Engine.
        :param pulumi.Input[_builtins.str] secret_id: ID of the Secret.
        :param pulumi.Input[_builtins.str] service_account_token_path: The Service Account token path in the K8s pod where the token is mounted.
        :param pulumi.Input[_builtins.str] sink_path: The location from which the authentication token should be read.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.bool] use_aws_iam: Boolean value to indicate if AWS IAM is used for authentication.
        :param pulumi.Input[_builtins.bool] use_jwt_auth: Boolean value to indicate if JWT is used for authentication.
        :param pulumi.Input[_builtins.bool] use_k8s_auth: Boolean value to indicate if K8s Auth is used for authentication.
        :param pulumi.Input[_builtins.bool] use_vault_agent: Boolean value to indicate if Vault Agent is used for authentication.
        :param pulumi.Input[_builtins.str] vault_aws_iam_role: The Vault role defined to bind to aws iam account/role being accessed.
        :param pulumi.Input[_builtins.str] vault_jwt_auth_path: Custom path at with JWT auth in enabled for Vault
        :param pulumi.Input[_builtins.str] vault_jwt_auth_role: The Vault role defined with JWT auth type for accessing Vault as per policies binded.
        :param pulumi.Input[_builtins.str] vault_k8s_auth_role: The role where K8s Auth will happen.
        :param pulumi.Input[_builtins.str] vault_url: URL of the HashiCorp Vault.
        :param pulumi.Input[_builtins.str] xvault_aws_iam_server_id: The AWS IAM Header Server ID that has been configured for this AWS IAM instance.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if app_role_id is not None:
            pulumi.set(__self__, "app_role_id", app_role_id)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if k8s_auth_endpoint is not None:
            pulumi.set(__self__, "k8s_auth_endpoint", k8s_auth_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if renew_app_role_token is not None:
            pulumi.set(__self__, "renew_app_role_token", renew_app_role_token)
        if renewal_interval_minutes is not None:
            pulumi.set(__self__, "renewal_interval_minutes", renewal_interval_minutes)
        if secret_engine_manually_configured is not None:
            pulumi.set(__self__, "secret_engine_manually_configured", secret_engine_manually_configured)
        if secret_engine_name is not None:
            pulumi.set(__self__, "secret_engine_name", secret_engine_name)
        if secret_engine_version is not None:
            pulumi.set(__self__, "secret_engine_version", secret_engine_version)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if service_account_token_path is not None:
            pulumi.set(__self__, "service_account_token_path", service_account_token_path)
        if sink_path is not None:
            pulumi.set(__self__, "sink_path", sink_path)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_aws_iam is not None:
            pulumi.set(__self__, "use_aws_iam", use_aws_iam)
        if use_jwt_auth is not None:
            pulumi.set(__self__, "use_jwt_auth", use_jwt_auth)
        if use_k8s_auth is not None:
            pulumi.set(__self__, "use_k8s_auth", use_k8s_auth)
        if use_vault_agent is not None:
            pulumi.set(__self__, "use_vault_agent", use_vault_agent)
        if vault_aws_iam_role is not None:
            pulumi.set(__self__, "vault_aws_iam_role", vault_aws_iam_role)
        if vault_jwt_auth_path is not None:
            pulumi.set(__self__, "vault_jwt_auth_path", vault_jwt_auth_path)
        if vault_jwt_auth_role is not None:
            pulumi.set(__self__, "vault_jwt_auth_role", vault_jwt_auth_role)
        if vault_k8s_auth_role is not None:
            pulumi.set(__self__, "vault_k8s_auth_role", vault_k8s_auth_role)
        if vault_url is not None:
            pulumi.set(__self__, "vault_url", vault_url)
        if xvault_aws_iam_server_id is not None:
            pulumi.set(__self__, "xvault_aws_iam_server_id", xvault_aws_iam_server_id)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access type.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="appRoleId")
    def app_role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of App Role.
        """
        return pulumi.get(self, "app_role_id")

    @app_role_id.setter
    def app_role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_role_id", value)

    @_builtins.property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication token for Vault.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_token", value)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region where the AWS IAM authentication will happen.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @_builtins.property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location of the Vault directory where the secret will be stored.
        """
        return pulumi.get(self, "base_path")

    @base_path.setter
    def base_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_path", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is default or not.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Delegate Selectors that belong to the same Delegate and are used to connect to the Secret Manager.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is default or not.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Read only or not.
        """
        return pulumi.get(self, "is_read_only")

    @is_read_only.setter
    def is_read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_read_only", value)

    @_builtins.property
    @pulumi.getter(name="k8sAuthEndpoint")
    def k8s_auth_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where Kubernetes Auth is enabled in Vault.
        """
        return pulumi.get(self, "k8s_auth_endpoint")

    @k8s_auth_endpoint.setter
    def k8s_auth_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "k8s_auth_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vault namespace where the Secret will be created.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Read only.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @_builtins.property
    @pulumi.getter(name="renewAppRoleToken")
    def renew_app_role_token(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if AppRole token renewal is enabled or not.
        """
        return pulumi.get(self, "renew_app_role_token")

    @renew_app_role_token.setter
    def renew_app_role_token(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renew_app_role_token", value)

    @_builtins.property
    @pulumi.getter(name="renewalIntervalMinutes")
    def renewal_interval_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time interval for the token renewal.
        """
        return pulumi.get(self, "renewal_interval_minutes")

    @renewal_interval_minutes.setter
    def renewal_interval_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renewal_interval_minutes", value)

    @_builtins.property
    @pulumi.getter(name="secretEngineManuallyConfigured")
    def secret_engine_manually_configured(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Manually entered Secret Engine.
        """
        return pulumi.get(self, "secret_engine_manually_configured")

    @secret_engine_manually_configured.setter
    def secret_engine_manually_configured(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secret_engine_manually_configured", value)

    @_builtins.property
    @pulumi.getter(name="secretEngineName")
    def secret_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Secret Engine.
        """
        return pulumi.get(self, "secret_engine_name")

    @secret_engine_name.setter
    def secret_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="secretEngineVersion")
    def secret_engine_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version of Secret Engine.
        """
        return pulumi.get(self, "secret_engine_version")

    @secret_engine_version.setter
    def secret_engine_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secret_engine_version", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Secret.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountTokenPath")
    def service_account_token_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Service Account token path in the K8s pod where the token is mounted.
        """
        return pulumi.get(self, "service_account_token_path")

    @service_account_token_path.setter
    def service_account_token_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_token_path", value)

    @_builtins.property
    @pulumi.getter(name="sinkPath")
    def sink_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location from which the authentication token should be read.
        """
        return pulumi.get(self, "sink_path")

    @sink_path.setter
    def sink_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sink_path", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="useAwsIam")
    def use_aws_iam(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if AWS IAM is used for authentication.
        """
        return pulumi.get(self, "use_aws_iam")

    @use_aws_iam.setter
    def use_aws_iam(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_aws_iam", value)

    @_builtins.property
    @pulumi.getter(name="useJwtAuth")
    def use_jwt_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if JWT is used for authentication.
        """
        return pulumi.get(self, "use_jwt_auth")

    @use_jwt_auth.setter
    def use_jwt_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_jwt_auth", value)

    @_builtins.property
    @pulumi.getter(name="useK8sAuth")
    def use_k8s_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if K8s Auth is used for authentication.
        """
        return pulumi.get(self, "use_k8s_auth")

    @use_k8s_auth.setter
    def use_k8s_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_k8s_auth", value)

    @_builtins.property
    @pulumi.getter(name="useVaultAgent")
    def use_vault_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if Vault Agent is used for authentication.
        """
        return pulumi.get(self, "use_vault_agent")

    @use_vault_agent.setter
    def use_vault_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_vault_agent", value)

    @_builtins.property
    @pulumi.getter(name="vaultAwsIamRole")
    def vault_aws_iam_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Vault role defined to bind to aws iam account/role being accessed.
        """
        return pulumi.get(self, "vault_aws_iam_role")

    @vault_aws_iam_role.setter
    def vault_aws_iam_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_aws_iam_role", value)

    @_builtins.property
    @pulumi.getter(name="vaultJwtAuthPath")
    def vault_jwt_auth_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom path at with JWT auth in enabled for Vault
        """
        return pulumi.get(self, "vault_jwt_auth_path")

    @vault_jwt_auth_path.setter
    def vault_jwt_auth_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_jwt_auth_path", value)

    @_builtins.property
    @pulumi.getter(name="vaultJwtAuthRole")
    def vault_jwt_auth_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Vault role defined with JWT auth type for accessing Vault as per policies binded.
        """
        return pulumi.get(self, "vault_jwt_auth_role")

    @vault_jwt_auth_role.setter
    def vault_jwt_auth_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_jwt_auth_role", value)

    @_builtins.property
    @pulumi.getter(name="vaultK8sAuthRole")
    def vault_k8s_auth_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role where K8s Auth will happen.
        """
        return pulumi.get(self, "vault_k8s_auth_role")

    @vault_k8s_auth_role.setter
    def vault_k8s_auth_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_k8s_auth_role", value)

    @_builtins.property
    @pulumi.getter(name="vaultUrl")
    def vault_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the HashiCorp Vault.
        """
        return pulumi.get(self, "vault_url")

    @vault_url.setter
    def vault_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_url", value)

    @_builtins.property
    @pulumi.getter(name="xvaultAwsIamServerId")
    def xvault_aws_iam_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS IAM Header Server ID that has been configured for this AWS IAM instance.
        """
        return pulumi.get(self, "xvault_aws_iam_server_id")

    @xvault_aws_iam_server_id.setter
    def xvault_aws_iam_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xvault_aws_iam_server_id", value)


@pulumi.type_token("harness:platform/vaultConnector:VaultConnector")
class VaultConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 app_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 k8s_auth_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 renew_app_role_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 renewal_interval_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_engine_manually_configured: Optional[pulumi.Input[_builtins.bool]] = None,
                 secret_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_engine_version: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_token_path: Optional[pulumi.Input[_builtins.str]] = None,
                 sink_path: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_aws_iam: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_jwt_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_k8s_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_vault_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 vault_aws_iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_jwt_auth_path: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_jwt_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_k8s_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_url: Optional[pulumi.Input[_builtins.str]] = None,
                 xvault_aws_iam_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating a HashiCorp Vault Secret Manager connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        aws_auth = harness.platform.VaultConnector("aws_auth",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            aws_region="aws_region",
            base_path="base_path",
            access_type="AWS_IAM",
            default=False,
            xvault_aws_iam_server_id=f"account.{test['id']}",
            read_only=True,
            renewal_interval_minutes=60,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            vault_aws_iam_role="vault_aws_iam_role",
            use_aws_iam=True,
            use_k8s_auth=False,
            use_vault_agent=False,
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        app_role = harness.platform.VaultConnector("app_role",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            app_role_id="app_role_id",
            base_path="base_path",
            access_type="APP_ROLE",
            default=False,
            secret_id=f"account.{test['id']}",
            read_only=True,
            renewal_interval_minutes=60,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            use_aws_iam=False,
            use_k8s_auth=False,
            use_vault_agent=False,
            renew_app_role_token=True,
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        k8s_auth = harness.platform.VaultConnector("k8s_auth",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            auth_token=f"account.{test['id']}",
            base_path="base_path",
            access_type="K8s_AUTH",
            default=False,
            k8s_auth_endpoint="k8s_auth_endpoint",
            namespace="namespace",
            read_only=True,
            renewal_interval_minutes=10,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            service_account_token_path="service_account_token_path",
            use_aws_iam=False,
            use_k8s_auth=True,
            use_vault_agent=False,
            vault_k8s_auth_role="vault_k8s_auth_role",
            vault_aws_iam_role="vault_aws_iam_role",
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        vault_agent = harness.platform.VaultConnector("vault_agent",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            auth_token=f"account.{test['id']}",
            base_path="base_path",
            access_type="VAULT_AGENT",
            default=False,
            namespace="namespace",
            read_only=True,
            renewal_interval_minutes=10,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            use_aws_iam=False,
            use_k8s_auth=False,
            use_vault_agent=True,
            sink_path="sink_path",
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        token = harness.platform.VaultConnector("token",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            auth_token=f"account.{test['id']}",
            base_path="base_path",
            access_type="TOKEN",
            default=False,
            namespace="namespace",
            read_only=True,
            renewal_interval_minutes=10,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            use_aws_iam=False,
            use_k8s_auth=False,
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        jwt = harness.platform.VaultConnector("jwt",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            base_path="base_path",
            access_type="JWT",
            default=False,
            read_only=True,
            renewal_interval_minutes=60,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            use_aws_iam=False,
            use_k8s_auth=False,
            use_vault_agent=False,
            renew_app_role_token=False,
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=True,
            vault_jwt_auth_role="vault_jwt_auth_role",
            vault_jwt_auth_path="vault_jwt_auth_path",
            execute_on_delegate=True)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level vault connector

        ```sh
        $ pulumi import harness:platform/vaultConnector:VaultConnector example <connector_id>
        ```

        Import org level vault connector

        ```sh
        $ pulumi import harness:platform/vaultConnector:VaultConnector example <ord_id>/<connector_id>
        ```

        Import project level vault connector

        ```sh
        $ pulumi import harness:platform/vaultConnector:VaultConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: Access type.
        :param pulumi.Input[_builtins.str] app_role_id: ID of App Role.
        :param pulumi.Input[_builtins.str] auth_token: Authentication token for Vault.
        :param pulumi.Input[_builtins.str] aws_region: AWS region where the AWS IAM authentication will happen.
        :param pulumi.Input[_builtins.str] base_path: Location of the Vault directory where the secret will be stored.
        :param pulumi.Input[_builtins.bool] default: Is default or not.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: List of Delegate Selectors that belong to the same Delegate and are used to connect to the Secret Manager.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.bool] is_default: Is default or not.
        :param pulumi.Input[_builtins.bool] is_read_only: Read only or not.
        :param pulumi.Input[_builtins.str] k8s_auth_endpoint: The path where Kubernetes Auth is enabled in Vault.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] namespace: Vault namespace where the Secret will be created.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.bool] read_only: Read only.
        :param pulumi.Input[_builtins.bool] renew_app_role_token: Boolean value to indicate if AppRole token renewal is enabled or not.
        :param pulumi.Input[_builtins.int] renewal_interval_minutes: The time interval for the token renewal.
        :param pulumi.Input[_builtins.bool] secret_engine_manually_configured: Manually entered Secret Engine.
        :param pulumi.Input[_builtins.str] secret_engine_name: Name of the Secret Engine.
        :param pulumi.Input[_builtins.int] secret_engine_version: Version of Secret Engine.
        :param pulumi.Input[_builtins.str] secret_id: ID of the Secret.
        :param pulumi.Input[_builtins.str] service_account_token_path: The Service Account token path in the K8s pod where the token is mounted.
        :param pulumi.Input[_builtins.str] sink_path: The location from which the authentication token should be read.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.bool] use_aws_iam: Boolean value to indicate if AWS IAM is used for authentication.
        :param pulumi.Input[_builtins.bool] use_jwt_auth: Boolean value to indicate if JWT is used for authentication.
        :param pulumi.Input[_builtins.bool] use_k8s_auth: Boolean value to indicate if K8s Auth is used for authentication.
        :param pulumi.Input[_builtins.bool] use_vault_agent: Boolean value to indicate if Vault Agent is used for authentication.
        :param pulumi.Input[_builtins.str] vault_aws_iam_role: The Vault role defined to bind to aws iam account/role being accessed.
        :param pulumi.Input[_builtins.str] vault_jwt_auth_path: Custom path at with JWT auth in enabled for Vault
        :param pulumi.Input[_builtins.str] vault_jwt_auth_role: The Vault role defined with JWT auth type for accessing Vault as per policies binded.
        :param pulumi.Input[_builtins.str] vault_k8s_auth_role: The role where K8s Auth will happen.
        :param pulumi.Input[_builtins.str] vault_url: URL of the HashiCorp Vault.
        :param pulumi.Input[_builtins.str] xvault_aws_iam_server_id: The AWS IAM Header Server ID that has been configured for this AWS IAM instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a HashiCorp Vault Secret Manager connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        aws_auth = harness.platform.VaultConnector("aws_auth",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            aws_region="aws_region",
            base_path="base_path",
            access_type="AWS_IAM",
            default=False,
            xvault_aws_iam_server_id=f"account.{test['id']}",
            read_only=True,
            renewal_interval_minutes=60,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            vault_aws_iam_role="vault_aws_iam_role",
            use_aws_iam=True,
            use_k8s_auth=False,
            use_vault_agent=False,
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        app_role = harness.platform.VaultConnector("app_role",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            app_role_id="app_role_id",
            base_path="base_path",
            access_type="APP_ROLE",
            default=False,
            secret_id=f"account.{test['id']}",
            read_only=True,
            renewal_interval_minutes=60,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            use_aws_iam=False,
            use_k8s_auth=False,
            use_vault_agent=False,
            renew_app_role_token=True,
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        k8s_auth = harness.platform.VaultConnector("k8s_auth",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            auth_token=f"account.{test['id']}",
            base_path="base_path",
            access_type="K8s_AUTH",
            default=False,
            k8s_auth_endpoint="k8s_auth_endpoint",
            namespace="namespace",
            read_only=True,
            renewal_interval_minutes=10,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            service_account_token_path="service_account_token_path",
            use_aws_iam=False,
            use_k8s_auth=True,
            use_vault_agent=False,
            vault_k8s_auth_role="vault_k8s_auth_role",
            vault_aws_iam_role="vault_aws_iam_role",
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        vault_agent = harness.platform.VaultConnector("vault_agent",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            auth_token=f"account.{test['id']}",
            base_path="base_path",
            access_type="VAULT_AGENT",
            default=False,
            namespace="namespace",
            read_only=True,
            renewal_interval_minutes=10,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            use_aws_iam=False,
            use_k8s_auth=False,
            use_vault_agent=True,
            sink_path="sink_path",
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        token = harness.platform.VaultConnector("token",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            auth_token=f"account.{test['id']}",
            base_path="base_path",
            access_type="TOKEN",
            default=False,
            namespace="namespace",
            read_only=True,
            renewal_interval_minutes=10,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            use_aws_iam=False,
            use_k8s_auth=False,
            vault_url="https://vault_url.com",
            use_jwt_auth=False)
        jwt = harness.platform.VaultConnector("jwt",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            base_path="base_path",
            access_type="JWT",
            default=False,
            read_only=True,
            renewal_interval_minutes=60,
            secret_engine_manually_configured=True,
            secret_engine_name="secret_engine_name",
            secret_engine_version=2,
            use_aws_iam=False,
            use_k8s_auth=False,
            use_vault_agent=False,
            renew_app_role_token=False,
            delegate_selectors=["harness-delegate"],
            vault_url="https://vault_url.com",
            use_jwt_auth=True,
            vault_jwt_auth_role="vault_jwt_auth_role",
            vault_jwt_auth_path="vault_jwt_auth_path",
            execute_on_delegate=True)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level vault connector

        ```sh
        $ pulumi import harness:platform/vaultConnector:VaultConnector example <connector_id>
        ```

        Import org level vault connector

        ```sh
        $ pulumi import harness:platform/vaultConnector:VaultConnector example <ord_id>/<connector_id>
        ```

        Import project level vault connector

        ```sh
        $ pulumi import harness:platform/vaultConnector:VaultConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param VaultConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 app_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 k8s_auth_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 renew_app_role_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 renewal_interval_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_engine_manually_configured: Optional[pulumi.Input[_builtins.bool]] = None,
                 secret_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_engine_version: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_token_path: Optional[pulumi.Input[_builtins.str]] = None,
                 sink_path: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_aws_iam: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_jwt_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_k8s_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_vault_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 vault_aws_iam_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_jwt_auth_path: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_jwt_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_k8s_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_url: Optional[pulumi.Input[_builtins.str]] = None,
                 xvault_aws_iam_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultConnectorArgs.__new__(VaultConnectorArgs)

            __props__.__dict__["access_type"] = access_type
            __props__.__dict__["app_role_id"] = app_role_id
            __props__.__dict__["auth_token"] = auth_token
            __props__.__dict__["aws_region"] = aws_region
            __props__.__dict__["base_path"] = base_path
            __props__.__dict__["default"] = default
            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["description"] = description
            __props__.__dict__["execute_on_delegate"] = execute_on_delegate
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["is_read_only"] = is_read_only
            __props__.__dict__["k8s_auth_endpoint"] = k8s_auth_endpoint
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["renew_app_role_token"] = renew_app_role_token
            if renewal_interval_minutes is None and not opts.urn:
                raise TypeError("Missing required property 'renewal_interval_minutes'")
            __props__.__dict__["renewal_interval_minutes"] = renewal_interval_minutes
            __props__.__dict__["secret_engine_manually_configured"] = secret_engine_manually_configured
            __props__.__dict__["secret_engine_name"] = secret_engine_name
            __props__.__dict__["secret_engine_version"] = secret_engine_version
            __props__.__dict__["secret_id"] = secret_id
            __props__.__dict__["service_account_token_path"] = service_account_token_path
            __props__.__dict__["sink_path"] = sink_path
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_aws_iam"] = use_aws_iam
            __props__.__dict__["use_jwt_auth"] = use_jwt_auth
            __props__.__dict__["use_k8s_auth"] = use_k8s_auth
            __props__.__dict__["use_vault_agent"] = use_vault_agent
            __props__.__dict__["vault_aws_iam_role"] = vault_aws_iam_role
            __props__.__dict__["vault_jwt_auth_path"] = vault_jwt_auth_path
            __props__.__dict__["vault_jwt_auth_role"] = vault_jwt_auth_role
            __props__.__dict__["vault_k8s_auth_role"] = vault_k8s_auth_role
            if vault_url is None and not opts.urn:
                raise TypeError("Missing required property 'vault_url'")
            __props__.__dict__["vault_url"] = vault_url
            __props__.__dict__["xvault_aws_iam_server_id"] = xvault_aws_iam_server_id
        super(VaultConnector, __self__).__init__(
            'harness:platform/vaultConnector:VaultConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_type: Optional[pulumi.Input[_builtins.str]] = None,
            app_role_id: Optional[pulumi.Input[_builtins.str]] = None,
            auth_token: Optional[pulumi.Input[_builtins.str]] = None,
            aws_region: Optional[pulumi.Input[_builtins.str]] = None,
            base_path: Optional[pulumi.Input[_builtins.str]] = None,
            default: Optional[pulumi.Input[_builtins.bool]] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            is_read_only: Optional[pulumi.Input[_builtins.bool]] = None,
            k8s_auth_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            read_only: Optional[pulumi.Input[_builtins.bool]] = None,
            renew_app_role_token: Optional[pulumi.Input[_builtins.bool]] = None,
            renewal_interval_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            secret_engine_manually_configured: Optional[pulumi.Input[_builtins.bool]] = None,
            secret_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_engine_version: Optional[pulumi.Input[_builtins.int]] = None,
            secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_token_path: Optional[pulumi.Input[_builtins.str]] = None,
            sink_path: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            use_aws_iam: Optional[pulumi.Input[_builtins.bool]] = None,
            use_jwt_auth: Optional[pulumi.Input[_builtins.bool]] = None,
            use_k8s_auth: Optional[pulumi.Input[_builtins.bool]] = None,
            use_vault_agent: Optional[pulumi.Input[_builtins.bool]] = None,
            vault_aws_iam_role: Optional[pulumi.Input[_builtins.str]] = None,
            vault_jwt_auth_path: Optional[pulumi.Input[_builtins.str]] = None,
            vault_jwt_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
            vault_k8s_auth_role: Optional[pulumi.Input[_builtins.str]] = None,
            vault_url: Optional[pulumi.Input[_builtins.str]] = None,
            xvault_aws_iam_server_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VaultConnector':
        """
        Get an existing VaultConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: Access type.
        :param pulumi.Input[_builtins.str] app_role_id: ID of App Role.
        :param pulumi.Input[_builtins.str] auth_token: Authentication token for Vault.
        :param pulumi.Input[_builtins.str] aws_region: AWS region where the AWS IAM authentication will happen.
        :param pulumi.Input[_builtins.str] base_path: Location of the Vault directory where the secret will be stored.
        :param pulumi.Input[_builtins.bool] default: Is default or not.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: List of Delegate Selectors that belong to the same Delegate and are used to connect to the Secret Manager.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.bool] is_default: Is default or not.
        :param pulumi.Input[_builtins.bool] is_read_only: Read only or not.
        :param pulumi.Input[_builtins.str] k8s_auth_endpoint: The path where Kubernetes Auth is enabled in Vault.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] namespace: Vault namespace where the Secret will be created.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.bool] read_only: Read only.
        :param pulumi.Input[_builtins.bool] renew_app_role_token: Boolean value to indicate if AppRole token renewal is enabled or not.
        :param pulumi.Input[_builtins.int] renewal_interval_minutes: The time interval for the token renewal.
        :param pulumi.Input[_builtins.bool] secret_engine_manually_configured: Manually entered Secret Engine.
        :param pulumi.Input[_builtins.str] secret_engine_name: Name of the Secret Engine.
        :param pulumi.Input[_builtins.int] secret_engine_version: Version of Secret Engine.
        :param pulumi.Input[_builtins.str] secret_id: ID of the Secret.
        :param pulumi.Input[_builtins.str] service_account_token_path: The Service Account token path in the K8s pod where the token is mounted.
        :param pulumi.Input[_builtins.str] sink_path: The location from which the authentication token should be read.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.bool] use_aws_iam: Boolean value to indicate if AWS IAM is used for authentication.
        :param pulumi.Input[_builtins.bool] use_jwt_auth: Boolean value to indicate if JWT is used for authentication.
        :param pulumi.Input[_builtins.bool] use_k8s_auth: Boolean value to indicate if K8s Auth is used for authentication.
        :param pulumi.Input[_builtins.bool] use_vault_agent: Boolean value to indicate if Vault Agent is used for authentication.
        :param pulumi.Input[_builtins.str] vault_aws_iam_role: The Vault role defined to bind to aws iam account/role being accessed.
        :param pulumi.Input[_builtins.str] vault_jwt_auth_path: Custom path at with JWT auth in enabled for Vault
        :param pulumi.Input[_builtins.str] vault_jwt_auth_role: The Vault role defined with JWT auth type for accessing Vault as per policies binded.
        :param pulumi.Input[_builtins.str] vault_k8s_auth_role: The role where K8s Auth will happen.
        :param pulumi.Input[_builtins.str] vault_url: URL of the HashiCorp Vault.
        :param pulumi.Input[_builtins.str] xvault_aws_iam_server_id: The AWS IAM Header Server ID that has been configured for this AWS IAM instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultConnectorState.__new__(_VaultConnectorState)

        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["app_role_id"] = app_role_id
        __props__.__dict__["auth_token"] = auth_token
        __props__.__dict__["aws_region"] = aws_region
        __props__.__dict__["base_path"] = base_path
        __props__.__dict__["default"] = default
        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["description"] = description
        __props__.__dict__["execute_on_delegate"] = execute_on_delegate
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["is_read_only"] = is_read_only
        __props__.__dict__["k8s_auth_endpoint"] = k8s_auth_endpoint
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["renew_app_role_token"] = renew_app_role_token
        __props__.__dict__["renewal_interval_minutes"] = renewal_interval_minutes
        __props__.__dict__["secret_engine_manually_configured"] = secret_engine_manually_configured
        __props__.__dict__["secret_engine_name"] = secret_engine_name
        __props__.__dict__["secret_engine_version"] = secret_engine_version
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["service_account_token_path"] = service_account_token_path
        __props__.__dict__["sink_path"] = sink_path
        __props__.__dict__["tags"] = tags
        __props__.__dict__["use_aws_iam"] = use_aws_iam
        __props__.__dict__["use_jwt_auth"] = use_jwt_auth
        __props__.__dict__["use_k8s_auth"] = use_k8s_auth
        __props__.__dict__["use_vault_agent"] = use_vault_agent
        __props__.__dict__["vault_aws_iam_role"] = vault_aws_iam_role
        __props__.__dict__["vault_jwt_auth_path"] = vault_jwt_auth_path
        __props__.__dict__["vault_jwt_auth_role"] = vault_jwt_auth_role
        __props__.__dict__["vault_k8s_auth_role"] = vault_k8s_auth_role
        __props__.__dict__["vault_url"] = vault_url
        __props__.__dict__["xvault_aws_iam_server_id"] = xvault_aws_iam_server_id
        return VaultConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access type.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="appRoleId")
    def app_role_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of App Role.
        """
        return pulumi.get(self, "app_role_id")

    @_builtins.property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> pulumi.Output[_builtins.str]:
        """
        Authentication token for Vault.
        """
        return pulumi.get(self, "auth_token")

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS region where the AWS IAM authentication will happen.
        """
        return pulumi.get(self, "aws_region")

    @_builtins.property
    @pulumi.getter(name="basePath")
    def base_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Location of the Vault directory where the secret will be stored.
        """
        return pulumi.get(self, "base_path")

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is default or not.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Delegate Selectors that belong to the same Delegate and are used to connect to the Secret Manager.
        """
        return pulumi.get(self, "delegate_selectors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is default or not.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Read only or not.
        """
        return pulumi.get(self, "is_read_only")

    @_builtins.property
    @pulumi.getter(name="k8sAuthEndpoint")
    def k8s_auth_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path where Kubernetes Auth is enabled in Vault.
        """
        return pulumi.get(self, "k8s_auth_endpoint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Vault namespace where the Secret will be created.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Read only.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="renewAppRoleToken")
    def renew_app_role_token(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean value to indicate if AppRole token renewal is enabled or not.
        """
        return pulumi.get(self, "renew_app_role_token")

    @_builtins.property
    @pulumi.getter(name="renewalIntervalMinutes")
    def renewal_interval_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        The time interval for the token renewal.
        """
        return pulumi.get(self, "renewal_interval_minutes")

    @_builtins.property
    @pulumi.getter(name="secretEngineManuallyConfigured")
    def secret_engine_manually_configured(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Manually entered Secret Engine.
        """
        return pulumi.get(self, "secret_engine_manually_configured")

    @_builtins.property
    @pulumi.getter(name="secretEngineName")
    def secret_engine_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the Secret Engine.
        """
        return pulumi.get(self, "secret_engine_name")

    @_builtins.property
    @pulumi.getter(name="secretEngineVersion")
    def secret_engine_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Version of Secret Engine.
        """
        return pulumi.get(self, "secret_engine_version")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the Secret.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccountTokenPath")
    def service_account_token_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Service Account token path in the K8s pod where the token is mounted.
        """
        return pulumi.get(self, "service_account_token_path")

    @_builtins.property
    @pulumi.getter(name="sinkPath")
    def sink_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The location from which the authentication token should be read.
        """
        return pulumi.get(self, "sink_path")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="useAwsIam")
    def use_aws_iam(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean value to indicate if AWS IAM is used for authentication.
        """
        return pulumi.get(self, "use_aws_iam")

    @_builtins.property
    @pulumi.getter(name="useJwtAuth")
    def use_jwt_auth(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean value to indicate if JWT is used for authentication.
        """
        return pulumi.get(self, "use_jwt_auth")

    @_builtins.property
    @pulumi.getter(name="useK8sAuth")
    def use_k8s_auth(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean value to indicate if K8s Auth is used for authentication.
        """
        return pulumi.get(self, "use_k8s_auth")

    @_builtins.property
    @pulumi.getter(name="useVaultAgent")
    def use_vault_agent(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean value to indicate if Vault Agent is used for authentication.
        """
        return pulumi.get(self, "use_vault_agent")

    @_builtins.property
    @pulumi.getter(name="vaultAwsIamRole")
    def vault_aws_iam_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Vault role defined to bind to aws iam account/role being accessed.
        """
        return pulumi.get(self, "vault_aws_iam_role")

    @_builtins.property
    @pulumi.getter(name="vaultJwtAuthPath")
    def vault_jwt_auth_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom path at with JWT auth in enabled for Vault
        """
        return pulumi.get(self, "vault_jwt_auth_path")

    @_builtins.property
    @pulumi.getter(name="vaultJwtAuthRole")
    def vault_jwt_auth_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Vault role defined with JWT auth type for accessing Vault as per policies binded.
        """
        return pulumi.get(self, "vault_jwt_auth_role")

    @_builtins.property
    @pulumi.getter(name="vaultK8sAuthRole")
    def vault_k8s_auth_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The role where K8s Auth will happen.
        """
        return pulumi.get(self, "vault_k8s_auth_role")

    @_builtins.property
    @pulumi.getter(name="vaultUrl")
    def vault_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the HashiCorp Vault.
        """
        return pulumi.get(self, "vault_url")

    @_builtins.property
    @pulumi.getter(name="xvaultAwsIamServerId")
    def xvault_aws_iam_server_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS IAM Header Server ID that has been configured for this AWS IAM instance.
        """
        return pulumi.get(self, "xvault_aws_iam_server_id")

