from typing import Overload, List, Tuple


class ConceptDenotation:
    def __init__(self, num_objects: int) -> None: ...
    def __eq__(self) -> bool: ...
    def __ne__(self) -> bool: ...
    def __str__(self) -> str: ...
    def __len__(self) -> int: ...
    def __hash__(self) -> int: ...
    def contains(self, object_index: int)-> bool: ...
    def set(self) -> None: ...
    def insert(self, object_index: int) -> None: ...
    def erase(self, object_index: int) -> None: ...
    def intersects(self, other: "ConceptDenotation") -> bool: ...
    def is_subset_of(self, other: "ConceptDenotation") -> bool: ...
    def to_vector(self) -> List[int]: ...
    def to_sorted_vector(self) -> List[int]: ...
    def get_num_objects(self) -> int: ...


class RoleDenotation:
    def __init__(self, num_objects: int) -> None: ...
    def __eq__(self) -> bool: ...
    def __ne__(self) -> bool: ...
    def __str__(self) -> str: ...
    def __len__(self) -> int: ...
    def __hash__(self) -> int: ...
    def contains(self, pair_of_object_indices: Tuple[int, int])-> bool: ...
    def set(self) -> None: ...
    def insert(self, pair_of_object_indices: Tuple[int, int]) -> None: ...
    def erase(self, pair_of_object_indices: Tuple[int, int]) -> None: ...
    def intersects(self, other: "ConceptDenotation") -> bool: ...
    def is_subset_of(self, other: "ConceptDenotation") -> bool: ...
    def to_vector(self) -> List[Tuple[int, int]]: ...
    def to_sorted_vector(self) -> List[Tuple[int, int]]: ...
    def get_num_objects(self) -> int: ...


class DenotationsCaches:
    def __init__(self) -> None: ...


class Constant:
    def __eq__(self, other: "Constant") -> bool: ...
    def __ne__(self, other: "Constant") -> bool: ...
    def __str__(self) -> str: ...
    def get_index(self) -> int: ...
    def get_name(self) -> str: ...


class Predicate:
    def __eq__(self, other: "Predicate") -> bool: ...
    def __ne__(self, other: "Predicate") -> bool: ...
    def __str__(self) -> str: ...
    def get_index(self) -> int: ...
    def get_name(self) -> str: ...
    def get_arity(self) -> int: ...
    def is_static(self) -> bool: ...


class VocabularyInfo:
    def __init__(self) -> None: ...
    def __str__(self) -> str: ...
    def add_predicate(self, name: str, arity: int, is_static: bool) -> Predicate: ...
    def add_constant(self, name: str) -> Constant: ...
    def get_predicates(self) -> List[Predicate]: ...
    def get_constants(self) -> List[Constant]: ...
    def get_predicate(self, name: str) -> Predicate: ...
    def get_constant(self, name: str) -> Constant: ...


class Object:
    def __eq__(self, other: "Object") -> bool: ...
    def __ne__(self, other: "Object") -> bool: ...
    def __str__(self) -> str: ...
    def get_index(self) -> int: ...
    def get_name(self) -> str: ...


class Atom:
    def __eq__(self, other: "Atom") -> bool: ...
    def __ne__(self, other: "Atom") -> bool: ...
    def __str__(self) -> str: ...
    def get_index(self) -> int: ...
    def get_name(self) -> str: ...
    def get_predicate_index(self) -> int: ...
    def get_object_indices(self) -> List[int]: ...
    def is_static(self) -> bool: ...


class InstanceInfo:
    def __init__(self, index: int, vocabulary: VocabularyInfo) -> None: ...
    def __str__(self) -> str: ...
    def add_object(self, name: str) -> Object: ...
    @overload
    def add_atom(self, predicate: Predicate, objects: List[Object]) -> Atom: ...
    @overload
    def add_atom(self, predicate_name: str, object_names: List[str]) -> Atom: ...
    @overload
    def add_atom(self, predicate_index: int, object_indices: List[int]) -> Atom: ...
    @overload
    def add_static_atom(self, predicate: Predicate, objects: List[Object]) -> Atom: ...
    @overload
    def add_static_atom(self, predicate_name: str, object_names: List[str]) -> Atom: ...
    @overload
    def add_static_atom(self, predicate_index: int, object_indices: List[int]) -> Atom: ...
    def get_index(self) -> int: ...
    def get_objects(self) -> List[Object]: ...
    def get_atoms(self) -> List[Atom]: ...
    def get_static_atoms(self) -> List[Atom]: ...
    def get_object(self, object_name: str) -> Object: ...
    def get_atom(self, atom_name: str) -> Atom: ...
    def get_vocabulary_info(self) -> VocabularyInfo: ...
    def clear_atoms(self) -> None: ...
    def clear_static_atoms(self) -> None: ...


class State:
    @overload
    def __init__(self, instance: InstanceInfo, atoms: List[Atom]) -> None: ...
    @overload
    def __init__(self, instance: InstanceInfo, atom_indices: List[int]) -> None: ...
    def __eq__(self, other: "State") -> bool: ...
    def __ne__(self, other: "State") -> bool: ...
    def __str__(self) -> str: ...
    def __hash__(self) -> int: ...
    def get_index(self) -> int: ...
    def get_atom_indices(self) -> List[int]: ...
    def get_instance_info(self) -> InstanceInfo: ...


class Concept():
    def __str__(self) -> str: ...
    def compute_complexity(self) -> int: ...
    def get_index(self) -> int: ...
    def get_vocabulary_info(self) -> VocabularyInfo: ...
    @overload
    def evaluate(self, state: State) -> ConceptDenotation: ...
    @overload
    def evaluate(self, state: State, denotations_caches: DenotationsCaches) -> ConceptDenotation: ...
    @overload
    def evaluate(self, states: List[State], denotations_caches: DenotationsCaches) -> List[ConceptDenotation]: ...


class Role():
    def __str__(self) -> str: ...
    def compute_complexity(self) -> int: ...
    def get_index(self) -> int: ...
    def get_vocabulary_info(self) -> VocabularyInfo: ...
    @overload
    def evaluate(self, state: State) -> RoleDenotation: ...
    @overload
    def evaluate(self, state: State, denotations_caches: DenotationsCaches) -> RoleDenotation: ...
    @overload
    def evaluate(self, states: List[State], denotations_caches: DenotationsCaches) -> List[RoleDenotation]: ...


class Boolean():
    def __str__(self) -> str: ...
    def compute_complexity(self) -> int: ...
    def get_index(self) -> int: ...
    def get_vocabulary_info(self) -> VocabularyInfo: ...
    @overload
    def evaluate(self, state: State) -> bool: ...
    @overload
    def evaluate(self, state: State, denotations_caches: DenotationsCaches) -> bool: ...
    @overload
    def evaluate(self, states: List[State], denotations_caches: DenotationsCaches) -> List[bool]: ...


class Numerical():
    def __str__(self) -> str: ...
    def compute_complexity(self) -> int: ...
    def get_index(self) -> int: ...
    def get_vocabulary_info(self) -> VocabularyInfo: ...
    @overload
    def evaluate(self, state: State) -> int: ...
    @overload
    def evaluate(self, state: State, denotations_caches: DenotationsCaches) -> int: ...
    @overload
    def evaluate(self, states: List[State], denotations_caches: DenotationsCaches) -> List[int]: ...


class SyntacticElementFactory:
    def __init__(self, vocabulary: VocabularyInfo) -> None: ...
    def parse_concept(self, description: str, filename: str = "") -> Concept: ...
    def parse_role(self, description: str, filename: str = "") -> Role: ...
    def parse_boolean(self, description: str, filename: str = "") -> Boolean: ...
    def parse_numerical(self, description: str, filename: str = "") -> Numerical: ...

    @overload
    def make_empty_boolean(self, concept: Concept) -> Boolean: ...
    @overload
    def make_empty_boolean(self, role: Role) -> Boolean: ...
    @overload
    def make_inclusion_boolean(self, concept_left: Concept, concept_right: Concept) -> Boolean: ...
    @overload
    def make_inclusion_boolean(self, role_left: Role, role_right: Concept) -> Boolean: ...
    def make_nullary_boolean(self, predicate: Predicate) -> Boolean: ...

    def make_all_concept(self, role: Role, concept: Concept) -> Concept: ...
    def make_and_concept(self, concept_left: Concept, concept_right: Concept) -> Concept: ...
    def make_bot_concept(self) -> Concept: ...
    def make_diff_concept(self, concept_left: Concept, concept_right: Concept) -> Concept: ...
    def make_equal_concept(self, role_left: Role, role_right: Role) -> Concept: ...
    def make_not_concept(self, concept: Concept) -> Concept: ...
    def make_one_of_concept(self, constant: Constant) -> Concept: ...
    def make_or_concept(self, concept_left: Concept, concept_right: Concept) -> Concept: ...
    def make_projection_concept(self, role: Role, position: int) -> Concept: ...
    def make_primitive_concept(self, predicate: Predicate, position: int) -> Concept: ...
    def make_some_concept(self, role: Role, concept: Concept) -> Concept: ...
    def make_subset_concept(self, role_left: Role, role_right: Role) -> Concept: ...
    def make_top_concept(self) -> Concept: ...

    def make_concept_distance_numerical(self, concept_from: Concept, role: Role, concept_to: Concept) -> Numerical: ...
    @overload
    def make_count_numerical(self, concept: Concept) -> Numerical: ...
    @overload
    def make_count_numerical(self, role: Role) -> Numerical: ...
    def make_role_distance_numerical(self, role_from: Role, role: Role, role_to: Role) -> Numerical: ...
    def make_sum_concept_distance_numerical(self, concept_from: Concept, role: Role, concept_to: Concept) -> Numerical: ...
    def make_sum_role_distance_numerical(self, role_from: Role, role: Role, role_to: Role) -> Numerical: ...

    def make_and_concept(self, role_left: Role, role_right: Role) -> Role: ...
    def make_compose_role(self, role_left: Role, role_right: Role) -> Role: ...
    def make_diff_role(self, role_left: Role, role_right: Role) -> Role: ...
    def make_identity_role(self, concept: Concept) -> Role: ...
    def make_inverse_role(self, role: Role) -> Role: ...
    def make_not_role(self, role: Role) -> Role: ...
    def make_or_concept(self, role_left: Role, role_right: Role) -> Role: ...
    def make_primitive_role(self, predicate: Predicate, position_first: int, position_second: int) -> Role: ...
    def make_restrict_role(self, role: Role, concept: Concept) -> Role: ...
    def make_top_role(self) -> Role: ...
    def make_transitive_closure(self, role: Role) -> Role: ...
    def make_transitive_reflexive_closure(self, role: Role) -> Role: ...

    def get_vocabulary_info(self): VocabularyInfo: ...