from typing import List

from ..core import SyntacticElementFactory, State


class FeatureGenerator:
    def generate(self, 
        factory: SyntacticElementFactory, 
        states: List[State],
        concept_complexity_limit: int = 9,
        role_complexity_limit: int = 9,
        boolean_complexity_limit: int = 9,
        count_numerical_complexity_limit: int = 9,
        distance_numerical_complexity_limit: int = 9,
        time_limit: int = 3600,
        feature_limit: int = 10000) -> List[str]: ...
    def set_generate_empty_boolean(self, enable: bool) -> None: ...
    def set_generate_inclusion_boolean(self, enable: bool) -> None: ...
    def set_generate_nullary_boolean(self, enable: bool) -> None: ...
    def set_generate_all_concept(self, enable: bool) -> None: ...
    def set_generate_and_concept(self, enable: bool) -> None: ...
    def set_generate_bot_concept(self, enable: bool) -> None: ...
    def set_generate_diff_concept(self, enable: bool) -> None: ...
    def set_generate_equal_concept(self, enable: bool) -> None: ...
    def set_generate_not_concept(self, enable: bool) -> None: ...
    def set_generate_one_of_concept(self, enable: bool) -> None: ...
    def set_generate_or_concept(self, enable: bool) -> None: ...
    def set_generate_primitive_concept(self, enable: bool) -> None: ...
    def set_generate_projection_concept(self, enable: bool) -> None: ...
    def set_generate_some_concept(self, enable: bool) -> None: ...
    def set_generate_subset_concept(self, enable: bool) -> None: ...
    def set_generate_top_concept(self, enable: bool) -> None: ...
    def set_generate_concept_distance_numerical(self, enable: bool) -> None: ...
    def set_generate_count_numerical(self, enable: bool) -> None: ...
    def set_generate_and_role(self, enable: bool) -> None: ...
    def set_generate_compose_role(self, enable: bool) -> None: ...
    def set_generate_diff_role(self, enable: bool) -> None: ...
    def set_generate_identity_role(self, enable: bool) -> None: ...
    def set_generate_inverse_role(self, enable: bool) -> None: ...
    def set_generate_not_role(self, enable: bool) -> None: ...
    def set_generate_or_role(self, enable: bool) -> None: ...
    def set_generate_primitive_role(self, enable: bool) -> None: ...
    def set_generate_restrict_role(self, enable: bool) -> None: ...
    def set_generate_top_role(self, enable: bool) -> None: ...
    def set_generate_transitive_closure_role(self, enable: bool) -> None: ...
    def set_generate_transitive_reflexive_closure_role(self, enable: bool) -> None: ...


def generate_features(self, 
    factory: SyntacticElementFactory,
    states: List[State],
    concept_complexity_limit: int = 9,
    role_complexity_limit: int = 9,
    boolean_complexity_limit: int = 9,
    count_numerical_complexity_limit: int = 9,
    distance_numerical_complexity_limit: int = 9,
    time_limit: int = 3600,
    feature_limit: int = 10000,
    generate_empty_boolean: bool = True,
    generate_inclusion_boolean: bool = True,
    generate_nullary_boolean: bool = True,
    generate_all_concept: bool = True,
    generate_and_concept: bool = True,
    generate_bot_concept: bool = True,
    generate_diff_concept: bool = False,
    generate_equal_concept: bool = True,
    generate_not_concept: bool = True,
    generate_one_of_concept: bool = True,
    generate_or_concept: bool = False,
    generate_primitive_concept: bool = True,
    generate_projection_concept: bool = False,
    generate_some_concept: bool = True,
    generate_subset_concept: bool = False,
    generate_top_concept: bool = True,
    generate_concept_distance_numerical: bool = True,
    generate_count_numerical: bool = True,
    generate_and_role: bool = True,
    generate_compose_role: bool = False,
    generate_diff_role: bool = False,
    generate_identity_role: bool = True,
    generate_inverse_role: bool = True,
    generate_not_role: bool = False,
    generate_or_role: bool = False,
    generate_primitive_role: bool = True,
    generate_restrict_role: bool = True,
    generate_top_role: bool = False,
    generate_transitive_closure_role: bool = True,
    generate_transitive_reflexive_closure_role: bool = False) -> List[str]: ...
