from enum import Enum

from typing import Overload, Dict, List, MutableSet

from ..core import VocabularyInfo, InstanceInfo, State


class StateSpace:
    @overload
    def __init__(self,
        instance_info: InstanceInfo,
        states: Dict[int, State],
        initial_state_index: int,
        forward_successor_state_indices: Dict[int, MutableSet[int]],
        goal_state_indices: MutableSet[int]) -> None: ...
    @overload
    def __init__(self, state_space: "StateSpace", state_indices: MutableSet[int]) -> None: ...
    def __str__(self) -> str: ...
    def compute_distances(self, state_indices: MutableSet[int], forward: bool, stop_if_goal: bool) -> Dict[int, int]: ...
    def compute_goal_distances(self) -> Dict[int, int]: ...
    def is_goal(self, state_index: int) -> bool: ...
    def to_dot(self, verbosity_level: int) -> str: ...
    def set_initial_state_index(self, index: int) -> None: ...
    def set_goal_state_indices(self, state_indices: MutableSet[int]) -> None: ...
    def get_states(self) -> Dict[int, State]: ...
    def get_initial_state_index(self) -> int: ...
    def get_forward_successor_state_indices(self) -> Dict[int, MutableSet[int]]: ...
    def get_backward_successor_state_indices(self) -> Dict[int, MutableSet[int]]: ...
    def get_goal_state_indices(self) -> MutableSet[int]: ...
    def get_instance_info(self) -> InstanceInfo: ...


class GeneratorExitCode(Enum):
    COMPLETE = ...
    INCOMPLETE = ...
    FAIL = ...


class GeneratorResult:
    exit_code: GeneratorExitCode
    state_space: StateSpace


def generate_state_space(domain_file: str, instance_file: str, vocabulary_info: VocabularyInfo = None, index: int = -1, max_time: int = 2147483646, max_num_states: int = 2147483646) -> GeneratorResult: ...
