"""Planner model

Revision ID: 1d328f7bf643
Revises: 5cf9660bba80
Create Date: 2022-01-27 11:52:57.282622+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '1d328f7bf643'
down_revision = '06c48492f587'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('planner_project',
    sa.Column('create_date', sa.DateTime(), nullable=True),
    sa.Column('update_date', sa.DateTime(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=False),
    sa.Column('creator_id', sa.Integer(), nullable=True),
    sa.Column('update_user_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['creator_id'], ['faraday_user.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['update_user_id'], ['faraday_user.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('project_task',
    sa.Column('create_date', sa.DateTime(), nullable=True),
    sa.Column('update_date', sa.DateTime(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('start_date', sa.DateTime(), nullable=True),
    sa.Column('end_date', sa.DateTime(), nullable=True),
    sa.Column('status', sa.Enum('new', 'review', 'completed', 'in progress', name='project_task_statuses'), nullable=True),
    sa.Column('type', sa.Enum('task', 'milestone', name='project_task_types'), nullable=False),
    sa.Column('project_id', sa.Integer(), nullable=False),
    sa.Column('creator_id', sa.Integer(), nullable=True),
    sa.Column('update_user_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['creator_id'], ['faraday_user.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['project_id'], ['planner_project.id'], ),
    sa.ForeignKeyConstraint(['update_user_id'], ['faraday_user.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_project_task_project_id'), 'project_task', ['project_id'], unique=False)
    op.create_table('project_task_user_association',
    sa.Column('task_id', sa.Integer(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['task_id'], ['project_task.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['faraday_user.id'], ondelete='CASCADE')
    )
    op.create_table('task_dependencies_association',
    sa.Column('task_id', sa.Integer(), nullable=True),
    sa.Column('task_dependency_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['task_dependency_id'], ['project_task.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['task_id'], ['project_task.id'], )
    )
    op.create_table('vulnerabilities_related_association',
    sa.Column('task_id', sa.Integer(), nullable=True),
    sa.Column('vulnerability_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['task_id'], ['project_task.id'], ),
    sa.ForeignKeyConstraint(['vulnerability_id'], ['vulnerability.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('task_id', 'vulnerability_id', name='vuln_task_pkey'),
    )
    # op.alter_column('comment', 'workspace_id',
    #                 existing_type=sa.Integer(),
    #                 nullable=True,
    #                 )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # op.alter_column('comment', 'workspace_id',
    #                 existing_type=sa.Integer(),
    #                 nullable=False,
    #                 )
    op.drop_table('vulnerabilities_related_association')
    op.drop_table('task_dependencies_association')
    op.drop_table('project_task_user_association')
    op.drop_index(op.f('ix_project_task_project_id'), table_name='project_task')
    op.drop_table('project_task')
    # op.drop_index(op.f('ix_planner_project_workspace_id'), table_name='planner_project')
    # op.drop_index(op.f('ix_project_task_workspace_id'), table_name='project_task')
    op.drop_table('planner_project')
    op.execute('DROP TYPE project_task_statuses')
    op.execute('DROP TYPE project_task_types')
    # ### end Alembic commands ###
