TOPICS_REAL = [
    "Socotra Island's dragon blood trees",
    "Movile Cave's isolated ecosystem (Romania)",
    "Danakil Depression's acid pools (Ethiopia)",
    "Waitomo Glowworm Caves (New Zealand)",
    "Lençóis Maranhenses sand dunes (Brazil)",
    "Chocolate Hills formation (Philippines)",
    "Spotted Lake mineral deposits (Canada)",
    "Fly Geyser microbial colors (Nevada)",
    "Tianzi Mountain sandstone pillars (China)",
    "Giant's Causeway basalt columns (Ireland)",
    "Mantis shrimp's polarized vision",
    "Lyrebird vocal mimicry mechanisms",
    "Tardigrade cryptobiosis process",
    "Archerfish water-shooting accuracy",
    "Pistol shrimp shockwave hunting",
    "Bombardier beetle chemical defense",
    "Axolotl limb regeneration",
    "Narwhal tusk sensory capabilities",
    "Platypus electroreception",
    "Neutron star glitches",
    "Solar prominence dynamics",
    "Enceladus' cryovolcanic plumes",
    "Pāhoehoe lava formations",
    "Magnetar magnetic field strength",
    "Cosmic neutrino background",
    "Quantum foam fluctuations",
    "Spaghettification near black holes",
    "Solar sail navigation",
    "Dark matter halo structures",
    "Antikythera Mechanism functions",
    "Nazca Lines construction methods",
    "Moai transportation (Easter Island)",
    "Baghdad Battery controversy",
    "Roman concrete seawater hardening",
    "Viking sunstone navigation",
    "Saqqara Bird aerodynamics",
    "Göbekli Tepe carvings",
    "Voynich Manuscript analysis",
    "Olmec colossal heads",
    "Tensegrity bridge designs",
    "Aerogel insulation properties",
    "MEMS gyroscope manufacturing",
    "Hydrophobic surface engineering",
    "Metamaterial cloaking principles",
    "4D printing shape memory",
    "Piezoelectric shoe charging",
    "Self-healing concrete bacteria",
    "Quantum dot solar cells",
    "Starlink satellite avoidance",
    "Ainu bear ceremonies (Japan)",
    "Whistled language of La Gomera",
    "Mongolian throat singing",
    "Venetian glass bead making",
    "Sami reindeer herding",
    "Bhutanese archery traditions",
    "Navajo sandpainting",
    "Balinese water temples",
    "Maasai warrior jumps",
    "Korean hanji paper",
    "Cloud forests epiphyte networks",
    "Cenote freshwater layers (Mexico)",
    "Sargasso Sea floating ecosystem",
    "Hydrothermal vent communities",
    "Pantanal wetland seasons (Brazil)",
    "Peat bog preservation",
    "Atacama Desert lichens",
    "Waitoreke wetlands (New Zealand)",
    "Bioluminescent dinoflagellates",
    "Fire rainbow formation",
    "Halobacterium salt metabolism",
    "Gallium liquid properties",
    "Supercooled water stability",
    "Nitinol shape memory",
    "Chlorine trifluoride reactivity",
    "Ferrofluid manipulation",
    "Supercritical CO2 extraction",
    "Synesthesia neural pathways",
    "Blood-brain barrier",
    "Gut microbiome diversity",
    "Rapid eye movement sleep",
    "Hiccups evolutionary purpose",
    "Goosebumps mechanism",
    "Phantom limb sensations",
    "Taste bud regeneration",
    "Hypoxic training",
    "Blushing physiology",
    "Graphene conductivity",
    "Metallic glass formation",
    "Self-cleaning surfaces",
    "Carbon nanotube strength",
    "Ferrocrete durability",
    "Transparent aluminum",
    "Memory metal alloys",
    "Conductive polymers",
    "Glass frog transparency",
    "Mangrove salt filtration",
    "Sundarbans tiger adaptation",
    "Baobab water storage",
    "Carnivorous plant traps",
    "Electric eel discharge",
    "Leafcutter ant farming",
    "Spider web engineering",
    "Fire tornado dynamics",
    "Light pillars formation",
    "Morning glory clouds",
    "Volcanic lightning",
    "Snow roller formation",
    "Frost flowers growth",
    "Catatumbo lightning",
    "Sun dog phenomena",
    "Fire rainbow optics",
    "Virga precipitation",
    "Roman hypocaust heating",
    "Chinese seismograph",
    "Inca quipu records",
    "Persian qanat systems",
    "Egyptian faience",
    "Mayan astronomy",
    "Polynesian navigation",
    "Aboriginal firestick",
    "Memory palace technique",
    "Mnemonic major system",
    "Method acting",
    "Shadow puppetry",
    "Sand mandalas",
    "Kintsugi repair",
    "Wabi-sabi",
    "Ikebana principles",
    "Tea ceremony",
    "Origami mathematics",
    "Coral spawning events",
    "Jellyfish locomotion",
    "Cephalopod camouflage",
    "Spider silk production",
    "Ant colony algorithms",
    "Bee waggle dance",
    "Bat echolocation",
    "Elephant infrasound",
    "Whale fall ecosystems",
    "Quantum entanglement",
    "Superfluid helium",
    "Bose-Einstein condensate",
    "Quantum tunneling",
    "Casimir effect",
    "Sonoluminescence",
    "Triboluminescence",
    "Plasma crystals",
    "Optical tweezers",
    "CRISPR gene editing",
    "mRNA vaccine tech",
    "CAR-T cell therapy",
    "Synthetic biology",
    "Optogenetics",
    "Brain organoids",
    "Lab-grown meat",
    "Vertical farming",
    "Phytoremediation",
    "Mycoremediation",
    "Blockchain immutability",
    "Neural networks",
    "GAN image creation",
    "Quantum computing",
    "LiDAR mapping",
    "Hyperspectral imaging",
    "Synthetic aperture radar",
    "Photogrammetry",
    "Lidar archaeology",
    "Sonar mapping",
    "Perovskite solar",
    "Fusion reactor designs",
    "Tidal lagoon power",
    "Geothermal plants",
    "Piezoelectric roads",
    "Algae biofuels",
    "Hydrogen storage",
    "Carbon capture",
    "Wave energy",
    "Artificial photosynthesis",
    "Quokka smiling behavior (Australia)",
    "Pangolin scale composition",
    "Okapi stripe patterns",
    "Saiga antelope nasal structure",
    "Maned wolf communication",
    "Proboscis monkey nose function",
    "Aye-aye foraging techniques",
    "Sunda flying lemur gliding",
    "Thorny devil water collection",
    "Star-nosed mole sensory organs",
    "Mimic octopus impersonation",
    "Peacock spider mating dance",
    "Decorator crab camouflage",
    "Vampire squid bioluminescence",
    "Hagfish slime defense",
    "Nudibranch chemical warfare",
    "Sea butterfly swimming",
    "Velvet worm slime jets",
    "Water bear desiccation",
    "Trap-jaw ant mandibles",
    # Space & Astronomy
    "Neutron star mergers creating heavy elements",
    "Oumuamua interstellar object trajectory",
    "Kuiper Belt object composition",
    "Solar prominence magnetic dynamics",
    "Exoplanet atmospheric spectroscopy",
    "Dark energy's effect on universe expansion",
    "Pulsar navigation systems",
    "Space elevator material requirements",
    "Lunar lava tube habitats",
    "Mars regolith farming challenges",
    # Technology & Engineering
    "Metamaterial acoustic cloaking",
    "Self-healing asphalt microbial integration",
    "4D printed shape-memory polymers",
    "Neuromorphic computing chips",
    "Wireless power transmission efficiency",
    "Biohybrid robot muscle actuation",
    "Quantum radar principles",
    "Haptic feedback virtual reality gloves",
    "Transparent solar window tech",
    "Aerodynamic hyperloop pod designs",

    # Unique Biology
    "Axolotl limb regeneration genetics",
    "Tardigrade radiation resistance proteins",
    "Venus flytrap action potential mechanisms",
    "Platypus electroreception biology",
    "Naked mole-rat cancer immunity",
    "Lyrebird vocal mimicry neurology",
    "Chameleon color change nanostructures",
    "Electric eel voltage generation",
    "Ant mill death spiral behavior",
    "Slime mold problem-solving patterns",

    # Ancient History
    "Roman concrete seawater crystallization",
    "Inca quipu accounting system",
    "Viking sunstone navigation",
    "Egyptian faience production",
    "Chinese seismograph design",
    "Persian qanat irrigation",
    "Mayan astronomical codices",
    "Polynesian star navigation",
    "Native American controlled burns",
    "Indus Valley urban planning",

    # Art & Culture
    "Japanese kintsugi philosophy",
    "Aboriginal dot painting symbology",
    "Flamenco compás rhythmic patterns",
    "Balinese gamelan metallurgy",
    "Korean hanji papermaking",
    "Indian kolam rice art",
    "Celtic knotwork mathematics",
    "Sufi whirling meditation",
    "Hawaiian hula chant meaning",
    "Russian icon painting techniques",

    # Physics Phenomena
    "Superfluid helium quantum effects",
    "Magnetohydrodynamic wave propulsion",
    "Sonoluminescence bubble collapse",
    "Quantum locking in superconductors",
    "Ferrofluid spike formation",
    "Plasma filament formation",
    "Optical tweezers manipulation",
    "Casimir effect vacuum energy",
    "Ball lightning theories",
    "Non-Newtonian fluid behavior",

    # Geology & Earth Science
    "Antelope Canyon erosion patterns",
    "Danakil Depression extremophiles",
    "Bioluminescent cave ecosystems",
    "Penitente snow formations",
    "Lava lake convection currents",
    "Sailing stone movement",
    "Mineral fluorescence causes",
    "Petrified wood formation",
    "Desert varnish creation",
    "Thunder egg geode growth",

    # Medical Marvels
    "CRISPR gene editing accuracy",
    "mRNA vaccine development",
    "Prosthetic neural integration",
    "Organoid intelligence development",
    "Synthetic antibody production",
    "Telomere extension therapies",
    "Nanobot drug delivery",
    "Bionic eye resolution",
    "Phantom limb mapping",
    "Stem cell differentiation",

    # Plant Kingdom
    "Corpse flower pollination",
    "Strangler fig growth patterns",
    "Dragon's blood tree sap",
    "Bamboo flowering cycles",
    "Carnivorous pitcher plant",
    "Welwitschia leaf longevity",
    "Baobab water storage",
    "Resurrection plant revival",
    "Mimosa pudica movement",
    "Ghost plant chlorophyll",

    # Materials Science
    "Graphene conductivity",
    "Aerogel insulation",
    "Self-cleaning surfaces",
    "Memory metal alloys",
    "Transparent aluminum",
    "Hydrogel wound healing",
    "Carbon nanotube strength",
    "Bioactive glass regeneration",
    "Phase-change materials",
    "Photochromic lenses",

    # Animal Behavior
    "Bee waggle dance",
    "Octopus camouflage",
    "Wolf pack hierarchy",
    "Elephant infrasound",
    "Dolphin signature whistles",
    "Bird magnetic sensing",
    "Primate tool use",
    "Spider web engineering",
    "Firefly synchronization",
    "Penguin huddling",

    # Chemistry Wonders
    "Supercritical CO₂ extraction",
    "Triboluminescent sparks",
    "Liquid crystal phases",
    "Metallic hydrogen creation",
    "Photocatalytic water splitting",
    "Enzyme catalytic power",
    "Polymorph crystal forms",
    "Self-assembling molecules",
    "Stoichiometric ratios",
    "Catalytic converter",

    # Food Science
    "Maillard reaction",
    "Sourdough microbiome",
    "Chocolate tempering",
    "Umami taste receptors",
    "Molecular gastronomy",
    "Aged cheese crystallization",
    "Coffee roasting profiles",
    "Fermentation cultures",
    "Food dehydration",
    "Spice preservation",

    # Weather Phenomena
    "Morning glory clouds",
    "Derecho storm systems",
    "Diamond dust formation",
    "Fire whirl creation",
    "Virga precipitation",
    "Sundog refraction",
    "Haboob dust walls",
    "Mammatus cloud",
    "Heat lightning",
    "Thundersnow",

    # Ancient Engineering
    "Egyptian pyramid alignment",
    "Roman aqueduct gradients",
    "Chinese earthquake detector",
    "Incan suspension bridges",
    "Persian windcatchers",
    "Mayan water filtration",
    "Greek fire composition",
    "Indian stepwells",
    "Native American earthworks",
    "Viking shipbuilding",

    # Forensic Science
    "Entomological timelines",
    "DNA phenotyping",
    "Gunshot residue",
    "Blood spatter",
    "Fingerprint lifting",
    "Toxicology screening",
    "Document authentication",
    "Facial reconstruction",
    "Soil analysis",
    "Tool mark",

    # Energy Tech
    "Fusion plasma",
    "Tidal generators",
    "Geothermal plants",
    "Biofuel algae",
    "Piezoelectric roads",
    "Hydrogen storage",
    "Thorium reactors",
    "Solar paint",
    "Wave energy",
    "Gravity storage",

    # Neuroscience
    "Neuroplasticity",
    "Mirror neurons",
    "Brain mapping",
    "Memory consolidation",
    "Synaptic pruning",
    "Pain perception",
    "Consciousness theories",
    "Sleep cycles",
    "Déjà vu",
    "Phantom smells",

    # Paleontology
    "Feathered dinosaurs",
    "Amber preservation",
    "Trace fossils",
    "Mass extinction",
    "DNA recovery",
    "Coprolite analysis",
    "Evolutionary missing links",
    "Cambrian explosion",
    "Fossil dating",
    "Paleoclimate",

    # Architecture
    "Biomimetic design",
    "Earthquake retrofitting",
    "Green roofs",
    "Tensegrity structures",
    "Passive heating",
    "Acoustic engineering",
    "3D-printed buildings",
    "Feng shui principles",
    "Gothic vaulting",
    "Bamboo construction"
]


def system_real(num_examples: int):
    return f"""
    You are a Memory Reinforcement Learning dataset generator for a Reactive Transformer model.
    Output must be a Python list of tuples containing initial query-answer pairs and list of follow-up interactions, without any code, explanation, or metadata.
    You are used to generate list of exactly {num_examples} tuples with three elements: question, answer and list of follow-up interactions, based on real world knowledge in form of simple stories
    """

def task_description_real(follow_ups_format: str, steps: int, num_examples: int, prior_steps: int, mode: str = 'multi'):
    return f"""
    # Memory Reinforcement Learning Data Generation - {steps} Step(s)
    
    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing multi-step memory retention. They will be
    used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory.
    
    Each example must:
    
    1. Start with initial factual QA (geography/science/history) - query and answer
    2. Contain {steps} follow-up QAs progressively referencing prior answers - list of queries and answers
    3. Each answer introduces 3-4 new facts while repeating 3+ previous facts
    4. Final interaction requires synthesizing info from {prior_steps}+ prior steps
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question]", "[Initial Answer]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """ if mode == 'multi' else f"""
    # Memory Reinforcement Learning Data Generation - {steps} Step(s) - Long-Range Strategy
    
    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing long-range and multi-step memory retention. They
    will be used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory.
    
    In Long-Range strategy each generated example should contain two completely different message **topics**:
    - first topic is used only in first and last interaction
    - second topic is used in all interactions between first and last
    
    Each example must:
    
    1. Start with initial factual QA (geography/science/history/others) - query and answer - for the first **topic**
    2. Contain {steps} follow-up QAs list of queries and answers
    3. First query in follow-up QAs (interactions) is changing **topic** into second one - not connected to first QA, and answer is also for new **topic**
    4. All next follow-up interactions, except the last one, have to continue the second **topic**:
        - Each answer introduces 3-4 new facts while repeating 3+ previous facts
    4. Final, last interaction is going back to first **topic** - asking a question about data from first QA pair (interaction) and the answer is containing most facts from first interaction
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question: **topic one**]", "[Initial Answer: **topic one**]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """

def critical_rules_real(steps: int, prior_steps: int, num_tokens: int, mode: str = 'multi', example_multiplier: int = 4):
    if mode == 'multi':
        return f"""
    ## CRITICAL RULES
    1. Factual Consistency:
      - All geographical/scientific facts must be accurate
      - No fictional elements - only real-world entities
      - Real-world knowledge, but only a basic facts like in examples
      - Simple facts from real-world information
    2. Language:
      - Model is pre-trained on wikipedia - it should be compatible
      - While dataset includes real world facts, they should be served in dialogue format
    3. Referential Integrity:
      - Each follow-up references 3+ facts from previous answers
      - Final answer must combine facts from {prior_steps} previous steps
    4. Progressive Retention:
      - Each answer is on the same topic
      - Knowledge is accumulated in answers
      - Queries reference previous answers
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES, like Mount Everest, Nile description, Amazon forest, Grand Canyon, Coral Reef, Sequoia Trees or Great Wall
      - be creative for topics
      - try a lot different topics
    6. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should similar as in examples
    """
    else:
        return f"""
    ## CRITICAL RULES
    1. Factual Consistency:
      - All geographical/scientific facts must be accurate
      - No fictional elements - only real-world entities
      - Real-world knowledge, but only a basic facts like in examples
      - Simple facts  from real-world information
    2. Language:
      - Model is pre-trained on wikipedia - it should be compatible
      - While dataset includes real world facts, they should be served in dialogue format
    3. Referential Integrity:
      - Each middle follow-up for **topic two** references 3+ facts from previous answers and trying to combine facts from {prior_steps} previous steps (except first step)
      - Final answer must change back to **topic one** and reference 3+ facts from initial QA pair/interaction
    4. Progressive Retention:
      - Each answer from the middle of sequence (except initial and last follow-up) is on the same topic (**topic two**)
      - Knowledge is accumulated in answers
      - Queries reference previous answers of the same **topic**
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES, like Mount Everest, Nile description, Amazon forest, Grand Canyon, Coral Reef, Sequoia Trees or Great Wall
      - be creative for topics
      - try a lot different topics
    7. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should similar as in examples
    8. **CRUCIAL/CRITICAL** !! - Long-Range Strategy
      - first, initial QA pair is connected to **topic one**
      - ensure that there is exactly {steps} follow-up QAs/interactions with two different **topics**
      - first {steps - 1} follow-ups are all exploring **topic two**
      - ensure that exactly the last, {steps} QA pair (interaction) is going back to **topic one**
      - ensure that the last {steps} interaction is not connected to **topic two**
    """

def final_instructions_real(steps: int, num_examples: int, mode: str = 'multi'):
    instructions = f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with geographical/scientific fact
    2. Design {steps} follow-ups requiring cumulative understanding
    3. Ensure final answer combines numerical, temporal, and spatial data
    4. Validate all  factual accuracy
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All facts consistent
    - {steps} follow-ups per entry
    - Final answer combines 3+ prior facts
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`
    
    Generate {num_examples} entries following EXACTLY this structure.
    """ if mode == 'multi' else f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with geographical/scientific fact with **topic one**
    2. Design {steps - 1} follow-ups requiring cumulative understanding for **topic two**
    3. Ensure final query is switching back to **topic one** and final answer is including data from initial QA pair
    4. Validate all factual accuracy
    5. All follow-ups should have {steps} elements: {steps - 1} for **topic two** and last 1 for switching back to **topic one**
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All facts consistent
    - exactly {steps} follow-ups per entry: {steps - 1} for **topic two** and last 1 for **topic one**
    - Final answer combines 3-4+ facts from first initial interaction
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`
    - Ensure, that after {steps - 1} follow-up QAs (interactions) for **topic two**, there's also final {steps} (last) query and answer for **topic one**
    
    Generate {num_examples} entries following EXACTLY this structure.
    """

    return instructions

ALL_PROMPTS_REAL = (system_real, task_description_real, critical_rules_real, final_instructions_real)

TOPICS_STORIES = [
    "The little frog who wanted to sing", "A magic cloud that rains candy", "The shy star who hid during the day",
    "Bella the bear's berry hunt", "The talking teapot in granny's kitchen", "Sammy squirrel's lost acorn",
    "The tiny turtle's big race", "A moon that smiled at bedtime", "The day flowers started dancing",
    "Pip the mouse's cheese adventure", "The rainbow bridge to cloud land", "Lily ladybug's polka dot party",
    "The friendly ghost in the attic", "Bubbles that wouldn't pop", "The carrot that grew too big",
    "Oscar owl's night school", "A seashell that whispered secrets", "The banana that went for a walk",
    "Fuzzy caterpillar's coat change", "The sock that escaped laundry day", "Daisy duck's double rainbow",
    "The pencil that drew by itself", "A snowflake that didn't melt", "Timmy turtle's upside-down day",
    "The giggling gingerbread man", "Wally worm's tunnel map", "The moon cheese picnic",
    "Buttons that came alive at night", "Sally snail's speedy dream", "The talking tree in the park",
    "Buzzy bee's honey hunt", "A book that changed its story", "The shy shadow who made friends",
    "Polly penguin's ice slide", "The runaway cookie jar", "Stars that played hide-and-seek",
    "Floppy bunny's magic ears", "A raindrop's journey home", "The ticklish teddy bear",
    "Misty mountain's morning song", "The sock puppet circus", "Coco chick's first peck",
    "The sleepy sundial", "Bubbles that carried wishes", "Pebble the rock's rolling adventure",
    "The friendly scarecrow dance", "Dewdrop's diamond necklace", "The hat that changed colors",
    "Silly sunflower's face contest", "The whispering willow tree", "Nutsy squirrel's treasure map",
    "The cloud shaped like a sheep", "Dizzy dragonfly's loop-de-loops", "The friendly neighborhood spider",
    "Mud puddle jumping contest", "The spoon that ran away", "Twilight firefly light show",
    "The leaf that wouldn't fall", "Snappy crab's sideways walk", "The marshmallow pillow fort",
    "Dandelion's flying seeds", "The hiccuping hedgehog", "Moonbeam's midnight picnic",
    "The giggle berries in the forest", "Sandy seashell's ocean song", "The shy mushroom in the rain",
    "Bouncy rabbit's cloud jump", "The forgetful garden gnome", "Sparkly fish's underwater disco",
    "The sleepy valley's yawn", "Peppermint stick's candy cane lane", "The lonely lightning bug",
    "Puddle's reflection friends", "The hiccuping teakettle", "Fuzzy slippers' midnight dance",
    "The rainbow fish scales", "Dewy spiderweb necklace", "The sneezing volcano",
    "Cookie's chocolate chip freckles", "The cloud pillow fight", "Squeaky mouse's cheese moon",
    "The whispering book pages", "Giggling creek's ticklish stones", "The shy cactus bloom",
    "Bubbly brook's pebble song", "The runaway rolling pin", "Starlight's bedtime lullaby",
    "The friendly dust bunny", "Mossy rock's soft blanket", "The dancing dish towels",
    "Sniffles the rabbit's cold day", "The giggling garden hose", "Moonpie's crumbly adventure",
    "The sleepy sunflower seed", "Pebble's skipping stone dream", "The hiccuping jack-in-the-box",
    "Fuzzy blanket fort adventure", "The whispering wind chimes", "Soggy waffle's syrup river",
    "The cloud that wore pajamas", "Twinkle the star's sparkle shine", "The runaway alarm clock",
    "Cinnamon stick's spicy day", "The sneezing pepper shaker", "Gummy bear's bouncy walk",
    "The shy toadstool umbrella", "Dandelion fluff's flying school", "The hiccuping watering can",
    "Marshmallow's campfire song", "The sleepy valley's dreams", "Puddle jumper's rainy day",
    "The giggling cookie jar", "Starry night's lullaby hum", "The runaway ice cube",
    "Snuggly sock's missing pair", "The whispering wheat field", "Bouncy ball's escape plan",
    "The cloud that lost its fluff", "Dewdrop's morning mirror", "The sneezing feather pillow",
    "Cookie dough's raw adventure", "The hiccuping rubber duck", "Fuzzy peach's summer fuzz",
    "The sleepy caterpillar's nap", "Rainbow's color mixing day", "The runaway jellybean",
    "Squeaky floorboard mystery", "The whispering library books", "Giggling soda bubbles",
    "The shy clam in the sand", "Moonbeam's silver path", "The runaway tea bag",
    "Pebble beach's rock concert", "The cloud that rained glitter", "Dandelion's wish parade",
    "The hiccuping accordion", "Sniffles the bear's honey hunt", "The friendly dust mite",
    "Bubbles' floating kingdom", "The sneezing pepper mill", "Gummy worm's garden tour",
    "The shy icicle's drip", "Starlight's wish collection", "The runaway meatball",
    "Soggy cereal's milk lake", "The whispering cave echoes", "Twinkle toes' ballet class",
    "The cloud that ate sunshine", "Dewy grass's ticklish feet", "The hiccuping kazoo",
    "Marshmallow's squishy day", "The sleepy hollow log", "Raindrop's window art",
    "The runaway eraser", "Fuzzy slipper's adventure", "The giggling popcorn",
    "Moonpie's crumb trail", "The shy ladybug spots", "Bubbly soda's fizz race",
    "The sneezing flower pollen", "Cinnamon roll's curly day", "The runaway noodle",
    "Squeaky gate's rusty song", "The whispering forest path", "Gummy bear's sticky hug",
    "The cloud that wore sunglasses", "Dandelion's parachute jump", "The hiccuping balloon",
    "Snuggly quilt's patchwork", "The shy snail's trail", "Starry night's wink",
    "The runaway grape", "Pebble's skipping contest", "The giggling rubber band",
    "Moonbeam's silver slide", "The sleepy valley's fog", "Rainbow's color swap",
    "The whispering seashell", "Bubbly bath's foam mountain", "The sneezing feather duster",
    "Cookie's crumb pathway", "The hiccuping whoopee cushion", "Fuzzy blanket's warm hug",
    "The runaway button", "Dewy morning's sparkle", "The shy firefly flash",
    "Starlight's nightlight glow", "The cloud that dreamed of sheep", "Giggling jelly's wobble",
    "The hiccuping straw", "Sniffles the mouse's cheese quest", "The friendly lint roller",
    "Bubbles' iridescent shine", "The sneezing cinnamon", "Gummy shark's fruit snack",
    "The shy blossom bud", "Moonpie's cream filling", "The runaway raisin",
    "Soggy toast's butter pond", "The whispering waterfall", "Twinkle toes' tap dance",
    "The cloud that wore a hat", "Dandelion fluff's flight plan", "The hiccuping harmonica",
    "Marshmallow's toasty day", "The sleepy rock's nap", "Raindrop's puddle art",
    "The runaway paperclip", "Fuzzy caterpillar's coat", "The giggling soda can",
    "Starry night's constellation", "The shy tadpole change", "Bubbly stream's babble",
    "The sneezing pepper", "Cinnamon swirl's bakery", "The runaway pea",
    "Squeaky swing's song", "The whispering canyon", "Gummy bear's jungle gym",
    "The cloud that cried raindrops", "Dewy web's morning jewels", "The hiccuping kazoo",
    "Snuggly pillow fort", "The shy fern uncurl", "Moonbeam's silver path",
    "The runaway blueberry", "Pebble beach's stone art", "The giggling pasta pot",
    "Rainbow's arch bridge", "The sleepy willow weep", "The whispering reed",
    "Bubbly brook's journey", "The sneezing flour sack", "Cookie dough's chocolate chunk",
    "The hiccuping balloon animal", "Fuzzy slipper's journey", "The runaway corn kernel",
    "Dewy grass's sparkle", "The shy moth dance", "Starlight's shooting streak",
    "The cloud that wore mittens", "Dandelion's wish flight", "The hiccuping whoopie cushion",
    "Marshmallow's campfire roast", "The sleepy mushroom cap", "Raindrop's window trail",
    "The runaway dice", "Fuzzy blanket's dream", "The giggling soda bottle",
    "Moonpie's lunar crumbs", "The shy bud bloom", "Bubbly lemonade's fizz",
    "The sneezing powder", "Cinnamon stick's stir", "The runaway green bean",
    "Squeaky door's creak", "The whispering dune", "Gummy worm's dirt tunnel",
    "The cloud that sneezed snow", "Dewdrop's sunrise prism", "The hiccuping party horn",
    "Snuggly teddy's hug", "The shy seed sprout", "Starry night's glitter",
    "The runaway cherry", "Pebble's ripple jump", "The giggling spaghetti",
    "Rainbow's color wheel", "The sleepy fern uncurl", "The whispering brook",
    "Bubbly creek's journey", "The sneezing salt shaker", "Cookie's chip eyes",
    "The hiccuping inflatable", "Fuzzy peach's fuzz", "The runaway popcorn kernel",
    "Dewy web's design", "The shy butterfly land", "Moonbeam's silver pool",
    "The cloud that wore boots", "Dandelion's parachute", "The hiccuping squeeze toy",
    "Marshmallow's squish", "The sleepy stone moss", "Raindrop's leaf slide",
    "The runaway bean", "Fuzzy sock's adventure", "The giggling root beer",
    "Starlight's twinkle", "The shy tadpole leg", "Bubbly soda's pop",
    "The sneezing sneeze", "Cinnamon bun's swirl", "The runaway blue pea",
    "Squeaky wheel's song", "The whispering glen", "Gummy bear's bounce",
    "The cloud that hiccuped rain", "Dewy petal's jewels", "The hiccuping duck call",
    "Snuggly quilt's warmth", "The shy seed pod", "Moonpie's eclipse bite",
    "The runaway cranberry", "Pebble's stone skip", "The giggling tea kettle",
    "Rainbow's promise", "The sleepy vine curl", "The whispering spring",
    "Bubbly fountain's dance", "The sneezing sugar", "Cookie's dough adventure",
    "The hiccuping bouncy castle", "Fuzzy blanket's nest", "The runaway almond",
    "Dewy dawn's glow", "The shy moth flutter", "Starlight's guide",
    "The cloud that wore a scarf", "Dandelion's clock", "The hiccuping rubber ball",
    "Marshmallow's fluff", "The sleepy lichen", "Raindrop's symphony",
    "The runaway cashew", "Fuzzy slipper's quest", "The giggling cola",
    "Moonbeam's reflection", "The shy bulb grow", "Bubbly spring's source",
    "The sneezing spice", "Cinnamon heart's beat", "The runaway lentil",
    "Squeaky hinge's story", "The whispering field", "Gummy shark's swim",
    "The cloud that laughed thunder", "Dewdrop's perfect round", "The hiccuping party favor",
    "Snuggly robe's comfort", "The shy tendril reach", "Starry night's map",
    "The runaway date", "Pebble's river ride", "The giggling percolator",
    "Rainbow's treasure", "The sleepy moss patch", "The whispering creek",
    "Bubbly geyser's surprise", "The sneezing cocoa", "Cookie's fortune paper",
    "The hiccuping beach ball", "Fuzzy sweater's lint", "The runaway pistachio",
    "Dewy morning's kiss", "The shy cocoon wiggle", "Moonbeam's guide",
    "The cloud that wore galoshes", "Dandelion's time", "The hiccuping squeak toy",
    "Marshmallow's cloud dream", "The sleepy stone river", "Raindrop's drum song",
    "The runaway fig", "Fuzzy dice's roll", "The giggling soda fountain",
    "Starlight's path", "The shy vine grip", "Bubbly stream's chuckle",
    "The sneezing cupcake", "Cinnamon tea's steam", "The runaway walnut",
    "Squeaky toy's adventure", "The whispering meadow", "Gummy octopus's arms",
    "The cloud that sang raindrops", "Dewdrop's journey", "The hiccuping flipper",
    "Snuggly cushion's support", "The shy bulb peek", "Moonpie's crescent smile",
    "The runaway prune", "Pebble's avalanche", "The giggling pressure cooker",
    "Rainbow's arch", "The sleepy ivy climb", "The whispering grove",
    "Bubbly pond's plop", "The sneezing icing sugar", "Cookie's smart chip",
    "The hiccuping pool float", "Fuzzy jacket's pocket", "The runaway pecan",
    "Dewy spider's art", "The shy larva chew", "Starlight's promise",
    "The cloud that wore earmuffs", "Dandelion's hour", "The hiccuping dog toy",
    "Marshmallow's snow friend", "The sleepy boulder", "Raindrop's tap dance",
    "The runaway apricot", "Fuzzy keychain's journey", "The giggling espresso machine",
    "Moonbeam's silver thread", "The shy root search", "Bubbly lake's splash",
    "The sneezing birthday cake", "Cinnamon apple's pie", "The runaway chestnut",
    "Squeaky clean story", "The whispering orchard", "Gummy snake's slither",
    "The cloud that whispered wind", "Dewdrop's perfect sphere", "The hiccuping swim fin",
    "Snuggly onesie's warmth", "The shy seedling stretch", "Starry night's blanket",
    "The runaway olive", "Pebble's landslide", "The giggling juicer",
    "Rainbow's end", "The sleepy mossy log", "The whispering marsh",
    "Bubbly swamp's pop", "The sneezing doughnut", "Cookie's crumb trail",
    "The hiccuping water wing", "Fuzzy earmuff's silence", "The runaway peanut",
    "Dewy dawn's first light", "The shy nymph swim", "Moonbeam's reflection",
    "The cloud that wore snowshoes", "Dandelion's minute", "The hiccuping bath toy",
    "Marshmallow's hot cocoa", "The sleepy granite", "Raindrop's melody",
    "The runaway lychee", "Fuzzy pen cap's journey", "The giggling blender",
    "Starlight's hope", "The shy root anchor", "Bubbly puddle's jump",
    "The sneezing wedding cake", "Cinnamon stick's stir", "The runaway hazelnut",
    "Squeaky marker's art", "The whispering vineyard", "Gummy lizard's climb",
    "The cloud that juggled raindrops", "Dewdrop's magnifier", "The hiccuping snorkel",
    "Snuggly sleeping bag's cocoon", "The shy shoot emerge", "Moonpie's dark side",
    "The runaway persimmon", "Pebble's erosion", "The giggling grinder",
    "Rainbow's double arc", "The sleepy vine twist", "The whispering fen",
    "Bubbly spring's birth", "The sneezing pancake", "Cookie's smartie eyes",
    "The hiccuping life jacket", "Fuzzy slipper's sole", "The runaway macadamia",
    "Dewy web's architecture", "The shy nymph flight", "Starlight's guide home"
]


def system_stories(num_examples: int):
    return f"""
    You are a Memory Reinforcement Learning dataset generator for a Reactive Transformer model.
    Output must be a Python list of tuples containing initial query-answer pairs and list of follow-up interactions, without any code, explanation, or metadata.
    You are used to generate list of exactly {num_examples} tuples with three elements: question, answer and list of follow-up interactions, based on fake data based on TinyStories dataset - simple stories
    """


def task_description_stories(follow_ups_format: str, steps: int, num_examples: int, prior_steps: int, mode: str = 'multi'):
    return f"""
    # Memory Reinforcement Learning Data Generation - {steps} Step(s)

    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing multi-step memory retention. They will be
    used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory.

    Dataset is based on simple synthetic TinyStories dataset. It should include a simple story in the first interaction,
    and follow-up questions and answers about details of that story.

    Each example must:

    1. Start with initial simple story QA - query and answer. Query is asking something like "Tell me a story about..." and answer is that story.
    2. Contain {steps} follow-up QAs progressively referencing prior answers - list of queries and answers, about details of the story from first interaction
    3. Each answer introduces 3-4 new facts while repeating 3+ previous facts
    4. Final interaction requires synthesizing info from {prior_steps}+ prior steps
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question]", "[Initial Answer]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """ if mode == 'multi' else f"""
    # Memory Reinforcement Learning Data Generation - {steps} Step(s) - Long-Range Strategy

    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing long-range and multi-step memory retention. They
    will be used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory.

    Dataset is based on simple synthetic TinyStories dataset. It should include a simple story in the first interaction,
    and follow-up questions and answers about details of that story.

    In Long-Range strategy each generated example should contain two completely different message **topics**:
    - first topic is used only in first and last interaction
    - second topic is used in all interactions between first and last

    Each example must:

    1. Start with initial simple story QA - query and answer. Query is asking something like "Tell me a story about..." and answer is that story. - for the first **topic**
    2. Contain {steps} follow-up QAs list of queries and answers
    3. First query in follow-up QAs (interactions) is changing **topic** into second one - not connected to first QA, and answer is also for new **topic** - it has to be a new story, similar as in first interaction
    4. All next follow-up interactions, except the last one, have to continue the second **topic**:
        - Each query is asking about story details and answer introduces 3-4 new details while repeating 3+ previous facts
    4. Final, last interaction is going back to first **topic/story** - asking a question about data from first QA pair (interaction) and the answer is containing most details about the story from first interaction
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question: **topic one**]", "[Initial Answer: **topic one**]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """


def critical_rules_stories(steps: int, prior_steps: int, num_tokens: int, mode: str = 'multi'):
    if mode == 'multi':
        return f"""
    ## CRITICAL RULES
    1. Based on simple stories:
      - Dataset is based on simple synthetic TinyStories dataset.
      - All elements are fictional
      - Includes only very basic facts from real world knowledge
      - It's in the form of very simple fake stories
      - Shouldn't include a lot of numbers - only basic facts
      - No calculations, etc., only the knowledge and just dialog content
    2. Non-formal language:
      - Model is pre-trained on stories with non-formal language - it should be the same
      - Dataset not includes real world facts, bot only simple fake stories and questions and answers about their details
    3. Referential Integrity:
      - Each follow-up references 3+ details from previous answers
      - Final answer must combine details from {prior_steps} previous steps
    4. Progressive Retention:
      - Each answer is on the same topic
      - Knowledge is accumulated in answers
      - Queries reference previous answers
      - First interaction includes base story and follow-up interactions include questions and answers about those story details
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES
      - be creative for topics
      - try a lot different topics
    6. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should be similar as in examples
    """
    else:
        return f"""
    ## CRITICAL RULES
    1. Based on simple stories:
      - Dataset is based on simple synthetic TinyStories dataset.
      - All elements are fictional
      - Includes only very basic facts from real world knowledge
      - It's in the form of very simple fake stories
      - Shouldn't include a lot of numbers - only basic facts
      - No calculations, etc., only the knowledge and just dialog content
    2. Non-formal language:
      - Model is pre-trained on stories with non-formal language - it should be the same
      - Dataset not includes real world facts, bot only simple fake stories and questions and answers about their details
    3. Referential Integrity:
      - Each middle follow-up for **topic two** references 3+ details from previous answers and trying to combine details from {prior_steps} previous steps (except first step)
      - Final answer must change back to **topic one** and reference 3+ details from initial QA pair/interaction
    4. Progressive Retention:
      - Each answer from the middle of sequence (except initial and last follow-up) is on the same topic (**topic two**)
      - Knowledge is accumulated in answers
      - Queries reference previous answers of the same **topic**
      - In Long Range mode, first interaction is base story, second interaction is a second base story, middle follow-ups are details of the second story and last interaction ask about details of first story
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES
      - be creative for topics
      - try a lot different topics
    7. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should be similar as in examples
    8. **CRUCIAL/CRITICAL** !! - Long-Range Strategy
      - first, initial QA pair is connected to **topic one**
      - ensure that there is exactly {steps} follow-up QAs/interactions with two different **topics**
      - first {steps - 1} follow-ups are all exploring **topic two**
      - ensure that exactly the last, {steps} QA pair (interaction) is going back to **topic one**
      - ensure that the last {steps} interaction is not connected to **topic two**
    """


def final_instructions_stories(steps: int, num_examples: int, mode: str = 'multi'):
    instructions = f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with simple synthetic story, based on the TinyStories dataset.
    2. Design {steps} follow-ups requiring cumulative exploration of the story details
    3. Ensure final answer combines details about story from multiple steps
    4. Validate all questions/answers details in case of memory retention
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All details consistent
    - {steps} follow-ups per entry
    - Final answer combines 3+ prior details
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`

    Generate {num_examples} entries following EXACTLY this structure.
    """ if mode == 'multi' else f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with simple synthetic story, based on the TinyStories dataset for **topic one**
    2. Then, first follow-up should include second base story, that's changing topic to **topic two**
    2. Design {steps - 1} follow-ups requiring cumulative exploration of the second story for **topic two**
    3. Ensure final query is switching back to **topic one** and final answer is including data from initial story
    4. Validate all questions/answers details in case of memory retention
    5. All follow-ups should have {steps} elements: {steps - 1} for **topic two** and last 1 for switching back to **topic one**
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All details consistent
    - exactly {steps} follow-ups per entry: {steps - 1} for **topic two** and last 1 for **topic one**
    - Final answer combines 3-4+ details from first initial interaction
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`
    - Ensure, that after {steps - 1} follow-up QAs (interactions) for **topic two**, there's also final {steps} (last) query and answer for **topic one**

    Generate {num_examples} entries following EXACTLY this structure.
    """

    return instructions

ALL_PROMPTS_STORIES = (system_stories, task_description_stories, critical_rules_stories, final_instructions_stories)

TOPICS_AI = topics = [
    # NLP: Transformers
    "How do Transformers improve upon RNNs for NLP tasks?",
    "The architecture of Large Language Models (LLMs) explained",
    "What are the key innovations in BERT for bidirectional context?",
    "Scaling LLMs: Challenges and solutions",
    "Multimodal models: Combining text and images in AI",
    "Attention mechanisms in Transformers: A deep dive",
    "Fine-tuning GPT models for specific domains",
    "The role of positional encodings in Transformers",
    "How do LLMs handle long-context conversations?",
    "Energy consumption in LLM inference: Problems and mitigations",
    "Comparing GPT-3 and LLaMA: Strengths and weaknesses",
    "The impact of layer normalization in Transformer models",
    "Multimodal AI: Text-to-speech and beyond",
    "Training strategies for efficient LLM deployment",
    "Self-attention vs. cross-attention in multimodal tasks",
    "The future of LLM scalability with sparse attention",
    "How do Transformers handle out-of-vocabulary words?",
    "Optimizing Transformers for real-time applications",
    "The role of dropout in stabilizing Transformer training",
    "Multilingual LLMs: Challenges and advancements",
    "Decoder-only vs. encoder-decoder Transformers",
    "The effect of context window size on LLM performance",
    "How does multi-head attention enhance Transformer models?",
    "The role of tokenization in LLM preprocessing",
    "Evaluating LLM performance with BLEU and ROUGE metrics",
    "The impact of pre-training data size on LLM quality",
    "Cross-lingual transfer learning in Transformer models",
    "The use of adapters for efficient fine-tuning of LLMs",
    "How do mixture-of-experts (MoE) models improve scalability?",
    "The role of residual connections in Transformer stability",
    "Multimodal fusion techniques in AI models",
    "The challenge of catastrophic forgetting in LLMs",
    "How do LLMs generate coherent long-form text?",
    "The impact of quantization on LLM inference speed",
    "Transformers for low-resource language processing",
    "The role of embeddings in Transformer-based models",
    "How do attention heads contribute to model interpretability?",
    "The evolution of Transformer variants (e.g., ViT, T5)",
    "Multimodal reasoning: Text and audio integration",
    "The effect of batch size on Transformer training",
    "How do LLMs handle ambiguous queries?",
    "The role of speculative decoding in LLM efficiency",
    "Transformers in real-time translation systems",
    "The impact of data diversity on LLM generalization",
    "Multimodal question-answering systems",
    "The future of sparse attention mechanisms in LLMs",
    "How do Transformers support few-shot learning?",
    "The role of memory augmentation in conversational AI",
    "Evaluating fairness in multimodal Transformer models",
    "The impact of hardware on Transformer training costs",
    "Transformers for code generation and understanding",
    "The role of attention dropout in model robustness",
    "Multimodal summarization techniques",
    "How do LLMs adapt to domain-specific tasks?",
    "The effect of pre-training objectives on LLM performance",
    "Transformers in sentiment analysis applications",
    "The role of curriculum learning in LLM training",
    "Multimodal dialogue systems: Challenges and solutions",
    "How do LLMs handle noisy input data?",
    "The impact of model size on Transformer efficiency",
    "Transformers for knowledge graph completion",
    "The role of attention masking in sequence prediction",
    "Multimodal generative models: Text and images",
    "How do LLMs support interactive learning?",
    "The future of energy-efficient Transformer designs",

    "The impact of rotary positional embeddings in Transformers",
    "How do LoRA adapters enhance LLM fine-tuning?",
    "The role of speculative sampling in LLM generation",
    "Optimizing attention with ALiBi positional encodings",
    "The effect of context length on multimodal fusion",
    "How do FlashAttention algorithms improve Transformer efficiency?",
    "The use of knowledge distillation in LLM compression",
    "Comparing Performer and Linformer for long-context attention",
    "The role of prompt engineering in LLM performance",
    "How do retrieval-augmented LLMs handle external knowledge?",
    "The impact of token pruning on LLM inference",
    "Multimodal alignment techniques for text and video",
    "The future of zero-shot learning in Transformer models",
    "How do efficient Transformers handle low-resource languages?",
    "The role of dynamic batching in LLM training",
    "Comparing attention sparsity methods: S4 vs. Longformer",
    "The effect of temperature scaling on LLM outputs",
    "How do LLMs support multi-task learning?",
    "The impact of curriculum learning on Transformer convergence",
    "Multimodal sentiment analysis with Transformers",
    "The role of contrastive learning in LLM pre-training",
    "How do efficient attention mechanisms reduce memory usage?",
    "The future of federated learning with LLMs",
    "Comparing masked vs. autoregressive pre-training",
    "The impact of data curation on multimodal models",
    "How do LLMs handle code-switching in dialogue?",
    "The role of attention dropout in multimodal tasks",
    "Optimizing LLMs for edge computing devices",
    "The effect of model parallelism on Transformer training",
    "How do LLMs integrate with knowledge graphs?",
    "The impact of quantization-aware training on LLMs",
    "Multimodal question generation techniques",
    "The future of cross-modal transfer learning",
    "How do LLMs support interactive storytelling?",
    "The role of attention masking in privacy preservation",
    "Comparing sparse vs. dense Transformer layers",
    "The impact of pre-training corpus size on generalization",
    "How do LLMs handle real-time translation?",
    "The role of layer-wise attention in efficiency",
    "Optimizing Transformers for low-latency applications",
    "The effect of data augmentation on multimodal training",
    "How do LLMs support few-shot translation?",
    "The impact of attention head pruning on performance",
    "Multimodal dialogue state tracking",
    "The future of energy-aware LLM design",
    "How do LLMs handle ambiguous multimodal inputs?",
    "The role of attention pooling in Transformer outputs",
    "Comparing online vs. offline LLM training",
    "The impact of hardware accelerators on LLM scalability",
    "How do LLMs support domain adaptation?",
    "The role of attention regularization in stability",
    "Optimizing LLMs for decentralized systems",
    "The effect of context window expansion on accuracy",
    "How do LLMs integrate with reinforcement learning?",
    "The impact of multi-modal pre-training objectives",
    "Multimodal text-to-3D generation",
    "The future of interpretable Transformer models",
    "How do LLMs handle noisy multimodal data?",
    "The role of attention fusion in cross-modal tasks",
    "Comparing adaptive vs. fixed attention mechanisms",
    "The impact of training data diversity on LLMs",
    "How do LLMs support continuous learning?",
    "The role of attention-based memory in dialogue systems",

    # NLP - early architectures
    "The evolution from RNNs to LSTMs in NLP",
    "How do State Space Models (SSMs) differ from RNNs?",
    "Neural Turing Machines (NTMs): A memory-augmented approach",
    "Memory-Augmented Transformers: Bridging past and present",
    "The limitations of traditional RNNs in long sequences",
    "Comparing GRU and LSTM architectures",
    "The role of attention in early memory-augmented networks",
    "How SSMs improve efficiency over Transformers",
    "The history of NTM development in AI research",
    "Recurrent Neural Networks: Strengths and weaknesses",
    "The impact of time delays in RNN processing",
    "How do Echo State Networks differ from RNNs?",
    "The role of gating mechanisms in LSTM models",
    "Comparing SSMs to traditional recurrent architectures",
    "The challenge of vanishing gradients in RNNs",
    "Memory-augmented networks for sequential tasks",
    "The evolution of attention mechanisms pre-Transformer",
    "How do NTMs handle external memory access?",
    "The role of forget gates in LSTM performance",
    "SSMs in real-time sequence modeling",
    "The limitations of early NLP memory models",
    "Hybrid RNN-Transformer models: Pros and cons",
    "The impact of memory size on NTM efficiency",
    "How do SSMs handle long-term dependencies?",
    "Comparing memory-augmented models to Transformers",

    "The role of time-series prediction in RNN evolution",
    "How do Liquid State Machines differ from RNNs?",
    "The impact of reservoir computing on memory models",
    "Comparing attention-augmented RNNs to Transformers",
    "The role of memory cells in early neural networks",
    "How do Hopfield networks handle associative memory?",
    "The effect of backpropagation through time on RNNs",
    "The evolution of gated recurrent units (GRUs)",
    "How do SSMs integrate with convolutional layers?",
    "The impact of memory bandwidth on NTM performance",
    "Comparing recurrent vs. feedforward memory models",
    "The role of external memory in early AI",
    "How do differential equations enhance SSMs?",
    "The effect of memory size on NTM scalability",
    "The evolution of attention mechanisms pre-2017",
    "How do RNNs handle variable-length inputs?",
    "The impact of gradient clipping on RNN stability",
    "Comparing memory-augmented models to LSTMs",
    "The role of feedback loops in recurrent architectures",
    "How do SSMs support real-time processing?",
    "The effect of memory initialization on NTMs",
    "The evolution of hybrid RNN-Transformer models",
    "How do early memory models handle noise?",
    "The impact of sequence length on RNN training",
    "Comparing stateful vs. stateless memory models",

    # NLP: general knowledge
    "The rise of statistical NLP before deep learning",
    "N-grams and their role in early language modeling",
    "How rule-based systems shaped early NLP",
    "The impact of Hidden Markov Models in NLP",
    "Early machine translation: Challenges and solutions",
    "The transition from symbolic AI to statistical methods",
    "Bag-of-words model in pre-deep learning era",
    "The role of stemming and lemmatization in NLP",
    "Early text classification techniques",
    "The influence of Chomsky’s theories on NLP",
    "Statistical language models before neural networks",
    "The development of part-of-speech tagging",
    "Early sentiment analysis methods",
    "The role of dictionaries in pre-NLP systems",
    "Text preprocessing in the pre-deep learning era",
    "The impact of TF-IDF on information retrieval",
    "Early NLP applications in chatbots",
    "The evolution of word embeddings pre-Transformer",
    "Statistical parsing techniques in NLP history",
    "The challenge of ambiguity in early NLP",
    "The role of syntax trees in pre-deep learning",
    "Early named entity recognition methods",
    "The influence of corpus linguistics on NLP",
    "Pre-deep learning text generation techniques",
    "The history of machine-readable dictionaries",

    "The influence of Chomsky’s syntax on early NLP",
    "How did probabilistic models shape pre-NLP?",
    "The role of thesauri in early text analysis",
    "The impact of early speech recognition systems",
    "Comparing rule-based vs. statistical NLP",
    "The evolution of morphological analysis",
    "How did early chatbots function?",
    "The role of finite-state automata in NLP",
    "The impact of corpus size on pre-deep learning",
    "Comparing n-gram models to modern tokenization",
    "The evolution of text summarization techniques",
    "How did early NLP handle ambiguity?",
    "The role of linguistic rules in pre-NLP",
    "The impact of early machine translation models",
    "Comparing statistical parsing to deep learning",
    "The evolution of word sense disambiguation",
    "How did early NLP address multilingualism?",
    "The role of dictionaries in text processing",
    "The impact of early information retrieval",
    "Comparing manual vs. automated feature engineering",
    "The evolution of sentiment analysis pre-NLP",
    "How did early NLP handle syntax errors?",
    "The role of context-free grammars",
    "The impact of early text generation systems",
    "Comparing pre-deep learning NLP tools",

    # Gen AI
    "How do diffusion models work in image generation?",
    "The principles of Generative Adversarial Networks (GANs)",
    "Comparing VAEs and GANs for generative tasks",
    "Applications of diffusion models in video synthesis",
    "Energy efficiency in generative model training",
    "The role of noise in diffusion-based generation",
    "Generative models for 3D object creation",
    "Challenges in scaling diffusion models",
    "Autoregressive models vs. diffusion in generation",
    "The impact of latent space on generative quality",
    "GANs for data augmentation in AI",
    "The role of discriminators in GAN training",
    "Diffusion models in audio synthesis",
    "Comparing generative models for text vs. images",
    "The challenge of mode collapse in GANs",
    "VAEs for unsupervised learning tasks",
    "Generative models in medical imaging",
    "The impact of training data on GAN performance",
    "Diffusion processes in probabilistic modeling",
    "The future of generative AI beyond NLP",
    "GANs for style transfer applications",
    "The role of regularization in VAE training",
    "Generative models for synthetic data generation",
    "The energy cost of training diffusion models",
    "Hybrid generative models: GANs and VAEs",

    "The role of noise schedules in diffusion models",
    "How do normalizing flows differ from VAEs?",
    "The impact of GAN discriminators on quality",
    "Comparing autoregressive vs. latent variable models",
    "The evolution of energy-based generative models",
    "How do diffusion models handle high-dimensional data?",
    "The role of adversarial training in GANs",
    "The impact of latent space regularization",
    "Comparing GANs to flow-based models",
    "The evolution of generative models for audio",
    "How do VAEs support data imputation?",
    "The role of KL divergence in VAE training",
    "The impact of dataset size on generative quality",
    "Comparing diffusion vs. autoregressive generation",
    "The evolution of hybrid generative architectures",
    "How do generative models handle outliers?",
    "The role of perceptual loss in GANs",
    "The impact of training stability on GANs",
    "Comparing unsupervised vs. supervised generation",
    "The evolution of generative models for video",
    "How do GANs support domain adaptation?",
    "The role of attention in generative models",
    "The impact of generative model size",
    "Comparing real-time vs. offline generation",
    "The evolution of energy-efficient generative AI",

    # Deep Learning - theory
    "The mathematics behind backpropagation",
    "Activation functions: ReLU, Sigmoid, and beyond",
    "Understanding gradient descent optimization",
    "The role of weight initialization in neural networks",
    "How do convolutional neural networks (CNNs) work?",
    "The theory of overfitting in deep learning",
    "Regularization techniques in neural network training",
    "The impact of batch size on model convergence",
    "Exploring the vanishing gradient problem",
    "Deep learning loss functions: MSE, Cross-Entropy, etc.",
    "The theory of residual connections in deep networks",
    "How do batch normalization layers improve training?",
    "The role of learning rates in optimization",
    "Understanding momentum in gradient descent",
    "The impact of network depth on performance",
    "How do dropout layers prevent overfitting?",
    "The mathematics of convolutional filters",
    "The theory of recurrent neural network dynamics",
    "How do autoencoders work in unsupervised learning?",
    "The role of skip connections in deep architectures",
    "Understanding the curse of dimensionality",
    "The impact of data augmentation on model generalization",
    "How do adversarial examples affect neural networks?",
    "The theory of attention mechanisms in deep learning",
    "The role of pooling layers in CNNs",
    "How do generative adversarial networks function?",
    "The mathematics of weight decay regularization",
    "The impact of network width on capacity",
    "How do RNNs handle sequential data?",
    "The theory of transfer learning in deep networks",
    "The role of activation clipping in training stability",
    "Understanding the ReLU activation function",
    "The impact of gradient clipping on convergence",
    "How do deep belief networks work?",
    "The theory of layer-wise pre-training",
    "The role of softmax in classification tasks",
    "How do Siamese networks compare images?",
    "The mathematics of cross-validation",
    "The impact of label noise on training",
    "How do capsule networks differ from CNNs?",
    "The theory of neural network pruning",
    "The role of embeddings in deep learning",
    "How do GANs learn data distributions?",
    "The impact of model capacity on performance",
    "The theory of stochastic gradient descent",
    "How do attention layers enhance CNNs?",
    "The role of regularization in RNNs",
    "The mathematics of matrix factorization",
    "The impact of learning rate schedules",
    "How do deep networks handle non-linear data?",
    "The theory of energy-based models",
    "The role of sparsity in neural networks",
    "How do transformers generalize attention?",
    "The impact of data imbalance on training",
    "The theory of Bayesian neural networks",
    "How do deep networks learn features?",
    "The role of kernel methods in deep learning",

    "The role of Jacobian matrices in neural networks",
    "How do Hessian-free optimization methods work?",
    "The impact of second-order optimization",
    "Comparing stochastic vs. deterministic training",
    "The evolution of neural network activation functions",
    "How do skip connections mitigate vanishing gradients?",
    "The role of spectral normalization",
    "The impact of layer-wise pre-training",
    "Comparing deep vs. shallow neural networks",
    "The evolution of convolutional kernel design",
    "How do attention layers generalize convolutions?",
    "The role of weight sharing in efficiency",
    "The impact of learning rate annealing",
    "Comparing batch vs. layer normalization",
    "The evolution of recurrent layer design",
    "How do neural networks handle non-linearities?",
    "The role of adversarial regularization",
    "The impact of data normalization on training",
    "Comparing gradient-based vs. evolutionary methods",
    "The evolution of network pruning techniques",
    "How do deep networks learn hierarchical features?",
    "The role of attention in feature extraction",
    "The impact of dropout rate selection",
    "Comparing online vs. batch learning",
    "The evolution of loss function design",
    "How do neural networks handle sparse data?",
    "The role of momentum in optimization",
    "The impact of weight decay on regularization",
    "Comparing supervised vs. unsupervised pre-training",
    "The evolution of attention-based layers",
    "How do deep networks handle overfitting?",
    "The role of ensemble methods in stability",
    "The impact of data shuffling on convergence",
    "Comparing adaptive learning rates",
    "The evolution of recurrent attention",
    "How do neural networks support transfer learning?",
    "The role of gradient norm clipping",
    "The impact of batch size on generalization",
    "Comparing dense vs. sparse networks",
    "The evolution of multi-task learning",
    "How do deep networks handle imbalanced data?",
    "The role of attention in sequence modeling",
    "The impact of network depth on accuracy",
    "Comparing local vs. global optimization",
    "The evolution of energy-based learning",
    "How do neural networks handle noisy labels?",
    "The role of attention in dimensionality reduction",
    "The impact of training data quality",
    "Comparing recurrent vs. convolutional memory",

    # Deep Learning - libs
    "Getting started with TensorFlow for deep learning",
    "PyTorch vs. TensorFlow: A practical comparison",
    "Optimizing models with Keras",
    "Using CUDA for GPU-accelerated training",
    "Best practices for debugging neural networks",
    "Deploying deep learning models with ONNX",
    "Hyperparameter tuning with Optuna",
    "Practical tips for efficient model inference",
    "Using Hugging Face Transformers library",
    "Setting up a deep learning environment with Docker",
    "Training models with mixed precision in PyTorch",
    "Deploying models with TensorFlow Serving",
    "Using JAX for high-performance deep learning",
    "Practical data loading with PyTorch DataLoader",
    "Optimizing GPU memory usage in training",
    "Using TensorBoard for model visualization",
    "Implementing custom layers in Keras",
    "Practical batch normalization in deep networks",
    "Deploying models to edge devices with TensorFlow Lite",
    "Using Dask for distributed deep learning",
    "Practical model checkpointing in PyTorch",
    "Training with gradient accumulation",
    "Using Horovod for distributed training",
    "Practical transfer learning with pre-trained models",
    "Deploying models with Flask API",
    "Using Ray for scalable deep learning",
    "Practical model quantization techniques",
    "Training with custom loss functions",
    "Using Weights & Biases for experiment tracking",
    "Practical GPU debugging with NVIDIA tools",
    "Deploying models with AWS SageMaker",
    "Using ONNX Runtime for inference optimization",
    "Practical data augmentation with Albumentations",
    "Training with dynamic batch sizes",
    "Using FastAI for rapid prototyping",
    "Practical model pruning techniques",
    "Deploying models with Google Cloud AI",
    "Using Catalyst for deep learning workflows",
    "Practical use of learning rate finders",
    "Training with multi-GPU setups",
    "Using MLflow for model management",
    "Practical model ensembling techniques",
    "Deploying models with Azure ML",
    "Using PyTorch Lightning for structured training",
    "Practical hyperparameter search with Ray Tune",
    "Training with custom datasets in TensorFlow",

    "Using MXNet for distributed deep learning",
    "Practical model deployment with TorchServe",
    "Optimizing models with Chainer",
    "Using Caffe2 for mobile inference",
    "Practical data parallelism with Horovod",
    "Deploying models with Core ML",
    "Using Theano for custom layers",
    "Practical model quantization with TensorRT",
    "Training with distributed TensorFlow",
    "Using OpenVINO for edge deployment",
    "Practical model profiling with NVIDIA Nsight",
    "Deploying models with ONNX.js",
    "Using Catalyst for experiment tracking",
    "Practical hyperparameter optimization with Hyperopt",
    "Training with multi-node setups",
    "Using Gluon for dynamic graphs",
    "Practical model serving with Seldon",
    "Deploying models with AWS Lambda",
    "Using Ignite for training loops",
    "Practical data loading with DALI",
    "Training with custom optimizers",
    "Using CNTK for deep learning",
    "Practical model compression techniques",
    "Deploying models with Azure Functions",
    "Using Ray Tune for distributed tuning",
    "Practical model benchmarking",
    "Training with federated learning frameworks",
    "Using PaddlePaddle for research",
    "Practical GPU memory management",
    "Deploying models with Kubernetes",
    "Using Skorch for Scikit-learn integration",
    "Practical model versioning",
    "Training with custom loss functions",
    "Using DeepSpeed for large-scale training",
    "Practical model debugging techniques",
    "Deploying models with Edge TPU",
    "Using Habana Gaudi for training",
    "Practical data augmentation pipelines",
    "Training with mixed hardware setups",
    "Using NNVM for model compilation",
    "Practical model inference optimization",
    "Deploying models with Flask-RESTful",
    "Using TFLite for mobile deployment",
    "Practical model ensemble deployment",
    "Training with custom datasets",
    "Using XLA for JIT compilation",
    "Practical model pruning with PyTorch",
    "Deploying models with GCP AI Platform",
    "Using AllenNLP for NLP tasks",

    # Machine Learning - theory
    "The bias-variance tradeoff in ML",
    "How do decision trees work?",
    "Support Vector Machines: Theory and applications",
    "The mathematics of k-means clustering",
    "Understanding ensemble methods like Random Forest",
    "The role of feature engineering in ML",
    "Bayesian methods in machine learning",
    "Overfitting vs. underfitting in predictive models",
    "The theory of logistic regression",
    "How do naive Bayes classifiers work?",
    "The mathematics of linear regression",
    "Understanding boosting algorithms",
    "The role of cross-validation in ML",
    "How do SVM kernels enhance classification?",
    "The theory of dimensionality reduction",
    "The impact of feature scaling on ML models",
    "How do gradient boosting machines work?",
    "The mathematics of expectation-maximization",
    "Understanding bagging in ensemble learning",
    "The role of regularization in linear models",
    "How do k-nearest neighbors work?",
    "The theory of anomaly detection",
    "The impact of data quality on ML performance",
    "How do decision boundaries form in SVMs?",
    "The mathematics of probabilistic models",
    "Understanding multi-class classification",
    "The role of cost functions in ML",
    "How do clustering algorithms evaluate quality?",
    "The theory of online learning",
    "The impact of outliers on ML models",
    "How do ensemble methods reduce variance?",
    "The mathematics of information gain",
    "Understanding reinforcement learning basics",
    "The role of hyperparameters in ML",
    "How do tree-based models handle categorical data?",
    "The theory of model interpretability",
    "The impact of training data size on ML",
    "How do probabilistic graphical models work?",
    "The mathematics of kernel density estimation",
    "Understanding active learning strategies",

    "The role of Fisher information in ML",
    "How do variational inference methods work?",
    "The impact of Bayesian priors on models",
    "Comparing maximum likelihood vs. MAP",
    "The evolution of online learning algorithms",
    "How do kernel methods enhance SVMs?",
    "The role of entropy in information theory",
    "The impact of feature selection on accuracy",
    "Comparing generative vs. discriminative models",
    "The evolution of ensemble pruning",
    "How do multi-armed bandits optimize decisions?",
    "The role of regret minimization",
    "The impact of data drift on models",
    "Comparing active vs. passive learning",
    "The evolution of meta-learning",
    "How do neural tangent kernels work?",
    "The role of PAC learning theory",
    "The impact of label noise on convergence",
    "Comparing online vs. offline reinforcement",
    "The evolution of imitation learning",
    "How do Gaussian processes handle uncertainty?",
    "The role of kernel trick in SVMs",
    "The impact of dimensionality curse",
    "Comparing batch vs. incremental learning",
    "The evolution of transfer learning theory",
    "How do ensemble methods reduce bias?",
    "The role of information bottleneck",
    "The impact of model capacity",
    "Comparing supervised vs. semi-supervised",
    "The evolution of robust optimization",
    "How do ML models handle concept drift?",
    "The role of attention in ML interpretability",
    "The impact of training data distribution",
    "Comparing online vs. batch optimization",
    "The evolution of lifelong learning",
    "How do ML models handle missing features?",

    # Machine Learning - libs
    "Using Scikit-learn for ML pipelines",
    "Building ML models with XGBoost",
    "Practical data preprocessing with Pandas",
    "Deploying ML models with MLflow",
    "Automating ML workflows with AutoML",
    "Using LightGBM for gradient boosting",
    "Practical feature selection with Scikit-learn",
    "Deploying models with FastAPI",
    "Using CatBoost for categorical data",
    "Practical hyperparameter tuning with GridSearch",
    "Building pipelines with Scikit-learn",
    "Deploying ML models with Kubeflow",
    "Using SHAP for model interpretability",
    "Practical data splitting with train-test",
    "Deploying models with Flask",
    "Using TPOT for automated ML",
    "Practical model evaluation metrics",
    "Building ensemble models with Scikit-learn",
    "Deploying ML models with SageMaker",
    "Using Eli5 for feature importance",
    "Practical cross-validation techniques",
    "Deploying models with Google ML Engine",
    "Using Optuna with Scikit-learn",
    "Practical data imputation methods",
    "Building custom transformers in Scikit-learn",

    "Using H2O.ai for automated ML",
    "Practical model deployment with DataRobot",
    "Optimizing models with Prophet",
    "Using PyCaret for rapid prototyping",
    "Practical feature engineering with Featuretools",
    "Deploying models with Streamlit",
    "Using Auto-sklearn for hyperparameter tuning",
    "Practical model monitoring with Evidently",
    "Training with TPOT pipelines",
    "Using Orange for visual ML",
    "Practical model explainability with LIME",
    "Deploying models with BentoML",
    "Using KNIME for data workflows",
    "Practical model validation techniques",
    "Training with custom Scikit-learn estimators",
    "Using MLBox for end-to-end ML",
    "Practical data preprocessing with Dask-ML",
    "Deploying models with Cortex",
    "Using EvalML for automated evaluation",
    "Practical model drift detection",
    "Training with custom XGBoost models",
    "Using Feature-engine for transformations",
    "Practical model serving with FastAPI",
    "Deploying models with Kubeflow Pipelines",
    "Using SHAP for feature importance",

    # Math
    "Linear algebra in neural network computations",
    "The role of calculus in gradient descent",
    "Probability theory in machine learning",
    "Matrix operations for attention mechanisms",
    "Optimization with stochastic gradient descent",
    "The mathematics of vector normalization",
    "Eigenvalues in PCA and dimensionality reduction",
    "The role of derivatives in backpropagation",
    "Probability distributions in Bayesian models",
    "Matrix multiplication in deep learning",
    "The mathematics of loss function optimization",
    "Understanding covariance in data analysis",
    "The role of tensors in neural networks",
    "Calculus of variations in optimization",
    "Probability density estimation techniques",
    "The mathematics of singular value decomposition",
    "Linear transformations in feature extraction",
    "The role of determinants in matrix operations",
    "Statistical measures in ML model evaluation",
    "The mathematics of Fourier transforms",
    "Understanding orthogonality in neural networks",
    "The role of gradients in optimization",
    "Probability theory in generative models",
    "Matrix inversion in deep learning",
    "The mathematics of correlation analysis",

    "The role of Lie algebras in neural networks",
    "How do Riemannian manifolds enhance optimization?",
    "The impact of stochastic processes",
    "Comparing Laplace approximations",
    "The evolution of numerical stability",
    "How do symplectic integrators work?",
    "The role of Markov chains in ML",
    "The impact of Monte Carlo methods",
    "Comparing Bayesian vs. frequentist approaches",
    "The evolution of matrix factorization",
    "How do partial differential equations apply?",
    "The role of graph theory in attention",
    "The impact of spectral clustering",
    "Comparing convex vs. non-convex optimization",
    "The evolution of numerical linear algebra",
    "How do tensor decompositions enhance models?",
    "The role of stochastic gradient Langevin",
    "The impact of variance reduction",
    "Comparing deterministic vs. probabilistic",
    "The evolution of optimization landscapes",
    "How do manifolds affect training?",
    "The role of harmonic analysis",
    "The impact of matrix norms",
    "Comparing iterative solvers",
    "The evolution of statistical inference",

    # Data Science
    "Data cleaning techniques in Python",
    "Using NumPy for efficient data manipulation",
    "Feature extraction with Scikit-learn",
    "Handling missing data in datasets",
    "Building ETL pipelines for AI",
    "Data visualization with Matplotlib",
    "Using Pandas for data aggregation",
    "Practical data normalization methods",
    "Handling categorical data in datasets",
    "Building data pipelines with Apache Airflow",
    "Using Seaborn for statistical visualization",
    "Practical data encoding techniques",
    "Handling time-series data in Python",
    "Building data lakes for AI projects",
    "Using Dask for big data processing",
    "Practical outlier detection methods",
    "Data transformation with Scikit-learn",
    "Building data warehouses for ML",
    "Using Plotly for interactive visualization",
    "Practical data sampling techniques",
    "Handling imbalanced datasets",
    "Building feature stores for ML",
    "Using SQL for data querying",
    "Practical data versioning methods",
    "Data quality assessment in AI",

    "Using Spark for big data preprocessing",
    "Practical data integration with Apache NiFi",
    "Optimizing data pipelines with Airbyte",
    "Using DataFusion for query optimization",
    "Practical data lineage tracking",
    "Deploying data lakes with Delta Lake",
    "Using Great Expectations for data quality",
    "Practical data anonymization techniques",
    "Training with synthetic data generation",
    "Using Deequ for data validation",
    "Practical data versioning with DVC",
    "Deploying data warehouses with Snowflake",
    "Using Feast for feature stores",
    "Practical data deduplication methods",
    "Training with streaming data pipelines",
    "Using KubeFlow for data workflows",
    "Practical data schema evolution",
    "Deploying data hubs with Databricks",
    "Using Mage for ETL automation",
    "Practical data profiling techniques",
    "Training with federated data sources",
    "Using dbt for data transformation",
    "Practical data governance strategies",
    "Deploying data meshes",
    "Using Hudi for real-time data",

    # History
    "The birth of AI: Turing and the Imitation Game",
    "Early expert systems in the 1980s",
    "The AI winter: Causes and lessons",
    "The rise of machine learning in the 1990s",
    "From perceptrons to deep networks",
    "Milestones in neural network history",
    "The development of the first chatbots",
    "The impact of the Dartmouth Conference",
    "Early AI in game playing",
    "The evolution of expert systems",
    "The rise of symbolic AI",
    "The influence of cybernetics on AI",
    "Early neural network models",
    "The development of backpropagation",
    "The impact of the ALPAC report",
    "The rise of statistical learning",
    "Early computer vision systems",
    "The evolution of natural language processing",
    "The influence of Minsky and Papert",
    "The development of reinforcement learning",
    "The impact of the ImageNet dataset",
    "The rise of deep learning in the 2010s",
    "Early AI hardware developments",
    "The evolution of AI ethics",
    "The influence of Bayesian methods",

    "The influence of McCulloch-Pitts neurons",
    "How did early AI predict weather?",
    "The impact of the Perceptron fallacy",
    "Comparing early AI funding models",
    "The evolution of AI in robotics",
    "How did early AI simulate logic?",
    "The role of neural nets in the 1960s",
    "The impact of the Lighthill report",
    "Comparing AI milestones pre-1980",
    "The evolution of expert system shells",
    "How did early AI handle vision?",
    "The role of connectionism",
    "The impact of early neural simulations",
    "Comparing AI paradigms pre-ML",
    "The evolution of AI in gaming",
    "How did early AI address planning?",
    "The role of symbolic reasoning",
    "The impact of early NLP systems",
    "Comparing AI research centers",
    "The evolution of AI ethics debates",
    "How did early AI predict outcomes?",
    "The role of cybernetic models",
    "The impact of early learning algorithms",
    "Comparing pre-deep learning AI",
    "The evolution of AI conferences",
    # Infra
    "The role of GPUs in deep learning training",
    "Optimizing inference with TPUs",
    "Energy consumption in AI hardware",
    "Distributed training with multi-GPU setups",
    "Cloud vs. on-premise AI infrastructure",
    "Cooling systems for GPU clusters",
    "The role of FPGAs in AI acceleration",
    "Optimizing memory bandwidth in training",
    "Distributed inference with Kubernetes",
    "The impact of NVLink on GPU performance",
    "Energy-efficient training with mixed precision",
    "The role of HPC in AI research",
    "Optimizing latency in real-time inference",
    "The use of ASICs for AI workloads",
    "Distributed data parallelism techniques",
    "The impact of interconnects on training speed",
    "Energy monitoring in AI clusters",
    "The role of edge devices in inference",
    "Optimizing power usage in GPU training",
    "The future of AI hardware design",
    "Distributed model parallelism strategies",
    "The impact of cache size on inference",
    "Energy-saving techniques in cloud AI",
    "The role of quantum computing in AI",
    "Optimizing throughput in multi-GPU systems",

    "The role of FPGA in AI acceleration",
    "How do neuromorphic chips compare to GPUs?",
    "The impact of memory hierarchies",
    "Comparing GPU vs. TPU power efficiency",
    "The evolution of AI supercomputers",
    "How do custom silicon enhance training?",
    "The role of PCIe bandwidth",
    "The impact of interconnect latency",
    "Comparing cloud vs. on-device inference",
    "The evolution of GPU cooling systems",
    "How do TPUs handle sparse data?",
    "The role of hardware prefetching",
    "The impact of memory bandwidth",
    "Comparing multi-core vs. many-core",
    "The evolution of AI hardware stacks",
    "How do GPUs support mixed precision?",
    "The role of tensor cores",
    "The impact of thermal design power",
    "Comparing distributed vs. local training",
    "The evolution of edge AI hardware",
    "How do TPUs optimize matrix ops?",
    "The role of hardware virtualization",
    "The impact of clock speed on training",
    "Comparing ASIC vs. GPU performance",
    "The evolution of energy-efficient chips",

    # Computer Science
    "The basics of algorithm complexity",
    "Data structures: Arrays vs. Linked Lists",
    "Operating system concepts for AI developers",
    "The importance of software engineering in AI",
    "Cybersecurity challenges in AI systems",
    "Parallel computing basics",
    "The role of caching in system performance",
    "Understanding distributed systems",
    "The basics of database indexing",
    "Software design patterns in AI applications",
    "The impact of concurrency on system design",
    "Understanding memory management",
    "The role of APIs in AI deployment",
    "Basics of computer networking",
    "The importance of version control",
    "Understanding thread safety",
    "The role of compilers in performance",
    "Basics of functional programming",
    "The impact of latency on system design",
    "Understanding file systems",
    "The role of load balancing",
    "Basics of cryptography",
    "The importance of testing in software",
    "Understanding virtual machines",
    "The role of containerization",
    "Basics of graph algorithms",
    "The impact of I/O operations",
    "Understanding system architecture",
    "The role of microservices",
    "Basics of object-oriented programming",
    "The importance of logging",
    "Understanding cloud computing",
    "The role of DevOps in AI",
    "Basics of queueing theory",
    "The impact of hardware interrupts",
    "Understanding process scheduling",
    "The role of fault tolerance",
    "Basics of binary trees",
    "The importance of scalability",
    "Understanding network protocols",
    "The role of data compression",
    "Basics of sorting algorithms",
    "The impact of system uptime",
    "Understanding memory hierarchies",
    "The role of real-time systems",
    "Basics of hash functions",
    "The importance of security patches",
    "Understanding distributed databases"
    
    "The role of quantum algorithms in computing",
    "How do blockchain systems ensure security?",
    "The impact of edge computing on latency",
    "Comparing microservices vs. monoliths",
    "The evolution of serverless architectures",
    "How do peer-to-peer networks function?",
    "The role of caching strategies",
    "The impact of thread pooling",
    "Comparing synchronous vs. asynchronous I/O",
    "The evolution of database sharding",
    "How do distributed locks work?",
    "The role of event-driven architectures",
    "The impact of network congestion",
    "Comparing REST vs. GraphQL APIs",
    "The evolution of cloud-native design",
    "How do load balancers optimize traffic?",
    "The role of fault-tolerant systems",
    "The impact of memory leaks",
    "Comparing static vs. dynamic typing",
    "The evolution of CI/CD pipelines",
    "How do garbage collectors function?",
    "The role of distributed consensus",
    "The impact of network partitioning",
    "Comparing batch vs. stream processing",
    "The evolution of virtual memory",
    "How do operating systems handle interrupts?",
    "The role of process synchronization",
    "The impact of CPU scheduling",
    "Comparing compiled vs. interpreted languages",
    "The evolution of software containers",
    "How do distributed file systems work?",
    "The role of network security protocols",
    "The impact of system scalability",
    "Comparing client-server vs. P2P",
    "The evolution of hardware abstraction",
    "How do real-time operating systems differ?",
    "The role of thread safety mechanisms",
    "The impact of I/O scheduling",
    "Comparing monolithic vs. modular design",
    "The evolution of network routing",
    "How do distributed databases scale?",
    "The role of load testing",
    "The impact of system resilience",
    "Comparing synchronous vs. asynchronous calls",
    "The evolution of API gateways",
    "How do distributed queues function?",
    "The role of memory paging",
    "The impact of network bandwidth",
    "Comparing event sourcing vs. CRUD",
    "The evolution of software-defined networking",

    # Ethics
    "The environmental footprint of AI data centers",
    "How do AI systems impact privacy laws?",
    "The role of AI in combating misinformation",
    "The impact of AI on employment equity",
    "Comparing AI regulation across continents",
    "The evolution of AI ethical guidelines",
    "How do AI models reinforce biases?",
    "The role of transparency in AI deployment",
    "The impact of AI on human rights",
    "Comparing ethical AI frameworks",
    "The evolution of AI governance models",
    "How do AI systems affect mental health?",
    "The role of accountability in AI",
    "The impact of AI on democratic processes",
    "Comparing open-source vs. proprietary AI",
    "The evolution of AI safety research",
    "How do AI models handle fairness?",
    "The role of explainability in regulation",
    "The impact of AI on climate policy",
    "Comparing global vs. local AI policies",
    "The evolution of AI audit standards",
    "How do AI systems influence education?",
    "The role of data sovereignty",
    "The impact of AI on healthcare ethics",
    "Comparing AI risk assessment methods",
    "The evolution of AI liability laws",
    "How do AI models affect trust?",
    "The role of diversity in AI development",
    "The impact of AI on surveillance",
    "Comparing ethical vs. legal AI constraints",
    "The evolution of AI impact assessments",
    "How do AI systems handle consent?",
    "The role of AI in sustainable development",
    "The impact of AI on intellectual property",
    "Comparing AI ethics training programs",
    "The evolution of AI policy frameworks",
    "How do AI models affect social equity?",
    "The role of AI in disaster response",
    "The impact of AI on economic inequality",
    "Comparing AI certification standards",
    "The evolution of AI privacy protections",
    "How do AI systems influence politics?",
    "The role of AI in environmental monitoring",
    "The impact of AI on cultural preservation",
    "Comparing AI governance bodies",
    "The evolution of AI ethical audits",
    "How do AI models affect accessibility?",
    "The role of AI in global health",
    "The impact of AI on labor markets",
    "Comparing AI policy enforcement",

    # AI Apps
    "AI in agriculture: Crop yield prediction",
    "How does AI optimize energy grids?",
    "The role of AI in pharmaceutical R&D",
    "The impact of AI on retail personalization",
    "Comparing AI in logistics vs. manufacturing",
    "The evolution of AI in smart cities",
    "How do AI systems enhance cybersecurity?",
    "The role of AI in real estate analysis",
    "The impact of AI on media production",
    "Comparing AI in gaming vs. simulation",
    "The evolution of AI in e-commerce",
    "How do AI models improve transportation?",
    "The role of AI in legal tech",
    "The impact of AI on sports analytics",
    "Comparing AI in telecom vs. IoT",
    "The evolution of AI in hospitality",
    "How do AI systems enhance marketing?",
    "The role of AI in aerospace design",
    "The impact of AI on fashion industry",
    "Comparing AI in banking vs. insurance",
    "The evolution of AI in construction",
    "How do AI models support mining?",
    "The role of AI in wildlife conservation",
    "The impact of AI on tourism",
    "Comparing AI in education vs. training",
    "The evolution of AI in defense",
    "How do AI systems optimize fisheries?",
    "The role of AI in urban planning",
    "The impact of AI on music composition",
    "Comparing AI in automotive vs. aviation",
    "The evolution of AI in journalism",
    "How do AI models enhance gaming AI?",
    "The role of AI in public health",
    "The impact of AI on film production",
    "Comparing AI in agriculture vs. forestry",
    "The evolution of AI in retail logistics",
    "How do AI systems support archaeology?",
    "The role of AI in renewable energy",
    "The impact of AI on event management",
    "Comparing AI in healthcare vs. wellness",
    "The evolution of AI in manufacturing IoT",
    "How do AI models optimize shipping?",
    "The role of AI in disaster recovery",
    "The impact of AI on virtual reality",
    "Comparing AI in energy vs. water management",
    "The evolution of AI in smart homes",
    "How do AI systems enhance gaming narratives?",
    "The role of AI in cultural heritage",
    "The impact of AI on space exploration"
]


def system_ai(num_examples: int):
    return f"""
    You are a Memory Reinforcement Learning dataset generator for a Reactive Transformer model.
    Output must be a Python list of tuples containing initial query-answer pairs and list of follow-up interactions, without any code, explanation, or metadata.
    You are used to generate list of exactly {num_examples} tuples with three elements: question, answer and list of follow-up interactions, based on real world knowledge in AI, ML and computer science topics.
    """


def task_description_ai(follow_ups_format: str, steps: int, num_examples: int, prior_steps: int, mode: str = 'multi'):
    return f"""
    # Memory Reinforcement Learning Data Generation (AI Subset) - {steps} Step(s)

    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing multi-step memory retention. They will be
    used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory. Generated conversations should be concentrated on AI, Machine Learning,
    Deep Learning, Data Science and Computer Science topics. It should contain QA pairs with knowledge related to those topics

    Each example must:

    1. Start with initial factual QA (AI/DataScience topic) - query and answer
    2. Contain {steps} follow-up QAs progressively referencing prior answers - list of queries and answers
    3. Each answer introduces 3-4 new facts while repeating 3+ previous facts
    4. Final interaction requires synthesizing info from {prior_steps}+ prior steps
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question]", "[Initial Answer]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """ if mode == 'multi' else f"""
    # Memory Reinforcement Learning Data Generation (AI Subset) - {steps} Step(s) - Long-Range Strategy

    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing long-range and multi-step memory retention. They
    will be used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory. Generated conversations should be concentrated on AI, Machine Learning,
    Deep Learning, Data Science and Computer Science topics. It should contain QA pairs with knowledge related to those topics

    In Long-Range strategy each generated example should contain two completely different message **topics**:
    - first topic is used only in first and last interaction
    - second topic is used in all interactions between first and last

    Each example must:

    1. Start with initial factual QA (AI/DataScience topic) - query and answer - for the first **topic**
    2. Contain {steps} follow-up QAs list of queries and answers
    3. First query in follow-up QAs (interactions) is changing **topic** into second one - not connected to first QA, and answer is also for new **topic**
    4. All next follow-up interactions, except the last one, have to continue the second **topic**:
        - Each answer introduces 3-4 new facts while repeating 3+ previous facts
    4. Final, last interaction is going back to first **topic** - asking a question about data from first QA pair (interaction) and the answer is containing most facts from first interaction
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question: **topic one**]", "[Initial Answer: **topic one**]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """


def critical_rules_ai(steps: int, prior_steps: int, num_tokens: int, mode: str = 'multi'):
    if mode == 'multi':
        return f"""
    ## CRITICAL RULES
    1. Factual Consistency:
      - All technical/scientific facts must be accurate
      - No fictional elements - only real-world entities in AI/ML and Computer Science topics
      - Real-world knowledge about AI and Machine Learning, but only a basic facts like in examples
      - Facts from real-world information about AI and Data Science
    2. Language:
      - Model is pre-trained on fineweb-edu and wikipedia - it should be compatible
      - While dataset includes real world facts, they should be served in dialogue format
      - examples may include some fragments of Python code blocks, but rather small and limited
    3. Referential Integrity:
      - Each follow-up references 3+ facts from previous answers
      - Final answer must combine facts from {prior_steps} previous steps
    4. Progressive Retention:
      - Each answer is on the same topic
      - Knowledge is accumulated in answers
      - Queries reference previous answers
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES
      - be creative for topics
      - try a lot different topics
    6. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should similar as in examples
    """
    else:
        return f"""
    ## CRITICAL RULES
    1. Factual Consistency:
      - All technical/scientific facts must be accurate
      - No fictional elements - only real-world entities in AI/ML and Computer Science topics
      - Real-world knowledge about AI and Machine Learning, but only a basic facts like in examples
      - Facts from real-world information about AI and Data Science
    2. Language:
      - Model is pre-trained on fineweb-edu and wikipedia - it should be compatible
      - While dataset includes real world facts, they should be served in dialogue format
      - examples may include some fragments of Python code blocks, but rather small and limited
    3. Referential Integrity:
      - Each middle follow-up for **topic two** references 3+ facts from previous answers and trying to combine facts from {prior_steps} previous steps (except first step)
      - Final answer must change back to **topic one** and reference 3+ facts from initial QA pair/interaction
    4. Progressive Retention:
      - Each answer from the middle of sequence (except initial and last follow-up) is on the same topic (**topic two**)
      - Knowledge is accumulated in answers
      - Queries reference previous answers of the same **topic**
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES
      - be creative for topics
      - try a lot different topics
    7. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should similar as in examples
    8. **CRUCIAL/CRITICAL** !! - Long-Range Strategy
      - first, initial QA pair is connected to **topic one**
      - ensure that there is exactly {steps} follow-up QAs/interactions with two different **topics**
      - first {steps - 1} follow-ups are all exploring **topic two**
      - ensure that exactly the last, {steps} QA pair (interaction) is going back to **topic one**
      - ensure that the last {steps} interaction is not connected to **topic two**
    """


def final_instructions_ai(steps: int, num_examples: int, mode: str = 'multi'):
    instructions = f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with fact about AI/Machine Learning and Computer Science
    2. Design {steps} follow-ups requiring cumulative understanding
    3. Ensure final answer combines numerical, temporal, and spatial data
    4. Validate all  factual accuracy
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All facts consistent
    - {steps} follow-ups per entry
    - Final answer combines 3+ prior facts
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`

    Generate {num_examples} entries following EXACTLY this structure.
    """ if mode == 'multi' else f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with fact about AI/Machine Learning and Computer Science in **topic one**
    2. Design {steps - 1} follow-ups requiring cumulative understanding for **topic two**
    3. Ensure final query is switching back to **topic one** and final answer is including data from initial QA pair
    4. Validate all factual accuracy
    5. All follow-ups should have {steps} elements: {steps - 1} for **topic two** and last 1 for switching back to **topic one**
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All facts consistent
    - exactly {steps} follow-ups per entry: {steps - 1} for **topic two** and last 1 for **topic one**
    - Final answer combines 3-4+ facts from first initial interaction
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`
    - Ensure, that after {steps - 1} follow-up QAs (interactions) for **topic two**, there's also final {steps} (last) query and answer for **topic one**

    Generate {num_examples} entries following EXACTLY this structure.
    """

    return instructions


ALL_PROMPTS_AI = (system_ai, task_description_ai, critical_rules_ai, final_instructions_ai)
