# miniswhid

No-frills [Software Hash Identifier](https://www.swhid.org/) (SWHID) computation for files and directories.

[![PyPI version](https://badge.fury.io/py/miniswhid.svg)](https://badge.fury.io/py/miniswhid)
[![Python versions](https://img.shields.io/pypi/pyversions/miniswhid.svg)](https://pypi.org/project/miniswhid/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

## Features

- Support for content (`cnt`) and directory (`dir`) SWHIDs
- Concurrent file hashing on multi-core systems
- Minimal dependencies — uses only Python standard library

Revision, release and snapshot SWHIDs are *not* supported.

## Requirements

- Python 3.10 or higher

## Installation

```bash
pip install miniswhid
```

## Quick Start

### Command Line

```bash
# Compute SWHID for a file
miniswhid README.md
# Output: swh:1:cnt:4c7fdf8...

# Compute SWHID for a directory  
miniswhid /path/to/directory
# Output: swh:1:dir:8b137891...
```

### Python API

```python
from miniswhid import compute_content_swhid, compute_directory_swhid

# File content SWHID
file_swhid = compute_content_swhid("README.md")
print(file_swhid)  # swh:1:cnt:4c7fdf8...

# Directory SWHID
dir_swhid = compute_directory_swhid("/path/to/directory")  
print(dir_swhid)   # swh:1:dir:8b137891...
```

## Development

### Running Tests

```bash
# Install development dependencies
uv sync

# Run test suite
uv run pytest

# Run with coverage
uv run pytest --cov=miniswhid

# Run linting and type checking
uvx ruff check
uvx ruff format
uvx mypy .

# Or run all checks via pre-commit
uv run pre-commit run --all-files
```

## License

MIT - see [LICENSE](LICENSE) file.

## Acknowledgements

This project's test suite uses reference SWHID values generated by the [Software Heritage toolchain](https://docs.softwareheritage.org/devel/swh-core/cli.html#swh-identify) (`swh identify`) to ensure correctness and compatibility with the official implementation.

## Changelog

### 0.1.0 (2024-08-13)
- Initial release with complete SWHID computation for files and directories
- Command-line interface (`miniswhid` command)
- Python API with `compute_content_swhid()` and `compute_directory_swhid()`
- Parallel processing for directory traversal
- Comprehensive test suite with 22+ tests using official Software Heritage reference values
- Type checking with mypy and strict type annotations
- Code formatting and linting with ruff
- Pre-commit hooks for code quality assurance
- Automated PyPI publishing via GitHub Actions
- TestPyPI workflow for release validation