#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Setup script for math-bridge package
"""

from setuptools import setup, find_packages
import os

# Odczyt README
def read_file(filename):
    here = os.path.abspath(os.path.dirname(__file__))
    with open(os.path.join(here, filename), 'r', encoding='utf-8') as f:
        return f.read()

# Odczyt requirements
def read_requirements(filename):
    with open(filename, 'r', encoding='utf-8') as f:
        return [line.strip() for line in f if line.strip() and not line.startswith('#')]

long_description = read_file('README.md')
requirements = read_requirements('requirements.txt')

setup(
    name='math-bridge',
    version='1.0.0',
    
    # Metadata
    author='Twoje Imię',
    author_email='twoj@email.com',
    description='Zaawansowana biblioteka matematyczna do obliczeń gamma, Poissona i Kelly Criterion',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/twoj-username/math-bridge',
    project_urls={
        'Bug Reports': 'https://github.com/twoj-username/math-bridge/issues',
        'Source': 'https://github.com/twoj-username/math-bridge',
        'Documentation': 'https://github.com/twoj-username/math-bridge#readme',
    },
    
    # Pakiety
    packages=find_packages(exclude=['tests', 'tests.*', 'docs', 'examples']),
    
    # Wymagania Python
    python_requires='>=3.7',
    
    # Zależności
    install_requires=requirements,
    
    # Opcjonalne zależności
    extras_require={
        'dev': [
            'pytest>=7.0',
            'pytest-cov>=3.0',
            'black>=22.0',
            'flake8>=4.0',
            'isort>=5.0',
            'mypy>=0.950',
        ],
        'docs': [
            'sphinx>=4.0',
            'sphinx-rtd-theme>=1.0',
        ],
        'ml': [
            'xgboost>=1.5.0',
            'keras>=2.8.0',
            'tensorflow>=2.8.0',
        ],
    },
    
    # Classifiers - kategorie pakietu
    classifiers=[
        # Status rozwoju
        'Development Status :: 4 - Beta',
        
        # Grupa docelowa
        'Intended Audience :: Science/Research',
        'Intended Audience :: Developers',
        'Intended Audience :: Education',
        
        # Temat
        'Topic :: Scientific/Engineering',
        'Topic :: Scientific/Engineering :: Mathematics',
        'Topic :: Software Development :: Libraries',
        'Topic :: Software Development :: Libraries :: Python Modules',
        
        # Licencja
        'License :: OSI Approved :: MIT License',
        
        # Wspierane wersje Python
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
        
        # System operacyjny
        'Operating System :: OS Independent',
        
        # Inne
        'Natural Language :: English',
        'Natural Language :: Polish',
    ],
    
    # Słowa kluczowe
    keywords='mathematics gamma poisson kelly statistics probability calculus',
    
    # Licencja
    license='MIT',
    
    # Pliki danych do włączenia
    include_package_data=True,
    
    # Typ dystrybucji
    zip_safe=False,
    
    # Entry points (opcjonalne - dla CLI)
    # entry_points={
    #     'console_scripts': [
    #         'mathbridge=math_bridge.cli:main',
    #     ],
    # },
)