# Generated by Django 3.2.20 on 2023-08-17 15:36

from django.db import migrations, models

import richie.apps.core.fields.duration


class Migration(migrations.Migration):
    dependencies = [
        ("courses", "0033_auto_20211207_2251"),
    ]

    operations = [
        migrations.AddField(
            model_name="courserun",
            name="display_mode",
            field=models.CharField(
                choices=[
                    (
                        "compact",
                        "compact - show minimal information about the course run (only for products).",
                    ),
                    (
                        "detailed",
                        "detailed - show all information about the course run (only for products).",
                    ),
                ],
                default="detailed",
                max_length=20,
            ),
        ),
        migrations.AlterField(
            model_name="course",
            name="effort",
            field=richie.apps.core.fields.duration.CompositeDurationField(
                blank=True,
                default_unit="hour",
                help_text="Total amount of time to complete this course.",
                max_length=80,
                null=True,
                time_units={"hour": ("hour", "hours"), "minute": ("minute", "minutes")},
            ),
        ),
        migrations.AlterField(
            model_name="courserun",
            name="enrollment_count",
            field=models.PositiveIntegerField(
                blank=True,
                default=0,
                help_text="The number of enrolled students",
                verbose_name="enrollment count",
            ),
        ),
        migrations.AlterField(
            model_name="courserun",
            name="sync_mode",
            field=models.CharField(
                choices=[
                    ("manual", "Manual"),
                    ("sync_to_draft", "Synchronization to draft page"),
                    ("sync_to_public", "Synchronization to public page"),
                ],
                default="manual",
                max_length=20,
                verbose_name="Synchronization mode",
            ),
        ),
    ]
