# Generated by Django 4.2.17 on 2024-12-06 11:28

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("cms", "0022_auto_20180620_1551"),
        ("courses", "0035_add_menuentry"),
    ]

    operations = [
        migrations.AddField(
            model_name="courserun",
            name="certificate_offer",
            field=models.CharField(
                blank=True,
                choices=[
                    ("free", "free - The certification can be completed without cost"),
                    (
                        "subscription",
                        "subscription - Must be a subscriber or paid member to carry out the certification process",
                    ),
                    ("paid", "paid - Must pay to carry out the certification process"),
                ],
                max_length=20,
                null=True,
                verbose_name="certificate offer",
            ),
        ),
        migrations.AddField(
            model_name="courserun",
            name="certificate_price",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="The price of the certificate",
                max_digits=9,
                null=True,
                verbose_name="certificate price",
            ),
        ),
        migrations.AddField(
            model_name="courserun",
            name="offer",
            field=models.CharField(
                blank=True,
                choices=[
                    ("free", "free - The entire course can be completed without cost"),
                    (
                        "partially_free",
                        "partially_free - More than half of the course is for free",
                    ),
                    (
                        "subscription",
                        "subscription - Must be a subscriber or paid member to complete the entire course",
                    ),
                    ("paid", "paid - Must pay to complete the course"),
                ],
                max_length=20,
                null=True,
                verbose_name="offer",
            ),
        ),
        migrations.AddField(
            model_name="courserun",
            name="price",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="The price of the course run",
                max_digits=9,
                null=True,
                verbose_name="price",
            ),
        ),
        migrations.AddField(
            model_name="courserun",
            name="price_currency",
            field=models.CharField(default="EUR", max_length=7),
        ),
    ]
