# Generated by Django 4.2.20 on 2025-03-10 14:44

import django.core.validators
from django.db import migrations, models

import richie.apps.core.fields.duration


class Migration(migrations.Migration):

    dependencies = [
        ("courses", "0038_alter_mainmenuentry_menu_color"),
    ]

    operations = [
        migrations.AddField(
            model_name="program",
            name="duration",
            field=richie.apps.core.fields.duration.CompositeDurationField(
                blank=True,
                default_unit="hour",
                help_text="The program time range.",
                max_length=80,
                null=True,
                time_units={
                    "day": ("day", "days"),
                    "hour": ("hour", "hours"),
                    "minute": ("minute", "minutes"),
                    "month": ("month", "months"),
                    "week": ("week", "weeks"),
                },
            ),
        ),
        migrations.AddField(
            model_name="program",
            name="effort",
            field=richie.apps.core.fields.duration.CompositeDurationField(
                blank=True,
                default_unit="hour",
                help_text="Total amount of time to complete this program.",
                max_length=80,
                null=True,
                time_units={"hour": ("hour", "hours"), "minute": ("minute", "minutes")},
            ),
        ),
        migrations.AddField(
            model_name="program",
            name="price",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                default=0,
                help_text="The price of the program.",
                max_digits=10,
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="price",
            ),
        ),
    ]
