# Generated by Django 4.2.16 on 2024-11-22 00:16

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("cms", "0022_auto_20180620_1551"),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Slider",
            fields=[
                (
                    "cmsplugin_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="%(app_label)s_%(class)s",
                        serialize=False,
                        to="cms.cmsplugin",
                    ),
                ),
                ("title", models.CharField(max_length=255, verbose_name="title")),
            ],
            options={
                "verbose_name": "Slider",
                "verbose_name_plural": "Sliders",
            },
            bases=("cms.cmsplugin",),
        ),
        migrations.CreateModel(
            name="SlideItem",
            fields=[
                (
                    "cmsplugin_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="%(app_label)s_%(class)s",
                        serialize=False,
                        to="cms.cmsplugin",
                    ),
                ),
                (
                    "title",
                    models.CharField(default="", max_length=150, verbose_name="title"),
                ),
                (
                    "content",
                    models.TextField(blank=True, default="", verbose_name="content"),
                ),
                (
                    "link_url",
                    models.URLField(
                        blank=True,
                        help_text="Make the slide as a link with an URL.",
                        max_length=255,
                        null=True,
                        verbose_name="link URL",
                    ),
                ),
                (
                    "link_open_blank",
                    models.BooleanField(
                        default=False,
                        help_text="If checked the link will be open in a new window",
                        verbose_name="open new window",
                    ),
                ),
                (
                    "image",
                    filer.fields.image.FilerImageField(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="slide_image",
                        to=settings.FILER_IMAGE_MODEL,
                        verbose_name="image",
                    ),
                ),
            ],
            options={
                "verbose_name": "Slide item",
                "verbose_name_plural": "Slide items",
            },
            bases=("cms.cmsplugin",),
        ),
    ]
