# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetDNSSecResult',
    'AwaitableGetDNSSecResult',
    'get_dns_sec',
    'get_dns_sec_output',
]

@pulumi.output_type
class GetDNSSecResult:
    """
    A collection of values returned by getDNSSec.
    """
    def __init__(__self__, delegation=None, id=None, keys=None, zone=None):
        if delegation and not isinstance(delegation, dict):
            raise TypeError("Expected argument 'delegation' to be a dict")
        pulumi.set(__self__, "delegation", delegation)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if keys and not isinstance(keys, dict):
            raise TypeError("Expected argument 'keys' to be a dict")
        pulumi.set(__self__, "keys", keys)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def delegation(self) -> 'outputs.GetDNSSecDelegationResult':
        """
        (Computed) - Delegation field is documented
        below.
        """
        return pulumi.get(self, "delegation")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def keys(self) -> 'outputs.GetDNSSecKeysResult':
        """
        (Computed) - Keys field is documented below.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetDNSSecResult(GetDNSSecResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDNSSecResult(
            delegation=self.delegation,
            id=self.id,
            keys=self.keys,
            zone=self.zone)


def get_dns_sec(zone: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDNSSecResult:
    """
    Provides DNSSEC details about a NS1 Zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ns1 as ns1

    # Get DNSSEC details about a NS1 Zone.
    example_zone = ns1.Zone("exampleZone",
        dnssec=True,
        zone="terraform.example.io")
    example_dns_sec = example_zone.zone.apply(lambda zone: ns1.get_dns_sec(zone=zone))
    ```


    :param str zone: The name of the zone to get DNSSEC details for.
    """
    __args__ = dict()
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('ns1:index/getDNSSec:getDNSSec', __args__, opts=opts, typ=GetDNSSecResult).value

    return AwaitableGetDNSSecResult(
        delegation=__ret__.delegation,
        id=__ret__.id,
        keys=__ret__.keys,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_dns_sec)
def get_dns_sec_output(zone: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDNSSecResult]:
    """
    Provides DNSSEC details about a NS1 Zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ns1 as ns1

    # Get DNSSEC details about a NS1 Zone.
    example_zone = ns1.Zone("exampleZone",
        dnssec=True,
        zone="terraform.example.io")
    example_dns_sec = example_zone.zone.apply(lambda zone: ns1.get_dns_sec(zone=zone))
    ```


    :param str zone: The name of the zone to get DNSSEC details for.
    """
    ...
