# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetRecordResult',
    'AwaitableGetRecordResult',
    'get_record',
    'get_record_output',
]

@pulumi.output_type
class GetRecordResult:
    """
    A collection of values returned by getRecord.
    """
    def __init__(__self__, answers=None, domain=None, filters=None, id=None, link=None, meta=None, regions=None, short_answers=None, ttl=None, type=None, use_client_subnet=None, zone=None):
        if answers and not isinstance(answers, list):
            raise TypeError("Expected argument 'answers' to be a list")
        pulumi.set(__self__, "answers", answers)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if link and not isinstance(link, str):
            raise TypeError("Expected argument 'link' to be a str")
        pulumi.set(__self__, "link", link)
        if meta and not isinstance(meta, dict):
            raise TypeError("Expected argument 'meta' to be a dict")
        pulumi.set(__self__, "meta", meta)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)
        if short_answers and not isinstance(short_answers, list):
            raise TypeError("Expected argument 'short_answers' to be a list")
        pulumi.set(__self__, "short_answers", short_answers)
        if ttl and not isinstance(ttl, int):
            raise TypeError("Expected argument 'ttl' to be a int")
        pulumi.set(__self__, "ttl", ttl)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if use_client_subnet and not isinstance(use_client_subnet, bool):
            raise TypeError("Expected argument 'use_client_subnet' to be a bool")
        pulumi.set(__self__, "use_client_subnet", use_client_subnet)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def answers(self) -> Sequence['outputs.GetRecordAnswerResult']:
        """
        List of NS1 answers.
        """
        return pulumi.get(self, "answers")

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetRecordFilterResult']:
        """
        List of NS1 filters.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def link(self) -> str:
        """
        The target record this links to.
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def meta(self) -> Mapping[str, Any]:
        """
        Map of metadata
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetRecordRegionResult']:
        """
        List of regions.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="shortAnswers")
    def short_answers(self) -> Sequence[str]:
        return pulumi.get(self, "short_answers")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The records' time to live (in seconds).
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="useClientSubnet")
    def use_client_subnet(self) -> bool:
        """
        Whether to use EDNS client subnet data when available (in filter chain).
        """
        return pulumi.get(self, "use_client_subnet")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetRecordResult(GetRecordResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecordResult(
            answers=self.answers,
            domain=self.domain,
            filters=self.filters,
            id=self.id,
            link=self.link,
            meta=self.meta,
            regions=self.regions,
            short_answers=self.short_answers,
            ttl=self.ttl,
            type=self.type,
            use_client_subnet=self.use_client_subnet,
            zone=self.zone)


def get_record(domain: Optional[str] = None,
               type: Optional[str] = None,
               zone: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecordResult:
    """
    Provides details about a NS1 Record. Use this if you would simply like to read
    information from NS1 into your configurations. For read/write operations, you
    should use a resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ns1 as ns1

    example = ns1.get_record(domain="terraform.example.io",
        type="A",
        zone="example.io")
    ```


    :param str domain: The records' domain.
    :param str type: The records' RR type.
    :param str zone: The zone the record belongs to.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['type'] = type
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('ns1:index/getRecord:getRecord', __args__, opts=opts, typ=GetRecordResult).value

    return AwaitableGetRecordResult(
        answers=__ret__.answers,
        domain=__ret__.domain,
        filters=__ret__.filters,
        id=__ret__.id,
        link=__ret__.link,
        meta=__ret__.meta,
        regions=__ret__.regions,
        short_answers=__ret__.short_answers,
        ttl=__ret__.ttl,
        type=__ret__.type,
        use_client_subnet=__ret__.use_client_subnet,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_record)
def get_record_output(domain: Optional[pulumi.Input[str]] = None,
                      type: Optional[pulumi.Input[str]] = None,
                      zone: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRecordResult]:
    """
    Provides details about a NS1 Record. Use this if you would simply like to read
    information from NS1 into your configurations. For read/write operations, you
    should use a resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ns1 as ns1

    example = ns1.get_record(domain="terraform.example.io",
        type="A",
        zone="example.io")
    ```


    :param str domain: The records' domain.
    :param str type: The records' RR type.
    :param str zone: The zone the record belongs to.
    """
    ...
