# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotifyListArgs', 'NotifyList']

@pulumi.input_type
class NotifyListArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['NotifyListNotificationArgs']]]] = None):
        """
        The set of arguments for constructing a NotifyList resource.
        :param pulumi.Input[str] name: The free-form display name for the notify list.
        :param pulumi.Input[Sequence[pulumi.Input['NotifyListNotificationArgs']]] notifications: A list of notifiers. All notifiers in a notification list will receive notifications whenever an event is send to the list (e.g., when a monitoring job fails). Notifiers are documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The free-form display name for the notify list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotifyListNotificationArgs']]]]:
        """
        A list of notifiers. All notifiers in a notification list will receive notifications whenever an event is send to the list (e.g., when a monitoring job fails). Notifiers are documented below.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotifyListNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)


@pulumi.input_type
class _NotifyListState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['NotifyListNotificationArgs']]]] = None):
        """
        Input properties used for looking up and filtering NotifyList resources.
        :param pulumi.Input[str] name: The free-form display name for the notify list.
        :param pulumi.Input[Sequence[pulumi.Input['NotifyListNotificationArgs']]] notifications: A list of notifiers. All notifiers in a notification list will receive notifications whenever an event is send to the list (e.g., when a monitoring job fails). Notifiers are documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The free-form display name for the notify list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotifyListNotificationArgs']]]]:
        """
        A list of notifiers. All notifiers in a notification list will receive notifications whenever an event is send to the list (e.g., when a monitoring job fails). Notifiers are documented below.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotifyListNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)


class NotifyList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotifyListNotificationArgs']]]]] = None,
                 __props__=None):
        """
        Provides a NS1 Notify List resource. This can be used to create, modify, and delete notify lists.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ns1 as ns1

        nl = ns1.NotifyList("nl", notifications=[
            ns1.NotifyListNotificationArgs(
                config={
                    "url": "http://www.mywebhook.com",
                },
                type="webhook",
            ),
            ns1.NotifyListNotificationArgs(
                config={
                    "email": "test@test.com",
                },
                type="email",
            ),
        ])
        ```
        ## NS1 Documentation

        [NotifyList Api Doc](https://ns1.com/api#notification-lists)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The free-form display name for the notify list.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotifyListNotificationArgs']]]] notifications: A list of notifiers. All notifiers in a notification list will receive notifications whenever an event is send to the list (e.g., when a monitoring job fails). Notifiers are documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NotifyListArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a NS1 Notify List resource. This can be used to create, modify, and delete notify lists.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ns1 as ns1

        nl = ns1.NotifyList("nl", notifications=[
            ns1.NotifyListNotificationArgs(
                config={
                    "url": "http://www.mywebhook.com",
                },
                type="webhook",
            ),
            ns1.NotifyListNotificationArgs(
                config={
                    "email": "test@test.com",
                },
                type="email",
            ),
        ])
        ```
        ## NS1 Documentation

        [NotifyList Api Doc](https://ns1.com/api#notification-lists)

        :param str resource_name: The name of the resource.
        :param NotifyListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotifyListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotifyListNotificationArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotifyListArgs.__new__(NotifyListArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["notifications"] = notifications
        super(NotifyList, __self__).__init__(
            'ns1:index/notifyList:NotifyList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotifyListNotificationArgs']]]]] = None) -> 'NotifyList':
        """
        Get an existing NotifyList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The free-form display name for the notify list.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotifyListNotificationArgs']]]] notifications: A list of notifiers. All notifiers in a notification list will receive notifications whenever an event is send to the list (e.g., when a monitoring job fails). Notifiers are documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotifyListState.__new__(_NotifyListState)

        __props__.__dict__["name"] = name
        __props__.__dict__["notifications"] = notifications
        return NotifyList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The free-form display name for the notify list.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional[Sequence['outputs.NotifyListNotification']]]:
        """
        A list of notifiers. All notifiers in a notification list will receive notifications whenever an event is send to the list (e.g., when a monitoring job fails). Notifiers are documented below.
        """
        return pulumi.get(self, "notifications")

