# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'APIKeyDnsRecordsAllow',
    'APIKeyDnsRecordsDeny',
    'ApplicationDefaultConfig',
    'MonitoringJobRule',
    'NotifyListNotification',
    'PulsarJobBlendMetricWeights',
    'PulsarJobConfig',
    'PulsarJobWeight',
    'RecordAnswer',
    'RecordFilter',
    'RecordRegion',
    'TeamDnsRecordsAllow',
    'TeamDnsRecordsDeny',
    'TeamIpWhitelist',
    'UserDnsRecordsAllow',
    'UserDnsRecordsDeny',
    'ZoneSecondary',
    'GetDNSSecDelegationResult',
    'GetDNSSecDelegationDResult',
    'GetDNSSecDelegationDnskeyResult',
    'GetDNSSecKeysResult',
    'GetDNSSecKeysDnskeyResult',
    'GetRecordAnswerResult',
    'GetRecordFilterResult',
    'GetRecordRegionResult',
    'GetZoneSecondaryResult',
]

@pulumi.output_type
class APIKeyDnsRecordsAllow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeSubdomains":
            suggest = "include_subdomains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in APIKeyDnsRecordsAllow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        APIKeyDnsRecordsAllow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        APIKeyDnsRecordsAllow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 include_subdomains: bool,
                 type: str,
                 zone: str):
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "include_subdomains", include_subdomains)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> bool:
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class APIKeyDnsRecordsDeny(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeSubdomains":
            suggest = "include_subdomains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in APIKeyDnsRecordsDeny. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        APIKeyDnsRecordsDeny.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        APIKeyDnsRecordsDeny.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 include_subdomains: bool,
                 type: str,
                 zone: str):
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "include_subdomains", include_subdomains)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> bool:
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class ApplicationDefaultConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobTimeoutMillis":
            suggest = "job_timeout_millis"
        elif key == "requestTimeoutMillis":
            suggest = "request_timeout_millis"
        elif key == "staticValues":
            suggest = "static_values"
        elif key == "useXhr":
            suggest = "use_xhr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationDefaultConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationDefaultConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationDefaultConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http: bool,
                 https: Optional[bool] = None,
                 job_timeout_millis: Optional[int] = None,
                 request_timeout_millis: Optional[int] = None,
                 static_values: Optional[bool] = None,
                 use_xhr: Optional[bool] = None):
        """
        :param bool http: Indicates whether or not to use HTTP in measurements.
        :param bool https: Indicates whether or not to use HTTPS in measurements.
        :param int job_timeout_millis: - Maximum timeout per job
               0, the primary NSONE Global Network. Normally, you should not have to worry about this.
        :param int request_timeout_millis: Maximum timeout per request.
        :param bool static_values: - Indicates whether or not to skip aggregation for this job's measurements
        :param bool use_xhr: - Whether to use XMLHttpRequest (XHR) when taking measurements.
        """
        pulumi.set(__self__, "http", http)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if job_timeout_millis is not None:
            pulumi.set(__self__, "job_timeout_millis", job_timeout_millis)
        if request_timeout_millis is not None:
            pulumi.set(__self__, "request_timeout_millis", request_timeout_millis)
        if static_values is not None:
            pulumi.set(__self__, "static_values", static_values)
        if use_xhr is not None:
            pulumi.set(__self__, "use_xhr", use_xhr)

    @property
    @pulumi.getter
    def http(self) -> bool:
        """
        Indicates whether or not to use HTTP in measurements.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def https(self) -> Optional[bool]:
        """
        Indicates whether or not to use HTTPS in measurements.
        """
        return pulumi.get(self, "https")

    @property
    @pulumi.getter(name="jobTimeoutMillis")
    def job_timeout_millis(self) -> Optional[int]:
        """
        - Maximum timeout per job
        0, the primary NSONE Global Network. Normally, you should not have to worry about this.
        """
        return pulumi.get(self, "job_timeout_millis")

    @property
    @pulumi.getter(name="requestTimeoutMillis")
    def request_timeout_millis(self) -> Optional[int]:
        """
        Maximum timeout per request.
        """
        return pulumi.get(self, "request_timeout_millis")

    @property
    @pulumi.getter(name="staticValues")
    def static_values(self) -> Optional[bool]:
        """
        - Indicates whether or not to skip aggregation for this job's measurements
        """
        return pulumi.get(self, "static_values")

    @property
    @pulumi.getter(name="useXhr")
    def use_xhr(self) -> Optional[bool]:
        """
        - Whether to use XMLHttpRequest (XHR) when taking measurements.
        """
        return pulumi.get(self, "use_xhr")


@pulumi.output_type
class MonitoringJobRule(dict):
    def __init__(__self__, *,
                 comparison: str,
                 key: str,
                 value: str):
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def comparison(self) -> str:
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class NotifyListNotification(dict):
    def __init__(__self__, *,
                 config: Mapping[str, Any],
                 type: str):
        """
        :param Mapping[str, Any] config: Configuration details for the given notifier type.
        :param str type: The type of notifier. Available notifiers are indicated in /notifytypes endpoint.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> Mapping[str, Any]:
        """
        Configuration details for the given notifier type.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of notifier. Available notifiers are indicated in /notifytypes endpoint.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PulsarJobBlendMetricWeights(dict):
    def __init__(__self__, *,
                 timestamp: int):
        pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def timestamp(self) -> int:
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class PulsarJobConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobTimeoutMillis":
            suggest = "job_timeout_millis"
        elif key == "requestTimeoutMillis":
            suggest = "request_timeout_millis"
        elif key == "staticValues":
            suggest = "static_values"
        elif key == "urlPath":
            suggest = "url_path"
        elif key == "useXhr":
            suggest = "use_xhr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PulsarJobConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PulsarJobConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PulsarJobConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Optional[str] = None,
                 http: Optional[bool] = None,
                 https: Optional[bool] = None,
                 job_timeout_millis: Optional[int] = None,
                 request_timeout_millis: Optional[int] = None,
                 static_values: Optional[bool] = None,
                 url_path: Optional[str] = None,
                 use_xhr: Optional[bool] = None):
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if job_timeout_millis is not None:
            pulumi.set(__self__, "job_timeout_millis", job_timeout_millis)
        if request_timeout_millis is not None:
            pulumi.set(__self__, "request_timeout_millis", request_timeout_millis)
        if static_values is not None:
            pulumi.set(__self__, "static_values", static_values)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)
        if use_xhr is not None:
            pulumi.set(__self__, "use_xhr", use_xhr)

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def http(self) -> Optional[bool]:
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def https(self) -> Optional[bool]:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter(name="jobTimeoutMillis")
    def job_timeout_millis(self) -> Optional[int]:
        return pulumi.get(self, "job_timeout_millis")

    @property
    @pulumi.getter(name="requestTimeoutMillis")
    def request_timeout_millis(self) -> Optional[int]:
        return pulumi.get(self, "request_timeout_millis")

    @property
    @pulumi.getter(name="staticValues")
    def static_values(self) -> Optional[bool]:
        return pulumi.get(self, "static_values")

    @property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[str]:
        return pulumi.get(self, "url_path")

    @property
    @pulumi.getter(name="useXhr")
    def use_xhr(self) -> Optional[bool]:
        return pulumi.get(self, "use_xhr")


@pulumi.output_type
class PulsarJobWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PulsarJobWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PulsarJobWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PulsarJobWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: float,
                 name: str,
                 weight: int,
                 maximize: Optional[bool] = None):
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "weight", weight)
        if maximize is not None:
            pulumi.set(__self__, "maximize", maximize)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> float:
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def weight(self) -> int:
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter
    def maximize(self) -> Optional[bool]:
        return pulumi.get(self, "maximize")


@pulumi.output_type
class RecordAnswer(dict):
    def __init__(__self__, *,
                 answer: Optional[str] = None,
                 meta: Optional[Mapping[str, Any]] = None,
                 region: Optional[str] = None):
        """
        :param str answer: Space delimited string of RDATA fields dependent on the record type.
        :param str region: The region (Answer Group really) that this answer
               belongs to. This should be one of the names specified in `regions`. Only a
               single `region` per answer is currently supported. If you want an answer in
               multiple regions, duplicating the answer (including metadata) is the correct
               approach.
               * ` meta` - (Optional) meta is supported at the `answer` level. Meta
               is documented below.
        """
        if answer is not None:
            pulumi.set(__self__, "answer", answer)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def answer(self) -> Optional[str]:
        """
        Space delimited string of RDATA fields dependent on the record type.
        """
        return pulumi.get(self, "answer")

    @property
    @pulumi.getter
    def meta(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region (Answer Group really) that this answer
        belongs to. This should be one of the names specified in `regions`. Only a
        single `region` per answer is currently supported. If you want an answer in
        multiple regions, duplicating the answer (including metadata) is the correct
        approach.
        * ` meta` - (Optional) meta is supported at the `answer` level. Meta
        is documented below.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class RecordFilter(dict):
    def __init__(__self__, *,
                 filter: str,
                 config: Optional[Mapping[str, Any]] = None,
                 disabled: Optional[bool] = None):
        """
        :param str filter: The type of filter.
        :param Mapping[str, Any] config: The filters' configuration. Simple key/value pairs
               determined by the filter type.
        :param bool disabled: Determines whether the filter is applied in the
               filter chain.
        """
        pulumi.set(__self__, "filter", filter)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        The type of filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def config(self) -> Optional[Mapping[str, Any]]:
        """
        The filters' configuration. Simple key/value pairs
        determined by the filter type.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether the filter is applied in the
        filter chain.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class RecordRegion(dict):
    def __init__(__self__, *,
                 name: str,
                 meta: Optional[Mapping[str, Any]] = None):
        """
        :param str name: Name of the region (or Answer Group).
        """
        pulumi.set(__self__, "name", name)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the region (or Answer Group).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def meta(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "meta")


@pulumi.output_type
class TeamDnsRecordsAllow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeSubdomains":
            suggest = "include_subdomains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamDnsRecordsAllow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamDnsRecordsAllow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamDnsRecordsAllow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 include_subdomains: bool,
                 type: str,
                 zone: str):
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "include_subdomains", include_subdomains)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> bool:
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class TeamDnsRecordsDeny(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeSubdomains":
            suggest = "include_subdomains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamDnsRecordsDeny. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamDnsRecordsDeny.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamDnsRecordsDeny.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 include_subdomains: bool,
                 type: str,
                 zone: str):
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "include_subdomains", include_subdomains)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> bool:
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class TeamIpWhitelist(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The free form name of the team.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The free form name of the team.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class UserDnsRecordsAllow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeSubdomains":
            suggest = "include_subdomains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserDnsRecordsAllow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserDnsRecordsAllow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserDnsRecordsAllow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 include_subdomains: bool,
                 type: str,
                 zone: str):
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "include_subdomains", include_subdomains)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> bool:
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class UserDnsRecordsDeny(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeSubdomains":
            suggest = "include_subdomains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserDnsRecordsDeny. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserDnsRecordsDeny.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserDnsRecordsDeny.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 include_subdomains: bool,
                 type: str,
                 zone: str):
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "include_subdomains", include_subdomains)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> bool:
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class ZoneSecondary(dict):
    def __init__(__self__, *,
                 ip: str,
                 networks: Optional[Sequence[int]] = None,
                 notify: Optional[bool] = None,
                 port: Optional[int] = None):
        """
        :param str ip: IPv4 address of the secondary server.
        :param Sequence[int] networks: - List of network IDs (`int`) for which the zone
               should be made available. Default is network 0, the primary NSONE Global
               Network. Normally, you should not have to worry about this.
        :param bool notify: Whether we send `NOTIFY` messages to the secondary host
               when the zone changes. Default `false`.
        :param int port: Port of the the secondary server. Default `53`.
        """
        pulumi.set(__self__, "ip", ip)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if notify is not None:
            pulumi.set(__self__, "notify", notify)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        IPv4 address of the secondary server.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def networks(self) -> Optional[Sequence[int]]:
        """
        - List of network IDs (`int`) for which the zone
        should be made available. Default is network 0, the primary NSONE Global
        Network. Normally, you should not have to worry about this.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def notify(self) -> Optional[bool]:
        """
        Whether we send `NOTIFY` messages to the secondary host
        when the zone changes. Default `false`.
        """
        return pulumi.get(self, "notify")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port of the the secondary server. Default `53`.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDNSSecDelegationResult(dict):
    def __init__(__self__, *,
                 dnskeys: Sequence['outputs.GetDNSSecDelegationDnskeyResult'],
                 ds: Sequence['outputs.GetDNSSecDelegationDResult'],
                 ttl: int):
        """
        :param Sequence['GetDNSSecDelegationDnskeyArgs'] dnskeys: (Computed) List of Keys. Key is documented below.
        :param Sequence['GetDNSSecDelegationDArgs'] ds: (Computed) List of Keys. Key is documented below.
        :param int ttl: (Computed) TTL for the Keys (int).
        """
        pulumi.set(__self__, "dnskeys", dnskeys)
        pulumi.set(__self__, "ds", ds)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def dnskeys(self) -> Sequence['outputs.GetDNSSecDelegationDnskeyResult']:
        """
        (Computed) List of Keys. Key is documented below.
        """
        return pulumi.get(self, "dnskeys")

    @property
    @pulumi.getter
    def ds(self) -> Sequence['outputs.GetDNSSecDelegationDResult']:
        """
        (Computed) List of Keys. Key is documented below.
        """
        return pulumi.get(self, "ds")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        (Computed) TTL for the Keys (int).
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetDNSSecDelegationDResult(dict):
    def __init__(__self__, *,
                 algorithm: str,
                 flags: str,
                 protocol: str,
                 public_key: str):
        """
        :param str algorithm: (Computed) Algorithm of the key.
        :param str flags: (Computed) Flags for the key.
        :param str protocol: (Computed) Protocol of the key.
        :param str public_key: (Computed) Public key for the key.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        (Computed) Algorithm of the key.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def flags(self) -> str:
        """
        (Computed) Flags for the key.
        """
        return pulumi.get(self, "flags")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        (Computed) Protocol of the key.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        (Computed) Public key for the key.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GetDNSSecDelegationDnskeyResult(dict):
    def __init__(__self__, *,
                 algorithm: str,
                 flags: str,
                 protocol: str,
                 public_key: str):
        """
        :param str algorithm: (Computed) Algorithm of the key.
        :param str flags: (Computed) Flags for the key.
        :param str protocol: (Computed) Protocol of the key.
        :param str public_key: (Computed) Public key for the key.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        (Computed) Algorithm of the key.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def flags(self) -> str:
        """
        (Computed) Flags for the key.
        """
        return pulumi.get(self, "flags")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        (Computed) Protocol of the key.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        (Computed) Public key for the key.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GetDNSSecKeysResult(dict):
    def __init__(__self__, *,
                 dnskeys: Sequence['outputs.GetDNSSecKeysDnskeyResult'],
                 ttl: int):
        """
        :param Sequence['GetDNSSecKeysDnskeyArgs'] dnskeys: (Computed) List of Keys. Key is documented below.
        :param int ttl: (Computed) TTL for the Keys (int).
        """
        pulumi.set(__self__, "dnskeys", dnskeys)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def dnskeys(self) -> Sequence['outputs.GetDNSSecKeysDnskeyResult']:
        """
        (Computed) List of Keys. Key is documented below.
        """
        return pulumi.get(self, "dnskeys")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        (Computed) TTL for the Keys (int).
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetDNSSecKeysDnskeyResult(dict):
    def __init__(__self__, *,
                 algorithm: str,
                 flags: str,
                 protocol: str,
                 public_key: str):
        """
        :param str algorithm: (Computed) Algorithm of the key.
        :param str flags: (Computed) Flags for the key.
        :param str protocol: (Computed) Protocol of the key.
        :param str public_key: (Computed) Public key for the key.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        (Computed) Algorithm of the key.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def flags(self) -> str:
        """
        (Computed) Flags for the key.
        """
        return pulumi.get(self, "flags")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        (Computed) Protocol of the key.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        (Computed) Public key for the key.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GetRecordAnswerResult(dict):
    def __init__(__self__, *,
                 answer: str,
                 meta: Mapping[str, Any],
                 region: str):
        """
        :param Mapping[str, Any] meta: Map of metadata
        """
        pulumi.set(__self__, "answer", answer)
        pulumi.set(__self__, "meta", meta)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def answer(self) -> str:
        return pulumi.get(self, "answer")

    @property
    @pulumi.getter
    def meta(self) -> Mapping[str, Any]:
        """
        Map of metadata
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


@pulumi.output_type
class GetRecordFilterResult(dict):
    def __init__(__self__, *,
                 config: Mapping[str, Any],
                 disabled: bool,
                 filter: str):
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def config(self) -> Mapping[str, Any]:
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def filter(self) -> str:
        return pulumi.get(self, "filter")


@pulumi.output_type
class GetRecordRegionResult(dict):
    def __init__(__self__, *,
                 meta: Mapping[str, Any],
                 name: str):
        """
        :param Mapping[str, Any] meta: Map of metadata
        """
        pulumi.set(__self__, "meta", meta)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def meta(self) -> Mapping[str, Any]:
        """
        Map of metadata
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetZoneSecondaryResult(dict):
    def __init__(__self__, *,
                 ip: str,
                 networks: Sequence[int],
                 notify: bool,
                 port: int):
        """
        :param str ip: IPv4 address of the secondary server.
        :param Sequence[int] networks: List of network IDs (`int`) for which the zone should be made
               available. Default is network 0, the primary NSONE Global Network.
        :param bool notify: Whether we send `NOTIFY` messages to the secondary host
               when the zone changes. Default `false`.
        :param int port: Port of the the secondary server. Default `53`.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "notify", notify)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        IPv4 address of the secondary server.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def networks(self) -> Sequence[int]:
        """
        List of network IDs (`int`) for which the zone should be made
        available. Default is network 0, the primary NSONE Global Network.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def notify(self) -> bool:
        """
        Whether we send `NOTIFY` messages to the secondary host
        when the zone changes. Default `false`.
        """
        return pulumi.get(self, "notify")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port of the the secondary server. Default `53`.
        """
        return pulumi.get(self, "port")


