"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NonApiResource = exports.ApiResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents information about an API resource type.
 */
class ApiResource {
    constructor(options) {
        this.apiGroup = options.apiGroup;
        this.resourceType = options.resourceType;
    }
    /**
     * API resource information for a custom resource type.
     */
    static custom(options) {
        return new ApiResource(options);
    }
    ;
    asApiResource() {
        return this;
    }
    asNonApiResource() {
        return undefined;
    }
}
exports.ApiResource = ApiResource;
_a = JSII_RTTI_SYMBOL_1;
ApiResource[_a] = { fqn: "cdk8s-plus-25.ApiResource", version: "2.4.21" };
/**
 * API resource information for Binding.
 */
ApiResource.BINDINGS = new ApiResource({
    apiGroup: '',
    resourceType: 'bindings',
});
/**
 * API resource information for ComponentStatus.
 */
ApiResource.COMPONENT_STATUSES = new ApiResource({
    apiGroup: '',
    resourceType: 'componentstatuses',
});
/**
 * API resource information for ConfigMap.
 */
ApiResource.CONFIG_MAPS = new ApiResource({
    apiGroup: '',
    resourceType: 'configmaps',
});
/**
 * API resource information for Endpoints.
 */
ApiResource.ENDPOINTS = new ApiResource({
    apiGroup: '',
    resourceType: 'endpoints',
});
/**
 * API resource information for Event.
 */
ApiResource.EVENTS = new ApiResource({
    apiGroup: '',
    resourceType: 'events',
});
/**
 * API resource information for LimitRange.
 */
ApiResource.LIMIT_RANGES = new ApiResource({
    apiGroup: '',
    resourceType: 'limitranges',
});
/**
 * API resource information for Namespace.
 */
ApiResource.NAMESPACES = new ApiResource({
    apiGroup: '',
    resourceType: 'namespaces',
});
/**
 * API resource information for Node.
 */
ApiResource.NODES = new ApiResource({
    apiGroup: '',
    resourceType: 'nodes',
});
/**
 * API resource information for PersistentVolumeClaim.
 */
ApiResource.PERSISTENT_VOLUME_CLAIMS = new ApiResource({
    apiGroup: '',
    resourceType: 'persistentvolumeclaims',
});
/**
 * API resource information for PersistentVolume.
 */
ApiResource.PERSISTENT_VOLUMES = new ApiResource({
    apiGroup: '',
    resourceType: 'persistentvolumes',
});
/**
 * API resource information for Pod.
 */
ApiResource.PODS = new ApiResource({
    apiGroup: '',
    resourceType: 'pods',
});
/**
 * API resource information for PodTemplate.
 */
ApiResource.POD_TEMPLATES = new ApiResource({
    apiGroup: '',
    resourceType: 'podtemplates',
});
/**
 * API resource information for ReplicationController.
 */
ApiResource.REPLICATION_CONTROLLERS = new ApiResource({
    apiGroup: '',
    resourceType: 'replicationcontrollers',
});
/**
 * API resource information for ResourceQuota.
 */
ApiResource.RESOURCE_QUOTAS = new ApiResource({
    apiGroup: '',
    resourceType: 'resourcequotas',
});
/**
 * API resource information for Secret.
 */
ApiResource.SECRETS = new ApiResource({
    apiGroup: '',
    resourceType: 'secrets',
});
/**
 * API resource information for ServiceAccount.
 */
ApiResource.SERVICE_ACCOUNTS = new ApiResource({
    apiGroup: '',
    resourceType: 'serviceaccounts',
});
/**
 * API resource information for Service.
 */
ApiResource.SERVICES = new ApiResource({
    apiGroup: '',
    resourceType: 'services',
});
/**
 * API resource information for MutatingWebhookConfiguration.
 */
ApiResource.MUTATING_WEBHOOK_CONFIGURATIONS = new ApiResource({
    apiGroup: 'admissionregistration.k8s.io',
    resourceType: 'mutatingwebhookconfigurations',
});
/**
 * API resource information for ValidatingWebhookConfiguration.
 */
ApiResource.VALIDATING_WEBHOOK_CONFIGURATIONS = new ApiResource({
    apiGroup: 'admissionregistration.k8s.io',
    resourceType: 'validatingwebhookconfigurations',
});
/**
 * API resource information for CustomResourceDefinition.
 */
ApiResource.CUSTOM_RESOURCE_DEFINITIONS = new ApiResource({
    apiGroup: 'apiextensions.k8s.io',
    resourceType: 'customresourcedefinitions',
});
/**
 * API resource information for APIService.
 */
ApiResource.API_SERVICES = new ApiResource({
    apiGroup: 'apiregistration.k8s.io',
    resourceType: 'apiservices',
});
/**
 * API resource information for ControllerRevision.
 */
ApiResource.CONTROLLER_REVISIONS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'controllerrevisions',
});
/**
 * API resource information for DaemonSet.
 */
ApiResource.DAEMON_SETS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'daemonsets',
});
/**
 * API resource information for Deployment.
 */
ApiResource.DEPLOYMENTS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'deployments',
});
/**
 * API resource information for ReplicaSet.
 */
ApiResource.REPLICA_SETS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'replicasets',
});
/**
 * API resource information for StatefulSet.
 */
ApiResource.STATEFUL_SETS = new ApiResource({
    apiGroup: 'apps',
    resourceType: 'statefulsets',
});
/**
 * API resource information for TokenReview.
 */
ApiResource.TOKEN_REVIEWS = new ApiResource({
    apiGroup: 'authentication.k8s.io',
    resourceType: 'tokenreviews',
});
/**
 * API resource information for LocalSubjectAccessReview.
 */
ApiResource.LOCAL_SUBJECT_ACCESS_REVIEWS = new ApiResource({
    apiGroup: 'authorization.k8s.io',
    resourceType: 'localsubjectaccessreviews',
});
/**
 * API resource information for SelfSubjectAccessReview.
 */
ApiResource.SELF_SUBJECT_ACCESS_REVIEWS = new ApiResource({
    apiGroup: 'authorization.k8s.io',
    resourceType: 'selfsubjectaccessreviews',
});
/**
 * API resource information for SelfSubjectRulesReview.
 */
ApiResource.SELF_SUBJECT_RULES_REVIEWS = new ApiResource({
    apiGroup: 'authorization.k8s.io',
    resourceType: 'selfsubjectrulesreviews',
});
/**
 * API resource information for SubjectAccessReview.
 */
ApiResource.SUBJECT_ACCESS_REVIEWS = new ApiResource({
    apiGroup: 'authorization.k8s.io',
    resourceType: 'subjectaccessreviews',
});
/**
 * API resource information for HorizontalPodAutoscaler.
 */
ApiResource.HORIZONTAL_POD_AUTOSCALERS = new ApiResource({
    apiGroup: 'autoscaling',
    resourceType: 'horizontalpodautoscalers',
});
/**
 * API resource information for CronJob.
 */
ApiResource.CRON_JOBS = new ApiResource({
    apiGroup: 'batch',
    resourceType: 'cronjobs',
});
/**
 * API resource information for Job.
 */
ApiResource.JOBS = new ApiResource({
    apiGroup: 'batch',
    resourceType: 'jobs',
});
/**
 * API resource information for CertificateSigningRequest.
 */
ApiResource.CERTIFICATE_SIGNING_REQUESTS = new ApiResource({
    apiGroup: 'certificates.k8s.io',
    resourceType: 'certificatesigningrequests',
});
/**
 * API resource information for Lease.
 */
ApiResource.LEASES = new ApiResource({
    apiGroup: 'coordination.k8s.io',
    resourceType: 'leases',
});
/**
 * API resource information for EndpointSlice.
 */
ApiResource.ENDPOINT_SLICES = new ApiResource({
    apiGroup: 'discovery.k8s.io',
    resourceType: 'endpointslices',
});
/**
 * API resource information for FlowSchema.
 */
ApiResource.FLOW_SCHEMAS = new ApiResource({
    apiGroup: 'flowcontrol.apiserver.k8s.io',
    resourceType: 'flowschemas',
});
/**
 * API resource information for PriorityLevelConfiguration.
 */
ApiResource.PRIORITY_LEVEL_CONFIGURATIONS = new ApiResource({
    apiGroup: 'flowcontrol.apiserver.k8s.io',
    resourceType: 'prioritylevelconfigurations',
});
/**
 * API resource information for IngressClass.
 */
ApiResource.INGRESS_CLASSES = new ApiResource({
    apiGroup: 'networking.k8s.io',
    resourceType: 'ingressclasses',
});
/**
 * API resource information for Ingress.
 */
ApiResource.INGRESSES = new ApiResource({
    apiGroup: 'networking.k8s.io',
    resourceType: 'ingresses',
});
/**
 * API resource information for NetworkPolicy.
 */
ApiResource.NETWORK_POLICIES = new ApiResource({
    apiGroup: 'networking.k8s.io',
    resourceType: 'networkpolicies',
});
/**
 * API resource information for RuntimeClass.
 */
ApiResource.RUNTIME_CLASSES = new ApiResource({
    apiGroup: 'node.k8s.io',
    resourceType: 'runtimeclasses',
});
/**
 * API resource information for PodDisruptionBudget.
 */
ApiResource.POD_DISRUPTION_BUDGETS = new ApiResource({
    apiGroup: 'policy',
    resourceType: 'poddisruptionbudgets',
});
/**
 * API resource information for ClusterRoleBinding.
 */
ApiResource.CLUSTER_ROLE_BINDINGS = new ApiResource({
    apiGroup: 'rbac.authorization.k8s.io',
    resourceType: 'clusterrolebindings',
});
/**
 * API resource information for ClusterRole.
 */
ApiResource.CLUSTER_ROLES = new ApiResource({
    apiGroup: 'rbac.authorization.k8s.io',
    resourceType: 'clusterroles',
});
/**
 * API resource information for RoleBinding.
 */
ApiResource.ROLE_BINDINGS = new ApiResource({
    apiGroup: 'rbac.authorization.k8s.io',
    resourceType: 'rolebindings',
});
/**
 * API resource information for Role.
 */
ApiResource.ROLES = new ApiResource({
    apiGroup: 'rbac.authorization.k8s.io',
    resourceType: 'roles',
});
/**
 * API resource information for PriorityClass.
 */
ApiResource.PRIORITY_CLASSES = new ApiResource({
    apiGroup: 'scheduling.k8s.io',
    resourceType: 'priorityclasses',
});
/**
 * API resource information for CSIDriver.
 */
ApiResource.CSI_DRIVERS = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'csidrivers',
});
/**
 * API resource information for CSINode.
 */
ApiResource.CSI_NODES = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'csinodes',
});
/**
 * API resource information for CSIStorageCapacity.
 */
ApiResource.CSI_STORAGE_CAPACITIES = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'csistoragecapacities',
});
/**
 * API resource information for StorageClass.
 */
ApiResource.STORAGE_CLASSES = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'storageclasses',
});
/**
 * API resource information for VolumeAttachment.
 */
ApiResource.VOLUME_ATTACHMENTS = new ApiResource({
    apiGroup: 'storage.k8s.io',
    resourceType: 'volumeattachments',
});
/**
 * Factory for creating non api resources.
 */
class NonApiResource {
    constructor(nonResourceUrl) {
        this.nonResourceUrl = nonResourceUrl;
    }
    static of(url) {
        return new NonApiResource(url);
    }
    ;
    asApiResource() {
        return undefined;
    }
    asNonApiResource() {
        return this.nonResourceUrl;
    }
}
exports.NonApiResource = NonApiResource;
_b = JSII_RTTI_SYMBOL_1;
NonApiResource[_b] = { fqn: "cdk8s-plus-25.NonApiResource", version: "2.4.21" };
//# sourceMappingURL=data:application/json;base64,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