# Copyright 2020 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""File related util for model maker."""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import json

import tensorflow as tf


def load_json_file(json_file):
  """Loads json data from file."""
  with tf.io.gfile.GFile(json_file, 'r') as reader:
    return json.load(reader)


def write_json_file(json_file, data):
  """Writes json data into file."""
  with tf.io.gfile.GFile(json_file, 'w') as f:
    json.dump(data, f)
