## 📦 MultiProdigy AI Agents Framework

**MultiProdigy** is a modular, schema-driven, multi-agent framework built with Pydantic. It enables scalable and orchestrated communication between autonomous agents with a shared message bus, runtime engine, and support infrastructure.

------

## Features

- Plugin-based architecture
- Schema validation with Pydantic
- Logging setup with configurable log file
- Health checks for agent services
- Service discovery for agents
- Centralized error reporting
- Dynamic schema registration system

-------

## Documentation

- [Getting Started](https://github.com/Abhay-Cerberus/MultiProdigy/blob/main/docs/getting_started.md)  
- [Architecture](https://github.com/Abhay-Cerberus/MultiProdigy/blob/main/docs/architecture.md)  
- [Module Reference](https://github.com/Abhay-Cerberus/MultiProdigy/blob/main/docs/modules_reference.md)  
- [Sample Demo](https://github.com/Abhay-Cerberus/MultiProdigy/blob/main/docs/sample_agent_demo.md) 

--------

### If you want to Contribute to the Project

- Before Contributing, Read our [CODE OF CONDUCT](https://github.com/Abhay-Cerberus/MultiProdigy/blob/main/CODE_OF_CONDUCT.md) first
- [Contribution](https://github.com/Abhay-Cerberus/MultiProdigy/blob/main/CONTRIBUTING.md)
