import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AlertPolicyChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID where you want to link the channel to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_policy_channel#account_id AlertPolicyChannel#account_id}
    */
    readonly accountId?: number;
    /**
    * Array of channel IDs to apply to the specified policy. We recommended sorting channel IDs in ascending order to avoid drift your Terraform state.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_policy_channel#channel_ids AlertPolicyChannel#channel_ids}
    */
    readonly channelIds: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_policy_channel#id AlertPolicyChannel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_policy_channel#policy_id AlertPolicyChannel#policy_id}
    */
    readonly policyId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/alert_policy_channel newrelic_alert_policy_channel}
*/
export declare class AlertPolicyChannel extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_alert_policy_channel";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/alert_policy_channel newrelic_alert_policy_channel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AlertPolicyChannelConfig
    */
    constructor(scope: Construct, id: string, config: AlertPolicyChannelConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _channelIds?;
    get channelIds(): number[];
    set channelIds(value: number[]);
    get channelIdsInput(): number[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyId?;
    get policyId(): number;
    set policyId(value: number);
    get policyIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
