import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiAccessKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/api_access_key#account_id ApiAccessKey#account_id}
    */
    readonly accountId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/api_access_key#id ApiAccessKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/api_access_key#ingest_type ApiAccessKey#ingest_type}
    */
    readonly ingestType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/api_access_key#key_type ApiAccessKey#key_type}
    */
    readonly keyType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/api_access_key#name ApiAccessKey#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/api_access_key#notes ApiAccessKey#notes}
    */
    readonly notes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/api_access_key#user_id ApiAccessKey#user_id}
    */
    readonly userId?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/api_access_key newrelic_api_access_key}
*/
export declare class ApiAccessKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_api_access_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/api_access_key newrelic_api_access_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiAccessKeyConfig
    */
    constructor(scope: Construct, id: string, config: ApiAccessKeyConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    get accountIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingestType?;
    get ingestType(): string;
    set ingestType(value: string);
    resetIngestType(): void;
    get ingestTypeInput(): string | undefined;
    get key(): string;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    get keyTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    resetUserId(): void;
    get userIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
