import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/application_settings#app_apdex_threshold ApplicationSettings#app_apdex_threshold}
    */
    readonly appApdexThreshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/application_settings#enable_real_user_monitoring ApplicationSettings#enable_real_user_monitoring}
    */
    readonly enableRealUserMonitoring: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/application_settings#end_user_apdex_threshold ApplicationSettings#end_user_apdex_threshold}
    */
    readonly endUserApdexThreshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/application_settings#id ApplicationSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/application_settings#name ApplicationSettings#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/application_settings newrelic_application_settings}
*/
export declare class ApplicationSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_application_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/application_settings newrelic_application_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationSettingsConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationSettingsConfig);
    private _appApdexThreshold?;
    get appApdexThreshold(): number;
    set appApdexThreshold(value: number);
    get appApdexThresholdInput(): number | undefined;
    private _enableRealUserMonitoring?;
    get enableRealUserMonitoring(): boolean | cdktf.IResolvable;
    set enableRealUserMonitoring(value: boolean | cdktf.IResolvable);
    get enableRealUserMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _endUserApdexThreshold?;
    get endUserApdexThreshold(): number;
    set endUserApdexThreshold(value: number);
    get endUserApdexThresholdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
