import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudAwsGovcloudIntegrationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the account in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#account_id CloudAwsGovcloudIntegrations#account_id}
    */
    readonly accountId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#id CloudAwsGovcloudIntegrations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the linked AwsGovCloud account in New Relic
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#linked_account_id CloudAwsGovcloudIntegrations#linked_account_id}
    */
    readonly linkedAccountId: number;
    /**
    * alb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#alb CloudAwsGovcloudIntegrations#alb}
    */
    readonly alb?: CloudAwsGovcloudIntegrationsAlb;
    /**
    * api_gateway block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#api_gateway CloudAwsGovcloudIntegrations#api_gateway}
    */
    readonly apiGateway?: CloudAwsGovcloudIntegrationsApiGateway;
    /**
    * auto_scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#auto_scaling CloudAwsGovcloudIntegrations#auto_scaling}
    */
    readonly autoScaling?: CloudAwsGovcloudIntegrationsAutoScaling;
    /**
    * aws_direct_connect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_direct_connect CloudAwsGovcloudIntegrations#aws_direct_connect}
    */
    readonly awsDirectConnect?: CloudAwsGovcloudIntegrationsAwsDirectConnect;
    /**
    * aws_states block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_states CloudAwsGovcloudIntegrations#aws_states}
    */
    readonly awsStates?: CloudAwsGovcloudIntegrationsAwsStates;
    /**
    * cloudtrail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#cloudtrail CloudAwsGovcloudIntegrations#cloudtrail}
    */
    readonly cloudtrail?: CloudAwsGovcloudIntegrationsCloudtrail;
    /**
    * dynamo_db block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#dynamo_db CloudAwsGovcloudIntegrations#dynamo_db}
    */
    readonly dynamoDb?: CloudAwsGovcloudIntegrationsDynamoDb;
    /**
    * ebs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#ebs CloudAwsGovcloudIntegrations#ebs}
    */
    readonly ebs?: CloudAwsGovcloudIntegrationsEbs;
    /**
    * ec2 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#ec2 CloudAwsGovcloudIntegrations#ec2}
    */
    readonly ec2?: CloudAwsGovcloudIntegrationsEc2;
    /**
    * elastic_search block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#elastic_search CloudAwsGovcloudIntegrations#elastic_search}
    */
    readonly elasticSearch?: CloudAwsGovcloudIntegrationsElasticSearch;
    /**
    * elb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#elb CloudAwsGovcloudIntegrations#elb}
    */
    readonly elb?: CloudAwsGovcloudIntegrationsElb;
    /**
    * emr block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#emr CloudAwsGovcloudIntegrations#emr}
    */
    readonly emr?: CloudAwsGovcloudIntegrationsEmr;
    /**
    * iam block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#iam CloudAwsGovcloudIntegrations#iam}
    */
    readonly iam?: CloudAwsGovcloudIntegrationsIam;
    /**
    * lambda block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#lambda CloudAwsGovcloudIntegrations#lambda}
    */
    readonly lambda?: CloudAwsGovcloudIntegrationsLambda;
    /**
    * rds block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#rds CloudAwsGovcloudIntegrations#rds}
    */
    readonly rds?: CloudAwsGovcloudIntegrationsRds;
    /**
    * red_shift block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#red_shift CloudAwsGovcloudIntegrations#red_shift}
    */
    readonly redShift?: CloudAwsGovcloudIntegrationsRedShift;
    /**
    * route53 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#route53 CloudAwsGovcloudIntegrations#route53}
    */
    readonly route53?: CloudAwsGovcloudIntegrationsRoute53;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#s3 CloudAwsGovcloudIntegrations#s3}
    */
    readonly s3?: CloudAwsGovcloudIntegrationsS3;
    /**
    * sns block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#sns CloudAwsGovcloudIntegrations#sns}
    */
    readonly sns?: CloudAwsGovcloudIntegrationsSns;
    /**
    * sqs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#sqs CloudAwsGovcloudIntegrations#sqs}
    */
    readonly sqs?: CloudAwsGovcloudIntegrationsSqs;
}
export interface CloudAwsGovcloudIntegrationsAlb {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_extended_inventory CloudAwsGovcloudIntegrations#fetch_extended_inventory}
    */
    readonly fetchExtendedInventory?: boolean | cdktf.IResolvable;
    /**
    * Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_tags CloudAwsGovcloudIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * Specify each name or prefix for the LBs that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#load_balancer_prefixes CloudAwsGovcloudIntegrations#load_balancer_prefixes}
    */
    readonly loadBalancerPrefixes?: string[];
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsAlbToTerraform(struct?: CloudAwsGovcloudIntegrationsAlbOutputReference | CloudAwsGovcloudIntegrationsAlb): any;
export declare class CloudAwsGovcloudIntegrationsAlbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsAlb | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsAlb | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchExtendedInventory?;
    get fetchExtendedInventory(): boolean | cdktf.IResolvable;
    set fetchExtendedInventory(value: boolean | cdktf.IResolvable);
    resetFetchExtendedInventory(): void;
    get fetchExtendedInventoryInput(): boolean | cdktf.IResolvable | undefined;
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _loadBalancerPrefixes?;
    get loadBalancerPrefixes(): string[];
    set loadBalancerPrefixes(value: string[]);
    resetLoadBalancerPrefixes(): void;
    get loadBalancerPrefixesInput(): string[] | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsApiGateway {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#stage_prefixes CloudAwsGovcloudIntegrations#stage_prefixes}
    */
    readonly stagePrefixes?: string[];
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsApiGatewayToTerraform(struct?: CloudAwsGovcloudIntegrationsApiGatewayOutputReference | CloudAwsGovcloudIntegrationsApiGateway): any;
export declare class CloudAwsGovcloudIntegrationsApiGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsApiGateway | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsApiGateway | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _stagePrefixes?;
    get stagePrefixes(): string[];
    set stagePrefixes(value: string[]);
    resetStagePrefixes(): void;
    get stagePrefixesInput(): string[] | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsAutoScaling {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsGovcloudIntegrationsAutoScalingToTerraform(struct?: CloudAwsGovcloudIntegrationsAutoScalingOutputReference | CloudAwsGovcloudIntegrationsAutoScaling): any;
export declare class CloudAwsGovcloudIntegrationsAutoScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsAutoScaling | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsAutoScaling | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsGovcloudIntegrationsAwsDirectConnect {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsGovcloudIntegrationsAwsDirectConnectToTerraform(struct?: CloudAwsGovcloudIntegrationsAwsDirectConnectOutputReference | CloudAwsGovcloudIntegrationsAwsDirectConnect): any;
export declare class CloudAwsGovcloudIntegrationsAwsDirectConnectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsAwsDirectConnect | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsAwsDirectConnect | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsGovcloudIntegrationsAwsStates {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsGovcloudIntegrationsAwsStatesToTerraform(struct?: CloudAwsGovcloudIntegrationsAwsStatesOutputReference | CloudAwsGovcloudIntegrationsAwsStates): any;
export declare class CloudAwsGovcloudIntegrationsAwsStatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsAwsStates | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsAwsStates | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsGovcloudIntegrationsCloudtrail {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsGovcloudIntegrationsCloudtrailToTerraform(struct?: CloudAwsGovcloudIntegrationsCloudtrailOutputReference | CloudAwsGovcloudIntegrationsCloudtrail): any;
export declare class CloudAwsGovcloudIntegrationsCloudtrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsCloudtrail | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsCloudtrail | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsGovcloudIntegrationsDynamoDb {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_extended_inventory CloudAwsGovcloudIntegrations#fetch_extended_inventory}
    */
    readonly fetchExtendedInventory?: boolean | cdktf.IResolvable;
    /**
    * Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_tags CloudAwsGovcloudIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsDynamoDbToTerraform(struct?: CloudAwsGovcloudIntegrationsDynamoDbOutputReference | CloudAwsGovcloudIntegrationsDynamoDb): any;
export declare class CloudAwsGovcloudIntegrationsDynamoDbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsDynamoDb | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsDynamoDb | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchExtendedInventory?;
    get fetchExtendedInventory(): boolean | cdktf.IResolvable;
    set fetchExtendedInventory(value: boolean | cdktf.IResolvable);
    resetFetchExtendedInventory(): void;
    get fetchExtendedInventoryInput(): boolean | cdktf.IResolvable | undefined;
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsEbs {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_extended_inventory CloudAwsGovcloudIntegrations#fetch_extended_inventory}
    */
    readonly fetchExtendedInventory?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsEbsToTerraform(struct?: CloudAwsGovcloudIntegrationsEbsOutputReference | CloudAwsGovcloudIntegrationsEbs): any;
export declare class CloudAwsGovcloudIntegrationsEbsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsEbs | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsEbs | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchExtendedInventory?;
    get fetchExtendedInventory(): boolean | cdktf.IResolvable;
    set fetchExtendedInventory(value: boolean | cdktf.IResolvable);
    resetFetchExtendedInventory(): void;
    get fetchExtendedInventoryInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsEc2 {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Specify if IP addresses of ec2 instance should be collected
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_ip_addresses CloudAwsGovcloudIntegrations#fetch_ip_addresses}
    */
    readonly fetchIpAddresses?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsEc2ToTerraform(struct?: CloudAwsGovcloudIntegrationsEc2OutputReference | CloudAwsGovcloudIntegrationsEc2): any;
export declare class CloudAwsGovcloudIntegrationsEc2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsEc2 | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsEc2 | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchIpAddresses?;
    get fetchIpAddresses(): boolean | cdktf.IResolvable;
    set fetchIpAddresses(value: boolean | cdktf.IResolvable);
    resetFetchIpAddresses(): void;
    get fetchIpAddressesInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsElasticSearch {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Specify if IP addresses of ec2 instance should be collected
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_nodes CloudAwsGovcloudIntegrations#fetch_nodes}
    */
    readonly fetchNodes?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsElasticSearchToTerraform(struct?: CloudAwsGovcloudIntegrationsElasticSearchOutputReference | CloudAwsGovcloudIntegrationsElasticSearch): any;
export declare class CloudAwsGovcloudIntegrationsElasticSearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsElasticSearch | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsElasticSearch | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchNodes?;
    get fetchNodes(): boolean | cdktf.IResolvable;
    set fetchNodes(value: boolean | cdktf.IResolvable);
    resetFetchNodes(): void;
    get fetchNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsElb {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_extended_inventory CloudAwsGovcloudIntegrations#fetch_extended_inventory}
    */
    readonly fetchExtendedInventory?: boolean | cdktf.IResolvable;
    /**
    * Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_tags CloudAwsGovcloudIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsGovcloudIntegrationsElbToTerraform(struct?: CloudAwsGovcloudIntegrationsElbOutputReference | CloudAwsGovcloudIntegrationsElb): any;
export declare class CloudAwsGovcloudIntegrationsElbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsElb | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsElb | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchExtendedInventory?;
    get fetchExtendedInventory(): boolean | cdktf.IResolvable;
    set fetchExtendedInventory(value: boolean | cdktf.IResolvable);
    resetFetchExtendedInventory(): void;
    get fetchExtendedInventoryInput(): boolean | cdktf.IResolvable | undefined;
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsGovcloudIntegrationsEmr {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string;
    /**
    * Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_tags CloudAwsGovcloudIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsEmrToTerraform(struct?: CloudAwsGovcloudIntegrationsEmrOutputReference | CloudAwsGovcloudIntegrationsEmr): any;
export declare class CloudAwsGovcloudIntegrationsEmrOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsEmr | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsEmr | undefined);
    private _awsRegions?;
    get awsRegions(): string;
    set awsRegions(value: string);
    resetAwsRegions(): void;
    get awsRegionsInput(): string | undefined;
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsIam {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsIamToTerraform(struct?: CloudAwsGovcloudIntegrationsIamOutputReference | CloudAwsGovcloudIntegrationsIam): any;
export declare class CloudAwsGovcloudIntegrationsIamOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsIam | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsIam | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsLambda {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_tags CloudAwsGovcloudIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsLambdaToTerraform(struct?: CloudAwsGovcloudIntegrationsLambdaOutputReference | CloudAwsGovcloudIntegrationsLambda): any;
export declare class CloudAwsGovcloudIntegrationsLambdaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsLambda | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsLambda | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsRds {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_tags CloudAwsGovcloudIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsRdsToTerraform(struct?: CloudAwsGovcloudIntegrationsRdsOutputReference | CloudAwsGovcloudIntegrationsRds): any;
export declare class CloudAwsGovcloudIntegrationsRdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsRds | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsRds | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsRedShift {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsRedShiftToTerraform(struct?: CloudAwsGovcloudIntegrationsRedShiftOutputReference | CloudAwsGovcloudIntegrationsRedShift): any;
export declare class CloudAwsGovcloudIntegrationsRedShiftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsRedShift | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsRedShift | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsRoute53 {
    /**
    * Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_extended_inventory CloudAwsGovcloudIntegrations#fetch_extended_inventory}
    */
    readonly fetchExtendedInventory?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsGovcloudIntegrationsRoute53ToTerraform(struct?: CloudAwsGovcloudIntegrationsRoute53OutputReference | CloudAwsGovcloudIntegrationsRoute53): any;
export declare class CloudAwsGovcloudIntegrationsRoute53OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsRoute53 | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsRoute53 | undefined);
    private _fetchExtendedInventory?;
    get fetchExtendedInventory(): boolean | cdktf.IResolvable;
    set fetchExtendedInventory(value: boolean | cdktf.IResolvable);
    resetFetchExtendedInventory(): void;
    get fetchExtendedInventoryInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsGovcloudIntegrationsS3 {
    /**
    * Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_extended_inventory CloudAwsGovcloudIntegrations#fetch_extended_inventory}
    */
    readonly fetchExtendedInventory?: boolean | cdktf.IResolvable;
    /**
    * Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_tags CloudAwsGovcloudIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsS3ToTerraform(struct?: CloudAwsGovcloudIntegrationsS3OutputReference | CloudAwsGovcloudIntegrationsS3): any;
export declare class CloudAwsGovcloudIntegrationsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsS3 | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsS3 | undefined);
    private _fetchExtendedInventory?;
    get fetchExtendedInventory(): boolean | cdktf.IResolvable;
    set fetchExtendedInventory(value: boolean | cdktf.IResolvable);
    resetFetchExtendedInventory(): void;
    get fetchExtendedInventoryInput(): boolean | cdktf.IResolvable | undefined;
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsGovcloudIntegrationsSns {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_extended_inventory CloudAwsGovcloudIntegrations#fetch_extended_inventory}
    */
    readonly fetchExtendedInventory?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsGovcloudIntegrationsSnsToTerraform(struct?: CloudAwsGovcloudIntegrationsSnsOutputReference | CloudAwsGovcloudIntegrationsSns): any;
export declare class CloudAwsGovcloudIntegrationsSnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsSns | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsSns | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchExtendedInventory?;
    get fetchExtendedInventory(): boolean | cdktf.IResolvable;
    set fetchExtendedInventory(value: boolean | cdktf.IResolvable);
    resetFetchExtendedInventory(): void;
    get fetchExtendedInventoryInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsGovcloudIntegrationsSqs {
    /**
    * Specify each AWS region that includes the resources that you want to monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#aws_regions CloudAwsGovcloudIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_extended_inventory CloudAwsGovcloudIntegrations#fetch_extended_inventory}
    */
    readonly fetchExtendedInventory?: boolean | cdktf.IResolvable;
    /**
    * Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#fetch_tags CloudAwsGovcloudIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#metrics_polling_interval CloudAwsGovcloudIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each name or prefix for the Queues that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#queue_prefixes CloudAwsGovcloudIntegrations#queue_prefixes}
    */
    readonly queuePrefixes?: string[];
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_key CloudAwsGovcloudIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations#tag_value CloudAwsGovcloudIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsGovcloudIntegrationsSqsToTerraform(struct?: CloudAwsGovcloudIntegrationsSqsOutputReference | CloudAwsGovcloudIntegrationsSqs): any;
export declare class CloudAwsGovcloudIntegrationsSqsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsGovcloudIntegrationsSqs | undefined;
    set internalValue(value: CloudAwsGovcloudIntegrationsSqs | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchExtendedInventory?;
    get fetchExtendedInventory(): boolean | cdktf.IResolvable;
    set fetchExtendedInventory(value: boolean | cdktf.IResolvable);
    resetFetchExtendedInventory(): void;
    get fetchExtendedInventoryInput(): boolean | cdktf.IResolvable | undefined;
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _queuePrefixes?;
    get queuePrefixes(): string[];
    set queuePrefixes(value: string[]);
    resetQueuePrefixes(): void;
    get queuePrefixesInput(): string[] | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations newrelic_cloud_aws_govcloud_integrations}
*/
export declare class CloudAwsGovcloudIntegrations extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_cloud_aws_govcloud_integrations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_integrations newrelic_cloud_aws_govcloud_integrations} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudAwsGovcloudIntegrationsConfig
    */
    constructor(scope: Construct, id: string, config: CloudAwsGovcloudIntegrationsConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkedAccountId?;
    get linkedAccountId(): number;
    set linkedAccountId(value: number);
    get linkedAccountIdInput(): number | undefined;
    private _alb;
    get alb(): CloudAwsGovcloudIntegrationsAlbOutputReference;
    putAlb(value: CloudAwsGovcloudIntegrationsAlb): void;
    resetAlb(): void;
    get albInput(): CloudAwsGovcloudIntegrationsAlb | undefined;
    private _apiGateway;
    get apiGateway(): CloudAwsGovcloudIntegrationsApiGatewayOutputReference;
    putApiGateway(value: CloudAwsGovcloudIntegrationsApiGateway): void;
    resetApiGateway(): void;
    get apiGatewayInput(): CloudAwsGovcloudIntegrationsApiGateway | undefined;
    private _autoScaling;
    get autoScaling(): CloudAwsGovcloudIntegrationsAutoScalingOutputReference;
    putAutoScaling(value: CloudAwsGovcloudIntegrationsAutoScaling): void;
    resetAutoScaling(): void;
    get autoScalingInput(): CloudAwsGovcloudIntegrationsAutoScaling | undefined;
    private _awsDirectConnect;
    get awsDirectConnect(): CloudAwsGovcloudIntegrationsAwsDirectConnectOutputReference;
    putAwsDirectConnect(value: CloudAwsGovcloudIntegrationsAwsDirectConnect): void;
    resetAwsDirectConnect(): void;
    get awsDirectConnectInput(): CloudAwsGovcloudIntegrationsAwsDirectConnect | undefined;
    private _awsStates;
    get awsStates(): CloudAwsGovcloudIntegrationsAwsStatesOutputReference;
    putAwsStates(value: CloudAwsGovcloudIntegrationsAwsStates): void;
    resetAwsStates(): void;
    get awsStatesInput(): CloudAwsGovcloudIntegrationsAwsStates | undefined;
    private _cloudtrail;
    get cloudtrail(): CloudAwsGovcloudIntegrationsCloudtrailOutputReference;
    putCloudtrail(value: CloudAwsGovcloudIntegrationsCloudtrail): void;
    resetCloudtrail(): void;
    get cloudtrailInput(): CloudAwsGovcloudIntegrationsCloudtrail | undefined;
    private _dynamoDb;
    get dynamoDb(): CloudAwsGovcloudIntegrationsDynamoDbOutputReference;
    putDynamoDb(value: CloudAwsGovcloudIntegrationsDynamoDb): void;
    resetDynamoDb(): void;
    get dynamoDbInput(): CloudAwsGovcloudIntegrationsDynamoDb | undefined;
    private _ebs;
    get ebs(): CloudAwsGovcloudIntegrationsEbsOutputReference;
    putEbs(value: CloudAwsGovcloudIntegrationsEbs): void;
    resetEbs(): void;
    get ebsInput(): CloudAwsGovcloudIntegrationsEbs | undefined;
    private _ec2;
    get ec2(): CloudAwsGovcloudIntegrationsEc2OutputReference;
    putEc2(value: CloudAwsGovcloudIntegrationsEc2): void;
    resetEc2(): void;
    get ec2Input(): CloudAwsGovcloudIntegrationsEc2 | undefined;
    private _elasticSearch;
    get elasticSearch(): CloudAwsGovcloudIntegrationsElasticSearchOutputReference;
    putElasticSearch(value: CloudAwsGovcloudIntegrationsElasticSearch): void;
    resetElasticSearch(): void;
    get elasticSearchInput(): CloudAwsGovcloudIntegrationsElasticSearch | undefined;
    private _elb;
    get elb(): CloudAwsGovcloudIntegrationsElbOutputReference;
    putElb(value: CloudAwsGovcloudIntegrationsElb): void;
    resetElb(): void;
    get elbInput(): CloudAwsGovcloudIntegrationsElb | undefined;
    private _emr;
    get emr(): CloudAwsGovcloudIntegrationsEmrOutputReference;
    putEmr(value: CloudAwsGovcloudIntegrationsEmr): void;
    resetEmr(): void;
    get emrInput(): CloudAwsGovcloudIntegrationsEmr | undefined;
    private _iam;
    get iam(): CloudAwsGovcloudIntegrationsIamOutputReference;
    putIam(value: CloudAwsGovcloudIntegrationsIam): void;
    resetIam(): void;
    get iamInput(): CloudAwsGovcloudIntegrationsIam | undefined;
    private _lambda;
    get lambda(): CloudAwsGovcloudIntegrationsLambdaOutputReference;
    putLambda(value: CloudAwsGovcloudIntegrationsLambda): void;
    resetLambda(): void;
    get lambdaInput(): CloudAwsGovcloudIntegrationsLambda | undefined;
    private _rds;
    get rds(): CloudAwsGovcloudIntegrationsRdsOutputReference;
    putRds(value: CloudAwsGovcloudIntegrationsRds): void;
    resetRds(): void;
    get rdsInput(): CloudAwsGovcloudIntegrationsRds | undefined;
    private _redShift;
    get redShift(): CloudAwsGovcloudIntegrationsRedShiftOutputReference;
    putRedShift(value: CloudAwsGovcloudIntegrationsRedShift): void;
    resetRedShift(): void;
    get redShiftInput(): CloudAwsGovcloudIntegrationsRedShift | undefined;
    private _route53;
    get route53(): CloudAwsGovcloudIntegrationsRoute53OutputReference;
    putRoute53(value: CloudAwsGovcloudIntegrationsRoute53): void;
    resetRoute53(): void;
    get route53Input(): CloudAwsGovcloudIntegrationsRoute53 | undefined;
    private _s3;
    get s3(): CloudAwsGovcloudIntegrationsS3OutputReference;
    putS3(value: CloudAwsGovcloudIntegrationsS3): void;
    resetS3(): void;
    get s3Input(): CloudAwsGovcloudIntegrationsS3 | undefined;
    private _sns;
    get sns(): CloudAwsGovcloudIntegrationsSnsOutputReference;
    putSns(value: CloudAwsGovcloudIntegrationsSns): void;
    resetSns(): void;
    get snsInput(): CloudAwsGovcloudIntegrationsSns | undefined;
    private _sqs;
    get sqs(): CloudAwsGovcloudIntegrationsSqsOutputReference;
    putSqs(value: CloudAwsGovcloudIntegrationsSqs): void;
    resetSqs(): void;
    get sqsInput(): CloudAwsGovcloudIntegrationsSqs | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
