import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudAwsGovcloudLinkAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * access-key-id of awsGovcloud account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_link_account#access_key_id CloudAwsGovcloudLinkAccount#access_key_id}
    */
    readonly accessKeyId: string;
    /**
    * The ID of the account in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_link_account#account_id CloudAwsGovcloudLinkAccount#account_id}
    */
    readonly accountId?: number;
    /**
    * awsGovcloud account id
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_link_account#aws_account_id CloudAwsGovcloudLinkAccount#aws_account_id}
    */
    readonly awsAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_link_account#id CloudAwsGovcloudLinkAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * push or pull
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_link_account#metric_collection_mode CloudAwsGovcloudLinkAccount#metric_collection_mode}
    */
    readonly metricCollectionMode?: string;
    /**
    * name of the account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_link_account#name CloudAwsGovcloudLinkAccount#name}
    */
    readonly name: string;
    /**
    * secret access key of the awsGovcloud account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_link_account#secret_access_key CloudAwsGovcloudLinkAccount#secret_access_key}
    */
    readonly secretAccessKey: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_link_account newrelic_cloud_aws_govcloud_link_account}
*/
export declare class CloudAwsGovcloudLinkAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_cloud_aws_govcloud_link_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_govcloud_link_account newrelic_cloud_aws_govcloud_link_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudAwsGovcloudLinkAccountConfig
    */
    constructor(scope: Construct, id: string, config: CloudAwsGovcloudLinkAccountConfig);
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    get accessKeyIdInput(): string | undefined;
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _awsAccountId?;
    get awsAccountId(): string;
    set awsAccountId(value: string);
    get awsAccountIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metricCollectionMode?;
    get metricCollectionMode(): string;
    set metricCollectionMode(value: string);
    resetMetricCollectionMode(): void;
    get metricCollectionModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secretAccessKey?;
    get secretAccessKey(): string;
    set secretAccessKey(value: string);
    get secretAccessKeyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
