import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudAwsIntegrationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the account in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#account_id CloudAwsIntegrations#account_id}
    */
    readonly accountId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#id CloudAwsIntegrations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the linked AWS account in New Relic
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#linked_account_id CloudAwsIntegrations#linked_account_id}
    */
    readonly linkedAccountId: number;
    /**
    * billing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#billing CloudAwsIntegrations#billing}
    */
    readonly billing?: CloudAwsIntegrationsBilling;
    /**
    * cloudtrail block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#cloudtrail CloudAwsIntegrations#cloudtrail}
    */
    readonly cloudtrail?: CloudAwsIntegrationsCloudtrail;
    /**
    * health block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#health CloudAwsIntegrations#health}
    */
    readonly health?: CloudAwsIntegrationsHealth;
    /**
    * trusted_advisor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#trusted_advisor CloudAwsIntegrations#trusted_advisor}
    */
    readonly trustedAdvisor?: CloudAwsIntegrationsTrustedAdvisor;
    /**
    * vpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#vpc CloudAwsIntegrations#vpc}
    */
    readonly vpc?: CloudAwsIntegrationsVpc;
    /**
    * x_ray block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#x_ray CloudAwsIntegrations#x_ray}
    */
    readonly xRay?: CloudAwsIntegrationsXRay;
}
export interface CloudAwsIntegrationsBilling {
    /**
    * The data polling interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#metrics_polling_interval CloudAwsIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsIntegrationsBillingToTerraform(struct?: CloudAwsIntegrationsBillingOutputReference | CloudAwsIntegrationsBilling): any;
export declare class CloudAwsIntegrationsBillingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsIntegrationsBilling | undefined;
    set internalValue(value: CloudAwsIntegrationsBilling | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsIntegrationsCloudtrail {
    /**
    * Specify each AWS region that includes the resources that you want to monitor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#aws_regions CloudAwsIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * The data polling interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#metrics_polling_interval CloudAwsIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsIntegrationsCloudtrailToTerraform(struct?: CloudAwsIntegrationsCloudtrailOutputReference | CloudAwsIntegrationsCloudtrail): any;
export declare class CloudAwsIntegrationsCloudtrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsIntegrationsCloudtrail | undefined;
    set internalValue(value: CloudAwsIntegrationsCloudtrail | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsIntegrationsHealth {
    /**
    * The data polling interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#metrics_polling_interval CloudAwsIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsIntegrationsHealthToTerraform(struct?: CloudAwsIntegrationsHealthOutputReference | CloudAwsIntegrationsHealth): any;
export declare class CloudAwsIntegrationsHealthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsIntegrationsHealth | undefined;
    set internalValue(value: CloudAwsIntegrationsHealth | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsIntegrationsTrustedAdvisor {
    /**
    * The data polling interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#metrics_polling_interval CloudAwsIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsIntegrationsTrustedAdvisorToTerraform(struct?: CloudAwsIntegrationsTrustedAdvisorOutputReference | CloudAwsIntegrationsTrustedAdvisor): any;
export declare class CloudAwsIntegrationsTrustedAdvisorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsIntegrationsTrustedAdvisor | undefined;
    set internalValue(value: CloudAwsIntegrationsTrustedAdvisor | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudAwsIntegrationsVpc {
    /**
    * Specify each AWS region that includes the resources that you want to monitor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#aws_regions CloudAwsIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * Specify if NAT gateway should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#fetch_nat_gateway CloudAwsIntegrations#fetch_nat_gateway}
    */
    readonly fetchNatGateway?: boolean | cdktf.IResolvable;
    /**
    * Specify if VPN should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#fetch_vpn CloudAwsIntegrations#fetch_vpn}
    */
    readonly fetchVpn?: boolean | cdktf.IResolvable;
    /**
    * The data polling interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#metrics_polling_interval CloudAwsIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#tag_key CloudAwsIntegrations#tag_key}
    */
    readonly tagKey?: string;
    /**
    * Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#tag_value CloudAwsIntegrations#tag_value}
    */
    readonly tagValue?: string;
}
export declare function cloudAwsIntegrationsVpcToTerraform(struct?: CloudAwsIntegrationsVpcOutputReference | CloudAwsIntegrationsVpc): any;
export declare class CloudAwsIntegrationsVpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsIntegrationsVpc | undefined;
    set internalValue(value: CloudAwsIntegrationsVpc | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _fetchNatGateway?;
    get fetchNatGateway(): boolean | cdktf.IResolvable;
    set fetchNatGateway(value: boolean | cdktf.IResolvable);
    resetFetchNatGateway(): void;
    get fetchNatGatewayInput(): boolean | cdktf.IResolvable | undefined;
    private _fetchVpn?;
    get fetchVpn(): boolean | cdktf.IResolvable;
    set fetchVpn(value: boolean | cdktf.IResolvable);
    resetFetchVpn(): void;
    get fetchVpnInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    resetTagKey(): void;
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface CloudAwsIntegrationsXRay {
    /**
    * Specify each AWS region that includes the resources that you want to monitor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#aws_regions CloudAwsIntegrations#aws_regions}
    */
    readonly awsRegions?: string[];
    /**
    * The data polling interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations#metrics_polling_interval CloudAwsIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudAwsIntegrationsXRayToTerraform(struct?: CloudAwsIntegrationsXRayOutputReference | CloudAwsIntegrationsXRay): any;
export declare class CloudAwsIntegrationsXRayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAwsIntegrationsXRay | undefined;
    set internalValue(value: CloudAwsIntegrationsXRay | undefined);
    private _awsRegions?;
    get awsRegions(): string[];
    set awsRegions(value: string[]);
    resetAwsRegions(): void;
    get awsRegionsInput(): string[] | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations newrelic_cloud_aws_integrations}
*/
export declare class CloudAwsIntegrations extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_cloud_aws_integrations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_integrations newrelic_cloud_aws_integrations} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudAwsIntegrationsConfig
    */
    constructor(scope: Construct, id: string, config: CloudAwsIntegrationsConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkedAccountId?;
    get linkedAccountId(): number;
    set linkedAccountId(value: number);
    get linkedAccountIdInput(): number | undefined;
    private _billing;
    get billing(): CloudAwsIntegrationsBillingOutputReference;
    putBilling(value: CloudAwsIntegrationsBilling): void;
    resetBilling(): void;
    get billingInput(): CloudAwsIntegrationsBilling | undefined;
    private _cloudtrail;
    get cloudtrail(): CloudAwsIntegrationsCloudtrailOutputReference;
    putCloudtrail(value: CloudAwsIntegrationsCloudtrail): void;
    resetCloudtrail(): void;
    get cloudtrailInput(): CloudAwsIntegrationsCloudtrail | undefined;
    private _health;
    get health(): CloudAwsIntegrationsHealthOutputReference;
    putHealth(value: CloudAwsIntegrationsHealth): void;
    resetHealth(): void;
    get healthInput(): CloudAwsIntegrationsHealth | undefined;
    private _trustedAdvisor;
    get trustedAdvisor(): CloudAwsIntegrationsTrustedAdvisorOutputReference;
    putTrustedAdvisor(value: CloudAwsIntegrationsTrustedAdvisor): void;
    resetTrustedAdvisor(): void;
    get trustedAdvisorInput(): CloudAwsIntegrationsTrustedAdvisor | undefined;
    private _vpc;
    get vpc(): CloudAwsIntegrationsVpcOutputReference;
    putVpc(value: CloudAwsIntegrationsVpc): void;
    resetVpc(): void;
    get vpcInput(): CloudAwsIntegrationsVpc | undefined;
    private _xRay;
    get xRay(): CloudAwsIntegrationsXRayOutputReference;
    putXRay(value: CloudAwsIntegrationsXRay): void;
    resetXRay(): void;
    get xRayInput(): CloudAwsIntegrationsXRay | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
