import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudAzureIntegrationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the account in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#account_id CloudAzureIntegrations#account_id}
    */
    readonly accountId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#id CloudAzureIntegrations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the linked Azure account in New Relic
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#linked_account_id CloudAzureIntegrations#linked_account_id}
    */
    readonly linkedAccountId: number;
    /**
    * api_management block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#api_management CloudAzureIntegrations#api_management}
    */
    readonly apiManagement?: CloudAzureIntegrationsApiManagement;
    /**
    * app_gateway block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#app_gateway CloudAzureIntegrations#app_gateway}
    */
    readonly appGateway?: CloudAzureIntegrationsAppGateway;
    /**
    * app_service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#app_service CloudAzureIntegrations#app_service}
    */
    readonly appService?: CloudAzureIntegrationsAppService;
    /**
    * containers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#containers CloudAzureIntegrations#containers}
    */
    readonly containers?: CloudAzureIntegrationsContainers;
    /**
    * cosmos_db block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#cosmos_db CloudAzureIntegrations#cosmos_db}
    */
    readonly cosmosDb?: CloudAzureIntegrationsCosmosDb;
    /**
    * cost_management block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#cost_management CloudAzureIntegrations#cost_management}
    */
    readonly costManagement?: CloudAzureIntegrationsCostManagement;
    /**
    * data_factory block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#data_factory CloudAzureIntegrations#data_factory}
    */
    readonly dataFactory?: CloudAzureIntegrationsDataFactory;
    /**
    * event_hub block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#event_hub CloudAzureIntegrations#event_hub}
    */
    readonly eventHub?: CloudAzureIntegrationsEventHub;
    /**
    * express_route block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#express_route CloudAzureIntegrations#express_route}
    */
    readonly expressRoute?: CloudAzureIntegrationsExpressRoute;
    /**
    * firewalls block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#firewalls CloudAzureIntegrations#firewalls}
    */
    readonly firewalls?: CloudAzureIntegrationsFirewalls;
    /**
    * front_door block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#front_door CloudAzureIntegrations#front_door}
    */
    readonly frontDoor?: CloudAzureIntegrationsFrontDoor;
    /**
    * functions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#functions CloudAzureIntegrations#functions}
    */
    readonly functions?: CloudAzureIntegrationsFunctions;
    /**
    * key_vault block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#key_vault CloudAzureIntegrations#key_vault}
    */
    readonly keyVault?: CloudAzureIntegrationsKeyVault;
    /**
    * load_balancer block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#load_balancer CloudAzureIntegrations#load_balancer}
    */
    readonly loadBalancer?: CloudAzureIntegrationsLoadBalancer;
    /**
    * logic_apps block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#logic_apps CloudAzureIntegrations#logic_apps}
    */
    readonly logicApps?: CloudAzureIntegrationsLogicApps;
    /**
    * machine_learning block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#machine_learning CloudAzureIntegrations#machine_learning}
    */
    readonly machineLearning?: CloudAzureIntegrationsMachineLearning;
    /**
    * maria_db block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#maria_db CloudAzureIntegrations#maria_db}
    */
    readonly mariaDb?: CloudAzureIntegrationsMariaDb;
    /**
    * mysql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#mysql CloudAzureIntegrations#mysql}
    */
    readonly mysql?: CloudAzureIntegrationsMysql;
    /**
    * postgresql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#postgresql CloudAzureIntegrations#postgresql}
    */
    readonly postgresql?: CloudAzureIntegrationsPostgresql;
    /**
    * power_bi_dedicated block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#power_bi_dedicated CloudAzureIntegrations#power_bi_dedicated}
    */
    readonly powerBiDedicated?: CloudAzureIntegrationsPowerBiDedicated;
    /**
    * redis_cache block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#redis_cache CloudAzureIntegrations#redis_cache}
    */
    readonly redisCache?: CloudAzureIntegrationsRedisCache;
    /**
    * service_bus block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#service_bus CloudAzureIntegrations#service_bus}
    */
    readonly serviceBus?: CloudAzureIntegrationsServiceBus;
    /**
    * sql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#sql CloudAzureIntegrations#sql}
    */
    readonly sql?: CloudAzureIntegrationsSql;
    /**
    * sql_managed block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#sql_managed CloudAzureIntegrations#sql_managed}
    */
    readonly sqlManaged?: CloudAzureIntegrationsSqlManaged;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#storage CloudAzureIntegrations#storage}
    */
    readonly storage?: CloudAzureIntegrationsStorage;
    /**
    * virtual_machine block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#virtual_machine CloudAzureIntegrations#virtual_machine}
    */
    readonly virtualMachine?: CloudAzureIntegrationsVirtualMachine;
    /**
    * virtual_networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#virtual_networks CloudAzureIntegrations#virtual_networks}
    */
    readonly virtualNetworks?: CloudAzureIntegrationsVirtualNetworks;
    /**
    * vms block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#vms CloudAzureIntegrations#vms}
    */
    readonly vms?: CloudAzureIntegrationsVms;
    /**
    * vpn_gateway block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#vpn_gateway CloudAzureIntegrations#vpn_gateway}
    */
    readonly vpnGateway?: CloudAzureIntegrationsVpnGateway;
}
export interface CloudAzureIntegrationsApiManagement {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsApiManagementToTerraform(struct?: CloudAzureIntegrationsApiManagementOutputReference | CloudAzureIntegrationsApiManagement): any;
export declare class CloudAzureIntegrationsApiManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsApiManagement | undefined;
    set internalValue(value: CloudAzureIntegrationsApiManagement | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsAppGateway {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsAppGatewayToTerraform(struct?: CloudAzureIntegrationsAppGatewayOutputReference | CloudAzureIntegrationsAppGateway): any;
export declare class CloudAzureIntegrationsAppGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsAppGateway | undefined;
    set internalValue(value: CloudAzureIntegrationsAppGateway | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsAppService {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsAppServiceToTerraform(struct?: CloudAzureIntegrationsAppServiceOutputReference | CloudAzureIntegrationsAppService): any;
export declare class CloudAzureIntegrationsAppServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsAppService | undefined;
    set internalValue(value: CloudAzureIntegrationsAppService | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsContainers {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsContainersToTerraform(struct?: CloudAzureIntegrationsContainersOutputReference | CloudAzureIntegrationsContainers): any;
export declare class CloudAzureIntegrationsContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsContainers | undefined;
    set internalValue(value: CloudAzureIntegrationsContainers | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsCosmosDb {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsCosmosDbToTerraform(struct?: CloudAzureIntegrationsCosmosDbOutputReference | CloudAzureIntegrationsCosmosDb): any;
export declare class CloudAzureIntegrationsCosmosDbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsCosmosDb | undefined;
    set internalValue(value: CloudAzureIntegrationsCosmosDb | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsCostManagement {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify if additional cost data per tag should be collected. This field is case sensitive.
  
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#tag_keys CloudAzureIntegrations#tag_keys}
    */
    readonly tagKeys?: string[];
}
export declare function cloudAzureIntegrationsCostManagementToTerraform(struct?: CloudAzureIntegrationsCostManagementOutputReference | CloudAzureIntegrationsCostManagement): any;
export declare class CloudAzureIntegrationsCostManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsCostManagement | undefined;
    set internalValue(value: CloudAzureIntegrationsCostManagement | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _tagKeys?;
    get tagKeys(): string[];
    set tagKeys(value: string[]);
    resetTagKeys(): void;
    get tagKeysInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsDataFactory {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsDataFactoryToTerraform(struct?: CloudAzureIntegrationsDataFactoryOutputReference | CloudAzureIntegrationsDataFactory): any;
export declare class CloudAzureIntegrationsDataFactoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsDataFactory | undefined;
    set internalValue(value: CloudAzureIntegrationsDataFactory | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsEventHub {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsEventHubToTerraform(struct?: CloudAzureIntegrationsEventHubOutputReference | CloudAzureIntegrationsEventHub): any;
export declare class CloudAzureIntegrationsEventHubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsEventHub | undefined;
    set internalValue(value: CloudAzureIntegrationsEventHub | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsExpressRoute {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsExpressRouteToTerraform(struct?: CloudAzureIntegrationsExpressRouteOutputReference | CloudAzureIntegrationsExpressRoute): any;
export declare class CloudAzureIntegrationsExpressRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsExpressRoute | undefined;
    set internalValue(value: CloudAzureIntegrationsExpressRoute | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsFirewalls {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsFirewallsToTerraform(struct?: CloudAzureIntegrationsFirewallsOutputReference | CloudAzureIntegrationsFirewalls): any;
export declare class CloudAzureIntegrationsFirewallsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsFirewalls | undefined;
    set internalValue(value: CloudAzureIntegrationsFirewalls | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsFrontDoor {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsFrontDoorToTerraform(struct?: CloudAzureIntegrationsFrontDoorOutputReference | CloudAzureIntegrationsFrontDoor): any;
export declare class CloudAzureIntegrationsFrontDoorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsFrontDoor | undefined;
    set internalValue(value: CloudAzureIntegrationsFrontDoor | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsFunctions {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsFunctionsToTerraform(struct?: CloudAzureIntegrationsFunctionsOutputReference | CloudAzureIntegrationsFunctions): any;
export declare class CloudAzureIntegrationsFunctionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsFunctions | undefined;
    set internalValue(value: CloudAzureIntegrationsFunctions | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsKeyVault {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsKeyVaultToTerraform(struct?: CloudAzureIntegrationsKeyVaultOutputReference | CloudAzureIntegrationsKeyVault): any;
export declare class CloudAzureIntegrationsKeyVaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsKeyVault | undefined;
    set internalValue(value: CloudAzureIntegrationsKeyVault | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsLoadBalancer {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsLoadBalancerToTerraform(struct?: CloudAzureIntegrationsLoadBalancerOutputReference | CloudAzureIntegrationsLoadBalancer): any;
export declare class CloudAzureIntegrationsLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsLoadBalancer | undefined;
    set internalValue(value: CloudAzureIntegrationsLoadBalancer | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsLogicApps {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsLogicAppsToTerraform(struct?: CloudAzureIntegrationsLogicAppsOutputReference | CloudAzureIntegrationsLogicApps): any;
export declare class CloudAzureIntegrationsLogicAppsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsLogicApps | undefined;
    set internalValue(value: CloudAzureIntegrationsLogicApps | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsMachineLearning {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsMachineLearningToTerraform(struct?: CloudAzureIntegrationsMachineLearningOutputReference | CloudAzureIntegrationsMachineLearning): any;
export declare class CloudAzureIntegrationsMachineLearningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsMachineLearning | undefined;
    set internalValue(value: CloudAzureIntegrationsMachineLearning | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsMariaDb {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsMariaDbToTerraform(struct?: CloudAzureIntegrationsMariaDbOutputReference | CloudAzureIntegrationsMariaDb): any;
export declare class CloudAzureIntegrationsMariaDbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsMariaDb | undefined;
    set internalValue(value: CloudAzureIntegrationsMariaDb | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsMysql {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsMysqlToTerraform(struct?: CloudAzureIntegrationsMysqlOutputReference | CloudAzureIntegrationsMysql): any;
export declare class CloudAzureIntegrationsMysqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsMysql | undefined;
    set internalValue(value: CloudAzureIntegrationsMysql | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsPostgresql {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsPostgresqlToTerraform(struct?: CloudAzureIntegrationsPostgresqlOutputReference | CloudAzureIntegrationsPostgresql): any;
export declare class CloudAzureIntegrationsPostgresqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsPostgresql | undefined;
    set internalValue(value: CloudAzureIntegrationsPostgresql | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsPowerBiDedicated {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsPowerBiDedicatedToTerraform(struct?: CloudAzureIntegrationsPowerBiDedicatedOutputReference | CloudAzureIntegrationsPowerBiDedicated): any;
export declare class CloudAzureIntegrationsPowerBiDedicatedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsPowerBiDedicated | undefined;
    set internalValue(value: CloudAzureIntegrationsPowerBiDedicated | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsRedisCache {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsRedisCacheToTerraform(struct?: CloudAzureIntegrationsRedisCacheOutputReference | CloudAzureIntegrationsRedisCache): any;
export declare class CloudAzureIntegrationsRedisCacheOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsRedisCache | undefined;
    set internalValue(value: CloudAzureIntegrationsRedisCache | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsServiceBus {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsServiceBusToTerraform(struct?: CloudAzureIntegrationsServiceBusOutputReference | CloudAzureIntegrationsServiceBus): any;
export declare class CloudAzureIntegrationsServiceBusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsServiceBus | undefined;
    set internalValue(value: CloudAzureIntegrationsServiceBus | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsSql {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsSqlToTerraform(struct?: CloudAzureIntegrationsSqlOutputReference | CloudAzureIntegrationsSql): any;
export declare class CloudAzureIntegrationsSqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsSql | undefined;
    set internalValue(value: CloudAzureIntegrationsSql | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsSqlManaged {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsSqlManagedToTerraform(struct?: CloudAzureIntegrationsSqlManagedOutputReference | CloudAzureIntegrationsSqlManaged): any;
export declare class CloudAzureIntegrationsSqlManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsSqlManaged | undefined;
    set internalValue(value: CloudAzureIntegrationsSqlManaged | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsStorage {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsStorageToTerraform(struct?: CloudAzureIntegrationsStorageOutputReference | CloudAzureIntegrationsStorage): any;
export declare class CloudAzureIntegrationsStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsStorage | undefined;
    set internalValue(value: CloudAzureIntegrationsStorage | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsVirtualMachine {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsVirtualMachineToTerraform(struct?: CloudAzureIntegrationsVirtualMachineOutputReference | CloudAzureIntegrationsVirtualMachine): any;
export declare class CloudAzureIntegrationsVirtualMachineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsVirtualMachine | undefined;
    set internalValue(value: CloudAzureIntegrationsVirtualMachine | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsVirtualNetworks {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsVirtualNetworksToTerraform(struct?: CloudAzureIntegrationsVirtualNetworksOutputReference | CloudAzureIntegrationsVirtualNetworks): any;
export declare class CloudAzureIntegrationsVirtualNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsVirtualNetworks | undefined;
    set internalValue(value: CloudAzureIntegrationsVirtualNetworks | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsVms {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsVmsToTerraform(struct?: CloudAzureIntegrationsVmsOutputReference | CloudAzureIntegrationsVms): any;
export declare class CloudAzureIntegrationsVmsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsVms | undefined;
    set internalValue(value: CloudAzureIntegrationsVms | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
export interface CloudAzureIntegrationsVpnGateway {
    /**
    * The data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#metrics_polling_interval CloudAzureIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
    /**
    * Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations#resource_groups CloudAzureIntegrations#resource_groups}
    */
    readonly resourceGroups?: string[];
}
export declare function cloudAzureIntegrationsVpnGatewayToTerraform(struct?: CloudAzureIntegrationsVpnGatewayOutputReference | CloudAzureIntegrationsVpnGateway): any;
export declare class CloudAzureIntegrationsVpnGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudAzureIntegrationsVpnGateway | undefined;
    set internalValue(value: CloudAzureIntegrationsVpnGateway | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations newrelic_cloud_azure_integrations}
*/
export declare class CloudAzureIntegrations extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_cloud_azure_integrations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_azure_integrations newrelic_cloud_azure_integrations} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudAzureIntegrationsConfig
    */
    constructor(scope: Construct, id: string, config: CloudAzureIntegrationsConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkedAccountId?;
    get linkedAccountId(): number;
    set linkedAccountId(value: number);
    get linkedAccountIdInput(): number | undefined;
    private _apiManagement;
    get apiManagement(): CloudAzureIntegrationsApiManagementOutputReference;
    putApiManagement(value: CloudAzureIntegrationsApiManagement): void;
    resetApiManagement(): void;
    get apiManagementInput(): CloudAzureIntegrationsApiManagement | undefined;
    private _appGateway;
    get appGateway(): CloudAzureIntegrationsAppGatewayOutputReference;
    putAppGateway(value: CloudAzureIntegrationsAppGateway): void;
    resetAppGateway(): void;
    get appGatewayInput(): CloudAzureIntegrationsAppGateway | undefined;
    private _appService;
    get appService(): CloudAzureIntegrationsAppServiceOutputReference;
    putAppService(value: CloudAzureIntegrationsAppService): void;
    resetAppService(): void;
    get appServiceInput(): CloudAzureIntegrationsAppService | undefined;
    private _containers;
    get containers(): CloudAzureIntegrationsContainersOutputReference;
    putContainers(value: CloudAzureIntegrationsContainers): void;
    resetContainers(): void;
    get containersInput(): CloudAzureIntegrationsContainers | undefined;
    private _cosmosDb;
    get cosmosDb(): CloudAzureIntegrationsCosmosDbOutputReference;
    putCosmosDb(value: CloudAzureIntegrationsCosmosDb): void;
    resetCosmosDb(): void;
    get cosmosDbInput(): CloudAzureIntegrationsCosmosDb | undefined;
    private _costManagement;
    get costManagement(): CloudAzureIntegrationsCostManagementOutputReference;
    putCostManagement(value: CloudAzureIntegrationsCostManagement): void;
    resetCostManagement(): void;
    get costManagementInput(): CloudAzureIntegrationsCostManagement | undefined;
    private _dataFactory;
    get dataFactory(): CloudAzureIntegrationsDataFactoryOutputReference;
    putDataFactory(value: CloudAzureIntegrationsDataFactory): void;
    resetDataFactory(): void;
    get dataFactoryInput(): CloudAzureIntegrationsDataFactory | undefined;
    private _eventHub;
    get eventHub(): CloudAzureIntegrationsEventHubOutputReference;
    putEventHub(value: CloudAzureIntegrationsEventHub): void;
    resetEventHub(): void;
    get eventHubInput(): CloudAzureIntegrationsEventHub | undefined;
    private _expressRoute;
    get expressRoute(): CloudAzureIntegrationsExpressRouteOutputReference;
    putExpressRoute(value: CloudAzureIntegrationsExpressRoute): void;
    resetExpressRoute(): void;
    get expressRouteInput(): CloudAzureIntegrationsExpressRoute | undefined;
    private _firewalls;
    get firewalls(): CloudAzureIntegrationsFirewallsOutputReference;
    putFirewalls(value: CloudAzureIntegrationsFirewalls): void;
    resetFirewalls(): void;
    get firewallsInput(): CloudAzureIntegrationsFirewalls | undefined;
    private _frontDoor;
    get frontDoor(): CloudAzureIntegrationsFrontDoorOutputReference;
    putFrontDoor(value: CloudAzureIntegrationsFrontDoor): void;
    resetFrontDoor(): void;
    get frontDoorInput(): CloudAzureIntegrationsFrontDoor | undefined;
    private _functions;
    get functions(): CloudAzureIntegrationsFunctionsOutputReference;
    putFunctions(value: CloudAzureIntegrationsFunctions): void;
    resetFunctions(): void;
    get functionsInput(): CloudAzureIntegrationsFunctions | undefined;
    private _keyVault;
    get keyVault(): CloudAzureIntegrationsKeyVaultOutputReference;
    putKeyVault(value: CloudAzureIntegrationsKeyVault): void;
    resetKeyVault(): void;
    get keyVaultInput(): CloudAzureIntegrationsKeyVault | undefined;
    private _loadBalancer;
    get loadBalancer(): CloudAzureIntegrationsLoadBalancerOutputReference;
    putLoadBalancer(value: CloudAzureIntegrationsLoadBalancer): void;
    resetLoadBalancer(): void;
    get loadBalancerInput(): CloudAzureIntegrationsLoadBalancer | undefined;
    private _logicApps;
    get logicApps(): CloudAzureIntegrationsLogicAppsOutputReference;
    putLogicApps(value: CloudAzureIntegrationsLogicApps): void;
    resetLogicApps(): void;
    get logicAppsInput(): CloudAzureIntegrationsLogicApps | undefined;
    private _machineLearning;
    get machineLearning(): CloudAzureIntegrationsMachineLearningOutputReference;
    putMachineLearning(value: CloudAzureIntegrationsMachineLearning): void;
    resetMachineLearning(): void;
    get machineLearningInput(): CloudAzureIntegrationsMachineLearning | undefined;
    private _mariaDb;
    get mariaDb(): CloudAzureIntegrationsMariaDbOutputReference;
    putMariaDb(value: CloudAzureIntegrationsMariaDb): void;
    resetMariaDb(): void;
    get mariaDbInput(): CloudAzureIntegrationsMariaDb | undefined;
    private _mysql;
    get mysql(): CloudAzureIntegrationsMysqlOutputReference;
    putMysql(value: CloudAzureIntegrationsMysql): void;
    resetMysql(): void;
    get mysqlInput(): CloudAzureIntegrationsMysql | undefined;
    private _postgresql;
    get postgresql(): CloudAzureIntegrationsPostgresqlOutputReference;
    putPostgresql(value: CloudAzureIntegrationsPostgresql): void;
    resetPostgresql(): void;
    get postgresqlInput(): CloudAzureIntegrationsPostgresql | undefined;
    private _powerBiDedicated;
    get powerBiDedicated(): CloudAzureIntegrationsPowerBiDedicatedOutputReference;
    putPowerBiDedicated(value: CloudAzureIntegrationsPowerBiDedicated): void;
    resetPowerBiDedicated(): void;
    get powerBiDedicatedInput(): CloudAzureIntegrationsPowerBiDedicated | undefined;
    private _redisCache;
    get redisCache(): CloudAzureIntegrationsRedisCacheOutputReference;
    putRedisCache(value: CloudAzureIntegrationsRedisCache): void;
    resetRedisCache(): void;
    get redisCacheInput(): CloudAzureIntegrationsRedisCache | undefined;
    private _serviceBus;
    get serviceBus(): CloudAzureIntegrationsServiceBusOutputReference;
    putServiceBus(value: CloudAzureIntegrationsServiceBus): void;
    resetServiceBus(): void;
    get serviceBusInput(): CloudAzureIntegrationsServiceBus | undefined;
    private _sql;
    get sql(): CloudAzureIntegrationsSqlOutputReference;
    putSql(value: CloudAzureIntegrationsSql): void;
    resetSql(): void;
    get sqlInput(): CloudAzureIntegrationsSql | undefined;
    private _sqlManaged;
    get sqlManaged(): CloudAzureIntegrationsSqlManagedOutputReference;
    putSqlManaged(value: CloudAzureIntegrationsSqlManaged): void;
    resetSqlManaged(): void;
    get sqlManagedInput(): CloudAzureIntegrationsSqlManaged | undefined;
    private _storage;
    get storage(): CloudAzureIntegrationsStorageOutputReference;
    putStorage(value: CloudAzureIntegrationsStorage): void;
    resetStorage(): void;
    get storageInput(): CloudAzureIntegrationsStorage | undefined;
    private _virtualMachine;
    get virtualMachine(): CloudAzureIntegrationsVirtualMachineOutputReference;
    putVirtualMachine(value: CloudAzureIntegrationsVirtualMachine): void;
    resetVirtualMachine(): void;
    get virtualMachineInput(): CloudAzureIntegrationsVirtualMachine | undefined;
    private _virtualNetworks;
    get virtualNetworks(): CloudAzureIntegrationsVirtualNetworksOutputReference;
    putVirtualNetworks(value: CloudAzureIntegrationsVirtualNetworks): void;
    resetVirtualNetworks(): void;
    get virtualNetworksInput(): CloudAzureIntegrationsVirtualNetworks | undefined;
    private _vms;
    get vms(): CloudAzureIntegrationsVmsOutputReference;
    putVms(value: CloudAzureIntegrationsVms): void;
    resetVms(): void;
    get vmsInput(): CloudAzureIntegrationsVms | undefined;
    private _vpnGateway;
    get vpnGateway(): CloudAzureIntegrationsVpnGatewayOutputReference;
    putVpnGateway(value: CloudAzureIntegrationsVpnGateway): void;
    resetVpnGateway(): void;
    get vpnGatewayInput(): CloudAzureIntegrationsVpnGateway | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
