import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudGcpIntegrationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the newrelic account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#account_id CloudGcpIntegrations#account_id}
    */
    readonly accountId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#id CloudGcpIntegrations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Id of the linked gcp account in New Relic
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#linked_account_id CloudGcpIntegrations#linked_account_id}
    */
    readonly linkedAccountId: number;
    /**
    * app_engine block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#app_engine CloudGcpIntegrations#app_engine}
    */
    readonly appEngine?: CloudGcpIntegrationsAppEngine;
    /**
    * big_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#big_query CloudGcpIntegrations#big_query}
    */
    readonly bigQuery?: CloudGcpIntegrationsBigQuery;
    /**
    * big_table block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#big_table CloudGcpIntegrations#big_table}
    */
    readonly bigTable?: CloudGcpIntegrationsBigTable;
    /**
    * composer block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#composer CloudGcpIntegrations#composer}
    */
    readonly composer?: CloudGcpIntegrationsComposer;
    /**
    * data_flow block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#data_flow CloudGcpIntegrations#data_flow}
    */
    readonly dataFlow?: CloudGcpIntegrationsDataFlow;
    /**
    * data_proc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#data_proc CloudGcpIntegrations#data_proc}
    */
    readonly dataProc?: CloudGcpIntegrationsDataProc;
    /**
    * data_store block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#data_store CloudGcpIntegrations#data_store}
    */
    readonly dataStore?: CloudGcpIntegrationsDataStore;
    /**
    * fire_base_database block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#fire_base_database CloudGcpIntegrations#fire_base_database}
    */
    readonly fireBaseDatabase?: CloudGcpIntegrationsFireBaseDatabase;
    /**
    * fire_base_hosting block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#fire_base_hosting CloudGcpIntegrations#fire_base_hosting}
    */
    readonly fireBaseHosting?: CloudGcpIntegrationsFireBaseHosting;
    /**
    * fire_base_storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#fire_base_storage CloudGcpIntegrations#fire_base_storage}
    */
    readonly fireBaseStorage?: CloudGcpIntegrationsFireBaseStorage;
    /**
    * fire_store block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#fire_store CloudGcpIntegrations#fire_store}
    */
    readonly fireStore?: CloudGcpIntegrationsFireStore;
    /**
    * functions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#functions CloudGcpIntegrations#functions}
    */
    readonly functions?: CloudGcpIntegrationsFunctions;
    /**
    * interconnect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#interconnect CloudGcpIntegrations#interconnect}
    */
    readonly interconnect?: CloudGcpIntegrationsInterconnect;
    /**
    * kubernetes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#kubernetes CloudGcpIntegrations#kubernetes}
    */
    readonly kubernetes?: CloudGcpIntegrationsKubernetes;
    /**
    * load_balancing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#load_balancing CloudGcpIntegrations#load_balancing}
    */
    readonly loadBalancing?: CloudGcpIntegrationsLoadBalancing;
    /**
    * mem_cache block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#mem_cache CloudGcpIntegrations#mem_cache}
    */
    readonly memCache?: CloudGcpIntegrationsMemCache;
    /**
    * pub_sub block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#pub_sub CloudGcpIntegrations#pub_sub}
    */
    readonly pubSub?: CloudGcpIntegrationsPubSub;
    /**
    * redis block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#redis CloudGcpIntegrations#redis}
    */
    readonly redis?: CloudGcpIntegrationsRedis;
    /**
    * router block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#router CloudGcpIntegrations#router}
    */
    readonly router?: CloudGcpIntegrationsRouter;
    /**
    * run block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#run CloudGcpIntegrations#run}
    */
    readonly run?: CloudGcpIntegrationsRun;
    /**
    * spanner block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#spanner CloudGcpIntegrations#spanner}
    */
    readonly spanner?: CloudGcpIntegrationsSpanner;
    /**
    * sql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#sql CloudGcpIntegrations#sql}
    */
    readonly sql?: CloudGcpIntegrationsSql;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#storage CloudGcpIntegrations#storage}
    */
    readonly storage?: CloudGcpIntegrationsStorage;
    /**
    * virtual_machines block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#virtual_machines CloudGcpIntegrations#virtual_machines}
    */
    readonly virtualMachines?: CloudGcpIntegrationsVirtualMachines;
    /**
    * vpc_access block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#vpc_access CloudGcpIntegrations#vpc_access}
    */
    readonly vpcAccess?: CloudGcpIntegrationsVpcAccess;
}
export interface CloudGcpIntegrationsAppEngine {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsAppEngineToTerraform(struct?: CloudGcpIntegrationsAppEngineOutputReference | CloudGcpIntegrationsAppEngine): any;
export declare class CloudGcpIntegrationsAppEngineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsAppEngine | undefined;
    set internalValue(value: CloudGcpIntegrationsAppEngine | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsBigQuery {
    /**
    * to fetch tags of the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#fetch_tags CloudGcpIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsBigQueryToTerraform(struct?: CloudGcpIntegrationsBigQueryOutputReference | CloudGcpIntegrationsBigQuery): any;
export declare class CloudGcpIntegrationsBigQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsBigQuery | undefined;
    set internalValue(value: CloudGcpIntegrationsBigQuery | undefined);
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsBigTable {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsBigTableToTerraform(struct?: CloudGcpIntegrationsBigTableOutputReference | CloudGcpIntegrationsBigTable): any;
export declare class CloudGcpIntegrationsBigTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsBigTable | undefined;
    set internalValue(value: CloudGcpIntegrationsBigTable | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsComposer {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsComposerToTerraform(struct?: CloudGcpIntegrationsComposerOutputReference | CloudGcpIntegrationsComposer): any;
export declare class CloudGcpIntegrationsComposerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsComposer | undefined;
    set internalValue(value: CloudGcpIntegrationsComposer | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsDataFlow {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsDataFlowToTerraform(struct?: CloudGcpIntegrationsDataFlowOutputReference | CloudGcpIntegrationsDataFlow): any;
export declare class CloudGcpIntegrationsDataFlowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsDataFlow | undefined;
    set internalValue(value: CloudGcpIntegrationsDataFlow | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsDataProc {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsDataProcToTerraform(struct?: CloudGcpIntegrationsDataProcOutputReference | CloudGcpIntegrationsDataProc): any;
export declare class CloudGcpIntegrationsDataProcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsDataProc | undefined;
    set internalValue(value: CloudGcpIntegrationsDataProc | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsDataStore {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsDataStoreToTerraform(struct?: CloudGcpIntegrationsDataStoreOutputReference | CloudGcpIntegrationsDataStore): any;
export declare class CloudGcpIntegrationsDataStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsDataStore | undefined;
    set internalValue(value: CloudGcpIntegrationsDataStore | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsFireBaseDatabase {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsFireBaseDatabaseToTerraform(struct?: CloudGcpIntegrationsFireBaseDatabaseOutputReference | CloudGcpIntegrationsFireBaseDatabase): any;
export declare class CloudGcpIntegrationsFireBaseDatabaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsFireBaseDatabase | undefined;
    set internalValue(value: CloudGcpIntegrationsFireBaseDatabase | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsFireBaseHosting {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsFireBaseHostingToTerraform(struct?: CloudGcpIntegrationsFireBaseHostingOutputReference | CloudGcpIntegrationsFireBaseHosting): any;
export declare class CloudGcpIntegrationsFireBaseHostingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsFireBaseHosting | undefined;
    set internalValue(value: CloudGcpIntegrationsFireBaseHosting | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsFireBaseStorage {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsFireBaseStorageToTerraform(struct?: CloudGcpIntegrationsFireBaseStorageOutputReference | CloudGcpIntegrationsFireBaseStorage): any;
export declare class CloudGcpIntegrationsFireBaseStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsFireBaseStorage | undefined;
    set internalValue(value: CloudGcpIntegrationsFireBaseStorage | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsFireStore {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsFireStoreToTerraform(struct?: CloudGcpIntegrationsFireStoreOutputReference | CloudGcpIntegrationsFireStore): any;
export declare class CloudGcpIntegrationsFireStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsFireStore | undefined;
    set internalValue(value: CloudGcpIntegrationsFireStore | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsFunctions {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsFunctionsToTerraform(struct?: CloudGcpIntegrationsFunctionsOutputReference | CloudGcpIntegrationsFunctions): any;
export declare class CloudGcpIntegrationsFunctionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsFunctions | undefined;
    set internalValue(value: CloudGcpIntegrationsFunctions | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsInterconnect {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsInterconnectToTerraform(struct?: CloudGcpIntegrationsInterconnectOutputReference | CloudGcpIntegrationsInterconnect): any;
export declare class CloudGcpIntegrationsInterconnectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsInterconnect | undefined;
    set internalValue(value: CloudGcpIntegrationsInterconnect | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsKubernetes {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsKubernetesToTerraform(struct?: CloudGcpIntegrationsKubernetesOutputReference | CloudGcpIntegrationsKubernetes): any;
export declare class CloudGcpIntegrationsKubernetesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsKubernetes | undefined;
    set internalValue(value: CloudGcpIntegrationsKubernetes | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsLoadBalancing {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsLoadBalancingToTerraform(struct?: CloudGcpIntegrationsLoadBalancingOutputReference | CloudGcpIntegrationsLoadBalancing): any;
export declare class CloudGcpIntegrationsLoadBalancingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsLoadBalancing | undefined;
    set internalValue(value: CloudGcpIntegrationsLoadBalancing | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsMemCache {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsMemCacheToTerraform(struct?: CloudGcpIntegrationsMemCacheOutputReference | CloudGcpIntegrationsMemCache): any;
export declare class CloudGcpIntegrationsMemCacheOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsMemCache | undefined;
    set internalValue(value: CloudGcpIntegrationsMemCache | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsPubSub {
    /**
    * to fetch tags of the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#fetch_tags CloudGcpIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsPubSubToTerraform(struct?: CloudGcpIntegrationsPubSubOutputReference | CloudGcpIntegrationsPubSub): any;
export declare class CloudGcpIntegrationsPubSubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsPubSub | undefined;
    set internalValue(value: CloudGcpIntegrationsPubSub | undefined);
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsRedis {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsRedisToTerraform(struct?: CloudGcpIntegrationsRedisOutputReference | CloudGcpIntegrationsRedis): any;
export declare class CloudGcpIntegrationsRedisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsRedis | undefined;
    set internalValue(value: CloudGcpIntegrationsRedis | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsRouter {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsRouterToTerraform(struct?: CloudGcpIntegrationsRouterOutputReference | CloudGcpIntegrationsRouter): any;
export declare class CloudGcpIntegrationsRouterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsRouter | undefined;
    set internalValue(value: CloudGcpIntegrationsRouter | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsRun {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsRunToTerraform(struct?: CloudGcpIntegrationsRunOutputReference | CloudGcpIntegrationsRun): any;
export declare class CloudGcpIntegrationsRunOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsRun | undefined;
    set internalValue(value: CloudGcpIntegrationsRun | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsSpanner {
    /**
    * to fetch tags of the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#fetch_tags CloudGcpIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsSpannerToTerraform(struct?: CloudGcpIntegrationsSpannerOutputReference | CloudGcpIntegrationsSpanner): any;
export declare class CloudGcpIntegrationsSpannerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsSpanner | undefined;
    set internalValue(value: CloudGcpIntegrationsSpanner | undefined);
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsSql {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsSqlToTerraform(struct?: CloudGcpIntegrationsSqlOutputReference | CloudGcpIntegrationsSql): any;
export declare class CloudGcpIntegrationsSqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsSql | undefined;
    set internalValue(value: CloudGcpIntegrationsSql | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsStorage {
    /**
    * to fetch tags of the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#fetch_tags CloudGcpIntegrations#fetch_tags}
    */
    readonly fetchTags?: boolean | cdktf.IResolvable;
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsStorageToTerraform(struct?: CloudGcpIntegrationsStorageOutputReference | CloudGcpIntegrationsStorage): any;
export declare class CloudGcpIntegrationsStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsStorage | undefined;
    set internalValue(value: CloudGcpIntegrationsStorage | undefined);
    private _fetchTags?;
    get fetchTags(): boolean | cdktf.IResolvable;
    set fetchTags(value: boolean | cdktf.IResolvable);
    resetFetchTags(): void;
    get fetchTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsVirtualMachines {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsVirtualMachinesToTerraform(struct?: CloudGcpIntegrationsVirtualMachinesOutputReference | CloudGcpIntegrationsVirtualMachines): any;
export declare class CloudGcpIntegrationsVirtualMachinesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsVirtualMachines | undefined;
    set internalValue(value: CloudGcpIntegrationsVirtualMachines | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
export interface CloudGcpIntegrationsVpcAccess {
    /**
    * the data polling interval in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations#metrics_polling_interval CloudGcpIntegrations#metrics_polling_interval}
    */
    readonly metricsPollingInterval?: number;
}
export declare function cloudGcpIntegrationsVpcAccessToTerraform(struct?: CloudGcpIntegrationsVpcAccessOutputReference | CloudGcpIntegrationsVpcAccess): any;
export declare class CloudGcpIntegrationsVpcAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudGcpIntegrationsVpcAccess | undefined;
    set internalValue(value: CloudGcpIntegrationsVpcAccess | undefined);
    private _metricsPollingInterval?;
    get metricsPollingInterval(): number;
    set metricsPollingInterval(value: number);
    resetMetricsPollingInterval(): void;
    get metricsPollingIntervalInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations newrelic_cloud_gcp_integrations}
*/
export declare class CloudGcpIntegrations extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_cloud_gcp_integrations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_integrations newrelic_cloud_gcp_integrations} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudGcpIntegrationsConfig
    */
    constructor(scope: Construct, id: string, config: CloudGcpIntegrationsConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkedAccountId?;
    get linkedAccountId(): number;
    set linkedAccountId(value: number);
    get linkedAccountIdInput(): number | undefined;
    private _appEngine;
    get appEngine(): CloudGcpIntegrationsAppEngineOutputReference;
    putAppEngine(value: CloudGcpIntegrationsAppEngine): void;
    resetAppEngine(): void;
    get appEngineInput(): CloudGcpIntegrationsAppEngine | undefined;
    private _bigQuery;
    get bigQuery(): CloudGcpIntegrationsBigQueryOutputReference;
    putBigQuery(value: CloudGcpIntegrationsBigQuery): void;
    resetBigQuery(): void;
    get bigQueryInput(): CloudGcpIntegrationsBigQuery | undefined;
    private _bigTable;
    get bigTable(): CloudGcpIntegrationsBigTableOutputReference;
    putBigTable(value: CloudGcpIntegrationsBigTable): void;
    resetBigTable(): void;
    get bigTableInput(): CloudGcpIntegrationsBigTable | undefined;
    private _composer;
    get composer(): CloudGcpIntegrationsComposerOutputReference;
    putComposer(value: CloudGcpIntegrationsComposer): void;
    resetComposer(): void;
    get composerInput(): CloudGcpIntegrationsComposer | undefined;
    private _dataFlow;
    get dataFlow(): CloudGcpIntegrationsDataFlowOutputReference;
    putDataFlow(value: CloudGcpIntegrationsDataFlow): void;
    resetDataFlow(): void;
    get dataFlowInput(): CloudGcpIntegrationsDataFlow | undefined;
    private _dataProc;
    get dataProc(): CloudGcpIntegrationsDataProcOutputReference;
    putDataProc(value: CloudGcpIntegrationsDataProc): void;
    resetDataProc(): void;
    get dataProcInput(): CloudGcpIntegrationsDataProc | undefined;
    private _dataStore;
    get dataStore(): CloudGcpIntegrationsDataStoreOutputReference;
    putDataStore(value: CloudGcpIntegrationsDataStore): void;
    resetDataStore(): void;
    get dataStoreInput(): CloudGcpIntegrationsDataStore | undefined;
    private _fireBaseDatabase;
    get fireBaseDatabase(): CloudGcpIntegrationsFireBaseDatabaseOutputReference;
    putFireBaseDatabase(value: CloudGcpIntegrationsFireBaseDatabase): void;
    resetFireBaseDatabase(): void;
    get fireBaseDatabaseInput(): CloudGcpIntegrationsFireBaseDatabase | undefined;
    private _fireBaseHosting;
    get fireBaseHosting(): CloudGcpIntegrationsFireBaseHostingOutputReference;
    putFireBaseHosting(value: CloudGcpIntegrationsFireBaseHosting): void;
    resetFireBaseHosting(): void;
    get fireBaseHostingInput(): CloudGcpIntegrationsFireBaseHosting | undefined;
    private _fireBaseStorage;
    get fireBaseStorage(): CloudGcpIntegrationsFireBaseStorageOutputReference;
    putFireBaseStorage(value: CloudGcpIntegrationsFireBaseStorage): void;
    resetFireBaseStorage(): void;
    get fireBaseStorageInput(): CloudGcpIntegrationsFireBaseStorage | undefined;
    private _fireStore;
    get fireStore(): CloudGcpIntegrationsFireStoreOutputReference;
    putFireStore(value: CloudGcpIntegrationsFireStore): void;
    resetFireStore(): void;
    get fireStoreInput(): CloudGcpIntegrationsFireStore | undefined;
    private _functions;
    get functions(): CloudGcpIntegrationsFunctionsOutputReference;
    putFunctions(value: CloudGcpIntegrationsFunctions): void;
    resetFunctions(): void;
    get functionsInput(): CloudGcpIntegrationsFunctions | undefined;
    private _interconnect;
    get interconnect(): CloudGcpIntegrationsInterconnectOutputReference;
    putInterconnect(value: CloudGcpIntegrationsInterconnect): void;
    resetInterconnect(): void;
    get interconnectInput(): CloudGcpIntegrationsInterconnect | undefined;
    private _kubernetes;
    get kubernetes(): CloudGcpIntegrationsKubernetesOutputReference;
    putKubernetes(value: CloudGcpIntegrationsKubernetes): void;
    resetKubernetes(): void;
    get kubernetesInput(): CloudGcpIntegrationsKubernetes | undefined;
    private _loadBalancing;
    get loadBalancing(): CloudGcpIntegrationsLoadBalancingOutputReference;
    putLoadBalancing(value: CloudGcpIntegrationsLoadBalancing): void;
    resetLoadBalancing(): void;
    get loadBalancingInput(): CloudGcpIntegrationsLoadBalancing | undefined;
    private _memCache;
    get memCache(): CloudGcpIntegrationsMemCacheOutputReference;
    putMemCache(value: CloudGcpIntegrationsMemCache): void;
    resetMemCache(): void;
    get memCacheInput(): CloudGcpIntegrationsMemCache | undefined;
    private _pubSub;
    get pubSub(): CloudGcpIntegrationsPubSubOutputReference;
    putPubSub(value: CloudGcpIntegrationsPubSub): void;
    resetPubSub(): void;
    get pubSubInput(): CloudGcpIntegrationsPubSub | undefined;
    private _redis;
    get redis(): CloudGcpIntegrationsRedisOutputReference;
    putRedis(value: CloudGcpIntegrationsRedis): void;
    resetRedis(): void;
    get redisInput(): CloudGcpIntegrationsRedis | undefined;
    private _router;
    get router(): CloudGcpIntegrationsRouterOutputReference;
    putRouter(value: CloudGcpIntegrationsRouter): void;
    resetRouter(): void;
    get routerInput(): CloudGcpIntegrationsRouter | undefined;
    private _run;
    get run(): CloudGcpIntegrationsRunOutputReference;
    putRun(value: CloudGcpIntegrationsRun): void;
    resetRun(): void;
    get runInput(): CloudGcpIntegrationsRun | undefined;
    private _spanner;
    get spanner(): CloudGcpIntegrationsSpannerOutputReference;
    putSpanner(value: CloudGcpIntegrationsSpanner): void;
    resetSpanner(): void;
    get spannerInput(): CloudGcpIntegrationsSpanner | undefined;
    private _sql;
    get sql(): CloudGcpIntegrationsSqlOutputReference;
    putSql(value: CloudGcpIntegrationsSql): void;
    resetSql(): void;
    get sqlInput(): CloudGcpIntegrationsSql | undefined;
    private _storage;
    get storage(): CloudGcpIntegrationsStorageOutputReference;
    putStorage(value: CloudGcpIntegrationsStorage): void;
    resetStorage(): void;
    get storageInput(): CloudGcpIntegrationsStorage | undefined;
    private _virtualMachines;
    get virtualMachines(): CloudGcpIntegrationsVirtualMachinesOutputReference;
    putVirtualMachines(value: CloudGcpIntegrationsVirtualMachines): void;
    resetVirtualMachines(): void;
    get virtualMachinesInput(): CloudGcpIntegrationsVirtualMachines | undefined;
    private _vpcAccess;
    get vpcAccess(): CloudGcpIntegrationsVpcAccessOutputReference;
    putVpcAccess(value: CloudGcpIntegrationsVpcAccess): void;
    resetVpcAccess(): void;
    get vpcAccessInput(): CloudGcpIntegrationsVpcAccess | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
