import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DashboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * Determines who can edit the dashboard in an account. Valid values are all, editable_by_all, editable_by_owner, or read_only. Defaults to editable_by_all.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#editable Dashboard#editable}
    */
    readonly editable?: string;
    /**
    * New Relic One supports a 3 column grid or a 12 column grid. New Relic Insights supports a 3 column grid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#grid_column_count Dashboard#grid_column_count}
    */
    readonly gridColumnCount?: number;
    /**
    * The icon for the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#icon Dashboard#icon}
    */
    readonly icon?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#id Dashboard#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The title of the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#title Dashboard#title}
    */
    readonly title: string;
    /**
    * Determines who can see the dashboard in an account. Valid values are all or owner. Defaults to all.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#visibility Dashboard#visibility}
    */
    readonly visibility?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#filter Dashboard#filter}
    */
    readonly filter?: DashboardFilter;
    /**
    * widget block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#widget Dashboard#widget}
    */
    readonly widget?: DashboardWidget[] | cdktf.IResolvable;
}
export interface DashboardFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#attributes Dashboard#attributes}
    */
    readonly attributes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#event_types Dashboard#event_types}
    */
    readonly eventTypes: string[];
}
export declare function dashboardFilterToTerraform(struct?: DashboardFilterOutputReference | DashboardFilter): any;
export declare class DashboardFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardFilter | undefined;
    set internalValue(value: DashboardFilter | undefined);
    private _attributes?;
    get attributes(): string[];
    set attributes(value: string[]);
    resetAttributes(): void;
    get attributesInput(): string[] | undefined;
    private _eventTypes?;
    get eventTypes(): string[];
    set eventTypes(value: string[]);
    get eventTypesInput(): string[] | undefined;
}
export interface DashboardWidgetCompareWithPresentation {
    /**
    * The color for the rendered data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#color Dashboard#color}
    */
    readonly color: string;
    /**
    * The name for the rendered data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
}
export declare function dashboardWidgetCompareWithPresentationToTerraform(struct?: DashboardWidgetCompareWithPresentationOutputReference | DashboardWidgetCompareWithPresentation): any;
export declare class DashboardWidgetCompareWithPresentationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetCompareWithPresentation | undefined;
    set internalValue(value: DashboardWidgetCompareWithPresentation | undefined);
    private _color?;
    get color(): string;
    set color(value: string);
    get colorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DashboardWidgetCompareWith {
    /**
    * The offset duration for the COMPARE WITH clause.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#offset_duration Dashboard#offset_duration}
    */
    readonly offsetDuration: string;
    /**
    * presentation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#presentation Dashboard#presentation}
    */
    readonly presentation: DashboardWidgetCompareWithPresentation;
}
export declare function dashboardWidgetCompareWithToTerraform(struct?: DashboardWidgetCompareWith | cdktf.IResolvable): any;
export declare class DashboardWidgetCompareWithOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetCompareWith | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetCompareWith | cdktf.IResolvable | undefined);
    private _offsetDuration?;
    get offsetDuration(): string;
    set offsetDuration(value: string);
    get offsetDurationInput(): string | undefined;
    private _presentation;
    get presentation(): DashboardWidgetCompareWithPresentationOutputReference;
    putPresentation(value: DashboardWidgetCompareWithPresentation): void;
    get presentationInput(): DashboardWidgetCompareWithPresentation | undefined;
}
export declare class DashboardWidgetCompareWithList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetCompareWith[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetCompareWithOutputReference;
}
export interface DashboardWidgetMetric {
    /**
    * The metric name to display.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The metric scope.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#scope Dashboard#scope}
    */
    readonly scope?: string;
    /**
    * The metric units.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#units Dashboard#units}
    */
    readonly units?: string;
    /**
    * The metric values to display.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#values Dashboard#values}
    */
    readonly values?: string[];
}
export declare function dashboardWidgetMetricToTerraform(struct?: DashboardWidgetMetric | cdktf.IResolvable): any;
export declare class DashboardWidgetMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetMetric | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetMetric | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _units?;
    get units(): string;
    set units(value: string);
    resetUnits(): void;
    get unitsInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DashboardWidgetMetricList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetMetric[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetMetricOutputReference;
}
export interface DashboardWidget {
    /**
    * The target account ID to fetch data from, if not the current account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#account_id Dashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * Column position of widget from top left, starting at 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#column Dashboard#column}
    */
    readonly column: number;
    /**
    * The ID of a dashboard to link to from the widget's facets.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#drilldown_dashboard_id Dashboard#drilldown_dashboard_id}
    */
    readonly drilldownDashboardId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#duration Dashboard#duration}
    */
    readonly duration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#end_time Dashboard#end_time}
    */
    readonly endTime?: number;
    /**
    * A collection of entity ids to display data for. These are typically application IDs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#entity_ids Dashboard#entity_ids}
    */
    readonly entityIds?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Height of the widget. Valid values are 1 to 3 inclusive. Defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#height Dashboard#height}
    */
    readonly height?: number;
    /**
    * The limit of distinct data series to display.  Requires `order_by` to be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * Description of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#notes Dashboard#notes}
    */
    readonly notes?: string;
    /**
    * Valid NRQL query string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#nrql Dashboard#nrql}
    */
    readonly nrql?: string;
    /**
    * Set the order of result series.  Required when using `limit`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#order_by Dashboard#order_by}
    */
    readonly orderBy?: string;
    /**
    * Row position of widget from top left, starting at 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#row Dashboard#row}
    */
    readonly row: number;
    /**
    * The markdown source to be rendered in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#source Dashboard#source}
    */
    readonly source?: string;
    /**
    * Threshold above which the displayed value will be styled with a red color.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#threshold_red Dashboard#threshold_red}
    */
    readonly thresholdRed?: number;
    /**
    * Threshold above which the displayed value will be styled with a yellow color.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#threshold_yellow Dashboard#threshold_yellow}
    */
    readonly thresholdYellow?: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#title Dashboard#title}
    */
    readonly title: string;
    /**
    * How the widget visualizes data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#visualization Dashboard#visualization}
    */
    readonly visualization: string;
    /**
    * Width of the widget. Valid values are 1 to 3 inclusive. Defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#width Dashboard#width}
    */
    readonly width?: number;
    /**
    * compare_with block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#compare_with Dashboard#compare_with}
    */
    readonly compareWith?: DashboardWidgetCompareWith[] | cdktf.IResolvable;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: DashboardWidgetMetric[] | cdktf.IResolvable;
}
export declare function dashboardWidgetToTerraform(struct?: DashboardWidget | cdktf.IResolvable): any;
export declare class DashboardWidgetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidget | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidget | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _column?;
    get column(): number;
    set column(value: number);
    get columnInput(): number | undefined;
    private _drilldownDashboardId?;
    get drilldownDashboardId(): number;
    set drilldownDashboardId(value: number);
    resetDrilldownDashboardId(): void;
    get drilldownDashboardIdInput(): number | undefined;
    private _duration?;
    get duration(): number;
    set duration(value: number);
    resetDuration(): void;
    get durationInput(): number | undefined;
    private _endTime?;
    get endTime(): number;
    set endTime(value: number);
    resetEndTime(): void;
    get endTimeInput(): number | undefined;
    private _entityIds?;
    get entityIds(): number[];
    set entityIds(value: number[]);
    resetEntityIds(): void;
    get entityIdsInput(): number[] | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _height?;
    get height(): number;
    set height(value: number);
    resetHeight(): void;
    get heightInput(): number | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _nrql?;
    get nrql(): string;
    set nrql(value: string);
    resetNrql(): void;
    get nrqlInput(): string | undefined;
    private _orderBy?;
    get orderBy(): string;
    set orderBy(value: string);
    resetOrderBy(): void;
    get orderByInput(): string | undefined;
    get rawMetricName(): string;
    private _row?;
    get row(): number;
    set row(value: number);
    get rowInput(): number | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _thresholdRed?;
    get thresholdRed(): number;
    set thresholdRed(value: number);
    resetThresholdRed(): void;
    get thresholdRedInput(): number | undefined;
    private _thresholdYellow?;
    get thresholdYellow(): number;
    set thresholdYellow(value: number);
    resetThresholdYellow(): void;
    get thresholdYellowInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _visualization?;
    get visualization(): string;
    set visualization(value: string);
    get visualizationInput(): string | undefined;
    get widgetId(): number;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
    private _compareWith;
    get compareWith(): DashboardWidgetCompareWithList;
    putCompareWith(value: DashboardWidgetCompareWith[] | cdktf.IResolvable): void;
    resetCompareWith(): void;
    get compareWithInput(): cdktf.IResolvable | DashboardWidgetCompareWith[] | undefined;
    private _metric;
    get metric(): DashboardWidgetMetricList;
    putMetric(value: DashboardWidgetMetric[] | cdktf.IResolvable): void;
    resetMetric(): void;
    get metricInput(): cdktf.IResolvable | DashboardWidgetMetric[] | undefined;
}
export declare class DashboardWidgetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidget[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard newrelic_dashboard}
*/
export declare class Dashboard extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_dashboard";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard newrelic_dashboard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DashboardConfig
    */
    constructor(scope: Construct, id: string, config: DashboardConfig);
    get dashboardUrl(): string;
    private _editable?;
    get editable(): string;
    set editable(value: string);
    resetEditable(): void;
    get editableInput(): string | undefined;
    private _gridColumnCount?;
    get gridColumnCount(): number;
    set gridColumnCount(value: number);
    resetGridColumnCount(): void;
    get gridColumnCountInput(): number | undefined;
    private _icon?;
    get icon(): string;
    set icon(value: string);
    resetIcon(): void;
    get iconInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _filter;
    get filter(): DashboardFilterOutputReference;
    putFilter(value: DashboardFilter): void;
    resetFilter(): void;
    get filterInput(): DashboardFilter | undefined;
    private _widget;
    get widget(): DashboardWidgetList;
    putWidget(value: DashboardWidget[] | cdktf.IResolvable): void;
    resetWidget(): void;
    get widgetInput(): cdktf.IResolvable | DashboardWidget[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
