import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the account in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/account#account_id DataNewrelicAccount#account_id}
    */
    readonly accountId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/account#id DataNewrelicAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the account in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/account#name DataNewrelicAccount#name}
    */
    readonly name?: string;
    /**
    * The scope of the account in New Relic.  Valid values are "global" and "in_region".  Defaults to "in_region".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/account#scope DataNewrelicAccount#scope}
    */
    readonly scope?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/account newrelic_account}
*/
export declare class DataNewrelicAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/account newrelic_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicAccountConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNewrelicAccountConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
