import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicAlertPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID to operate on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/alert_policy#account_id DataNewrelicAlertPolicy#account_id}
    */
    readonly accountId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/alert_policy#id DataNewrelicAlertPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The rollup strategy for the policy. Options include: `PER_POLICY`, `PER_CONDITION`, or `PER_CONDITION_AND_TARGET`. The default is `PER_POLICY`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/alert_policy#incident_preference DataNewrelicAlertPolicy#incident_preference}
    */
    readonly incidentPreference?: string;
    /**
    * The name of the alert policy in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/alert_policy#name DataNewrelicAlertPolicy#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/alert_policy newrelic_alert_policy}
*/
export declare class DataNewrelicAlertPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_alert_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/alert_policy newrelic_alert_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicAlertPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicAlertPolicyConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    get createdAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _incidentPreference?;
    get incidentPreference(): string;
    set incidentPreference(value: string);
    resetIncidentPreference(): void;
    get incidentPreferenceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get updatedAt(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
