import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EntityTagsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The guid of the entity to tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#guid EntityTags#guid}
    */
    readonly guid: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#id EntityTags#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#tag EntityTags#tag}
    */
    readonly tag: EntityTagsTag[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#timeouts EntityTags#timeouts}
    */
    readonly timeouts?: EntityTagsTimeouts;
}
export interface EntityTagsTag {
    /**
    * The tag key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#key EntityTags#key}
    */
    readonly key: string;
    /**
    * The tag values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#values EntityTags#values}
    */
    readonly values: string[];
}
export declare function entityTagsTagToTerraform(struct?: EntityTagsTag | cdktf.IResolvable): any;
export declare class EntityTagsTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EntityTagsTag | cdktf.IResolvable | undefined;
    set internalValue(value: EntityTagsTag | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class EntityTagsTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EntityTagsTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EntityTagsTagOutputReference;
}
export interface EntityTagsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#create EntityTags#create}
    */
    readonly create?: string;
}
export declare function entityTagsTimeoutsToTerraform(struct?: EntityTagsTimeoutsOutputReference | EntityTagsTimeouts | cdktf.IResolvable): any;
export declare class EntityTagsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EntityTagsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EntityTagsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags newrelic_entity_tags}
*/
export declare class EntityTags extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_entity_tags";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags newrelic_entity_tags} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EntityTagsConfig
    */
    constructor(scope: Construct, id: string, config: EntityTagsConfig);
    private _guid?;
    get guid(): string;
    set guid(value: string);
    get guidInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _tag;
    get tag(): EntityTagsTagList;
    putTag(value: EntityTagsTag[] | cdktf.IResolvable): void;
    get tagInput(): cdktf.IResolvable | EntityTagsTag[] | undefined;
    private _timeouts;
    get timeouts(): EntityTagsTimeoutsOutputReference;
    putTimeouts(value: EntityTagsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EntityTagsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
