import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface InfraAlertConditionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The operator used to evaluate the threshold value. Valid values are above, below, and equal. Supported by the infra_metric and infra_process_running condition types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#comparison InfraAlertCondition#comparison}
    */
    readonly comparison?: string;
    /**
    * The description of the Infrastructure alert condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#description InfraAlertCondition#description}
    */
    readonly description?: string;
    /**
    * Whether the condition is turned on or off. Valid values are true and false. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#enabled InfraAlertCondition#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The metric event; for example, SystemSample or StorageSample. Supported by the infra_metric condition type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#event InfraAlertCondition#event}
    */
    readonly event?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#id InfraAlertCondition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * For alerts on integrations, use this instead of event. Supported by the infra_metric condition type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#integration_provider InfraAlertCondition#integration_provider}
    */
    readonly integrationProvider?: string;
    /**
    * The Infrastructure alert condition's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#name InfraAlertCondition#name}
    */
    readonly name: string;
    /**
    * The ID of the alert policy where this condition should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#policy_id InfraAlertCondition#policy_id}
    */
    readonly policyId: number;
    /**
    * Any filters applied to processes; for example: commandName = 'java'. Supported by the infra_process_running condition type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#process_where InfraAlertCondition#process_where}
    */
    readonly processWhere?: string;
    /**
    * Runbook URL to display in notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#runbook_url InfraAlertCondition#runbook_url}
    */
    readonly runbookUrl?: string;
    /**
    * The attribute name to identify the metric being targeted; for example, cpuPercent, diskFreePercent, or memoryResidentSizeBytes. The underlying API will automatically populate this value for Infrastructure integrations (for example diskFreePercent), so make sure to explicitly include this value to avoid diff issues. Supported by the infra_metric condition type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#select InfraAlertCondition#select}
    */
    readonly select?: string;
    /**
    * The type of Infrastructure alert condition. Valid values are infra_process_running, infra_metric, and infra_host_not_reporting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#type InfraAlertCondition#type}
    */
    readonly type: string;
    /**
    * Determines how much time, in hours, will pass before a violation is automatically closed. Valid values are 1, 2, 4, 8, 12, 24, 48, or 72
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#violation_close_timer InfraAlertCondition#violation_close_timer}
    */
    readonly violationCloseTimer?: number;
    /**
    * If applicable, this identifies any Infrastructure host filters used; for example: hostname LIKE '%cassandra%'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#where InfraAlertCondition#where}
    */
    readonly where?: string;
    /**
    * critical block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#critical InfraAlertCondition#critical}
    */
    readonly critical?: InfraAlertConditionCritical;
    /**
    * warning block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#warning InfraAlertCondition#warning}
    */
    readonly warning?: InfraAlertConditionWarning;
}
export interface InfraAlertConditionCritical {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#duration InfraAlertCondition#duration}
    */
    readonly duration: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#time_function InfraAlertCondition#time_function}
    */
    readonly timeFunction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#value InfraAlertCondition#value}
    */
    readonly value?: number;
}
export declare function infraAlertConditionCriticalToTerraform(struct?: InfraAlertConditionCriticalOutputReference | InfraAlertConditionCritical): any;
export declare class InfraAlertConditionCriticalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InfraAlertConditionCritical | undefined;
    set internalValue(value: InfraAlertConditionCritical | undefined);
    private _duration?;
    get duration(): number;
    set duration(value: number);
    get durationInput(): number | undefined;
    private _timeFunction?;
    get timeFunction(): string;
    set timeFunction(value: string);
    resetTimeFunction(): void;
    get timeFunctionInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    resetValue(): void;
    get valueInput(): number | undefined;
}
export interface InfraAlertConditionWarning {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#duration InfraAlertCondition#duration}
    */
    readonly duration: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#time_function InfraAlertCondition#time_function}
    */
    readonly timeFunction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition#value InfraAlertCondition#value}
    */
    readonly value?: number;
}
export declare function infraAlertConditionWarningToTerraform(struct?: InfraAlertConditionWarningOutputReference | InfraAlertConditionWarning): any;
export declare class InfraAlertConditionWarningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InfraAlertConditionWarning | undefined;
    set internalValue(value: InfraAlertConditionWarning | undefined);
    private _duration?;
    get duration(): number;
    set duration(value: number);
    get durationInput(): number | undefined;
    private _timeFunction?;
    get timeFunction(): string;
    set timeFunction(value: string);
    resetTimeFunction(): void;
    get timeFunctionInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    resetValue(): void;
    get valueInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition newrelic_infra_alert_condition}
*/
export declare class InfraAlertCondition extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_infra_alert_condition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/infra_alert_condition newrelic_infra_alert_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options InfraAlertConditionConfig
    */
    constructor(scope: Construct, id: string, config: InfraAlertConditionConfig);
    private _comparison?;
    get comparison(): string;
    set comparison(value: string);
    resetComparison(): void;
    get comparisonInput(): string | undefined;
    get createdAt(): number;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _event?;
    get event(): string;
    set event(value: string);
    resetEvent(): void;
    get eventInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationProvider?;
    get integrationProvider(): string;
    set integrationProvider(value: string);
    resetIntegrationProvider(): void;
    get integrationProviderInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyId?;
    get policyId(): number;
    set policyId(value: number);
    get policyIdInput(): number | undefined;
    private _processWhere?;
    get processWhere(): string;
    set processWhere(value: string);
    resetProcessWhere(): void;
    get processWhereInput(): string | undefined;
    private _runbookUrl?;
    get runbookUrl(): string;
    set runbookUrl(value: string);
    resetRunbookUrl(): void;
    get runbookUrlInput(): string | undefined;
    private _select?;
    get select(): string;
    set select(value: string);
    resetSelect(): void;
    get selectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get updatedAt(): number;
    private _violationCloseTimer?;
    get violationCloseTimer(): number;
    set violationCloseTimer(value: number);
    resetViolationCloseTimer(): void;
    get violationCloseTimerInput(): number | undefined;
    private _where?;
    get where(): string;
    set where(value: string);
    resetWhere(): void;
    get whereInput(): string | undefined;
    private _critical;
    get critical(): InfraAlertConditionCriticalOutputReference;
    putCritical(value: InfraAlertConditionCritical): void;
    resetCritical(): void;
    get criticalInput(): InfraAlertConditionCritical | undefined;
    private _warning;
    get warning(): InfraAlertConditionWarningOutputReference;
    putWarning(value: InfraAlertConditionWarning): void;
    resetWarning(): void;
    get warningInput(): InfraAlertConditionWarning | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
